/*
 * Decompiled with CFR 0.152.
 */
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;

public class AuctionEntry
extends XMLSerializeSimple
implements Comparable {
    public static final int SUCC_HIGHBID = 0;
    public static final int SUCC_OUTBID = 1;
    public static final int FAIL_ENDED = 2;
    public static final int FAIL_CONNECT = 3;
    public static final int FAIL_PARSE = 4;
    public static final int FAIL_BADMULTI = 5;
    private AuctionInfo _auction = null;
    private String _identifier = null;
    private EventLogger entryEvents = null;
    private String _comment = null;
    private Currency _shipping = null;
    private boolean _auctionEnded = false;
    private boolean _isUpdating = false;
    private boolean _needsUpdate = false;
    private boolean _forceUpdate = false;
    private boolean _isLoaded = false;
    private MultiSnipe _snipeMulti = null;
    private boolean _invalid = false;
    private boolean _isHighBidder = false;
    private boolean _isSeller = false;
    private Currency _bid = Currency.NoValue();
    private Currency _snipeBid = Currency.NoValue();
    private Currency _cancelSnipeBid = null;
    private int _bidQuantity = 1;
    private int _snipeQuantity = 1;
    private int _cancelSnipeQuant = 1;
    private AuctionServer _aucServ = null;
    private long _whenBid = 0L;
    private long _lastUpdated = 0L;
    private long _quickerUpdateStart = 1800000L;
    private long _updateFrequency = 2400000L;
    private long _snipeAt = -1L;
    private static long _defaultSnipeAt = 30000L;
    private long _justAdded = 0L;
    private long _dontUpdate = 0L;
    private String _category = null;
    private boolean _sticky = false;
    private StringBuffer _lastErrorPage = null;
    private boolean _shippingSet = false;
    protected String[] infoTags = new String[]{"info", "bid", "snipe", "complete", "invalid", "comment", "log", "multisnipe", "shipping", "category"};
    private static Map allMultiSnipes = new TreeMap();
    public static final String endedAuction = "Auction ended.";
    private static final String mf_min_sec = "{6}{2,number,##}m, {7}{3,number,##}s";
    private static final String mf_hrs_min = "{5}{1,number,##}h, {6}{2,number,##}m";
    private static final String mf_day_hrs = "{4}{0,number,##}d, {5}{1,number,##}h";
    private static final String mf_min_sec_detailed = "{6}{2,number,##} minute{2,choice,0#, |1#, |1<s,} {7}{3,number,##} second{3,choice,0#|1#|1<s}";
    private static final String mf_hrs_min_detailed = "{5}{1,number,##} hour{1,choice,0#, |1#, |1<s,} {6}{2,number,##} minute{2,choice,0#|1#|1<s}";
    private static final String mf_day_hrs_detailed = "{4}{0,number,##} day{0,choice,0#, |1#, |1<s,}  {5}{1,number,##} hour{1,choice,0#|1#|1<s}";

    public void logError() {
        this.setLastStatus("Communications failure talking to the server.");
        this.setInvalid();
    }

    private synchronized void prepareAuctionEntry(String string) {
        this._lastUpdated = 0L;
        this._needsUpdate = true;
        if (string.startsWith("http")) {
            this._aucServ = AuctionServerManager.getInstance().getServerForUrlString(string);
            if (this._aucServ != null) {
                this._identifier = this._aucServ.extractIdentifierFromURLString(string);
                this._auction = this._aucServ.addAuction(AuctionServer.getURLFromString(string), this._identifier);
                this._needsUpdate = false;
                this._isLoaded = true;
            }
        } else {
            this._aucServ = AuctionServerManager.getInstance().getServerForIdentifier(string);
            if (this._aucServ != null) {
                this._auction = this._aucServ.addAuction(string);
                this._isLoaded = true;
                this._identifier = string;
            }
        }
        if (this._auction == null || this._aucServ == null) {
            this._identifier = null;
            this._isLoaded = false;
        } else {
            this.entryEvents = new EventLogger(this.getIdentifier(), this.getTitle());
            this.checkHighBidder(true);
            this.checkSeller();
            this.checkEnded();
        }
    }

    public AuctionEntry(String string) {
        this.checkConfigurationSnipeTime();
        this._justAdded = System.currentTimeMillis() + 300000L;
        this.prepareAuctionEntry(string);
    }

    public AuctionEntry() {
        this.checkConfigurationSnipeTime();
    }

    private void checkEnded() {
        Date date;
        if (!this._auctionEnded && (date = new Date(System.currentTimeMillis() + this._aucServ.getOfficialServerTimeDelta())).after(this.getEndDate())) {
            this._auctionEnded = true;
        }
    }

    public AuctionServer getServer() {
        return this._aucServ;
    }

    public void setServer(AuctionServer auctionServer) {
        this._aucServ = auctionServer;
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public boolean isSnipeValid() {
        Currency currency = this._aucServ.getMinimumBidIncrement(this.getCurBid(), this.getNumBidders());
        Currency currency2 = Currency.NoValue();
        boolean bl = false;
        try {
            currency2 = this.getCurBid().add(currency);
            if (!this.getSnipeBid().less(currency2)) {
                bl = true;
            }
        }
        catch (Currency.CurrencyTypeException currencyTypeException) {
            ErrorManagement.handleException("This should never happen (" + currency2 + ", " + this.getSnipeBid() + ")!", currencyTypeException);
        }
        return bl;
    }

    public boolean isSniped() {
        return this._snipeBid != null && !this._snipeBid.isNull();
    }

    public boolean isMultiSniped() {
        return this._snipeMulti != null;
    }

    public boolean isBidOn() {
        return this._bid != null && !this._bid.isNull();
    }

    public boolean isUpdating() {
        return this._isUpdating;
    }

    public boolean isHighBidder() {
        return this._isHighBidder;
    }

    public boolean isSeller() {
        return this._isSeller;
    }

    public Currency getBid() {
        return this._bid;
    }

    public void setBid(Currency currency) {
        this._bid = currency == null ? Currency.NoValue() : currency;
    }

    public void setBidQuantity(int n) {
        this._bidQuantity = n;
    }

    public Currency getSnipeBid() {
        return this._snipeBid;
    }

    public int getSnipeQuantity() {
        return this._snipeQuantity;
    }

    public int getBidQuantity() {
        return this._bidQuantity;
    }

    public void setMultiSnipe(MultiSnipe multiSnipe) {
        if (this._snipeMulti != multiSnipe) {
            if (this._snipeMulti != null) {
                this._snipeMulti.remove(this);
            }
            this._snipeMulti = multiSnipe;
            if (this._snipeMulti != null) {
                if (!this.isSniped()) {
                    this.prepareSnipe(this._snipeMulti.getSnipeValue(this));
                }
                this._snipeMulti.add(this);
                this.addMulti(this._snipeMulti);
            }
        }
        if (multiSnipe == null) {
            this.prepareSnipe(Currency.NoValue(), 0);
        }
    }

    private static long getGlobalSnipeTime() {
        String string = JConfig.queryConfiguration("snipemilliseconds");
        long l = string != null ? Long.parseLong(string) : 30000L;
        return l;
    }

    public MultiSnipe getMultiSnipe() {
        return this._snipeMulti;
    }

    private void checkConfigurationSnipeTime() {
        _defaultSnipeAt = AuctionEntry.getGlobalSnipeTime();
    }

    public static long getDefaultSnipeTime() {
        _defaultSnipeAt = AuctionEntry.getGlobalSnipeTime();
        return _defaultSnipeAt;
    }

    public static void setDefaultSnipeTime(long l) {
        JConfig.setConfiguration("snipemilliseconds", Long.toString(l));
        _defaultSnipeAt = l;
    }

    public long getSnipeTime() {
        return this.hasDefaultSnipeTime() ? _defaultSnipeAt : this._snipeAt;
    }

    public boolean hasDefaultSnipeTime() {
        return this._snipeAt == -1L;
    }

    public void setSnipeTime(long l) {
        this._snipeAt = l;
    }

    public long getJustAdded() {
        return this._justAdded;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    private void checkHighBidder(boolean bl) {
        int n = this.getNumBidders();
        if (n > 0) {
            if (this.isOutbid() && bl) {
                this._aucServ.updateHighBid(this);
            }
            if (this.isBidOn() && this.isPrivate()) {
                Currency currency = this.getCurBid();
                try {
                    if (currency.less(this._bid)) {
                        this._isHighBidder = true;
                    }
                }
                catch (Currency.CurrencyTypeException currencyTypeException) {
                    ErrorManagement.handleException("This should never happen (bad Currency at this point!).", currencyTypeException);
                }
                if (currency.equals(this._bid)) {
                    this._isHighBidder = n == 1;
                }
            } else if (!this.isDutch()) {
                String string = this._aucServ.getUserId().trim();
                this._isHighBidder = string.equalsIgnoreCase(this.getHighBidder());
            }
        }
    }

    private void checkDutchHighBidder() {
        this._isHighBidder = this._aucServ.isHighDutch(this);
    }

    private void checkSeller() {
        String string = this._aucServ.getUserId();
        this._isSeller = string.equalsIgnoreCase(this.getSeller());
    }

    public synchronized boolean checkUpdate() {
        long l = System.currentTimeMillis();
        if (this._justAdded != 0L && l > this._justAdded) {
            this._justAdded = 0L;
        }
        if (this._dontUpdate != 0L) {
            if (l > this._dontUpdate) {
                this._dontUpdate = 0L;
            } else {
                return false;
            }
        }
        if (!(this._needsUpdate || this._isUpdating || this._auctionEnded)) {
            long l2 = l + this._aucServ.getOfficialServerTimeDelta();
            if (l2 > this.getEndDate().getTime()) {
                this._needsUpdate = true;
            } else {
                if (this._updateFrequency != 60000L && this.getEndDate().getTime() - this._quickerUpdateStart < l2) {
                    this._updateFrequency = 60000L;
                    this._needsUpdate = true;
                }
                if (this._lastUpdated + this._updateFrequency < l) {
                    this._needsUpdate = true;
                }
            }
        }
        return this._needsUpdate;
    }

    public long getNextUpdate() {
        return (this._lastUpdated == 0L ? System.currentTimeMillis() : this._lastUpdated) + this._updateFrequency;
    }

    public void clearInvalid() {
        this._invalid = false;
    }

    public void setInvalid() {
        this._invalid = true;
    }

    public boolean isInvalid() {
        return this._invalid;
    }

    public void setComment(String string) {
        this._comment = string.trim().equals("") ? null : string;
    }

    public String getComment() {
        return this._comment;
    }

    public void setLastStatus(String string) {
        this.entryEvents.setLastStatus(string);
    }

    public void setShipping(Currency currency) {
        this._shippingSet = true;
        this._shipping = currency;
    }

    public String getLastStatus() {
        return this.getLastStatus(false);
    }

    public String getLastStatus(boolean bl) {
        return this.entryEvents.getLastStatus(bl);
    }

    public int getStatusCount() {
        return this.entryEvents.getStatusCount();
    }

    protected String[] getTags() {
        return this.infoTags;
    }

    protected void handleTag(int n, XMLElement xMLElement) {
        switch (n) {
            case 0: {
                this._auction = this._aucServ.getNewSpecificAuction();
                this._auction.setIdentifier(this._identifier);
                this._auction.fromXML(xMLElement);
                break;
            }
            case 1: {
                Currency currency = Currency.getCurrency(xMLElement.getProperty("CURRENCY"), xMLElement.getProperty("PRICE"));
                this.setBid(currency);
                this._bidQuantity = Integer.parseInt(xMLElement.getProperty("QUANTITY"));
                if (xMLElement.getProperty("WHEN", null) == null) break;
                this._whenBid = Long.parseLong(xMLElement.getProperty("WHEN"));
                break;
            }
            case 2: {
                Currency currency = Currency.getCurrency(xMLElement.getProperty("CURRENCY"), xMLElement.getProperty("PRICE"));
                this.prepareSnipe(currency, Integer.parseInt(xMLElement.getProperty("QUANTITY")));
                this._snipeAt = Long.parseLong(xMLElement.getProperty("SECONDSPRIOR"));
                break;
            }
            case 3: {
                this._auctionEnded = true;
                break;
            }
            case 4: {
                this._invalid = true;
                break;
            }
            case 5: {
                this._comment = xMLElement.getContents();
                break;
            }
            case 6: {
                this.entryEvents = new EventLogger(this.getIdentifier(), this.getTitle());
                this.entryEvents.fromXML(xMLElement);
                break;
            }
            case 7: {
                long l = Long.parseLong(xMLElement.getProperty("ID"));
                MultiSnipe multiSnipe = this.whichMulti(l);
                if (multiSnipe == null) {
                    String string = xMLElement.getProperty("COLOR");
                    Currency currency = Currency.getCurrency(xMLElement.getProperty("DEFAULT"));
                    boolean bl = xMLElement.getProperty("SUBTRACTSHIPPING", "false").equals("true");
                    multiSnipe = new MultiSnipe(string, currency, l, bl);
                }
                this.setMultiSnipe(multiSnipe);
                break;
            }
            case 8: {
                this._shipping = Currency.getCurrency(xMLElement.getProperty("CURRENCY"), xMLElement.getProperty("PRICE"));
                this._shippingSet = xMLElement.getProperty("OVERRIDDEN", "false").equals("true");
                break;
            }
            case 9: {
                this._category = xMLElement.getContents();
                this._sticky = xMLElement.getProperty("STICKY", "false").equals("true");
                break;
            }
        }
    }

    public XMLElement toXML() {
        XMLElement xMLElement;
        XMLElement xMLElement2 = new XMLElement("auction");
        xMLElement2.setProperty("id", this.getIdentifier());
        xMLElement2.addChild(this._auction.toXML());
        if (this.isBidOn()) {
            XMLElement xMLElement3 = new XMLElement("bid");
            xMLElement3.setEmpty();
            xMLElement3.setProperty("quantity", Integer.toString(this._bidQuantity));
            xMLElement3.setProperty("currency", this._bid.fullCurrencyName());
            xMLElement3.setProperty("price", Double.toString(this._bid.getValue()));
            if (this._whenBid != 0L) {
                xMLElement3.setProperty("when", Long.toString(this._whenBid));
            }
            xMLElement2.addChild(xMLElement3);
        }
        if (this.isSniped()) {
            XMLElement xMLElement4 = new XMLElement("snipe");
            xMLElement4.setEmpty();
            xMLElement4.setProperty("quantity", Integer.toString(this._snipeQuantity));
            xMLElement4.setProperty("currency", this._snipeBid.fullCurrencyName());
            xMLElement4.setProperty("price", Double.toString(this._snipeBid.getValue()));
            xMLElement4.setProperty("secondsprior", Long.toString(this._snipeAt));
            xMLElement2.addChild(xMLElement4);
        }
        if (this.isMultiSniped()) {
            MultiSnipe multiSnipe = this.getMultiSnipe();
            XMLElement xMLElement5 = new XMLElement("multisnipe");
            xMLElement5.setEmpty();
            xMLElement5.setProperty("subtractshipping", Boolean.toString(multiSnipe.subtractShipping()));
            xMLElement5.setProperty("color", multiSnipe.getColorString());
            xMLElement5.setProperty("default", multiSnipe.getSnipeValue(null).fullCurrency());
            xMLElement5.setProperty("id", Long.toString(multiSnipe.getIdentifier()));
            xMLElement2.addChild(xMLElement5);
        }
        if (this._auctionEnded) {
            XMLElement xMLElement6 = new XMLElement("complete");
            xMLElement6.setEmpty();
            xMLElement2.addChild(xMLElement6);
        }
        if (this._invalid) {
            XMLElement xMLElement7 = new XMLElement("invalid");
            xMLElement7.setEmpty();
            xMLElement2.addChild(xMLElement7);
        }
        if (this._comment != null) {
            XMLElement xMLElement8 = new XMLElement("comment");
            xMLElement8.setContents(this._comment);
            xMLElement2.addChild(xMLElement8);
        }
        if (this._category != null) {
            XMLElement xMLElement9 = new XMLElement("category");
            xMLElement9.setContents(this._category);
            xMLElement9.setProperty("sticky", this._sticky ? "true" : "false");
            xMLElement2.addChild(xMLElement9);
        }
        if (this._shipping != null) {
            XMLElement xMLElement10 = new XMLElement("shipping");
            xMLElement10.setEmpty();
            xMLElement10.setProperty("currency", this._shipping.fullCurrencyName());
            xMLElement10.setProperty("price", Double.toString(this._shipping.getValue()));
            if (this._shippingSet) {
                xMLElement10.setProperty("overridden", "true");
            }
            xMLElement2.addChild(xMLElement10);
        }
        if ((xMLElement = this.entryEvents.toXML()) != null) {
            xMLElement2.addChild(xMLElement);
        }
        return xMLElement2;
    }

    public void fromXML(XMLElement xMLElement) {
        String string = xMLElement.getProperty("ID", null);
        if (string != null) {
            this._identifier = string;
            super.fromXML(xMLElement);
            this._isLoaded = false;
            this._lastUpdated = 0L;
            if (!this._auctionEnded) {
                this.setNeedsUpdate();
            }
            if (this.entryEvents == null) {
                this.entryEvents = new EventLogger(this.getIdentifier(), this.getTitle());
            }
            this.checkHighBidder(false);
            this.checkSeller();
        }
    }

    private void addMulti(MultiSnipe multiSnipe) {
        Long l = new Long(multiSnipe.getIdentifier());
        if (!allMultiSnipes.containsKey(l)) {
            allMultiSnipes.put(l, multiSnipe);
        }
    }

    private MultiSnipe whichMulti(long l) {
        return (MultiSnipe)allMultiSnipes.get(new Long(l));
    }

    public boolean checkSnipe() {
        boolean bl = false;
        if (this.isSniped()) {
            long l;
            long l2 = this._auction.getEndDate().getTime();
            if (l2 > (l = System.currentTimeMillis() + this._aucServ.getOfficialServerTimeDelta() + this._aucServ.getPageRequestTime() * this._aucServ.getSnipePadding())) {
                long l3 = this.hasDefaultSnipeTime() ? l + _defaultSnipeAt : l + this._snipeAt;
                bl = l3 >= l2;
            } else {
                this.setLastStatus("Cancelling snipe, time is suddenly past auction-end.");
                this.cancelSnipe(true);
            }
        }
        return bl;
    }

    public boolean snipeCancelled() {
        return this._cancelSnipeBid != null;
    }

    public Currency getCancelledSnipe() {
        return this._cancelSnipeBid;
    }

    public int getCancelledSnipeQuantity() {
        return this._cancelSnipeQuant;
    }

    public void cancelSnipe(boolean bl) {
        if (this.isSniped()) {
            this.setLastStatus("Cancelling snipe.");
            if (bl) {
                this._cancelSnipeBid = this._snipeBid;
                this._cancelSnipeQuant = this._snipeQuantity;
            }
        }
        this.setMultiSnipe(null);
    }

    public void snipeCompleted() {
        this.setBid(this._snipeBid);
        this._bidQuantity = this._snipeQuantity;
        this._needsUpdate = true;
        this._snipeBid = Currency.NoValue();
        this._snipeQuantity = 0;
    }

    public void update() {
        Object object;
        this._isUpdating = true;
        this._needsUpdate = false;
        MQFactory.getConcrete("redraw").enqueue(this);
        this._forceUpdate = false;
        try {
            this._aucServ.reloadAuction(this);
        }
        catch (Exception exception) {
            ErrorManagement.handleException("Unexpected exception during auction reload/update.", exception);
        }
        this._lastUpdated = System.currentTimeMillis();
        this._isUpdating = false;
        MQFactory.getConcrete("redraw").enqueue(this);
        this._justAdded = 0L;
        try {
            this.checkHighBidder(true);
            if (this.isDutch()) {
                this.checkDutchHighBidder();
            }
        }
        catch (Exception exception) {
            ErrorManagement.handleException("Unexpected exception during high bidder check.", exception);
        }
        this.checkSeller();
        if (this._auctionEnded) {
            if (this.isMultiSniped()) {
                object = this.getMultiSnipe();
                if (this.isHighBidder() && (!this.isReserve() || this.isReserveMet())) {
                    ((MultiSnipe)object).setWonAuction(this);
                } else {
                    ((MultiSnipe)object).remove(this);
                }
            }
            if (this.isSniped()) {
                this.setLastStatus("Cancelling snipe, auction is reported as ended.");
                this.cancelSnipe(true);
            }
        } else {
            object = new Date(System.currentTimeMillis() + this._aucServ.getOfficialServerTimeDelta());
            if (((Date)object).after(this.getEndDate())) {
                this._auctionEnded = true;
                this._needsUpdate = true;
                this._forceUpdate = true;
            }
        }
    }

    public void prepareSnipe(Currency currency) {
        this.prepareSnipe(currency, 1);
    }

    public void prepareSnipe(Currency currency, int n) {
        this._snipeBid = currency;
        this._snipeQuantity = n;
        if (currency == null || currency.isNull()) {
            MQFactory.getConcrete(this._aucServ.getName()).enqueue(new AuctionQObject(10, this, null));
        } else {
            MQFactory.getConcrete(this._aucServ.getName()).enqueue(new AuctionQObject(8, this, null));
        }
        MQFactory.getConcrete("Swing").enqueue("SNIPECHANGED");
    }

    public int bid(Currency currency) {
        return this.bid(currency, 1);
    }

    public int bid(Currency currency, int n) {
        this.setBid(currency);
        this._whenBid = System.currentTimeMillis();
        ErrorManagement.logDebug("Bidding " + currency + " on " + n + " item[s] of (" + this.getIdentifier() + ")-" + this.getTitle());
        return this._aucServ.bid(this, currency, n);
    }

    public int buy(int n) {
        Currency currency = this.getBuyNow();
        if (currency != null && !currency.isNull()) {
            this.setBid(this.getBuyNow());
            this._whenBid = System.currentTimeMillis();
            ErrorManagement.logDebug("Buying " + n + " item[s] of (" + this.getIdentifier() + ")-" + this.getTitle());
            return this._aucServ.buy(this, n);
        }
        return 15;
    }

    public void setNeedsUpdate() {
        this._needsUpdate = true;
    }

    public void forceUpdate() {
        this._forceUpdate = true;
        this._dontUpdate = 0L;
        this._needsUpdate = true;
    }

    String getCategory() {
        return this._category;
    }

    void setCategory(String string) {
        this._category = string;
        if (this.isEnded()) {
            this._sticky = true;
        }
    }

    public boolean isSticky() {
        return this._sticky;
    }

    public void setSticky(boolean bl) {
        this._sticky = bl;
    }

    public void clearNeedsUpdate() {
        this._needsUpdate = false;
        this._lastUpdated = System.currentTimeMillis();
    }

    public void pauseUpdate() {
        this._dontUpdate = System.currentTimeMillis() + 300000L;
    }

    public boolean isPaused() {
        return this._dontUpdate != 0L;
    }

    private static String convertToMsgFormat(String string) {
        String string2 = string.replaceAll("DD", "{4}{0,number,##}");
        string2 = string2.replaceAll("HH", "{5}{1,number,##}");
        string2 = string2.replaceAll("MM", "{6}{2,number,##}");
        string2 = string2.replaceAll("SS", "{7}{3,number,##}");
        return string2;
    }

    public String getTimeLeft() {
        long l = System.currentTimeMillis();
        long l2 = this._aucServ.getOfficialServerTimeDelta();
        long l3 = this._aucServ.getPageRequestTime();
        boolean bl = JConfig.queryConfiguration("timeleft.detailed", "false").equals("true");
        if (!this.isEnded()) {
            long l4;
            try {
                l4 = this.getEndDate().getTime() - (l + l2 - l3);
            }
            catch (Exception exception) {
                ErrorManagement.handleException("Error getting the end date.", exception);
                l4 = 0L;
            }
            if (l4 >= 0L) {
                String string;
                long l5 = l4 / 86400000L;
                long l6 = (l4 -= l5 * 86400000L) / 3600000L;
                long l7 = (l4 -= l6 * 3600000L) / 60000L;
                long l8 = (l4 -= l7 * 60000L) / 1000L;
                if (l5 == 0L) {
                    if (l6 == 0L) {
                        string = bl ? mf_min_sec_detailed : mf_min_sec;
                        String string2 = JConfig.queryConfiguration("timeleft.minutes");
                        if (string2 != null) {
                            string = AuctionEntry.convertToMsgFormat(string2);
                        }
                    } else {
                        string = bl ? mf_hrs_min_detailed : mf_hrs_min;
                        String string3 = JConfig.queryConfiguration("timeleft.hours");
                        if (string3 != null) {
                            string = AuctionEntry.convertToMsgFormat(string3);
                        }
                    }
                } else {
                    string = bl ? mf_day_hrs_detailed : mf_day_hrs;
                    String string4 = JConfig.queryConfiguration("timeleft.days");
                    if (string4 != null) {
                        string = AuctionEntry.convertToMsgFormat(string4);
                    }
                }
                String string5 = "";
                String string6 = "";
                String string7 = "";
                String string8 = "";
                if (l5 < 10L) {
                    string5 = " ";
                }
                if (l6 < 10L) {
                    string6 = " ";
                }
                if (l7 < 10L) {
                    string7 = " ";
                }
                if (l8 < 10L) {
                    string8 = " ";
                }
                Object[] objectArray = new Object[]{new Long(l5), new Long(l6), new Long(l7), new Long(l8), string5, string6, string7, string8};
                return MessageFormat.format(string, objectArray);
            }
        }
        return endedAuction;
    }

    public boolean isEnded() {
        return this._auctionEnded;
    }

    public void setEnded(boolean bl) {
        this._auctionEnded = bl;
    }

    public boolean isUpdateForced() {
        return this._forceUpdate;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        if (object == this) {
            return 0;
        }
        if (!(object instanceof AuctionEntry)) {
            throw new ClassCastException("AuctionEntry cannot compareTo different classes!");
        }
        AuctionEntry auctionEntry = (AuctionEntry)object;
        if (this.getIdentifier().equals(auctionEntry.getIdentifier())) {
            return 0;
        }
        if (this.getEndDate().after(auctionEntry.getEndDate())) {
            return 1;
        }
        if (auctionEntry.getEndDate().after(this.getEndDate())) {
            return -1;
        }
        return this.getIdentifier().compareTo(auctionEntry.getIdentifier());
    }

    public int getFlags() {
        int n = 1;
        if (this.isFixed()) {
            n = 0;
        }
        if (this.getHighBidder() != null) {
            if (this.isHighBidder()) {
                n = 2;
            } else if (this.isSeller() && this.getNumBidders() > 0 && (!this.isReserve() || this.isReserveMet())) {
                n = 4;
            }
        }
        if (!this.getBuyNow().isNull()) {
            n += 8;
        }
        if (this.isReserve()) {
            n = this.isReserveMet() ? (n += 16) : (n += 32);
        }
        if (this.hasPaypal()) {
            n += 64;
        }
        return n;
    }

    public void setAuctionInfo(AuctionInfo auctionInfo) {
        if (!this._auction.getEndDate().equals(auctionInfo.getEndDate())) {
            Currency currency = this._snipeBid;
            int n = this._snipeQuantity;
            this.prepareSnipe(null);
            this.prepareSnipe(currency, n);
        }
        this._auction = auctionInfo;
        this.checkHighBidder(false);
        this.checkSeller();
        this.checkEnded();
    }

    public Currency getCurBid() {
        return this._auction.getCurBid();
    }

    public Currency getUSCurBid() {
        return this._auction.getUSCurBid();
    }

    public Currency getMinBid() {
        return this._auction.getMinBid();
    }

    public Currency getShipping() {
        if (this._shipping != null) {
            return this._shipping;
        }
        return this._auction.getShipping();
    }

    public Currency getInsurance() {
        return this._auction.getInsurance();
    }

    public boolean getInsuranceOptional() {
        return this._auction.getInsuranceOptional();
    }

    public Currency getBuyNow() {
        return this._auction.getBuyNow();
    }

    public int getQuantity() {
        return this._auction.getQuantity();
    }

    public int getNumBidders() {
        return this._auction.getNumBidders();
    }

    public String getSeller() {
        return this._auction.getSeller();
    }

    public String getHighBidder() {
        return this._auction.getHighBidder();
    }

    public String getHighBidderEmail() {
        return this._auction.getHighBidderEmail();
    }

    public String getTitle() {
        return this._auction.getTitle();
    }

    public Date getStartDate() {
        if (this._auction != null && this._auction.getStartDate() != null) {
            return this._auction.getStartDate();
        }
        return Constants.LONG_AGO;
    }

    public Date getEndDate() {
        if (this._auction != null && this._auction.getEndDate() != null) {
            return this._auction.getEndDate();
        }
        return Constants.FAR_FUTURE;
    }

    public Date getSnipeDate() {
        return new Date(this._auction.getEndDate().getTime() - this.getSnipeTime());
    }

    public boolean isDutch() {
        return this._auction.isDutch();
    }

    public boolean isReserve() {
        return this._auction.isReserve();
    }

    public boolean isReserveMet() {
        return this._auction.isReserveMet();
    }

    public boolean isPrivate() {
        return this._auction.isPrivate();
    }

    public boolean isFixed() {
        return this._auction.isFixed();
    }

    public boolean isOutbid() {
        return this._auction.isOutbid();
    }

    public StringBuffer getContent() {
        return this._auction.getContent();
    }

    public String getThumbnail() {
        return this._auction.getThumbnail();
    }

    public boolean hasPaypal() {
        return this._auction.hasPaypal();
    }

    public String getItemLocation() {
        return this._auction.getItemLocation();
    }

    public String getPostiveFeedbackPercentage() {
        return this._auction.getPostiveFeedbackPercentage();
    }

    public int getFeedbackScore() {
        return this._auction.getFeedbackScore();
    }

    public void setErrorPage(StringBuffer stringBuffer) {
        this._lastErrorPage = stringBuffer;
    }

    public StringBuffer getErrorPage() {
        return this._lastErrorPage;
    }

    public Currency getShippingWithInsurance() {
        Currency currency = this.getShipping();
        if (currency == null || currency.isNull()) {
            return Currency.NoValue();
        }
        if (this.getInsurance() != null && !this.getInsurance().isNull() && !this.getInsuranceOptional()) {
            try {
                currency = currency.add(this.getInsurance());
            }
            catch (Currency.CurrencyTypeException currencyTypeException) {
                ErrorManagement.handleException("Insurance is somehow a different type than shipping?!?", currencyTypeException);
            }
        }
        return currency;
    }

    public boolean isShippingOverridden() {
        return this._shippingSet;
    }

    public static class AuctionComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            AuctionEntry auctionEntry = (AuctionEntry)object;
            AuctionEntry auctionEntry2 = (AuctionEntry)object2;
            int n = auctionEntry.getEndDate().compareTo(auctionEntry2.getEndDate());
            if (n == 0) {
                n = auctionEntry.compareTo(auctionEntry2);
            }
            return n;
        }
    }
}

