/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.Date;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public abstract class AuctionInfo
extends XMLSerializeSimple {
    protected String _identifier = null;
    protected Currency _curBid = Currency.NoValue();
    protected Currency _minBid = Currency.NoValue();
    protected Currency _shipping = Currency.NoValue();
    protected Currency _insurance = Currency.NoValue();
    protected Currency _us_cur = Currency.NoValue();
    protected Currency _buy_now_us = Currency.NoValue();
    protected boolean _insurance_optional = true;
    protected boolean _fixed_price = false;
    protected boolean _no_thumbnail = false;
    protected Currency _buy_now = Currency.NoValue();
    protected Date _start;
    protected Date _end;
    protected String _seller;
    protected String _highBidder;
    protected String _title;
    protected String _highBidderEmail;
    protected int _quantity;
    protected int _numBids;
    protected boolean _isDutch;
    protected boolean _isReserve;
    protected boolean _isPrivate;
    protected boolean _reserveMet;
    protected boolean _hasThumb = false;
    protected boolean _outbid = false;
    protected int _feedback = 0;
    protected String _postivePercentage = "";
    protected String _itemLocation = "";
    protected boolean _paypal = false;
    protected static final BASE64Decoder b64dec = new BASE64Decoder();
    protected static final BASE64Encoder b64enc = new BASE64Encoder();
    protected GZip _loadedPage = null;
    protected String[] infoTags = new String[]{"title", "seller", "highbidder", "bidcount", "start", "end", "currently", "dutch", "reserve", "private", "content", "shipping", "insurance", "buynow", "usprice", "fixed", "minimum", "paypal", "location", "feedback", "percentage"};

    public AuctionInfo() {
    }

    public AuctionInfo(String string, String string2, String string3, Currency currency, Date date, Date date2, int n) {
        this._title = string.trim();
        this._highBidder = string3.trim();
        this._seller = string2.trim();
        this._start = date;
        this._end = date2;
        this._curBid = currency;
        this._numBids = n;
    }

    protected String[] getTags() {
        return this.infoTags;
    }

    protected void handleTag(int n, XMLElement xMLElement) {
        switch (n) {
            case 0: {
                if (JConfig.queryConfiguration("savefile.format", "0100").compareTo("0101") >= 0) {
                    this._title = xMLElement.decodeString(xMLElement.getContents(), 0);
                    break;
                }
                this._title = xMLElement.getContents();
                break;
            }
            case 1: {
                this._seller = xMLElement.getContents();
                break;
            }
            case 2: {
                this._highBidder = xMLElement.getContents();
                break;
            }
            case 3: {
                this._numBids = Integer.parseInt(xMLElement.getContents());
                break;
            }
            case 4: {
                this._start = new Date(Long.parseLong(xMLElement.getContents()));
                break;
            }
            case 5: {
                this._end = new Date(Long.parseLong(xMLElement.getContents()));
                break;
            }
            case 6: {
                this._curBid = Currency.getCurrency(xMLElement.getProperty("CURRENCY"), xMLElement.getProperty("PRICE"));
                if (this._curBid.getCurrencyType() != 1) break;
                this._us_cur = this._curBid;
                break;
            }
            case 7: {
                this._isDutch = true;
                this._quantity = Integer.parseInt(xMLElement.getProperty("QUANTITY"));
                break;
            }
            case 8: {
                this._isReserve = true;
                this._reserveMet = "true".equals(xMLElement.getProperty("MET"));
                break;
            }
            case 9: {
                this._isPrivate = true;
                break;
            }
            case 10: {
                String string = xMLElement.getProperty("COMPRESSED");
                try {
                    if (string == null || !string.equals("true")) {
                        this.setRealContent(b64dec.decodeBuffer(xMLElement.getContents()), true);
                    } else {
                        this.setRealContent(GZip.uncompress(b64dec.decodeBuffer(xMLElement.getContents()), false), true);
                    }
                }
                catch (IOException iOException) {
                    ErrorManagement.handleException("handleTag failed to load content.", iOException);
                }
                this._loadedPage = null;
                break;
            }
            case 11: {
                this._shipping = Currency.getCurrency(xMLElement.getProperty("CURRENCY"), xMLElement.getProperty("PRICE"));
                break;
            }
            case 12: {
                this._insurance = Currency.getCurrency(xMLElement.getProperty("CURRENCY"), xMLElement.getProperty("PRICE"));
                this._insurance_optional = xMLElement.getProperty("OPTIONAL") == null || xMLElement.getProperty("OPTIONAL").equals("true");
                break;
            }
            case 13: {
                this._buy_now = Currency.getCurrency(xMLElement.getProperty("CURRENCY"), xMLElement.getProperty("PRICE"));
                break;
            }
            case 14: {
                this._us_cur = Currency.getCurrency(xMLElement.getProperty("CURRENCY"), xMLElement.getProperty("PRICE"));
                break;
            }
            case 15: {
                this._fixed_price = true;
                break;
            }
            case 16: {
                this._minBid = Currency.getCurrency(xMLElement.getProperty("CURRENCY"), xMLElement.getProperty("PRICE"));
                break;
            }
            case 17: {
                this._paypal = true;
                break;
            }
            case 18: {
                this._itemLocation = xMLElement.getContents();
                break;
            }
            case 19: {
                this._feedback = Integer.parseInt(xMLElement.getContents());
                break;
            }
            case 20: {
                this._postivePercentage = xMLElement.getContents();
                break;
            }
        }
    }

    public XMLElement toXML() {
        XMLElement xMLElement = new XMLElement("info");
        XMLElement xMLElement2 = new XMLElement("title");
        xMLElement2.setContents(XMLElement.encodeString(this._title));
        xMLElement.addChild(xMLElement2);
        XMLElement xMLElement3 = new XMLElement("seller");
        xMLElement3.setContents(this._seller);
        xMLElement.addChild(xMLElement3);
        if (this._start != null) {
            XMLElement xMLElement4 = new XMLElement("start");
            xMLElement4.setContents(Long.toString(this._start.getTime()));
            xMLElement.addChild(xMLElement4);
        }
        if (this._end != null) {
            XMLElement xMLElement5 = new XMLElement("end");
            xMLElement5.setContents(Long.toString(this._end.getTime()));
            xMLElement.addChild(xMLElement5);
        }
        XMLElement xMLElement6 = new XMLElement("bidcount");
        xMLElement6.setContents(Integer.toString(this._numBids));
        xMLElement.addChild(xMLElement6);
        if (this._loadedPage != null) {
            XMLElement xMLElement7 = new XMLElement("content");
            xMLElement7.setProperty("compressed", "true");
            String string = b64enc.encode(this._loadedPage.getCompressedData());
            xMLElement7.setContents(string);
            xMLElement.addChild(xMLElement7);
        }
        XMLElement xMLElement8 = new XMLElement("currently");
        xMLElement8.setEmpty();
        xMLElement8.setProperty("currency", this._curBid.fullCurrencyName());
        xMLElement8.setProperty("price", Double.toString(this._curBid.getValue()));
        xMLElement.addChild(xMLElement8);
        if (this._shipping != null) {
            XMLElement xMLElement9 = new XMLElement("shipping");
            xMLElement9.setEmpty();
            xMLElement9.setProperty("currency", this._shipping.fullCurrencyName());
            xMLElement9.setProperty("price", Double.toString(this._shipping.getValue()));
            xMLElement.addChild(xMLElement9);
        }
        if (this._insurance != null) {
            XMLElement xMLElement10 = new XMLElement("insurance");
            xMLElement10.setEmpty();
            xMLElement10.setProperty("currency", this._insurance.fullCurrencyName());
            xMLElement10.setProperty("price", Double.toString(this._insurance.getValue()));
            xMLElement10.setProperty("optional", this._insurance_optional ? "true" : "false");
            xMLElement.addChild(xMLElement10);
        }
        if (this._buy_now != null) {
            XMLElement xMLElement11 = new XMLElement("buynow");
            xMLElement11.setEmpty();
            xMLElement11.setProperty("currency", this._buy_now.fullCurrencyName());
            xMLElement11.setProperty("price", Double.toString(this._buy_now.getValue()));
            xMLElement.addChild(xMLElement11);
        }
        if (this._curBid.getCurrencyType() != 1 && this._us_cur != null && !this._us_cur.isNull()) {
            XMLElement xMLElement12 = new XMLElement("usprice");
            xMLElement12.setEmpty();
            xMLElement12.setProperty("currency", this._us_cur.fullCurrencyName());
            xMLElement12.setProperty("price", Double.toString(this._us_cur.getValue()));
            xMLElement.addChild(xMLElement12);
        }
        if (this._minBid != null && !this._minBid.isNull()) {
            XMLElement xMLElement13 = new XMLElement("minimum");
            xMLElement13.setEmpty();
            xMLElement13.setProperty("currency", this._minBid.fullCurrencyName());
            xMLElement13.setProperty("price", Double.toString(this._minBid.getValue()));
            xMLElement.addChild(xMLElement13);
        }
        if (this._highBidder != null) {
            XMLElement xMLElement14 = new XMLElement("highbidder");
            xMLElement14.setContents(this._highBidder);
            xMLElement.addChild(xMLElement14);
        }
        if (this._isDutch) {
            XMLElement xMLElement15 = new XMLElement("dutch");
            xMLElement15.setEmpty();
            xMLElement15.setProperty("quantity", Integer.toString(this._quantity));
            xMLElement.addChild(xMLElement15);
        }
        if (this._isReserve) {
            XMLElement xMLElement16 = new XMLElement("reserve");
            xMLElement16.setEmpty();
            xMLElement16.setProperty("met", this._reserveMet ? "true" : "false");
            xMLElement.addChild(xMLElement16);
        }
        if (this._isPrivate) {
            XMLElement xMLElement17 = new XMLElement("private");
            xMLElement17.setEmpty();
            xMLElement.addChild(xMLElement17);
        }
        if (this._fixed_price) {
            XMLElement xMLElement18 = new XMLElement("fixed");
            xMLElement18.setEmpty();
            xMLElement.addChild(xMLElement18);
        }
        if (this._paypal) {
            XMLElement xMLElement19 = new XMLElement("paypal");
            xMLElement19.setEmpty();
            xMLElement.addChild(xMLElement19);
        }
        if (this._itemLocation != null && !this._itemLocation.equals("")) {
            XMLElement xMLElement20 = new XMLElement("location");
            xMLElement20.setContents(this._itemLocation);
            xMLElement.addChild(xMLElement20);
        }
        if (this._feedback != 0) {
            XMLElement xMLElement21 = new XMLElement("feedback");
            xMLElement21.setContents(Integer.toString(this._feedback));
            xMLElement.addChild(xMLElement21);
        }
        if (this._postivePercentage != null && !this._postivePercentage.equals("")) {
            XMLElement xMLElement22 = new XMLElement("percentage");
            xMLElement22.setContents(this._postivePercentage);
            xMLElement.addChild(xMLElement22);
        }
        return xMLElement;
    }

    public void setThumbnail(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            this._no_thumbnail = true;
        } else {
            this.saveThumbnail(byteBuffer);
        }
    }

    private void saveThumbnail(ByteBuffer byteBuffer) {
        this.getValidImagePath(byteBuffer);
    }

    private String getValidImagePath(ByteBuffer byteBuffer) {
        File file;
        String string;
        String string2 = JConfig.queryConfiguration("auctions.savepath");
        String string3 = string2 + System.getProperty("file.separator") + this._identifier;
        String string4 = string = string3 + "_t.jpg";
        if (byteBuffer != null) {
            byteBuffer.save(string3 + ".jpg");
        }
        if (!(file = new File(string)).exists()) {
            File file2 = new File(string3 + ".jpg");
            if (!file2.exists()) {
                return null;
            }
            String string5 = string3 + "_b.jpg";
            File file3 = new File(string5);
            string4 = string3 + ".jpg";
            if (!file3.exists()) {
                int n;
                int n2;
                int n3;
                String string6 = JConfig.queryConfiguration("thumbnail.maxWidth", "256");
                String string7 = JConfig.queryConfiguration("thumbnail.prefWidth", "128");
                String string8 = JConfig.queryConfiguration("thumbnail.maxHeight", "256");
                String string9 = JConfig.queryConfiguration("thumbnail.prefHeight", "128");
                int n4 = Integer.parseInt(string6);
                if (IconFactory.resizeImage(string4, string, n4, n3 = Integer.parseInt(string7), n2 = Integer.parseInt(string8), n = Integer.parseInt(string9))) {
                    string4 = string;
                } else {
                    try {
                        file3.createNewFile();
                    }
                    catch (IOException iOException) {
                        ErrorManagement.handleException("Can't create 'bad' lock file.", iOException);
                    }
                }
            }
        }
        return string4;
    }

    public void save() {
        String string = JConfig.queryConfiguration("auctions.savepath");
        if (string != null && JConfig.queryConfiguration("store.auctionHTML", "true").equals("true")) {
            String string2 = string + System.getProperty("file.separator") + this._identifier + ".html.gz";
            if (this._loadedPage != null) {
                this._loadedPage.save(string2);
            }
        }
        this._loadedPage = null;
    }

    public boolean hasThumbnail() {
        String string = this.getValidImagePath(null);
        if (string == null) {
            return false;
        }
        File file = new File(string);
        return file.exists();
    }

    public String getThumbnail() {
        if (!this._hasThumb && !this.hasThumbnail()) {
            return null;
        }
        this._hasThumb = true;
        String string = this.getValidImagePath(null);
        return "file:" + string;
    }

    private GZip loadFile(String string) {
        File file = new File(string);
        GZip gZip = new GZip();
        if (file.exists()) {
            if (file.length() < 524288L) {
                try {
                    ErrorManagement.logDebug("Loading from backing page (file is " + file.length() + " bytes)!");
                    gZip.load(file);
                }
                catch (IOException iOException) {
                    ErrorManagement.handleException("Couldn't read " + string, iOException);
                    return null;
                }
                return gZip;
            }
            ErrorManagement.logDebug("Can't load " + string + ", file is too large.");
        }
        return null;
    }

    public void setRealContent(StringBuffer stringBuffer, boolean bl) {
        if (stringBuffer != null) {
            byte[] byArray = stringBuffer.toString().getBytes();
            this.setRealContent(byArray, bl);
        }
    }

    public void setRealContent(byte[] byArray, boolean bl) {
        String string = JConfig.queryConfiguration("auctions.savepath");
        if (byArray != null) {
            this._loadedPage = new GZip();
            this._loadedPage.setData(byArray);
            if (string != null && bl) {
                String string2 = string + System.getProperty("file.separator") + this._identifier + ".html.gz";
                this._loadedPage.save(string2);
                this._loadedPage = null;
            }
        }
    }

    public GZip getRealContent() {
        String string = JConfig.queryConfiguration("auctions.savepath");
        if (string != null) {
            String string2 = string + System.getProperty("file.separator") + this._identifier + ".html.gz";
            ErrorManagement.logDebug("filePath = " + string2);
            return this.loadFile(string2);
        }
        return this._loadedPage;
    }

    public void setContent(StringBuffer stringBuffer, boolean bl) {
        this.setRealContent(stringBuffer, bl);
    }

    public StringBuffer getContent() {
        StringBuffer stringBuffer;
        if (this._loadedPage != null) {
            StringBuffer stringBuffer2 = this._loadedPage.getUncompressedData(false);
            if (stringBuffer2 == null) {
                stringBuffer2 = new StringBuffer("_loadedPage.getUncompressedData is null");
            }
            stringBuffer = stringBuffer2;
        } else {
            ErrorManagement.logDebug("_loadedPage is null, returning the 'real' cached copy!");
            GZip gZip = this.getRealContent();
            if (gZip != null) {
                stringBuffer = gZip.getUncompressedData();
                ErrorManagement.logDebug("Turned the uncompressed data into a StringBuffer!");
                if (stringBuffer == null) {
                    ErrorManagement.logDebug(" Failed to uncompress for id " + this._identifier);
                }
            } else {
                stringBuffer = new StringBuffer("Error getting real content.");
            }
        }
        return stringBuffer;
    }

    public void setIdentifier(String string) {
        this._identifier = string;
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public Currency getCurBid() {
        Currency currency = Currency.NoValue();
        if (this._curBid != null && !this._curBid.isNull()) {
            currency = this._curBid;
        }
        if (currency.isNull() && this._buy_now != null && !this._buy_now.isNull()) {
            currency = this._buy_now;
        }
        return currency;
    }

    public Currency getUSCurBid() {
        Currency currency = Currency.NoValue();
        if (this._us_cur != null && !this._us_cur.isNull()) {
            currency = this._us_cur;
        } else if (this._curBid.getCurrencyType() == 1) {
            currency = this._curBid;
        }
        if (currency.isNull() && this._buy_now_us != null && !this._buy_now_us.isNull()) {
            currency = this._buy_now_us;
        }
        return currency;
    }

    public Currency getMinBid() {
        if (this._minBid != null) {
            return this._minBid;
        }
        return this._curBid;
    }

    public Currency getShipping() {
        return this._shipping;
    }

    public Currency getInsurance() {
        return this._insurance;
    }

    public boolean getInsuranceOptional() {
        return this._insurance_optional;
    }

    public Currency getBuyNow() {
        return this._buy_now;
    }

    public int getQuantity() {
        return this._quantity;
    }

    public int getNumBidders() {
        return this._numBids;
    }

    public String getSeller() {
        return this._seller;
    }

    public String getHighBidder() {
        return this._highBidder;
    }

    public String getHighBidderEmail() {
        return this._highBidderEmail;
    }

    public String getTitle() {
        return this._title;
    }

    public Date getStartDate() {
        return this._start;
    }

    public Date getEndDate() {
        return this._end;
    }

    public boolean isDutch() {
        return this._isDutch;
    }

    public boolean isReserve() {
        return this._isReserve;
    }

    public boolean isPrivate() {
        return this._isPrivate;
    }

    public boolean isFixed() {
        return this._fixed_price;
    }

    public boolean isReserveMet() {
        return this._reserveMet;
    }

    public boolean isOutbid() {
        return this._outbid;
    }

    public boolean hasPaypal() {
        return this._paypal;
    }

    public String getItemLocation() {
        return this._itemLocation;
    }

    public String getPostiveFeedbackPercentage() {
        return this._postivePercentage;
    }

    public int getFeedbackScore() {
        return this._feedback;
    }

    public abstract ByteBuffer getSiteThumbnail();

    public abstract ByteBuffer getAlternateSiteThumbnail();
}

