/*
 * Decompiled with CFR 0.152.
 */
public class Auctions
implements TimerHandler.WakeupProcess {
    boolean _selling = false;
    boolean _complete = false;
    private volatile TableSorter _tSort;
    private String _name;
    private static volatile boolean isBlocked = false;
    private static final int LINE_LENGTH = 80;

    public Auctions(String string) {
        this._name = string;
        this._tSort = new TableSorter(string, "Time left", new auctionTableModel());
    }

    public String getName() {
        return this._name;
    }

    public static void startBlocking() {
        isBlocked = true;
    }

    public static void endBlocking() {
        isBlocked = false;
    }

    public static boolean isBlocked() {
        return isBlocked;
    }

    public TableSorter getTableSorter() {
        return this._tSort;
    }

    public void setSelling() {
        this._selling = true;
    }

    public boolean isSelling() {
        return this._selling;
    }

    public void setComplete() {
        this._complete = true;
    }

    public boolean isCompleted() {
        return this._complete;
    }

    public int getColumnCount() {
        return this._tSort.getColumnCount();
    }

    public int getRowCount() {
        return this._tSort.getRowCount();
    }

    public String getColumnName(int n) {
        return this._tSort.getColumnName(n);
    }

    public int getColumnNumber(String string) {
        return this._tSort.getColumnNumber(string);
    }

    public AuctionEntry getEntry(final String string) {
        Object object = this._tSort.find(new Comparison(){

            public boolean match(Object object) {
                AuctionEntry auctionEntry;
                return object instanceof AuctionEntry && string.equals((auctionEntry = (AuctionEntry)object).getIdentifier());
            }
        });
        return (AuctionEntry)object;
    }

    public boolean update(AuctionEntry auctionEntry) {
        return this._tSort.update(auctionEntry);
    }

    public void refilterAll(boolean bl) {
        for (int i = this._tSort.getRowCount() - 1; i >= 0; --i) {
            AuctionEntry auctionEntry = (AuctionEntry)this._tSort.getValueAt(i, -1);
            if (bl) {
                this.delEntry(auctionEntry);
                continue;
            }
            auctionEntry.setCategory(null);
            FilterManager.getInstance().refilterAuction(auctionEntry, false);
        }
    }

    public void delEntry(AuctionEntry auctionEntry) {
        boolean bl = this._tSort.delete(auctionEntry);
        if (bl) {
            AuctionServerManager.getInstance().delete_entry(auctionEntry);
        }
    }

    private static boolean manageDeleted(AuctionEntry auctionEntry) {
        if (AuctionsManager.getInstance().isDeleted(auctionEntry.getIdentifier())) {
            ErrorManagement.logDebug("Skipping previously deleted auction (" + auctionEntry.getIdentifier() + ").");
            return true;
        }
        return false;
    }

    public boolean addEntry(AuctionEntry auctionEntry) {
        boolean bl;
        if (auctionEntry == null) {
            return true;
        }
        if (Auctions.manageDeleted(auctionEntry)) {
            return false;
        }
        boolean bl2 = bl = this._tSort.insert(auctionEntry) != -1;
        if (bl) {
            AuctionServerManager.getInstance().add_entry(auctionEntry);
            return true;
        }
        ErrorManagement.logMessage("JBidWatch: Bad auction entry, cannot add!");
        return false;
    }

    public boolean verifyEntry(String string) {
        AuctionEntry auctionEntry = this.getEntry(string);
        return auctionEntry != null;
    }

    public boolean verifyEntry(final AuctionEntry auctionEntry) {
        Object object = this._tSort.find(new Comparison(){

            public boolean match(Object object) {
                return object == auctionEntry;
            }
        });
        return object != null;
    }

    public boolean anySnipes() {
        Object object = this._tSort.find(new Comparison(){

            public boolean match(Object object) {
                AuctionEntry auctionEntry = (AuctionEntry)object;
                return auctionEntry.isSniped() && !auctionEntry.isEnded();
            }
        });
        return object != null;
    }

    private static String getTitleAndComment(AuctionEntry auctionEntry) {
        String string = auctionEntry.getComment();
        if (string == null) {
            return auctionEntry.getTitle();
        }
        StringBuffer stringBuffer = new StringBuffer(" (");
        stringBuffer.append(auctionEntry.getTitle()).append(')');
        return stringBuffer.toString();
    }

    private boolean doUpdate(AuctionEntry auctionEntry) {
        String string = Auctions.getTitleAndComment(auctionEntry);
        if (!auctionEntry.isEnded() || auctionEntry.isUpdateForced()) {
            MQFactory.getConcrete("Swing").enqueue("Updating " + string);
            auctionEntry.update();
            Auctions auctions = FilterManager.getInstance().refilterAuction(auctionEntry, false);
            if (auctions == null) {
                MQFactory.getConcrete("Swing").enqueue("Done updating " + string);
            } else {
                MQFactory.getConcrete("Swing").enqueue(new StringBuffer(80).append("Moved to ").append(auctions.getName()).append(' ').append(string).toString());
                return true;
            }
        }
        return false;
    }

    private boolean doNextUpdate() {
        AuctionEntry auctionEntry = (AuctionEntry)this._tSort.find(new Comparison(){

            public boolean match(Object object) {
                return ((AuctionEntry)object).checkUpdate();
            }
        });
        if (auctionEntry != null) {
            boolean bl = auctionEntry.isUpdateForced();
            if (this.doUpdate(auctionEntry) || bl) {
                this._tSort.sort();
            }
        }
        return auctionEntry != null;
    }

    public boolean check() {
        if (isBlocked) {
            return false;
        }
        return this.doNextUpdate();
    }

    public void updateTime() {
        this._tSort.updateTime();
    }
}

