/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeMap;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class AuctionsUIModel {
    private Auctions _dataModel;
    private JTable _table;
    private JScrollPane _scroller;
    private DropTarget[] _targets;
    private Color _bgColor;
    private JPrintable _print;
    private CSVExporter _export;
    private JLabel _prices;
    private static final int DEFAULT_COLUMN_WIDTH = 75;
    private static final myTableCellRenderer _myRenderer = new myTableCellRenderer();
    private static final JContext tableAdapter = new JBidMouse();
    private static final JMouseAdapter frameAdapter = new JBidFrameMouse();
    private static final JTabManager allTabs = new JTabManager();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$javax$swing$ImageIcon;

    public AuctionsUIModel(Auctions auctions) {
        Object object;
        this._dataModel = auctions;
        this._targets = new DropTarget[2];
        this._table = this.prepTable(this._dataModel.getName(), this._dataModel.getTableSorter());
        if (auctions.isCompleted() && this._table.convertColumnIndexToView(12) == -1) {
            this._table.addColumn(new TableColumn(12, 75, _myRenderer, null));
        }
        if (JConfig.queryConfiguration("show_shipping", "false").equals("true")) {
            if (this._table.convertColumnIndexToView(7) == -1) {
                this._table.addColumn(new TableColumn(7));
            }
            JConfig.killAll("show_shipping");
        }
        this._table.addMouseListener(tableAdapter);
        this._dataModel.getTableSorter().addMouseListenerToHeaderInTable(this._table);
        this._scroller = JConfig.queryConfiguration("mac.aqua", "false").equals("true") ? new JScrollPane(this._table, 22, 31) : new JScrollPane(this._table, 20, 31);
        if (JConfig.queryConfiguration("ui.useCornerButton", "false").equals("true")) {
            object = new JButton("!");
            this._scroller.setCorner("UPPER_RIGHT_CORNER", (Component)object);
            ((AbstractButton)object).setActionCommand("!");
            ((Component)object).addMouseListener(tableAdapter);
        }
        this._bgColor = UIManager.getColor("window");
        this._scroller.getViewport().setBackground(this._bgColor);
        this._scroller.getViewport().addMouseListener(frameAdapter);
        object = auctions.isCompleted() ? new JDropListener(new JTableDrop()) : new JDropListener(new JTableDrop(this._dataModel.getName()));
        this._targets[0] = new DropTarget(this._scroller.getViewport(), (DropTargetListener)object);
        this._targets[1] = new DropTarget(this._table, (DropTargetListener)object);
        this._targets[0].setActive(true);
        this._targets[1].setActive(true);
        this._print = new JPrintable(this._table);
        this._export = new CSVExporter(this._table);
        this._table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = AuctionsUIModel.class$("java.lang.String")) : class$java$lang$String, _myRenderer);
        TableCellRenderer tableCellRenderer = this._table.getDefaultRenderer(class$javax$swing$Icon == null ? (class$javax$swing$Icon = AuctionsUIModel.class$("javax.swing.Icon")) : class$javax$swing$Icon);
        if (tableCellRenderer == null) {
            ErrorManagement.logDebug("No default renderer for icons?!?");
            tableCellRenderer = this._table.getDefaultRenderer(class$javax$swing$ImageIcon == null ? (class$javax$swing$ImageIcon = AuctionsUIModel.class$("javax.swing.ImageIcon")) : class$javax$swing$ImageIcon);
            if (tableCellRenderer == null) {
                ErrorManagement.logDebug("No default renderer for image icons either?!?");
            }
        }
        _myRenderer.setIconRenderer(tableCellRenderer);
        this._table.setDefaultRenderer(class$javax$swing$Icon == null ? (class$javax$swing$Icon = AuctionsUIModel.class$("javax.swing.Icon")) : class$javax$swing$Icon, _myRenderer);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this._scroller, "Center");
        JPanel jPanel2 = this.buildBottomPanel();
        jPanel.add((Component)jPanel2, "South");
        allTabs.add(this._dataModel.getName(), jPanel, this._dataModel.getTableSorter());
    }

    private JPanel buildBottomPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this._prices = new JLabel(" ");
        jPanel.add((Component)this._prices, "East");
        if (JConfig.queryConfiguration("display.bottombuttons", "false").equals("true")) {
            Box box = Box.createHorizontalBox();
            JButton jButton = tableAdapter.makeButton("Snipe");
            JButton jButton2 = tableAdapter.makeButton("Buy");
            JButton jButton3 = tableAdapter.makeButton("Bid");
            box.add(jButton);
            box.add(jButton2);
            box.add(jButton3);
            jPanel.add((Component)box, "West");
            jButton.setText("  Snipe   ");
            jButton3.setEnabled(true);
            jButton2.setEnabled(true);
        } else {
            jPanel.add((Component)JBidWatch.makeButton("icons/xml.gif", "Show RSS feed information", "RSS", allTabs, true), "West");
        }
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int[] nArray = AuctionsUIModel.this._table.getSelectedRows();
                if (nArray.length == 0) {
                    AuctionsUIModel.this._prices.setText(" ");
                } else {
                    String string = AuctionsUIModel.this.sum(nArray);
                    if (string != null) {
                        AuctionsUIModel.this._prices.setText(nArray.length + " items, price total: " + string);
                    } else {
                        AuctionsUIModel.this._prices.setText(" ");
                    }
                }
            }
        });
        return jPanel;
    }

    private static Currency getBestBidValue(AuctionEntry auctionEntry) {
        Currency currency = auctionEntry.isSniped() ? auctionEntry.getSnipeBid() : (auctionEntry.isBidOn() && !auctionEntry.isEnded() ? auctionEntry.getBid() : auctionEntry.getCurBid());
        return currency;
    }

    private static Currency addUSD(Currency currency, AuctionEntry auctionEntry) {
        boolean bl = currency == null || currency.isNull();
        try {
            if (auctionEntry.getShippingWithInsurance().isNull()) {
                if (bl) {
                    return auctionEntry.getUSCurBid();
                }
                return currency.add(auctionEntry.getUSCurBid());
            }
            currency = bl ? auctionEntry.getUSCurBid().add(Currency.convertToUSD(auctionEntry.getUSCurBid(), auctionEntry.getCurBid(), auctionEntry.getShippingWithInsurance())) : currency.add(auctionEntry.getUSCurBid().add(Currency.convertToUSD(auctionEntry.getUSCurBid(), auctionEntry.getCurBid(), auctionEntry.getShippingWithInsurance())));
        }
        catch (Currency.CurrencyTypeException currencyTypeException) {
            ErrorManagement.handleException("This should have been cleaned up.", currencyTypeException);
        }
        return currency;
    }

    private static Currency addNonUSD(Currency currency, AuctionEntry auctionEntry) {
        boolean bl = currency == null || currency.isNull();
        try {
            if (auctionEntry.getShippingWithInsurance().isNull()) {
                if (bl) {
                    return auctionEntry.getCurBid();
                }
                return currency.add(auctionEntry.getCurBid());
            }
            currency = bl ? auctionEntry.getCurBid().add(auctionEntry.getShippingWithInsurance()) : currency.add(auctionEntry.getCurBid().add(auctionEntry.getShippingWithInsurance()));
        }
        catch (Currency.CurrencyTypeException currencyTypeException) {
            ErrorManagement.handleException("This should have been cleaned up.", currencyTypeException);
        }
        return currency;
    }

    protected String sum(int[] nArray) {
        Object object;
        boolean bl = false;
        boolean bl2 = true;
        Currency currency = null;
        Currency currency2 = null;
        Currency currency3 = null;
        Currency currency4 = null;
        try {
            for (int i = 0; i < nArray.length; ++i) {
                try {
                    object = (AuctionEntry)this._table.getValueAt(nArray[i], -1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    object = null;
                    bl = true;
                }
                if (object == null) continue;
                if (currency == null) {
                    currency = ((AuctionEntry)object).getUSCurBid();
                    currency4 = AuctionsUIModel.getBestBidValue((AuctionEntry)object);
                    currency2 = AuctionsUIModel.addUSD(currency2, (AuctionEntry)object);
                    currency3 = AuctionsUIModel.addNonUSD(currency3, (AuctionEntry)object);
                } else {
                    Currency currency5 = ((AuctionEntry)object).getUSCurBid();
                    if (!currency5.isNull() && !currency.isNull() && currency5.getCurrencyType() != 0) {
                        currency = currency.add(currency5);
                        currency2 = AuctionsUIModel.addUSD(currency2, (AuctionEntry)object);
                        if (bl2) {
                            try {
                                currency4 = currency4.add(AuctionsUIModel.getBestBidValue((AuctionEntry)object));
                                currency3 = AuctionsUIModel.addNonUSD(currency3, (AuctionEntry)object);
                            }
                            catch (Currency.CurrencyTypeException currencyTypeException) {
                                bl2 = false;
                            }
                        }
                    }
                }
                if (((AuctionEntry)object).getCurBid().getCurrencyType() == 1) continue;
                bl = true;
            }
        }
        catch (Currency.CurrencyTypeException currencyTypeException) {
            ErrorManagement.handleException("Sum currency exception!", currencyTypeException);
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ErrorManagement.logDebug("Selection of " + nArray.length + " items changed out from under 'sum'.");
            return null;
        }
        catch (Exception exception) {
            ErrorManagement.handleException("Sum serious exception!", exception);
            return null;
        }
        if (currency == null || currency.isNull()) {
            return null;
        }
        String string = "s/h";
        if (!Locale.getDefault().equals(Locale.US)) {
            string = "p/p";
        }
        if (bl2 && currency4 != null) {
            object = new StringBuffer(currency4.toString());
            if (currency3 != null && !currency4.equals(currency3)) {
                ((StringBuffer)object).append(" (").append(currency3).append(" with ").append(string).append(')');
            }
            return ((StringBuffer)object).toString();
        }
        if (bl) {
            object = currency2 != null && !currency.equals(currency2) ? "Approximately " + currency.toString() + " (" + currency2 + " with " + string + ')' : "Approximately " + currency.toString();
            return object;
        }
        if (currency2 != null && !currency.equals(currency2)) {
            return currency.toString() + " (" + currency2 + " with " + string + ')';
        }
        return currency.toString();
    }

    public static JTabManager getTabManager() {
        return allTabs;
    }

    public void setBackground(Color color) {
        this._scroller.getViewport().setBackground(color);
        this._table.setBackground(color);
        this._bgColor = color;
    }

    public Color getBackground() {
        return this._bgColor;
    }

    public boolean redrawEntry(AuctionEntry auctionEntry) {
        return this._dataModel.update(auctionEntry);
    }

    public void redraw() {
        this._dataModel.updateTime();
    }

    public boolean toggleField(String string) {
        int n = TableColumnController.getInstance().getColumnNumber(string);
        if (this._table.convertColumnIndexToView(n) == -1) {
            this._table.addColumn(new TableColumn(n, 75, _myRenderer, null));
            return true;
        }
        this._table.removeColumn(this._table.getColumn(string));
        this._dataModel.getTableSorter().removeColumn(string, this._table);
        return false;
    }

    public List getColumns() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this._table.getColumnCount(); ++i) {
            arrayList.add(this._table.getColumnName(i));
        }
        return arrayList;
    }

    public boolean export(String string) {
        return this._export.export(string);
    }

    private JTable prepTable(String string, TableModel tableModel) {
        int n;
        String string2;
        if (string == null) {
            throw new NullPointerException("prepTable(prefix == null)");
        }
        if (tableModel == null) {
            throw new NullPointerException("prepTable(, atm==null)");
        }
        AuctionTable auctionTable = new AuctionTable();
        auctionTable.setShowGrid(false);
        auctionTable.setIntercellSpacing(new Dimension(0, 0));
        auctionTable.setDoubleBuffered(true);
        auctionTable.setAutoCreateColumnsFromModel(false);
        auctionTable.setModel(tableModel);
        String string3 = "";
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        try {
            for (int i = 0; i < tableModel.getColumnCount(); ++i) {
                string3 = tableModel.getColumnName(i);
                string2 = JConfig.queryDisplayProperty(string + '.' + string3);
                if (string2 == null) {
                    string2 = JConfig.queryDisplayProperty(string3);
                }
                if (string2 == null) continue;
                TableColumn tableColumn = new TableColumn(i);
                tableColumn.setHeaderValue(string3);
                tableColumn.setIdentifier(string3);
                auctionTable.addColumn(tableColumn);
                n = string2.indexOf(46);
                if (n != -1) {
                    String string4 = string2.substring(0, n);
                    string2 = string2.substring(n + 1);
                    treeMap.put(string3, new Integer(Integer.parseInt(string4)));
                }
                auctionTable.getColumn(string3).setPreferredWidth(Integer.parseInt(string2));
            }
        }
        catch (Exception exception) {
            ErrorManagement.handleException("In display configuration for table " + string + ", column \"" + string3 + "\" has an invalid property.", exception);
            ErrorManagement.logDebug("No longer loading column widths from configuration.");
        }
        if (!treeMap.isEmpty()) {
            Iterator iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                int n2 = auctionTable.getColumnModel().getColumnIndex(string2);
                n = (Integer)treeMap.get(string2);
                try {
                    auctionTable.moveColumn(n2, n);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return auctionTable;
    }

    public static String buildHTMLComment(AuctionEntry auctionEntry) {
        boolean bl;
        if (auctionEntry == null) {
            return null;
        }
        boolean bl2 = auctionEntry.getComment() != null;
        boolean bl3 = bl = auctionEntry.getThumbnail() != null;
        if (JConfig.queryConfiguration("display.thumbnail", "true").equals("false")) {
            bl = false;
        }
        if (!bl2 && !bl) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("<html><body>");
        if (bl && bl2) {
            stringBuffer.append("<table><tr><td><img src=\"").append(auctionEntry.getThumbnail()).append("\"></td><td>").append(auctionEntry.getComment()).append("</td></tr></table>");
        } else if (bl) {
            stringBuffer.append("<img src=\"").append(auctionEntry.getThumbnail()).append("\">");
        } else {
            stringBuffer.append(auctionEntry.getComment());
        }
        stringBuffer.append("</body></html>");
        return stringBuffer.toString();
    }

    public void print() {
        this._print.doPrint();
    }

    public void getColumnWidthsToProperties(Properties properties, String string) {
        for (int i = 0; i < this._table.getColumnCount(); ++i) {
            TableColumn tableColumn;
            try {
                tableColumn = this._table.getColumn(this._table.getColumnName(i));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManagement.logMessage("Column can't be retrieved from the table: " + this._table.getColumnName(i));
                tableColumn = null;
            }
            if (tableColumn == null) continue;
            properties.setProperty(string + '.' + this._table.getColumnName(i), Integer.toString(i) + '.' + Integer.toString(tableColumn.getWidth()));
        }
    }

    public void getColumnWidthsToProperties(Properties properties) {
        this.getColumnWidthsToProperties(properties, this._dataModel.getName());
    }

    public XMLElement getColumnsToXML() {
        XMLElement xMLElement = new XMLElement("columns");
        xMLElement.setProperty("count", Integer.toString(this._dataModel.getColumnCount()));
        xMLElement.setProperty("name", this._dataModel.getName());
        for (int i = 0; i < this._dataModel.getColumnCount(); ++i) {
            String string = this._dataModel.getColumnName(i);
            TableColumn tableColumn = this._table.getColumn(string);
            ColumnProps columnProps = new ColumnProps(string, i, tableColumn.getWidth());
            xMLElement.addChild(columnProps.toXML());
        }
        return xMLElement;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class AuctionTable
    extends JTable {
        private static final String METAL_MOUSE_LISTENER = "javax.swing.plaf.basic.BasicTableUI$MouseInputHandler";
        private static final String AQUA_MOUSE_LISTENER = "apple.laf.AquaTableUI$MouseInputHandler";
        private MouseListenerSelectProxy proxyMouseListener;

        private AuctionTable() {
            this.createDefaultRenderers();
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            int n = this.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            AuctionEntry auctionEntry = (AuctionEntry)this.getValueAt(n, -1);
            String string = AuctionsUIModel.buildHTMLComment(auctionEntry);
            if (string == null) {
                return super.getToolTipText(mouseEvent);
            }
            return string;
        }

        public synchronized void addMouseListener(MouseListener mouseListener) {
            String string = mouseListener.getClass().getName();
            if (this.proxyMouseListener == null && (string.equals(METAL_MOUSE_LISTENER) || string.equals(AQUA_MOUSE_LISTENER))) {
                this.proxyMouseListener = new MouseListenerSelectProxy(mouseListener);
                super.addMouseListener(this.proxyMouseListener);
            } else {
                super.addMouseListener(mouseListener);
            }
        }

        public synchronized void removeMouseListener(MouseListener mouseListener) {
            if (this.proxyMouseListener != null && mouseListener == this.proxyMouseListener.getPeer()) {
                super.removeMouseListener(this.proxyMouseListener);
                this.proxyMouseListener = null;
            } else {
                super.removeMouseListener(mouseListener);
            }
        }

        class MouseListenerSelectProxy
        implements MouseListener {
            private MouseListener m_peer;

            MouseListenerSelectProxy(MouseListener mouseListener) {
                this.m_peer = mouseListener;
            }

            public MouseListener getPeer() {
                return this.m_peer;
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    this.m_peer.mouseClicked(mouseEvent);
                }
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                this.m_peer.mouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                this.m_peer.mouseExited(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    this.m_peer.mousePressed(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (!mouseEvent.isPopupTrigger()) {
                    this.m_peer.mouseReleased(mouseEvent);
                }
            }
        }
    }

    private class ColumnProps {
        private String m_name;
        private int m_viewOrder;
        private int m_width;

        ColumnProps(String string, int n, int n2) {
            this.m_name = string;
            this.m_viewOrder = n;
            this.m_width = n2;
        }

        ColumnProps() {
            this.m_name = null;
            this.m_viewOrder = 0;
            this.m_width = -1;
        }

        public String getName() {
            return this.m_name;
        }

        public int getOrder() {
            return this.m_viewOrder;
        }

        public int getWidth() {
            return this.m_width;
        }

        public XMLElement toXML() {
            XMLElement xMLElement = new XMLElement("column");
            xMLElement.setProperty("name", this.getName());
            xMLElement.setProperty("order", Integer.toString(this.getOrder()));
            xMLElement.setProperty("width", Integer.toString(this.getWidth()));
            xMLElement.setEmpty();
            return xMLElement;
        }

        public void fromXML(XMLElement xMLElement) {
            this.m_name = xMLElement.getProperty("name");
            this.m_viewOrder = Integer.parseInt(xMLElement.getProperty("order"));
            this.m_width = Integer.parseInt(xMLElement.getProperty("width"));
        }
    }

    class JComponentCellRenderer
    implements TableCellRenderer {
        JComponentCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            return (Component)object;
        }
    }
}

