/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javax.swing.Icon;
import javax.swing.JTable;

public class CSVExporter {
    private JTable m_table;

    public CSVExporter(JTable jTable) {
        this.m_table = jTable;
    }

    private static void addCSV(StringBuffer stringBuffer, Object object, boolean bl) {
        String string = object.toString();
        string = string.replaceAll("\"", "\"\"");
        if (bl) {
            stringBuffer.append(',');
        }
        stringBuffer.append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
    }

    public boolean export(String string) {
        PrintStream printStream = null;
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            for (n = 0; n < this.m_table.getColumnModel().getColumnCount(); ++n) {
                CSVExporter.addCSV(stringBuffer, this.m_table.getColumnModel().getColumn(n).getHeaderValue(), n != 0);
            }
            stringBuffer.append('\n');
            for (n = 0; n < this.m_table.getRowCount(); ++n) {
                for (int i = 0; i < this.m_table.getColumnCount(); ++i) {
                    Object object = this.m_table.getValueAt(n, i);
                    if (object instanceof Icon) {
                        CSVExporter.addCSV(stringBuffer, "", i != 0);
                        continue;
                    }
                    if (object == null) continue;
                    CSVExporter.addCSV(stringBuffer, object, i != 0);
                }
                stringBuffer.append('\n');
            }
            printStream = new PrintStream(new FileOutputStream(string));
            printStream.println(stringBuffer);
            printStream.close();
        }
        catch (IOException iOException) {
            if (printStream != null) {
                try {
                    printStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ErrorManagement.handleException("Failed to write CSV file.", iOException);
            return false;
        }
        return true;
    }
}

