/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class CookieJar {
    private Map _cookies = new TreeMap();
    private boolean m_ignore_redirect_cookies = true;
    private static final boolean do_uber_debug = false;

    void ignoreCookiesInRedirects() {
        this.m_ignore_redirect_cookies = true;
    }

    void catchCookiesInRedirects() {
        this.m_ignore_redirect_cookies = false;
    }

    public Cookie getCookie(String string) {
        return (Cookie)this._cookies.get(string);
    }

    public StringBuffer getAllCookiesAndPage(String string) throws CookieException {
        return this.getAllCookiesAndPage(string, null, true);
    }

    public StringBuffer getAllCookiesAndPage(String string, String string2) throws CookieException {
        return this.getAllCookiesAndPage(string, string2, true);
    }

    public StringBuffer getAllCookiesAndPage(String string, String string2, boolean bl) throws CookieException {
        return this.getAllCookiesAndPage(string, string2, bl, null);
    }

    public StringBuffer getAllCookiesAndPage(String string, String string2, boolean bl, List list) throws CookieException {
        URLConnection uRLConnection = this.getAllCookiesFromPage(string, string2, bl, list);
        if (uRLConnection == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        try {
            stringBuffer = Http.receivePage(uRLConnection);
        }
        catch (ConnectException connectException) {
            this.logException(string, connectException);
            if (connectException.toString().indexOf("Connection refused") != -1) {
                throw new CookieException("Connection refused", connectException);
            }
        }
        catch (IOException iOException) {
            this.logException(string, iOException);
            return null;
        }
        return stringBuffer;
    }

    private void logException(String string, Exception exception) {
        int n = string.indexOf(63);
        String string2 = n == -1 ? "Error loading page: " + string : "Error loading page: " + string.substring(0, n);
        ErrorManagement.handleException(string2, exception);
    }

    public URLConnection getAllCookiesFromPage(String string, String string2, boolean bl) {
        return this.getAllCookiesFromPage(string, string2, bl, null);
    }

    public URLConnection getAllCookiesFromPage(String string, String string2, boolean bl, List list) {
        String string3 = string;
        if (list != null) {
            list.add(string);
        }
        String string4 = null;
        if (bl) {
            int n = string.indexOf("?");
            if (n < 0) {
                bl = false;
            } else {
                string4 = string.substring(n + 1);
                string3 = string.substring(0, n);
            }
        }
        HttpURLConnection httpURLConnection = this._cookies.size() > 0 ? (bl ? (HttpURLConnection)Http.postFormPage(string3, string4, this.toString(), string2, this.m_ignore_redirect_cookies) : (HttpURLConnection)Http.getPage(string3, this.toString(), string2, this.m_ignore_redirect_cookies)) : (bl ? (HttpURLConnection)Http.postFormPage(string3, string4, null, string2, this.m_ignore_redirect_cookies) : (HttpURLConnection)Http.getPage(string3, null, string2, this.m_ignore_redirect_cookies));
        if (httpURLConnection != null) {
            String string5;
            int n = 1;
            String string6 = null;
            do {
                if ((string5 = httpURLConnection.getHeaderFieldKey(n)) != null) {
                    if (string5.startsWith("Location") || string5.startsWith("location")) {
                        string6 = httpURLConnection.getHeaderField(n);
                        int n2 = string6.indexOf("&amp;");
                        while (n2 != -1) {
                            string6 = string6.substring(0, n2) + "&" + string6.substring(n2 + 5);
                            n2 = string6.indexOf("&amp;");
                        }
                        if (!string6.startsWith("http")) {
                            String string7 = "";
                            int n3 = string.indexOf(".com/");
                            if (!string6.startsWith("/")) {
                                string7 = "/";
                            }
                            String string8 = n3 == -1 ? string : string.substring(0, n3 + 4);
                            string6 = string8 + string7 + string6;
                        }
                    }
                    if (string5.startsWith("Set-Cookie") || string5.startsWith("Set-cookie")) {
                        Cookie cookie = new Cookie(httpURLConnection.getHeaderField(n));
                        this._cookies.put(cookie.getKey(), cookie);
                    }
                }
                ++n;
            } while (string5 != null);
            if (string6 != null) {
                return this.getAllCookiesFromPage(string6, string2, bl, list);
            }
        }
        return httpURLConnection;
    }

    public String toString() {
        boolean bl = true;
        StringBuffer stringBuffer = null;
        Iterator iterator = this._cookies.values().iterator();
        while (iterator.hasNext()) {
            Cookie cookie = (Cookie)iterator.next();
            if (cookie.getValue().equals("")) continue;
            if (!bl) {
                stringBuffer.append("; ");
            } else {
                bl = false;
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(cookie.getKey());
            stringBuffer.append("=");
            stringBuffer.append(cookie.getValue());
        }
        if (stringBuffer != null) {
            return stringBuffer.toString();
        }
        return null;
    }

    public class CookieException
    extends Exception {
        public CookieException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

