/*
 * Decompiled with CFR 0.152.
 */
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class Currency
implements Comparable {
    private static NumberFormat df = NumberFormat.getNumberInstance(Locale.US);
    public static final int NONE = 0;
    public static final int US_DOLLAR = 1;
    public static final int UK_POUND = 2;
    public static final int JP_YEN = 3;
    public static final int GER_MARK = 4;
    public static final int FR_FRANC = 5;
    public static final int CAN_DOLLAR = 6;
    public static final int EURO = 7;
    public static final int AU_DOLLAR = 8;
    public static final int CH_FRANC = 9;
    public static final int NT_DOLLAR = 10;
    public static final int TW_DOLLAR = 10;
    public static final int HK_DOLLAR = 11;
    private static Currency _noValue = null;
    private int _whatCurrency;
    private double _value;
    private static final char pound = '\u00a3';
    private static final Character objPound = new Character('\u00a3');
    private static final Integer CurDollar = new Integer(1);
    private static final Integer CurPound = new Integer(2);
    private static final Integer CurYen = new Integer(3);
    private static final Integer CurMark = new Integer(4);
    private static final Integer CurFranc = new Integer(5);
    private static final Integer CurSwiss = new Integer(9);
    private static final Integer CurCan = new Integer(6);
    private static final Integer CurEuro = new Integer(7);
    private static final Integer CurAu = new Integer(8);
    private static final Integer CurTaiwan = new Integer(10);
    private static final Integer CurHK = new Integer(11);
    private static final Object[][] xlateTable = new Object[][]{{"USD", CurDollar}, {"US $", CurDollar}, {"AU $", CurAu}, {"au$", CurAu}, {"AU", CurAu}, {"AUD", CurAu}, {"US", CurDollar}, {"USD $", CurDollar}, {"$", CurDollar}, {"C", CurCan}, {"C $", CurCan}, {"CAD", CurCan}, {"c$", CurCan}, {"GBP", CurPound}, {objPound.toString(), CurPound}, {"pound", CurPound}, {"\u00a3", CurPound}, {"&pound", CurPound}, {"Y", CurYen}, {"JPY", CurYen}, {"&yen", CurYen}, {"\u00a5", CurYen}, {"DM", CurMark}, {"FRF", CurFranc}, {"fr", CurFranc}, {"CHF", CurSwiss}, {"chf", CurSwiss}, {"dm", CurMark}, {"\u20ac", CurEuro}, {"eur", CurEuro}, {"EUR", CurEuro}, {"Eur", CurEuro}, {"NT$", CurTaiwan}, {"nt$", CurTaiwan}, {"NTD", CurTaiwan}, {"HK$", CurHK}, {"hk$", CurHK}, {"HKD", CurHK}};

    public static Currency NoValue() {
        if (_noValue == null) {
            _noValue = new Currency(0, 0.0);
        }
        return _noValue;
    }

    public static Currency convertToUSD(Currency currency, Currency currency2, Currency currency3) {
        if (currency3 != null && !currency3.isNull() && currency3.getCurrencyType() != 1) {
            double d = currency.getValue() / currency2.getValue();
            return Currency.getCurrency(1, d * currency3.getValue());
        }
        return currency3;
    }

    private int xlateSymbolToType(String string) {
        for (int i = 0; i < xlateTable.length; ++i) {
            if (!string.equals(xlateTable[i][0])) continue;
            Integer n = (Integer)xlateTable[i][1];
            return n;
        }
        return 0;
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static Currency getCurrency(String string) {
        if (string == null || string.equals("") || string.startsWith("UNK")) {
            return Currency.NoValue();
        }
        return new Currency(string);
    }

    public static Currency getCurrency(int n, double d) {
        if (n == 0) {
            return Currency.NoValue();
        }
        return new Currency(n, d);
    }

    public static Currency getCurrency(String string, double d) {
        if (string == null || string.equalsIgnoreCase("UNK")) {
            return Currency.NoValue();
        }
        return new Currency(string, d);
    }

    public static Currency getCurrency(String string, String string2) {
        if (string == null || string.equalsIgnoreCase("UNK")) {
            return Currency.NoValue();
        }
        return new Currency(string, string2);
    }

    public Currency(String string) {
        this.setValues(string);
    }

    public Currency(int n, double d) {
        this.setValues(n, d);
    }

    public Currency(String string, double d) {
        this.setValues(string, d);
    }

    public Currency(String string, String string2) {
        this.setValues(string, Double.parseDouble(string2));
    }

    private int checkLengthMatchStart(String string, String string2) {
        String string3;
        String string4 = string.toLowerCase();
        if (string4.startsWith((string3 = string2.toLowerCase()) + " ")) {
            return string2.length() + 1;
        }
        if (string4.startsWith(string3)) {
            int n;
            for (n = string2.length(); n < string.length() && !Character.isDigit(string.charAt(n)); ++n) {
            }
            return n;
        }
        return 0;
    }

    private void setValues(String string) {
        if (string == null || string.equals("null")) {
            this.setValues(0, 0.0);
        } else {
            String string2;
            String string3;
            char c = string.charAt(0);
            int n = this.checkLengthMatchStart(string, "EUR");
            int n2 = this.checkLengthMatchStart(string, "GBP");
            int n3 = this.checkLengthMatchStart(string, "FRF");
            int n4 = this.checkLengthMatchStart(string, "CHF");
            int n5 = this.checkLengthMatchStart(string, "CAD");
            int n6 = this.checkLengthMatchStart(string, "NTD");
            int n7 = this.checkLengthMatchStart(string, "AUD");
            int n8 = this.checkLengthMatchStart(string, "USD");
            if (string.startsWith("US $")) {
                string3 = "US $";
                string2 = string.substring(4);
            } else if (string.startsWith("USD $")) {
                string3 = "USD $";
                string2 = string.substring(5);
            } else if (string.startsWith("AU $")) {
                string3 = "AU $";
                string2 = string.substring(4);
            } else if (n8 != 0) {
                string3 = "USD";
                string2 = string.substring(n8);
            } else if (n != 0) {
                string3 = "EUR";
                string2 = string.substring(n);
            } else if (n2 != 0) {
                string3 = "GBP";
                string2 = string.substring(n2);
            } else if (n3 != 0) {
                string3 = "FRF";
                string2 = string.substring(n3);
            } else if (n4 != 0) {
                string3 = "CHF";
                string2 = string.substring(n4);
            } else if (n5 != 0) {
                string3 = "CAD";
                string2 = string.substring(n5);
            } else if (n6 != 0) {
                string3 = "NTD";
                string2 = string.substring(n6);
            } else if (n7 != 0) {
                string3 = "AUD";
                string2 = string.substring(n7);
            } else if (string.startsWith("NT$")) {
                string3 = "NTD";
                string2 = string.substring(3);
            } else if (string.startsWith("nt$")) {
                string3 = "NTD";
                string2 = string.substring(3);
            } else if (string.startsWith("au$")) {
                string3 = "AUD";
                string2 = string.substring(3);
            } else if (string.startsWith("C $")) {
                string3 = "C $";
                string2 = string.substring(3);
            } else if (string.charAt(0) == '\u00a3') {
                string3 = "GBP";
                string2 = string.substring(1);
            } else if (!this.isDigit(c) && c != '$') {
                int n9 = string.indexOf(";");
                if (n9 == -1) {
                    n9 = string.indexOf(" ");
                }
                if (n9 != -1) {
                    string3 = string.substring(0, n9);
                    string2 = string.substring(string3.length() + 1);
                } else {
                    string3 = "$";
                    string2 = string;
                }
            } else {
                string3 = "$";
                string2 = this.isDigit(c) ? string : string.substring(1);
            }
            while (!string2.equals("") && !Character.isDigit(string2.charAt(0))) {
                string2 = string2.substring(1);
            }
            if (!string2.equals("")) {
                double d;
                try {
                    d = df.parse(string2).doubleValue();
                }
                catch (ParseException parseException) {
                    ErrorManagement.handleException("currency parse!", parseException);
                    d = 0.0;
                }
                this.setValues(string3, d);
            } else {
                this.setValues(null);
            }
        }
    }

    private void setValues(String string, double d) {
        this.setValues(this.xlateSymbolToType(string), d);
    }

    private void setValues(int n, double d) {
        this._whatCurrency = n;
        this._value = d;
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
    }

    public String fullCurrencyName() {
        switch (this._whatCurrency) {
            case 1: {
                return "USD";
            }
            case 8: {
                return "AUD";
            }
            case 10: {
                return "NTD";
            }
            case 11: {
                return "HKD";
            }
            case 2: {
                return "GBP";
            }
            case 3: {
                return "JPY";
            }
            case 4: {
                return "DM";
            }
            case 5: {
                return "FRF";
            }
            case 9: {
                return "CHF";
            }
            case 6: {
                return "CAD";
            }
            case 7: {
                return "EUR";
            }
        }
        return "UNK";
    }

    public double getValue() {
        return this._value;
    }

    public String fullCurrency() {
        return this.fullCurrencyName() + " " + this.getValueString();
    }

    public Currency add(Currency currency) throws CurrencyTypeException {
        if (currency == null) {
            throw new CurrencyTypeException("Cannot add null Currency.");
        }
        if (currency.getCurrencyType() == this._whatCurrency) {
            return new Currency(this._whatCurrency, this._value + currency.getValue());
        }
        if (this._whatCurrency == 0) {
            return new Currency(currency.getCurrencyType(), this._value + currency.getValue());
        }
        if (currency.getCurrencyType() == 0) {
            return new Currency(this._whatCurrency, this._value + currency.getValue());
        }
        throw new CurrencyTypeException("Cannot add " + this.fullCurrencyName() + " to " + currency.fullCurrencyName() + ".");
    }

    public Currency subtract(Currency currency) throws CurrencyTypeException {
        if (currency == null) {
            throw new CurrencyTypeException("Cannot add null Currency.");
        }
        if (currency.getCurrencyType() == this._whatCurrency) {
            return new Currency(this._whatCurrency, this._value - currency.getValue());
        }
        if (this._whatCurrency == 0) {
            return new Currency(currency.getCurrencyType(), this._value - currency.getValue());
        }
        if (currency.getCurrencyType() == 0) {
            return new Currency(this._whatCurrency, this._value - currency.getValue());
        }
        throw new CurrencyTypeException("Cannot subtract " + this.fullCurrencyName() + " from " + currency.fullCurrencyName() + ".");
    }

    public int getCurrencyType() {
        return this._whatCurrency;
    }

    public String getCurrencySymbol() {
        switch (this._whatCurrency) {
            case 1: {
                return "$";
            }
            case 10: {
                return "nt$";
            }
            case 11: {
                return "hk$";
            }
            case 2: {
                return objPound.toString();
            }
            case 3: {
                return "\u00a5";
            }
            case 5: {
                return "fr";
            }
            case 9: {
                return "chf";
            }
            case 4: {
                return "dm";
            }
            case 6: {
                return "c$";
            }
            case 8: {
                return "au$";
            }
            case 7: {
                return "\u20ac";
            }
        }
        return "unk";
    }

    public String toString() {
        if (this.isNull()) {
            return "null";
        }
        String string = this.getCurrencySymbol();
        string = string + df.format(this._value);
        return string;
    }

    public String getValueString() {
        if (this.isNull()) {
            return "null";
        }
        return df.format(this._value);
    }

    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        String string = this.fullCurrencyName() + this.getValueString();
        return string.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof Currency)) {
            return false;
        }
        Currency currency = (Currency)object;
        boolean bl = currency.getCurrencyType() == this._whatCurrency;
        boolean bl2 = (int)(currency.getValue() * 1000.0) == (int)(this._value * 1000.0);
        return bl && bl2;
    }

    public boolean less(Currency currency) throws CurrencyTypeException {
        boolean bl;
        if (currency == null) {
            return false;
        }
        if (currency == this) {
            return false;
        }
        boolean bl2 = bl = currency.getCurrencyType() == this._whatCurrency;
        if (!bl) {
            throw new CurrencyTypeException("Cannot compare different currencies.");
        }
        boolean bl3 = Double.compare((int)(currency.getValue() * 1000.0), (int)(this._value * 1000.0)) == 1;
        return bl3;
    }

    public boolean isNull() {
        return this._value == 0.0 && this._whatCurrency == 0;
    }

    public int compareTo(Object object) {
        if (object == null) {
            return 1;
        }
        if (object == this) {
            return 0;
        }
        if (!(object instanceof Currency)) {
            throw new ClassCastException("Currency cannot compareTo different classes!");
        }
        Currency currency = (Currency)object;
        if (currency.isNull()) {
            return 1;
        }
        if (this.isNull()) {
            return -1;
        }
        try {
            if (this.less(currency)) {
                return -1;
            }
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("Currency cannot compareTo different classes!\n" + classCastException);
        }
        catch (CurrencyTypeException currencyTypeException) {
            throw new ClassCastException("Currency cannot compareTo different currencies!\n" + currencyTypeException);
        }
        if (this.equals(currency)) {
            return 0;
        }
        return 1;
    }

    public class CurrencyTypeException
    extends Exception {
        String _associatedString;

        public CurrencyTypeException(String string) {
            this._associatedString = string;
        }

        public String toString() {
            return this._associatedString;
        }
    }
}

