/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;

public class FilterManager
implements MessageQueue.Listener {
    private static FilterManager _instance = null;
    private AuctionListHolder _main = null;
    private List _allLists;
    private Map _allOrderedAuctionEntries = new TreeMap();

    private FilterManager() {
        this._allLists = new ArrayList(3);
    }

    public boolean toggleField(String string, String string2) {
        for (int i = this._allLists.size() - 1; i >= 0; --i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (!auctionListHolder.getList().getName().equals(string)) continue;
            boolean bl = auctionListHolder.getUI().toggleField(string2);
            if (!bl) {
                JConfig.displayProperty.remove(string + '.' + string2);
            }
            return bl;
        }
        return false;
    }

    public List getColumns(String string) {
        for (int i = this._allLists.size() - 1; i >= 0; --i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (!auctionListHolder.getList().getName().equals(string)) continue;
            return auctionListHolder.getUI().getColumns();
        }
        return null;
    }

    public boolean exportTab(String string, String string2) {
        for (int i = this._allLists.size() - 1; i >= 0; --i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (!auctionListHolder.getList().getName().equals(string)) continue;
            return auctionListHolder.getUI().export(string2);
        }
        return false;
    }

    public void loadFilters() {
        String string;
        this._main = new AuctionListHolder("current");
        this._allLists.add(this._main);
        this._allLists.add(new AuctionListHolder("complete", true, false));
        this._allLists.add(new AuctionListHolder("selling", false, true));
        int n = 1;
        do {
            if ((string = JConfig.queryDisplayProperty("tabs.name." + n++)) == null) continue;
            this._allLists.add(new AuctionListHolder(string));
        } while (string != null);
    }

    public AuctionListHolder addTab(String string) {
        Color color = this._main.getUI().getBackground();
        this._main.getUI().getColumnWidthsToProperties(JConfig.displayProperty, string);
        AuctionListHolder auctionListHolder = new AuctionListHolder(string, color);
        this._allLists.add(auctionListHolder);
        return auctionListHolder;
    }

    public boolean printTab(String string) {
        for (int i = this._allLists.size() - 1; i >= 0; --i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (!auctionListHolder.getList().getName().equals(string)) continue;
            auctionListHolder.getUI().print();
            return true;
        }
        return false;
    }

    public boolean deleteTab(String string, boolean bl) {
        boolean bl2 = false;
        for (int i = this._allLists.size() - 1; i >= 0; --i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (!auctionListHolder.getList().getName().equals(string)) continue;
            if (auctionListHolder == this._main || auctionListHolder.getList().isCompleted() || auctionListHolder.getList().isSelling()) {
                return false;
            }
            this._allLists.remove(i);
            auctionListHolder.getList().refilterAll(bl);
            AuctionsUIModel.getTabManager().getTabs().remove(i);
            bl2 = true;
        }
        return bl2;
    }

    public static synchronized FilterManager getInstance() {
        if (_instance == null) {
            _instance = new FilterManager();
            MQFactory.getConcrete("redraw").registerListener(_instance);
        }
        return _instance;
    }

    public void messageAction(Object object) {
        AuctionEntry auctionEntry = (AuctionEntry)object;
        this.redrawEntry(auctionEntry);
    }

    public void redrawEntry(AuctionEntry auctionEntry) {
        for (int i = 0; i < this._allLists.size(); ++i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (!auctionListHolder.getUI().redrawEntry(auctionEntry)) continue;
            return;
        }
    }

    public void check() {
        for (int i = 0; i < this._allLists.size(); ++i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (auctionListHolder.getList().isCompleted()) continue;
            auctionListHolder.getUI().redraw();
        }
    }

    public void deleteAuction(AuctionEntry auctionEntry) {
        Auctions auctions = (Auctions)this._allOrderedAuctionEntries.get(auctionEntry);
        if (auctions == null) {
            auctions = this.whereIsAuction(auctionEntry);
        }
        if (auctions != null) {
            auctions.delEntry(auctionEntry);
        }
        this._allOrderedAuctionEntries.remove(auctionEntry);
    }

    public void addAuction(AuctionEntry auctionEntry) {
        Auctions auctions = (Auctions)this._allOrderedAuctionEntries.get(auctionEntry);
        if (auctions == null && (auctions = this.whereIsAuction(auctionEntry)) != null) {
            this._allOrderedAuctionEntries.put(auctionEntry, auctions);
        }
        if (auctions != null) {
            auctions.addEntry(auctionEntry);
        } else {
            Auctions auctions2 = this.matchAuction(auctionEntry);
            if (auctions2 != null) {
                auctions2.addEntry(auctionEntry);
                this._allOrderedAuctionEntries.put(auctionEntry, auctions2);
            }
        }
    }

    public Iterator getAuctionIterator() {
        return this._allOrderedAuctionEntries.keySet().iterator();
    }

    private Auctions findSellerList() {
        for (int i = 0; i < this._allLists.size(); ++i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (!auctionListHolder.getList().isSelling()) continue;
            return auctionListHolder.getList();
        }
        return null;
    }

    private Auctions findCompletedList() {
        for (int i = 0; i < this._allLists.size(); ++i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (!auctionListHolder.getList().isCompleted()) continue;
            return auctionListHolder.getList();
        }
        return null;
    }

    public Auctions findCategory(String string) {
        if (string == null) {
            return null;
        }
        for (int i = 0; i < this._allLists.size(); ++i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (!string.equals(auctionListHolder.getList().getName())) continue;
            return auctionListHolder.getList();
        }
        return null;
    }

    public List allCategories() {
        ArrayList<String> arrayList = null;
        for (int i = 0; i < this._allLists.size(); ++i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(auctionListHolder.getList().getName());
        }
        return arrayList;
    }

    public Auctions matchAuction(AuctionEntry auctionEntry) {
        String string;
        Auctions auctions;
        if (!auctionEntry.isSticky() || auctionEntry.getCategory() == null) {
            if (auctionEntry.isSeller()) {
                return this.findSellerList();
            }
            if (auctionEntry.isEnded()) {
                return this.findCompletedList();
            }
        }
        if ((auctions = this.findCategory(string = auctionEntry.getCategory())) != null) {
            return auctions;
        }
        if (string != null && !string.startsWith("New Search")) {
            return this.addTab(string).getList();
        }
        return this._main.getList();
    }

    public void setBackground(Color color) {
        for (int i = 0; i < this._allLists.size(); ++i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            auctionListHolder.getUI().setBackground(color);
        }
    }

    public Auctions whereIsAuction(AuctionEntry auctionEntry) {
        for (int i = 0; i < this._allLists.size(); ++i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (!auctionListHolder.getList().verifyEntry(auctionEntry)) continue;
            return auctionListHolder.getList();
        }
        return null;
    }

    public Auctions whereIsAuction(String string) {
        for (int i = 0; i < this._allLists.size(); ++i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            if (!auctionListHolder.getList().verifyEntry(string)) continue;
            return auctionListHolder.getList();
        }
        return null;
    }

    public Auctions refilterAuction(AuctionEntry auctionEntry, boolean bl) {
        Auctions auctions = this.matchAuction(auctionEntry);
        Auctions auctions2 = (Auctions)this._allOrderedAuctionEntries.get(auctionEntry);
        if (auctions2 == null) {
            auctions2 = this.whereIsAuction(auctionEntry);
        }
        if (auctions2 != null) {
            String string = auctions2.getName();
            if (auctions.isCompleted()) {
                String string2 = auctionEntry.isBidOn() || auctionEntry.isSniped() ? (auctionEntry.isHighBidder() ? JConfig.queryConfiguration(string + ".won_target") : JConfig.queryConfiguration(string + ".lost_target")) : JConfig.queryConfiguration(string + ".other_target");
                if (string2 != null) {
                    if (string2.equals("<delete>")) {
                        this.deleteAuction(auctionEntry);
                        return null;
                    }
                    auctionEntry.setSticky(true);
                    auctions = this.findCategory(string2);
                    if (auctions == null) {
                        AuctionListHolder auctionListHolder = this.addTab(string2);
                        auctions = auctionListHolder.getList();
                    }
                }
            }
        }
        if (auctions2 == auctions || auctions2 == null) {
            if (auctions2 == null) {
                ErrorManagement.logMessage("For some reason oldAuctions is null, and nobody acknowledges owning it, for auction entry " + auctionEntry.getTitle());
            }
            return null;
        }
        auctions2.delEntry(auctionEntry);
        auctions.addEntry(auctionEntry);
        this._allOrderedAuctionEntries.put(auctionEntry, auctions);
        return auctions;
    }

    public Properties extractProperties(Properties properties) {
        for (int i = 0; i < this._allLists.size(); ++i) {
            AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(i);
            auctionListHolder.getList().getTableSorter().getSortProperties(auctionListHolder.getList().getName(), properties);
            auctionListHolder.getUI().getColumnWidthsToProperties(properties);
            String string = auctionListHolder.getList().getName();
            if (i > 2) {
                properties.setProperty("tabs.name." + (i - 2), string);
            }
            String string2 = string + ".end.keep";
            String string3 = string + ".end.delete.notmybid";
            String string4 = string + ".end.delete.nobids";
            String string5 = string + ".archive";
            properties.setProperty(string2, JConfig.queryDisplayProperty(string2, "unset"));
            properties.setProperty(string3, JConfig.queryDisplayProperty(string3, "unset"));
            properties.setProperty(string4, JConfig.queryDisplayProperty(string4, "unset"));
            properties.setProperty(string5, JConfig.queryDisplayProperty(string5, "unset"));
        }
        return properties;
    }

    public int listLength() {
        return this._allLists.size();
    }

    public Auctions getList(int n) {
        AuctionListHolder auctionListHolder = (AuctionListHolder)this._allLists.get(n);
        return auctionListHolder.getList();
    }

    private class AuctionListHolder {
        private Auctions auctionList;
        private AuctionsUIModel auctionUI;

        AuctionListHolder(String string) {
            this.auctionList = new Auctions(string);
            this.auctionUI = new AuctionsUIModel(this.auctionList);
        }

        AuctionListHolder(String string, Color color) {
            this.auctionList = new Auctions(string);
            this.auctionUI = new AuctionsUIModel(this.auctionList);
            this.auctionUI.setBackground(color);
        }

        AuctionListHolder(String string, boolean bl, boolean bl2) {
            this.auctionList = new Auctions(string);
            if (bl) {
                this.auctionList.setComplete();
            }
            if (bl2) {
                this.auctionList.setSelling();
            }
            this.auctionUI = new AuctionsUIModel(this.auctionList);
        }

        public Auctions getList() {
            return this.auctionList;
        }

        public AuctionsUIModel getUI() {
            return this.auctionUI;
        }
    }
}

