/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class JConfigFrame
implements ActionListener {
    private JFrame mainFrame = this.createConfigFrame();
    private boolean buttonPressed = false;
    private List allTabs;
    private static int cfgCount = 1;

    public void spinWait() {
        while (!this.buttonPressed) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public JConfigFrame() {
        Rectangle rectangle = OptionUI.findCenterBounds(this.mainFrame.getPreferredSize());
        this.mainFrame.setLocation(rectangle.x, rectangle.y);
        this.show();
    }

    public final void show() {
        for (int i = 0; i < this.allTabs.size(); ++i) {
            JConfigTab jConfigTab = (JConfigTab)this.allTabs.get(i);
            jConfigTab.updateValues();
        }
        this.mainFrame.setState(0);
        this.mainFrame.setVisible(true);
    }

    private void applyAll() {
        for (int i = 0; i < this.allTabs.size(); ++i) {
            JConfigTab jConfigTab = (JConfigTab)this.allTabs.get(i);
            jConfigTab.apply();
        }
    }

    private void cancelAll() {
        for (int i = 0; i < this.allTabs.size(); ++i) {
            JConfigTab jConfigTab = (JConfigTab)this.allTabs.get(i);
            jConfigTab.cancel();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Save")) {
            this.applyAll();
            JConfig.updateComplete();
            JConfig.saveConfiguration();
        } else if (string.equals("Cancel")) {
            this.cancelAll();
        }
        this.mainFrame.setVisible(false);
        this.buttonPressed = true;
    }

    public static JPanel buildButtonPane(ActionListener actionListener) {
        JPanel jPanel = new JPanel();
        JButton jButton = new JButton("Cancel");
        jButton.setToolTipText("Cancel any changes made.");
        JButton jButton2 = new JButton("Save");
        jButton2.setToolTipText("Apply changes and save settings.");
        jPanel.add((Component)jButton, "West");
        jPanel.add((Component)jButton2, "Center");
        jButton.addActionListener(actionListener);
        jButton2.addActionListener(actionListener);
        return jPanel;
    }

    private static void anotherConfig() {
        ++cfgCount;
    }

    private JFrame createConfigFrame() {
        JConfigTab jConfigTab;
        JFrame jFrame;
        JTabbedPane jTabbedPane = new JTabbedPane();
        if (cfgCount == 2) {
            jFrame = new JFrame("Configuration Manager (2)");
        } else {
            JConfigFrame.anotherConfig();
            jFrame = new JFrame("Configuration Manager");
        }
        Platform.setMacFrameMenu(jFrame);
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jTabbedPane, "Center");
        this.allTabs = new ArrayList();
        this.allTabs.add(new JConfigGeneralTab());
        List list = AuctionServerManager.getInstance().getServerConfigurationTabs();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            jConfigTab = (JConfigTab)iterator.next();
            this.allTabs.add(jConfigTab);
        }
        if (Platform.isMac()) {
            this.allTabs.add(new JConfigMacBrowserTab());
        } else {
            this.allTabs.add(new JConfigBrowserTab());
        }
        this.allTabs.add(new JConfigFirewallTab());
        this.allTabs.add(new JConfigSnipeTab());
        this.allTabs.add(new JConfigFilePathTab());
        this.allTabs.add(new JConfigWebserverTab());
        this.allTabs.add(new JConfigSecurityTab());
        this.allTabs.add(new JConfigAdvancedTab());
        for (int i = 0; i < this.allTabs.size(); ++i) {
            jConfigTab = (JConfigTab)this.allTabs.get(i);
            jConfigTab.setOpaque(true);
            jTabbedPane.addTab(jConfigTab.getTabName(), jConfigTab);
        }
        jTabbedPane.setSelectedIndex(0);
        container.add((Component)JConfigFrame.buildButtonPane(this), "South");
        jFrame.addWindowListener(new IconifyingWindowAdapter(jFrame));
        jFrame.pack();
        jFrame.setResizable(false);
        return jFrame;
    }

    public static class IconifyingWindowAdapter
    extends WindowAdapter {
        private final JFrame _window;

        IconifyingWindowAdapter(JFrame jFrame) {
            this._window = jFrame;
        }

        public void windowIconified(WindowEvent windowEvent) {
            super.windowIconified(windowEvent);
            if (Platform.isWindows() && Platform.isTrayEnabled() && JConfig.queryConfiguration("windows.tray", "true").equals("true") && JConfig.queryConfiguration("windows.minimize", "true").equals("true")) {
                this._window.setVisible(false);
            }
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            super.windowDeiconified(windowEvent);
            if (Platform.isWindows() && Platform.isTrayEnabled() && JConfig.queryConfiguration("windows.tray", "true").equals("true") && JConfig.queryConfiguration("windows.minimize", "true").equals("true")) {
                this._window.setState(0);
                this._window.setVisible(true);
            }
        }
    }

    private final class JConfigMacBrowserTab
    extends JConfigStubTab {
        public String getTabName() {
            return "Browser";
        }

        JConfigMacBrowserTab() {
            JLabel jLabel = new JLabel("Under MacOSX, the browser does not need to be configured.");
            this.setLayout(new BorderLayout());
            this.add((Component)jLabel, "Center");
        }
    }

    private class JConfigSecurityTab
    extends JConfigStubTab {
        private JConfigSecurityTab() {
        }

        public String getTabName() {
            return "Security";
        }
    }
}

