/*
 * Decompiled with CFR 0.152.
 */
import com.stevesoft.pat.Regex;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JHTML
implements JHTMLListener {
    protected boolean m_loaded = false;
    protected int m_tokenIndex;
    protected int m_contentIndex;
    private JHTMLParser m_parser;
    private Map contentMap;
    private Map caselessContentMap;
    private List contentList;
    private List m_formList;
    private Form m_curForm;
    private static boolean do_uber_debug = false;
    private static final boolean CHECK_CASE = false;

    public JHTML(StringBuffer stringBuffer) {
        this.setup();
        this.m_parser = new JHTMLParser(stringBuffer, this);
    }

    private void setup() {
        this.caselessContentMap = new HashMap();
        this.contentMap = new HashMap();
        this.contentList = new ArrayList();
        this.m_formList = new ArrayList();
        this.m_curForm = null;
        this.reset();
    }

    public void reset() {
        this.m_tokenIndex = 0;
        this.m_contentIndex = 0;
    }

    public List getForms() {
        return this.m_formList;
    }

    public void addToken(htmlToken htmlToken2, int n) {
        if (htmlToken2.getTokenType() == 4) {
            if (htmlToken2.getToken().length() == 1 && !Character.isDigit(htmlToken2.getToken().charAt(0))) {
                return;
            }
            intPair intPair2 = new intPair(n, this.contentList.size());
            if (!this.contentMap.containsKey(htmlToken2.getToken())) {
                this.contentMap.put(htmlToken2.getToken(), intPair2);
                this.caselessContentMap.put(htmlToken2.getToken().toLowerCase(), intPair2);
            }
            this.contentList.add(htmlToken2.getToken());
        } else if (htmlToken2.getTokenType() == 1 || htmlToken2.getTokenType() == 2 || htmlToken2.getTokenType() == 3) {
            if (htmlToken2.getToken().toLowerCase().startsWith("form")) {
                if (this.m_curForm == null) {
                    this.m_curForm = new Form(htmlToken2.getToken());
                } else {
                    this.m_formList.add(this.m_curForm);
                    this.m_curForm = new Form(htmlToken2.getToken());
                }
            } else if (htmlToken2.getToken().toLowerCase().startsWith("/form")) {
                if (this.m_curForm != null) {
                    this.m_formList.add(this.m_curForm);
                }
                this.m_curForm = null;
            }
            if (this.m_curForm != null && htmlToken2.getToken().regionMatches(true, 0, "input", 0, 5)) {
                this.m_curForm.addInput(htmlToken2.getToken());
            }
        }
    }

    public static String getFirstContent(String string) {
        JHTML jHTML = new JHTML(new StringBuffer(string));
        return (String)jHTML.contentList.get(0);
    }

    public String getFirstContent() {
        if (this.contentList.size() == 0) {
            return null;
        }
        return (String)this.contentList.get(0);
    }

    public String getNextContent() {
        if (this.m_contentIndex + 1 >= this.contentList.size()) {
            return null;
        }
        return (String)this.contentList.get(this.m_contentIndex++);
    }

    public String getPrevContent() {
        if (this.m_contentIndex == 0) {
            return null;
        }
        return (String)this.contentList.get(--this.m_contentIndex);
    }

    public String getPrevContent(int n) {
        if (n > this.m_contentIndex) {
            this.m_contentIndex = 0;
            return null;
        }
        this.m_contentIndex -= n;
        return (String)this.contentList.get(this.m_contentIndex);
    }

    public intPair lookup(String string, boolean bl) {
        intPair intPair2 = bl ? (intPair)this.caselessContentMap.get(string.toLowerCase()) : (intPair)this.contentMap.get(string);
        return intPair2;
    }

    private String contentLookup(String string, boolean bl) {
        intPair intPair2 = this.lookup(string, bl);
        if (intPair2 == null) {
            return null;
        }
        this.m_tokenIndex = intPair2.first + 2;
        this.m_contentIndex = intPair2.second + 1;
        return (String)this.contentList.get(this.m_contentIndex++);
    }

    public String find(String string, boolean bl) {
        Iterator iterator = this.contentList.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (!string2.regionMatches(bl, 0, string, 0, string.length())) continue;
            return string2;
        }
        return null;
    }

    private String contentFind(String string, boolean bl) {
        String string2 = this.find(string, bl);
        if (string2 != null) {
            string2 = this.contentLookup(string2, false);
        }
        return string2;
    }

    public String grep(String string) {
        Regex regex = new Regex(string);
        regex.optimize();
        return this.grep(regex);
    }

    public String grep(Regex regex) {
        Iterator iterator = this.contentList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!regex.search(string)) continue;
            return string;
        }
        return null;
    }

    private String grepAfter(Regex regex, Regex regex2) {
        Iterator iterator = this.contentList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!regex.search(string)) continue;
            Iterator iterator2 = iterator;
            if (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (regex2 == null || !regex2.search(string2)) {
                    this.contentLookup(string, false);
                    return string2;
                }
            }
            iterator = iterator2;
        }
        return null;
    }

    private String contentGrep(String string, String string2) {
        Regex regex = new Regex(string);
        Regex regex2 = null;
        if (string2 != null) {
            regex2 = new Regex(string2);
        }
        return this.grepAfter(regex, regex2);
    }

    public String getNextContentAfterContent(String string) {
        return this.contentFind(string, false);
    }

    public String getNextContentAfterContent(String string, boolean bl, boolean bl2) {
        if (bl) {
            return this.contentLookup(string, bl2);
        }
        return this.contentFind(string, bl2);
    }

    public String getContentBeforeContent(String string) {
        if (this.contentFind(string, false) != null && this.getPrevContent() != null && this.getPrevContent() != null) {
            return this.getPrevContent();
        }
        return null;
    }

    public String getNextContentAfterRegex(String string) {
        return this.contentGrep(string, null);
    }

    public String getNextContentAfterRegexIgnoring(String string, String string2) {
        return this.contentGrep(string, string2);
    }

    public String getNextTag() {
        htmlToken htmlToken2 = this.nextToken();
        if (htmlToken2 != null) {
            while (htmlToken2 != null && htmlToken2.getTokenType() == 4 && htmlToken2.getTokenType() != 5) {
                htmlToken2 = this.nextToken();
            }
            if (htmlToken2 != null && htmlToken2.getTokenType() != 5) {
                return htmlToken2.getToken();
            }
        }
        return null;
    }

    public List getAllLinks() {
        ArrayList<String> arrayList = null;
        String string = this.getNextTag();
        while (string != null) {
            if (string.startsWith("A ") || string.startsWith("a ")) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string);
            }
            string = this.getNextTag();
        }
        return arrayList;
    }

    public List getAllImages() {
        HashSet<String> hashSet = null;
        String string = this.getNextTag();
        while (string != null) {
            if (string.toLowerCase().startsWith("img ")) {
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                hashSet.add(JHTML.deAmpersand(string));
            }
            string = this.getNextTag();
        }
        return new ArrayList(hashSet);
    }

    public List getAllURLsOnPage(boolean bl) {
        List list = this.getAllLinks();
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = null;
        for (int i = 0; i < list.size(); ++i) {
            String string;
            String string2 = (String)list.get(i);
            int n = string2.indexOf(34);
            if (n == -1 || (n = (string = string2.substring(n + 1)).indexOf(34)) == -1 || (n = (string = string.substring(0, n)).indexOf(35)) != -1) continue;
            boolean bl2 = false;
            if (bl) {
                boolean bl3 = bl2 = string.indexOf("ViewItem") != -1;
                if (bl2) {
                    string = JHTML.deAmpersand(string);
                }
            }
            if (bl && !bl2) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(string);
        }
        return arrayList;
    }

    public static String deAmpersand(String string) {
        int n = string.indexOf("&amp;");
        while (n != -1) {
            string = string.substring(0, n + 1) + string.substring(n + 5);
            n = string.indexOf("&amp;");
        }
        return string;
    }

    public htmlToken nextToken() {
        htmlToken htmlToken2;
        if ((htmlToken2 = this.m_parser.getTokenAt(this.m_tokenIndex++)) == null) {
            --this.m_tokenIndex;
        }
        return htmlToken2;
    }

    public boolean isLoaded() {
        return this.m_loaded;
    }

    private void loadParseURL(String string, String string2, CleanupHandler cleanupHandler) {
        StringBuffer stringBuffer;
        this.m_parser = new JHTMLParser(this);
        try {
            URLConnection uRLConnection = Http.getPage(string, string2, null, true);
            stringBuffer = Http.receivePage(uRLConnection);
            if (stringBuffer != null) {
                if (cleanupHandler != null) {
                    cleanupHandler.cleanup(stringBuffer);
                }
                this.m_parser.parse(stringBuffer);
                this.m_loaded = true;
            }
        }
        catch (IOException iOException) {
            stringBuffer = null;
            ErrorManagement.handleException("JHTML.loadPage: " + iOException, iOException);
        }
        if (stringBuffer == null) {
            this.m_loaded = false;
        }
    }

    public JHTML(String string, String string2, CleanupHandler cleanupHandler) {
        this.setup();
        this.loadParseURL(string, string2, cleanupHandler);
    }

    public Form getFormWithInput(String string) {
        List list = this.getForms();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Form form = (Form)iterator.next();
            if (!form.hasInput(string)) continue;
            return form;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        JHTML jHTML = new JHTML(stringArray[1], null, null);
        Form form = jHTML.getFormWithInput("firedFilterId");
        try {
            System.err.println("Form == \"" + form.getCGI() + '\"');
        }
        catch (Exception exception) {
            System.err.println("Caught: " + exception);
        }
    }

    public class Form {
        private List allInputs;
        private XMLElement formTag = new XMLElement();

        public Form(String string) {
            this.formTag.parseString('<' + string + "/>");
            this.allInputs = new ArrayList();
            if (do_uber_debug) {
                ErrorManagement.logDebug("Name: " + this.formTag.getProperty("name", "(unnamed)"));
            }
        }

        public String getName() {
            return this.formTag.getProperty("name");
        }

        public boolean hasInput(String string) {
            Iterator iterator = this.allInputs.iterator();
            while (iterator.hasNext()) {
                XMLElement xMLElement = (XMLElement)iterator.next();
                String string2 = xMLElement.getProperty("name");
                if (string2 == null || !string.equalsIgnoreCase(string2)) continue;
                return true;
            }
            return false;
        }

        public boolean delInput(String string) {
            Iterator iterator = this.allInputs.iterator();
            while (iterator.hasNext()) {
                XMLElement xMLElement = (XMLElement)iterator.next();
                String string2 = xMLElement.getProperty("name");
                if (string2 == null || !string.equalsIgnoreCase(string2)) continue;
                iterator.remove();
                return true;
            }
            return false;
        }

        public String getCGI() throws UnsupportedEncodingException {
            Object object;
            Iterator iterator = this.allInputs.iterator();
            StringBuffer stringBuffer = new StringBuffer("");
            String string = "";
            while (iterator.hasNext()) {
                String string2;
                object = (XMLElement)iterator.next();
                if (do_uber_debug) {
                    ErrorManagement.logDebug("Type == " + ((XMLElement)object).getProperty("type", "text"));
                }
                if (stringBuffer.length() != 0) {
                    string = "&";
                }
                String string3 = ((XMLElement)object).getProperty("type", "text");
                String string4 = ((XMLElement)object).getProperty("name", "");
                if (string3.equals("text") || string3.equals("hidden") || string3.equals("password")) {
                    stringBuffer.append(string).append(string4).append('=').append(URLEncoder.encode(((XMLElement)object).getProperty("value", ""), "UTF-8"));
                    continue;
                }
                if (string3.equals("checkbox") || string3.equals("radio")) {
                    if (((XMLElement)object).getProperty("checked") == null) continue;
                    stringBuffer.append(string).append(string4).append('=').append(URLEncoder.encode(((XMLElement)object).getProperty("value", "on"), "UTF-8"));
                    continue;
                }
                if (!string3.equals("submit") || string4.length() == 0 || (string2 = ((XMLElement)object).getProperty("value", "Submit")).equalsIgnoreCase("cancel")) continue;
                stringBuffer.append(string).append(string4).append('=').append(URLEncoder.encode(string2, "UTF-8"));
            }
            object = this.formTag.getProperty("action");
            if (object != null) {
                if (((String)object).indexOf(63) == -1) {
                    return (String)object + '?' + stringBuffer;
                }
                return (String)object + '&' + stringBuffer;
            }
            return stringBuffer.toString();
        }

        public void addInput(String string) {
            XMLElement xMLElement = new XMLElement();
            xMLElement.parseString('<' + string + "/>");
            boolean bl = false;
            String string2 = xMLElement.getProperty("type", "text").toLowerCase();
            boolean bl2 = JConfig.queryConfiguration("debug.showInputs", "false").equals("true");
            if (string2.equals("text")) {
                if (bl2) {
                    ErrorManagement.logDebug("T: Name: " + xMLElement.getProperty("name") + ", Value: " + xMLElement.getProperty("value"));
                }
            } else if (string2.equals("password")) {
                if (bl2) {
                    ErrorManagement.logDebug("P: Name: " + xMLElement.getProperty("name") + ", Value: " + xMLElement.getProperty("value"));
                }
            } else if (string2.equals("hidden")) {
                if (bl2) {
                    ErrorManagement.logDebug("H: Name: " + xMLElement.getProperty("name") + ", Value: " + xMLElement.getProperty("value"));
                }
            } else if (string2.equals("checkbox")) {
                if (bl2) {
                    ErrorManagement.logDebug("CB: Name: " + xMLElement.getProperty("name") + ", Value: " + xMLElement.getProperty("value"));
                }
            } else if (string2.equals("radio")) {
                if (bl2) {
                    ErrorManagement.logDebug("R: Name: " + xMLElement.getProperty("name") + ", Value: " + xMLElement.getProperty("value"));
                }
            } else if (string2.equals("submit")) {
                if (bl2) {
                    ErrorManagement.logDebug("S: Name: " + xMLElement.getProperty("name") + ", Value: " + xMLElement.getProperty("value"));
                }
            } else if (string2.equals("image")) {
                if (bl2) {
                    ErrorManagement.logDebug("I: Name: " + xMLElement.getProperty("name") + ", Value: " + xMLElement.getProperty("value"));
                }
            } else if (string2.equals("button")) {
                if (bl2) {
                    ErrorManagement.logDebug("B: Name: " + xMLElement.getProperty("name") + ", Value: " + xMLElement.getProperty("value"));
                }
            } else if (string2.equals("reset")) {
                if (bl2) {
                    ErrorManagement.logDebug("RST: Name: " + xMLElement.getProperty("name") + ", Value: " + xMLElement.getProperty("value"));
                }
            } else {
                ErrorManagement.logDebug("Unknown input type: " + string2);
                bl = true;
            }
            if (!bl) {
                this.allInputs.add(xMLElement);
            }
        }

        public void setText(String string, String string2) {
            Iterator iterator = this.allInputs.iterator();
            while (iterator.hasNext()) {
                XMLElement xMLElement = (XMLElement)iterator.next();
                String string3 = xMLElement.getProperty("name");
                if (string3 == null || !string3.equalsIgnoreCase(string)) continue;
                xMLElement.setProperty("value", string2);
            }
        }
    }

    private class intPair {
        public int first;
        public int second;

        public intPair(int n, int n2) {
            this.first = n;
            this.second = n2;
        }
    }
}

