/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class JPrintable
implements Printable,
Runnable {
    JTable tableView;
    protected int m_maxNumPage = 1;
    private static Thread m_thr = null;

    public JPrintable(JTable jTable) {
        this.tableView = jTable;
    }

    public void doPrint() {
        m_thr = new Thread((Runnable)this, "Printing");
        m_thr.start();
    }

    public void run() {
        this.myPrint();
    }

    public void myPrint() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        pageFormat.setOrientation(0);
        printerJob.setPrintable(this, pageFormat);
        if (!printerJob.printDialog()) {
            return;
        }
        try {
            printerJob.print();
        }
        catch (Exception exception) {
            ErrorManagement.handleException("Failed to print: " + exception, exception);
        }
    }

    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n >= this.m_maxNumPage) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY());
        int n2 = graphics2D.getFontMetrics().getHeight();
        int n3 = graphics2D.getFontMetrics().getDescent();
        double d = pageFormat.getImageableHeight() - (double)n2;
        double d2 = pageFormat.getImageableWidth();
        double d3 = this.tableView.getColumnModel().getTotalColumnWidth();
        double d4 = 1.0;
        if (d3 >= d2) {
            d4 = d2 / d3;
        }
        graphics2D.setFont(this.tableView.getFont());
        graphics2D.setColor(Color.black);
        graphics2D.drawString("Page: " + (n + 1), (int)d2 / 2 - 35, (int)(d + (double)n2 - (double)n3));
        TableColumnModel tableColumnModel = this.tableView.getColumnModel();
        int n4 = tableColumnModel.getColumnCount();
        int[] nArray = new int[n4];
        nArray[0] = 0;
        graphics2D.scale(d4, d4);
        JPrintable.prepColumnWidths(n4, tableColumnModel, nArray);
        graphics2D.setFont(this.tableView.getFont());
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n5 = fontMetrics.getHeight();
        double d5 = (double)this.tableView.getTableHeader().getHeight() * d4;
        double d6 = d3 * d4;
        double d7 = (double)(this.tableView.getRowHeight() + this.tableView.getRowMargin()) * d4;
        int n6 = (int)((d - d5) / d7);
        int n7 = (int)d5 + fontMetrics.getMaxAscent() + fontMetrics.getLeading();
        this.m_maxNumPage = (int)Math.ceil((double)this.tableView.getRowCount() / (double)n6);
        if (n >= this.m_maxNumPage) {
            return 1;
        }
        int n8 = n * n6;
        int n9 = Math.min(this.tableView.getRowCount(), n8 + n6);
        StringBuffer stringBuffer = new StringBuffer();
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        for (int i = n8; i < n9; ++i) {
            for (int j = 0; j < n4; ++j) {
                Object object = this.tableView.getValueAt(i, j);
                int n10 = this.tableView.getColumnModel().getColumn(j).getWidth();
                if (object instanceof Icon) {
                    Icon icon = (Icon)object;
                    int n11 = nArray[j] + (n10 / 2 - icon.getIconWidth() / 2);
                    graphics2D.setClip(n11, n7, icon.getIconWidth(), icon.getIconHeight());
                    icon.paintIcon(this.tableView, graphics2D, n11, n7);
                    continue;
                }
                stringBuffer.setLength(0);
                if (object != null) {
                    stringBuffer.append(object.toString());
                }
                rectangle.setBounds(nArray[j], n7, n10, n5);
                graphics2D.setClip(rectangle);
                graphics2D.drawString(stringBuffer.toString(), nArray[j], n7 + fontMetrics.getMaxAscent());
            }
            n7 += n5;
        }
        graphics2D.scale(1.0 / d4, 1.0 / d4);
        graphics2D.setClip(0, 0, (int)Math.ceil(d6), (int)Math.ceil(d5));
        graphics2D.scale(d4, d4);
        this.tableView.getTableHeader().paint(graphics2D);
        System.gc();
        return 0;
    }

    private static void prepColumnWidths(int n, TableColumnModel tableColumnModel, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n2 = tableColumn.getWidth();
            if (i + 1 >= n) continue;
            nArray[i + 1] = nArray[i] + n2;
        }
    }
}

