/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.util.Iterator;
import java.util.LinkedList;

public class MultiSnipe {
    private Color _bgColor;
    private String _bgColorString;
    private Currency _defaultSnipeValue;
    private boolean _subtractShipping;
    private long _internalId;
    private LinkedList auctionEntriesInThisGroup = new LinkedList();
    private static final int HEX_BASE = 16;

    private void setValues(Color color, Currency currency, long l, boolean bl) {
        this._bgColor = color;
        this._bgColorString = MultiSnipe.makeRGB(color);
        this._defaultSnipeValue = currency;
        this._subtractShipping = bl;
        this._internalId = l;
    }

    public static String makeRGB(Color color) {
        String string;
        String string2;
        String string3 = Integer.toString(color.getRed(), 16);
        if (string3.length() == 1) {
            string3 = '0' + string3;
        }
        if ((string2 = Integer.toString(color.getGreen(), 16)).length() == 1) {
            string2 = '0' + string2;
        }
        if ((string = Integer.toString(color.getBlue(), 16)).length() == 1) {
            string = '0' + string;
        }
        return string3 + string2 + string;
    }

    public static Color reverseColor(String string) {
        int n = Integer.parseInt(string.substring(0, 2), 16);
        int n2 = Integer.parseInt(string.substring(2, 4), 16);
        int n3 = Integer.parseInt(string.substring(4, 6), 16);
        return new Color(n, n2, n3);
    }

    public MultiSnipe(String string, Currency currency, long l, boolean bl) {
        Color color = MultiSnipe.reverseColor(string);
        this.setValues(color, currency, l, bl);
    }

    public MultiSnipe(Color color, Currency currency, boolean bl) {
        this.setValues(color, currency, System.currentTimeMillis(), bl);
    }

    public Color getColor() {
        return this._bgColor;
    }

    public String getColorString() {
        return this._bgColorString;
    }

    public Currency getSnipeValue(AuctionEntry auctionEntry) {
        Currency currency;
        if (auctionEntry != null && this._subtractShipping && (currency = auctionEntry.getShippingWithInsurance()) != null && !currency.isNull()) {
            try {
                return this._defaultSnipeValue.subtract(currency);
            }
            catch (Currency.CurrencyTypeException currencyTypeException) {
                // empty catch block
            }
        }
        return this._defaultSnipeValue;
    }

    public long getIdentifier() {
        return this._internalId;
    }

    public void add(AuctionEntry auctionEntry) {
        this.auctionEntriesInThisGroup.add(auctionEntry);
    }

    public void remove(AuctionEntry auctionEntry) {
        this.auctionEntriesInThisGroup.remove(auctionEntry);
    }

    public void setWonAuction(AuctionEntry auctionEntry) {
        LinkedList linkedList = this.auctionEntriesInThisGroup;
        this.auctionEntriesInThisGroup = new LinkedList();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            AuctionEntry auctionEntry2 = (AuctionEntry)iterator.next();
            ErrorManagement.logDebug("Cancelling Snipe for: " + auctionEntry2.getTitle() + '(' + auctionEntry2.getIdentifier() + ')');
            auctionEntry2.cancelSnipe(false);
        }
        linkedList.clear();
    }

    public boolean anyEarlier(AuctionEntry auctionEntry) {
        Iterator iterator = this.auctionEntriesInThisGroup.iterator();
        while (iterator.hasNext()) {
            AuctionEntry auctionEntry2 = (AuctionEntry)iterator.next();
            if (!auctionEntry2.getEndDate().before(auctionEntry.getEndDate())) continue;
            return true;
        }
        return false;
    }

    public static boolean isSafeMultiSnipe(AuctionEntry auctionEntry, AuctionEntry auctionEntry2) {
        long l = auctionEntry.getEndDate().getTime();
        long l2 = auctionEntry2.getEndDate().getTime();
        long l3 = l - auctionEntry.getSnipeTime();
        long l4 = l2 - auctionEntry2.getSnipeTime();
        return !(l == l2 || l < l2 && l >= l4 || l2 < l && l2 >= l3);
    }

    public boolean isSafeToAdd(AuctionEntry auctionEntry) {
        Iterator iterator = this.auctionEntriesInThisGroup.iterator();
        while (iterator.hasNext()) {
            AuctionEntry auctionEntry2 = (AuctionEntry)iterator.next();
            if (auctionEntry2 == auctionEntry || MultiSnipe.isSafeMultiSnipe(auctionEntry2, auctionEntry)) continue;
            return false;
        }
        return true;
    }

    public boolean subtractShipping() {
        return this._subtractShipping;
    }
}

