/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;

public class SearchInfoDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JComboBox searchTypeBox;
    private JTextField searchNameField;
    private JComboBox periodList;
    private JComboBox currencyBox = null;
    private JCheckBox periodEnabled;
    private JComboBox tabList;
    private JTextField searchField;
    private boolean cancelled = false;
    private Searcher curSearch;
    private Map curToId = null;
    private static final String[] _periods = new String[]{"Every hour", "Every 6 hours", "Every 12 hours", "Once a day", "Every other day", "Once a week", "Only on command"};
    private static final String[] _search_types = new String[]{"Text Search", "Title Only", "Seller Search", "URL Load", "My Items"};
    private static final int[] _hours = new int[]{1, 6, 12, 24, 48, 168, -1};

    public String getType() {
        return (String)this.searchTypeBox.getSelectedItem();
    }

    public String getName() {
        return this.searchNameField.getText();
    }

    public String getSearch() {
        return this.searchField.getText();
    }

    public String getPeriod() {
        return (String)this.periodList.getSelectedItem();
    }

    public String getTab() {
        return (String)this.tabList.getSelectedItem();
    }

    public boolean doPeriodic() {
        return this.periodEnabled.isSelected();
    }

    public String getCurrency() {
        if (this.curToId == null) {
            return null;
        }
        return (String)this.curToId.get(this.currencyBox.getSelectedItem());
    }

    public SearchInfoDialog() {
        JConfig.setConfiguration("ebay.currencySearch.0", "All");
        JConfig.setConfiguration("ebay.currencySearch.1", "U.S. dollar");
        JConfig.setConfiguration("ebay.currencySearch.2", "Canadian dollar");
        JConfig.setConfiguration("ebay.currencySearch.3", "Pound Sterling");
        JConfig.setConfiguration("ebay.currencySearch.5", "Australian dollar");
        JConfig.setConfiguration("ebay.currencySearch.7", "Euro");
        JConfig.setConfiguration("ebay.currencySearch.44", "Indian Rupee");
        JConfig.setConfiguration("ebay.currencySearch.41", "New Taiwan dollar");
        JConfig.setConfiguration("ebay.currencySearch.13", "Swiss franc");
        this.setupUI();
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchInfoDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchInfoDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SearchInfoDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchInfoDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
    }

    private void onOK() {
        this.cancelled = false;
        if (this.curSearch == null) {
            this.curSearch = SearchManager.getInstance().buildSearch(System.currentTimeMillis(), this.getType(), this.getName(), this.getSearch(), "ebay", this.getCurrency(), -1);
            SearchManager.getInstance().addSearch(this.curSearch);
        } else {
            this.curSearch.setName(this.getName());
            this.curSearch.setSearch(this.getSearch());
            this.curSearch.setCurrency(this.getCurrency());
        }
        this.curSearch.setPeriod(_hours[this.periodList.getSelectedIndex()]);
        this.curSearch.setCategory(this.getTab());
        if (this.doPeriodic()) {
            this.curSearch.enable();
        } else {
            this.curSearch.disable();
        }
        this.dispose();
    }

    private void onCancel() {
        this.cancelled = true;
        this.dispose();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void prepare(Searcher searcher) {
        this.buildTabList();
        if (searcher == null) {
            this.tabList.setSelectedItem("current");
            this.searchField.setText("");
            this.searchNameField.setText("");
            this.periodList.setSelectedItem("Only on command");
            this.periodEnabled.setSelected(false);
            this.searchTypeBox.setEnabled(true);
            this.searchTypeBox.setSelectedIndex(0);
            this.currencyBox.setEnabled(true);
            this.currencyBox.setSelectedIndex(0);
        } else {
            this.tabList.setSelectedItem(searcher.getCategory());
            this.searchField.setText(searcher.getSearch());
            this.searchNameField.setText(searcher.getName());
            this.searchTypeBox.setSelectedItem(searcher.getTypeName());
            this.searchTypeBox.setEnabled(false);
            String string = searcher.getCurrency();
            if (string == null) {
                string = "0";
            }
            this.currencyBox.setSelectedItem(JConfig.queryConfiguration("ebay.currencySearch." + string, "All"));
            if (searcher.getTypeName().equals("Text") || searcher.getTypeName().equals("Title")) {
                this.currencyBox.setEnabled(true);
            } else {
                this.currencyBox.setEnabled(false);
            }
            this.periodEnabled.setSelected(searcher.isEnabled());
            this.periodList.setSelectedIndex(0);
            for (int i = 0; i < _hours.length; ++i) {
                if (searcher.getPeriod() != _hours[i]) continue;
                this.periodList.setSelectedIndex(i);
                break;
            }
        }
        this.curSearch = searcher;
    }

    public static void main(String[] stringArray) {
        SearchInfoDialog searchInfoDialog = new SearchInfoDialog();
        searchInfoDialog.pack();
        searchInfoDialog.setVisible(true);
        System.exit(0);
    }

    private JPanel boxUp(Component component, Component component2) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(component);
        jPanel.add(component2);
        return jPanel;
    }

    private void setupUI() {
        this.contentPane = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.buttonOK = new JButton();
        this.buttonOK.setText("OK");
        this.buttonCancel = new JButton();
        this.buttonCancel.setText("Cancel");
        jPanel.add((Component)this.boxUp(this.buttonOK, this.buttonCancel), "East");
        this.contentPane.add((Component)jPanel, "South");
        JLabel jLabel = new JLabel("Search Name: ");
        this.searchNameField = new JTextField(12);
        JLabel jLabel2 = new JLabel(" Search Type: ");
        this.searchTypeBox = new JComboBox<String>(_search_types);
        this.periodList = new JComboBox<String>(_periods);
        this.periodEnabled = new JCheckBox("Enable Repeated Search");
        this.tabList = new JComboBox();
        this.buildTabList();
        this.currencyBox = new JComboBox();
        this.buildCurrencyList(this.currencyBox);
        JLabel jLabel3 = new JLabel("Search: ");
        this.searchField = new JTextField(40);
        JLabel jLabel4 = new JLabel("Destination Tab: ");
        JLabel jLabel5 = new JLabel("Currency: ");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new SpringLayout());
        jPanel2.add(jLabel);
        jPanel2.add(this.boxUp(this.boxUp(this.searchNameField, jLabel2), this.searchTypeBox));
        jPanel2.add(jLabel3);
        jPanel2.add(this.searchField);
        jPanel2.add(jLabel4);
        jPanel2.add(this.tabList);
        jPanel2.add(jLabel5);
        jPanel2.add(this.currencyBox);
        jPanel2.add(new JLabel("Repeat every: "));
        jPanel2.add(this.boxUp(this.periodList, this.periodEnabled));
        SpringUtilities.makeCompactGrid(jPanel2, 5, 2, 6, 6, 6, 3);
        this.contentPane.add((Component)jPanel2, "Center");
    }

    private void buildCurrencyList(JComboBox jComboBox) {
        jComboBox.removeAllItems();
        jComboBox.setEditable(false);
        List list = JConfig.getMatching("ebay.currencySearch.");
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)object;
                String string2 = (String)object2;
                return Integer.valueOf(string).compareTo(Integer.valueOf(string2));
            }
        });
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string;
            Object e = iterator.next();
            if (e == null || (string = JConfig.queryConfiguration("ebay.currencySearch." + e)) == null) continue;
            jComboBox.addItem(string);
            if (this.curToId == null) {
                this.curToId = new TreeMap();
            }
            this.curToId.put(string, e);
        }
    }

    private void buildTabList() {
        this.tabList.removeAllItems();
        this.tabList.setEditable(true);
        List list = FilterManager.getInstance().allCategories();
        if (list != null) {
            list.remove("complete");
            list.remove("selling");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                this.tabList.addItem(string);
            }
        }
    }
}

