/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SearchManager
extends XMLSerializeSimple
implements SearchManagerInterface,
TimerHandler.WakeupProcess {
    private List _searches = new Vector();
    private static SearchManager _instance = null;
    protected String[] infoTags = new String[]{"search"};

    public void addSearch(Searcher searcher) {
        this._searches.add(searcher);
    }

    public Searcher getSearchByName(String string) {
        Iterator iterator = this._searches.iterator();
        while (iterator.hasNext()) {
            Searcher searcher = (Searcher)iterator.next();
            if (!string.equals(searcher.getName())) continue;
            return searcher;
        }
        return null;
    }

    public Searcher getSearchByIndex(int n) {
        if (n < this._searches.size()) {
            return (Searcher)this._searches.get(n);
        }
        return null;
    }

    public int findSearch(Searcher searcher) {
        return this._searches.indexOf(searcher);
    }

    public Searcher getSearchById(long l) {
        Iterator iterator = this._searches.iterator();
        while (iterator.hasNext()) {
            Searcher searcher = (Searcher)iterator.next();
            if (l != searcher.getId()) continue;
            return searcher;
        }
        return null;
    }

    public boolean check() {
        boolean bl = false;
        Iterator iterator = this._searches.iterator();
        while (iterator.hasNext()) {
            Searcher searcher = (Searcher)iterator.next();
            if (!searcher.shouldExecute()) continue;
            searcher.execute();
            bl = true;
        }
        return bl;
    }

    public boolean saveSearches() {
        String string;
        String string2 = string = JConfig.queryConfiguration("search.savefile", "searches.xml");
        boolean bl = true;
        StringBuffer stringBuffer = this.toXML().toStringBuffer();
        if (!(string = JConfig.getCanonicalFile(string, "jbidwatcher", false)).equals(string2)) {
            JConfig.setConfiguration("search.savefile", string);
        }
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            printStream.println("<?xml version=\"1.0\"?>");
            printStream.println("");
            printStream.println("<!DOCTYPE auctions SYSTEM \"http://www.jbidwatcher.com/searches.dtd\">");
            printStream.println("");
            printStream.println(stringBuffer);
            printStream.close();
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Failed to save searches.", iOException);
            bl = false;
        }
        return bl;
    }

    public void loadSearches() {
        String string;
        XMLElement xMLElement = new XMLElement(true);
        String string2 = string = JConfig.queryConfiguration("search.savefile", "searches.xml");
        if (!(string = JConfig.getCanonicalFile(string, "jbidwatcher", true)).equals(string2)) {
            JConfig.setConfiguration("search.savefile", string);
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(string));
            xMLElement.parseFromReader(inputStreamReader);
            if (!xMLElement.getTagName().equals("searches")) {
                throw new XMLParseException(xMLElement.getTagName(), "AuctionsManager only recognizes <searches> tag!");
            }
            this.fromXML(xMLElement);
        }
        catch (IOException iOException) {
            ErrorManagement.logDebug("JBW: Failed to load saved searches, the search file is probably not there yet.");
            ErrorManagement.logDebug("JBW: This is not an error, unless you are consistently getting it.");
        }
        catch (Exception exception) {
            ErrorManagement.handleException("JBW: Failed to load saved searches, file exists but can't be loaded!", exception);
        }
    }

    public XMLElement toXML() {
        XMLElement xMLElement = new XMLElement("searches");
        Iterator iterator = this._searches.iterator();
        while (iterator.hasNext()) {
            Searcher searcher = (Searcher)iterator.next();
            XMLElement xMLElement2 = searcher.toXML();
            xMLElement.addChild(xMLElement2);
        }
        return xMLElement;
    }

    protected String[] getTags() {
        return this.infoTags;
    }

    protected void handleTag(int n, XMLElement xMLElement) {
        switch (n) {
            case 0: {
                String string = xMLElement.getProperty("TYPE");
                long l = 0L;
                try {
                    l = Long.parseLong(xMLElement.getProperty("ID"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Searcher searcher = this.newSearch(string);
                searcher.setId(l);
                searcher.fromXML(xMLElement);
                if (searcher.getId() == 0L) {
                    if (searcher.getTypeName().equals("My Items")) {
                        searcher.setId(1L);
                    } else {
                        searcher.setId((long)searcher.getName().hashCode() + System.currentTimeMillis() + (long)searcher.getSearch().hashCode());
                    }
                }
                if (this.getSearchById(searcher.getId()) != null) break;
                this._searches.add(searcher);
                break;
            }
        }
    }

    public int getSearchCount() {
        return this._searches.size();
    }

    public void deleteSearch(Searcher searcher) {
        this._searches.remove(searcher);
    }

    private Searcher newSearch(String string) {
        if (string.startsWith("Text")) {
            return new StringSearcher();
        }
        if (string.startsWith("Title")) {
            return new TitleSearcher();
        }
        if (string.startsWith("Seller")) {
            return new SellerSearcher();
        }
        if (string.startsWith("URL")) {
            return new URLSearcher();
        }
        if (string.equals("My Items")) {
            return new MyItemSearcher();
        }
        ErrorManagement.logMessage("Failed to create searcher for: " + string);
        return null;
    }

    public Searcher addSearch(String string, String string2, String string3, String string4, int n, long l) {
        Searcher searcher = this.buildSearch(l, string, string2, string3, string4, null, n);
        this._searches.add(searcher);
        return searcher;
    }

    public Searcher buildSearch(long l, String string, String string2, String string3, String string4, String string5, int n) {
        Searcher searcher = this.newSearch(string);
        searcher.setId(l);
        searcher.setName(string2);
        searcher.setSearch(string3);
        searcher.setServer(string4);
        searcher.setPeriod(n);
        searcher.setCurrency(string5);
        return searcher;
    }

    private SearchManager() {
        AuctionServerManager.getInstance().addSearches(this);
    }

    public static SearchManager getInstance() {
        if (_instance == null) {
            _instance = new SearchManager();
        }
        return _instance;
    }

    public void saveSearchDisplay() {
        String string = JConfig.queryAuxConfiguration("searches.x", JConfig.queryDisplayProperty("searches.x"));
        String string2 = JConfig.queryAuxConfiguration("searches.y", JConfig.queryDisplayProperty("searches.y"));
        String string3 = JConfig.queryAuxConfiguration("searches.width", JConfig.queryDisplayProperty("searches.width"));
        String string4 = JConfig.queryAuxConfiguration("searches.height", JConfig.queryDisplayProperty("searches.height"));
        if (string != null && string2 != null && string3 != null && string4 != null) {
            JConfig.setAuxConfiguration("searches.x", string);
            JConfig.setAuxConfiguration("searches.y", string2);
            JConfig.setAuxConfiguration("searches.width", string3);
            JConfig.setAuxConfiguration("searches.height", string4);
        }
    }

    private class MyItemSearcher
    extends Searcher {
        private MyItemSearcher() {
        }

        public String getTypeName() {
            return "My Items";
        }

        protected void fire() {
            MQFactory.getConcrete(this._server).enqueue(new AuctionQObject(3, null, null));
        }
    }

    private class URLSearcher
    extends Searcher {
        private URLSearcher() {
        }

        public String getTypeName() {
            return "URL";
        }

        protected void fire() {
            MQFactory.getConcrete(this._server).enqueue(new AuctionQObject(0, this, this.getCategory()));
        }
    }

    private class SellerSearcher
    extends Searcher {
        private SellerSearcher() {
        }

        public String getTypeName() {
            return "Seller";
        }

        protected void fire() {
            MQFactory.getConcrete(this._server).enqueue(new AuctionQObject(2, this, this.getCategory()));
        }
    }

    private class TitleSearcher
    extends Searcher {
        private TitleSearcher() {
        }

        public String getTypeName() {
            return "Title";
        }

        protected void fire() {
            MQFactory.getConcrete(this._server).enqueue(new AuctionQObject(6, this, this.getCategory()));
        }
    }

    private class StringSearcher
    extends Searcher {
        private StringSearcher() {
        }

        public String getTypeName() {
            return "Text";
        }

        protected void fire() {
            MQFactory.getConcrete(this._server).enqueue(new AuctionQObject(1, this, this.getCategory()));
        }
    }
}

