/*
 * Decompiled with CFR 0.152.
 */
public class Snipe {
    public static final int SUCCESSFUL = 0;
    public static final int RESNIPE = 1;
    public static final int FAIL = 2;
    public static final int DONE = 3;
    private CookieJar m_cj = null;
    private AuctionEntry m_auction;
    private JHTML.Form m_bidForm = null;

    public Snipe(AuctionEntry auctionEntry) {
        this.m_auction = auctionEntry;
    }

    public String toString() {
        return "Snipe{m_cj=" + this.m_cj + ", m_auction=" + this.m_auction + ", m_bidForm=" + this.m_bidForm + '}';
    }

    public int fire() {
        if (this.m_auction.getSnipeBid().getValue() < 0.0) {
            this.m_auction.setLastStatus("Snipe amount is negative.  Not sniping.");
            return 2;
        }
        if (this.m_cj == null) {
            return this.presnipe();
        }
        return this.do_snipe();
    }

    private int do_snipe() {
        Object object;
        if (this.m_bidForm == null) {
            return 2;
        }
        Auctions.startBlocking();
        if (this.m_auction.isMultiSniped() && ((MultiSnipe)(object = this.m_auction.getMultiSnipe())).anyEarlier(this.m_auction)) {
            this.m_auction.setLastStatus("An earlier snipe in this multisnipe group has not been updated.");
            this.m_auction.setLastStatus("This snipe is NOT being fired, as it could end up winning two items.");
            Auctions.endBlocking();
            return 1;
        }
        MQFactory.getConcrete("Swing").enqueue("Sniping on " + this.m_auction.getTitle());
        object = this.m_auction.getServer();
        this.m_auction.setLastStatus("Firing actual snipe.");
        int n = ((AuctionServer)object).placeFinalBid(this.m_cj, this.m_bidForm, this.m_auction, this.m_auction.getSnipeBid(), this.m_auction.getSnipeQuantity());
        String string = Snipe.getSnipeResult(n, this.m_auction.getTitle(), this.m_auction);
        this.m_auction.setLastStatus(string);
        MQFactory.getConcrete("Swing").enqueue("NOTIFY " + string);
        ErrorManagement.logDebug(string);
        this.m_auction.snipeCompleted();
        Auctions.endBlocking();
        return 3;
    }

    private int presnipe() {
        Auctions.startBlocking();
        AuctionServer auctionServer = this.m_auction.getServer();
        this.m_auction.setLastStatus("Preparing snipe.");
        this.m_cj = auctionServer.getSignInCookie(null);
        if (this.m_cj == null) {
            this.m_auction.setLastStatus("Pre-snipe login failed.  Snipe will be retried, but is unlikely to fire.");
            MQFactory.getConcrete("Swing").enqueue("NOTIFY Pre-snipe login failed.");
            ErrorManagement.logDebug("Pre-snipe login failed.");
            Auctions.endBlocking();
            return 1;
        }
        int n = 0;
        try {
            this.m_bidForm = auctionServer.getBidForm(this.m_cj, this.m_auction, this.m_auction.getSnipeBid(), this.m_auction.getSnipeQuantity());
        }
        catch (AuctionServer.BadBidException badBidException) {
            String string = Snipe.getSnipeResult(badBidException.getResult(), this.m_auction.getTitle(), this.m_auction);
            this.m_auction.setLastStatus(string);
            MQFactory.getConcrete("Swing").enqueue("NOTIFY " + string);
            ErrorManagement.logDebug(string);
            n = 2;
        }
        Auctions.endBlocking();
        return n;
    }

    public static String getSnipeResult(int n, String string, AuctionEntry auctionEntry) {
        String string2;
        if (n == 4 || n == 5) {
            string2 = "Successfully sniped a high bid on " + string + '!';
        } else if (n == 6) {
            string2 = "Successfully sniped a high dutch bid on " + string + '!';
        } else {
            switch (n) {
                case -1: {
                    string2 = "Unknown error sniping on " + string;
                    break;
                }
                case 1: 
                case 9: {
                    string2 = "Snipe apparently failed, as the auction cannot be bid on anymore: " + string;
                    break;
                }
                case 10: {
                    string2 = "Snipe failed, as you are disallowed from bidding on " + auctionEntry.getSeller() + "'s items.";
                    break;
                }
                case 8: {
                    string2 = "Snipe was too low, and was not accepted.";
                    break;
                }
                case 13: {
                    string2 = "Your bid was below or equal to your previous high bid, and was not accepted.";
                    break;
                }
                case 11: {
                    string2 = "Your snipe was successful, but it did not meet the reserve price.";
                    break;
                }
                case 2: {
                    string2 = "There is an error with the amount for the snipe on " + string + " (Probably snipe too low vs. current bids).";
                    break;
                }
                case 3: {
                    string2 = "You have been outbid in your snipe on " + string;
                    break;
                }
                case 12: {
                    string2 = "Snipe failed due to connection problem.  Probably a timeout trying to reach eBay.";
                    break;
                }
                case 14: {
                    string2 = "Your snipe failed because the item was removed from JBidwatcher before the bid executed.";
                    break;
                }
                case 17: {
                    string2 = "You cannot interact with any auctions, your account has been suspended.";
                    break;
                }
                case 18: {
                    string2 = "Sign in failed repeatedly during bid.  Check your username and password information in the Configuration Manager.";
                    break;
                }
                case 19: {
                    string2 = "You are registered in a country to which the seller doesn't ship.";
                    break;
                }
                case 20: {
                    string2 = "You don't meet some requirement the seller has set for the item.  Check the item details for more information.";
                    break;
                }
                case 7: {
                    string2 = "There is a problem with the multisnipe, an earlier entry hasn't finished updating.  Trying again shortly.";
                    break;
                }
                default: {
                    string2 = "Something really bad happened, and I don't know what.";
                }
            }
        }
        return string2;
    }

    public AuctionEntry getItem() {
        return this.m_auction;
    }
}

