/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class TableSorter
extends Transformation
implements TableModelListener {
    private JTable _table = null;
    private ColumnStateList columnStateList;
    private BaseTransformation _model = null;
    private SortTransformation _sorted = null;
    private static final Icon ascend = new ImageIcon((class$TableSorter == null ? (class$TableSorter = TableSorter.class$("TableSorter")) : class$TableSorter).getResource("icons/ascend_10x5.gif"));
    private static final Icon descend = new ImageIcon((class$TableSorter == null ? (class$TableSorter = TableSorter.class$("TableSorter")) : class$TableSorter).getResource("icons/descend_10x5.gif"));
    static /* synthetic */ Class class$TableSorter;

    public TableSorter(String string, String string2, BaseTransformation baseTransformation) {
        this._model = baseTransformation;
        this.columnStateList = new ColumnStateList();
        this._sorted = new SortTransformation(this._model);
        this.m_tm = this._sorted;
        this.setDefaults(string, string2);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    public void sort() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Selection selection = new Selection(TableSorter.this._table, TableSorter.this._sorted);
                TableSorter.this._sorted.sort();
                TableSorter.this.restoreSelection(selection);
            }
        });
    }

    private void sortByList() {
        final TableSorter tableSorter = this;
        this._sorted.setSortList(this.columnStateList);
        if (this._table != null) {
            this.sort();
        }
        if (this._table != null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Selection selection = new Selection(TableSorter.this._table, TableSorter.this._sorted);
                    TableSorter.this._table.tableChanged(new TableModelEvent(tableSorter));
                    TableSorter.this.restoreSelection(selection);
                }
            });
        }
    }

    private void setDefaults(String string, String string2) {
        this.columnStateList.clear();
        int n = 0;
        while (true) {
            String string3;
            String string4;
            if (n == 0) {
                string4 = JConfig.queryDisplayProperty(string + ".sort_by", string2);
                string3 = JConfig.queryDisplayProperty(string + ".sort_direction", "ascending");
            } else {
                string4 = JConfig.queryDisplayProperty(string + ".sort_by" + "_" + n);
                string3 = JConfig.queryDisplayProperty(string + ".sort_direction" + "_" + n);
            }
            if (string4 == null || string3 == null) break;
            ColumnState columnState = new ColumnState(this.getColumnNumber(string4), string3.equals("ascending") ? 1 : -1);
            if (this.columnStateList.indexOf(columnState) == -1) {
                this.columnStateList.add(columnState);
            }
            ++n;
        }
        this.sortByList();
    }

    public int getRowCount() {
        return this.m_tm.getRowCount();
    }

    public int getColumnCount() {
        return this.m_tm.getColumnCount();
    }

    public synchronized Object getValueAt(int n, int n2) {
        return this.m_tm.getValueAt(n, n2);
    }

    public synchronized boolean delete(Object object) {
        int n = this.m_tm.findRow(object);
        final Object object2 = object;
        final TableSorter tableSorter = this;
        if (n == -1) {
            return false;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Selection selection = new Selection(TableSorter.this._table, TableSorter.this._sorted);
                int n = TableSorter.this.m_tm.findRow(object2);
                selection.delete(n);
                TableSorter.this.m_tm.delete(n);
                TableSorter.this._table.tableChanged(new TableModelEvent(tableSorter, n, n, -1, -1));
                TableSorter.this.restoreSelection(selection);
            }
        });
        return true;
    }

    private void restoreSelection(Selection selection) {
        int n;
        boolean bl = false;
        this._table.clearSelection();
        for (n = 0; n < selection.selected.length; ++n) {
            int n2;
            int n3 = selection.selected[n];
            if (n3 != selection.lead && n3 != -1 && (n2 = this._sorted.convertRowIndexToView(n3)) != -1) {
                this._table.getSelectionModel().addSelectionInterval(n2, n2);
            }
            if (n3 != selection.lead) continue;
            bl = true;
        }
        if (selection.lead >= 0 && (n = this._sorted.convertRowIndexToView(selection.lead)) != -1) {
            if (bl) {
                this._table.getSelectionModel().addSelectionInterval(n, n);
            } else {
                this._table.getSelectionModel().removeSelectionInterval(n, n);
            }
        }
    }

    public synchronized int insert(Object object) {
        final Selection selection = new Selection(this._table, this._sorted);
        int n = this.m_tm.insert(object);
        final TableSorter tableSorter = this;
        if (n == -1) {
            return -1;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TableSorter.this._table.tableChanged(new TableModelEvent(tableSorter, 0, TableSorter.this.m_tm.getRowCount(), -1, 1));
                TableSorter.this.restoreSelection(selection);
            }
        });
        return n;
    }

    public boolean update(Object object) {
        int n = this.m_tm.findRow(object);
        final Object object2 = object;
        final TableSorter tableSorter = this;
        if (n != -1) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int n = TableSorter.this.m_tm.findRow(object2);
                    TableSorter.this._table.tableChanged(new TableModelEvent(tableSorter, n));
                }
            });
        }
        return n != -1;
    }

    public void updateTime() {
        final TableSorter tableSorter = this;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TableSorter.this._table.tableChanged(new TableModelEvent(tableSorter, 0, TableSorter.this._sorted.getRowCount(), TableSorter.this.getColumnNumber("Time left")));
            }
        });
    }

    public Object find(Comparison comparison) {
        return this._sorted.find(comparison);
    }

    public Properties getSortProperties(String string, Properties properties) {
        TableColumnModel tableColumnModel = this._table.getColumnModel();
        for (int i = 0; i < this.columnStateList.size(); ++i) {
            ColumnState columnState = this.columnStateList.get(i);
            int n = this._table.convertColumnIndexToView(columnState.getColumn());
            if (n == -1) continue;
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            tableColumn.setHeaderValue(columnState.getHeaderValue());
            properties.setProperty(string + ".sort_by" + (i > 0 ? "_" + i : ""), this._model.getColumnName(columnState.getColumn()));
            properties.setProperty(string + ".sort_direction" + (i > 0 ? "_" + i : ""), columnState.getSort() == 1 ? "ascending" : "descending");
        }
        return properties;
    }

    private void setArrow(TableColumnModel tableColumnModel, int n, int n2) {
        if (n == -1) {
            return;
        }
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null || !(tableCellRenderer instanceof SortHeaderRenderer)) {
            tableCellRenderer = new SortHeaderRenderer();
            tableColumn.setHeaderRenderer(tableCellRenderer);
        }
        SortHeaderRenderer sortHeaderRenderer = (SortHeaderRenderer)tableCellRenderer;
        switch (n2) {
            case -1: {
                sortHeaderRenderer.setIcon(ascend);
                break;
            }
            case 0: {
                sortHeaderRenderer.setIcon(null);
                break;
            }
            case 1: {
                sortHeaderRenderer.setIcon(descend);
                break;
            }
        }
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        this._table = jTable;
        for (int i = 0; i < this.columnStateList.size(); ++i) {
            ColumnState columnState = this.columnStateList.get(i);
            int n = jTable.convertColumnIndexToView(columnState.getColumn());
            if (n == -1) continue;
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            String string = (String)tableColumn.getHeaderValue();
            columnState.setHeaderValue(string);
            tableColumn.setHeaderValue(string + (i > 0 ? " (" + (i + 1) + ")" : ""));
            tableColumn.setIdentifier(string);
            this.setArrow(tableColumnModel, jTable.convertColumnIndexToView(columnState.getColumn()), columnState.getSort());
        }
        jTable.setColumnSelectionAllowed(false);
        SortMouseAdapter sortMouseAdapter = new SortMouseAdapter(jTable, this);
        jTable.getTableHeader().addMouseListener(sortMouseAdapter);
    }

    public void removeColumn(String string, JTable jTable) {
        for (int i = 0; i < this.columnStateList.size(); ++i) {
            ColumnState columnState = this.columnStateList.get(i);
            if (columnState.getHeaderValue().equals(string)) {
                this.columnStateList.remove(columnState);
                --i;
            }
            this.refreshColumns(jTable, false);
        }
    }

    private void refreshColumns(JTable jTable, boolean bl) {
        int n = 0;
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < this.columnStateList.size(); ++i) {
            ColumnState columnState = this.columnStateList.get(i);
            int n2 = jTable.convertColumnIndexToView(columnState.getColumn());
            if (n2 != -1) {
                TableColumn tableColumn = tableColumnModel.getColumn(n2);
                if (bl) {
                    this.setArrow(tableColumnModel, n2, 0);
                    tableColumn.setHeaderValue(columnState.getHeaderValue());
                    continue;
                }
                tableColumn.setHeaderValue(columnState.getHeaderValue() + (i > 0 ? " (" + (i + 1 - n) + ")" : ""));
                continue;
            }
            ++n;
        }
    }

    public Object getObjectAt(int n, int n2) {
        if (this._table != null) {
            int n3 = this._table.rowAtPoint(new Point(n, n2));
            if (n == 0 && n2 == 0) {
                n3 = this._table.getSelectedRow();
            }
            if (n3 != -1) {
                return this.getValueAt(n3, -1);
            }
        }
        return null;
    }

    public boolean select(Selector selector) {
        return selector.select(this._table);
    }

    public int[] getSelectedRows() {
        return this._table.getSelectedRows();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SortMouseAdapter
    extends MouseAdapter {
        private final JTable mTable;
        private final TableSorter mSorter;

        public SortMouseAdapter(JTable jTable, TableSorter tableSorter2) {
            this.mTable = jTable;
            this.mSorter = tableSorter2;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = this.mTable.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            TableColumn tableColumn = tableColumnModel.getColumn(n);
            int n2 = this.mTable.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1) {
                ColumnState columnState = new ColumnState(n2);
                int n3 = TableSorter.this.columnStateList.indexOf(columnState);
                if ((mouseEvent.getModifiers() & 2) != 2) {
                    if (TableSorter.this.columnStateList.size() > 1 || n3 == -1) {
                        TableSorter.this.refreshColumns(this.mTable, true);
                        TableSorter.this.columnStateList.clear();
                        columnState.setSortState(1);
                    } else if (TableSorter.this.columnStateList.size() == 1) {
                        columnState.setSortState((columnState = TableSorter.this.columnStateList.get(0)).getSort() == 1 ? -1 : 1);
                    }
                    columnState.setHeaderValue((String)tableColumn.getHeaderValue());
                    TableSorter.this.setArrow(tableColumnModel, n, columnState.getSort());
                    TableSorter.this.columnStateList.add(columnState);
                } else {
                    if (n3 == -1) {
                        columnState.setHeaderValue((String)tableColumn.getHeaderValue());
                        TableSorter.this.columnStateList.add(columnState);
                    } else {
                        columnState = TableSorter.this.columnStateList.get(n3);
                    }
                    int n4 = columnState.setNextSortState();
                    TableSorter.this.setArrow(tableColumnModel, n, n4);
                    if (n4 == 0) {
                        tableColumn.setHeaderValue(columnState.getHeaderValue());
                        TableSorter.this.columnStateList.remove(columnState);
                    }
                    TableSorter.this.refreshColumns(this.mTable, false);
                }
                this.mSorter.sortByList();
                this.mTable.getTableHeader().repaint();
            }
        }
    }

    private class SortHeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        public SortHeaderRenderer() {
            this.setHorizontalTextPosition(2);
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JTableHeader jTableHeader;
            if (jTable != null && (jTableHeader = jTable.getTableHeader()) != null) {
                this.setForeground(jTableHeader.getForeground());
                this.setBackground(jTableHeader.getBackground());
                this.setFont(jTableHeader.getFont());
            }
            this.setText(object == null ? "" : object.toString());
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            return this;
        }
    }

    private static class Selection {
        protected final int[] selected;
        protected int lead = -1;
        protected SortTransformation sorter;

        protected void delete(int n) {
            int n2 = this.sorter.convertRowIndexToModel(n);
            for (int i = 0; i < this.selected.length; ++i) {
                if (this.selected[i] > n2) {
                    int n3 = i;
                    this.selected[n3] = this.selected[n3] - 1;
                    continue;
                }
                if (this.selected[i] != n2) continue;
                this.selected[i] = -1;
            }
            if (this.lead > n2) {
                --this.lead;
            } else if (this.lead == n2) {
                this.lead = -1;
            }
        }

        protected Selection(JTable jTable, SortTransformation sortTransformation) {
            this.sorter = sortTransformation;
            this.selected = jTable.getSelectedRows();
            for (int i = 0; i < this.selected.length; ++i) {
                int n = this.selected[i];
                this.selected[i] = this.sorter.convertRowIndexToModel(n);
            }
            if (this.selected.length > 0) {
                this.lead = this.sorter.convertRowIndexToModel(jTable.getSelectionModel().getLeadSelectionIndex());
            }
        }
    }
}

