/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.PartialBuffer;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.Replacer;
import com.stevesoft.pat.StringBufferLike;
import com.stevesoft.pat.Transformer;
import com.stevesoft.pat.wrap.WriterWrap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class RegexWriter
extends Writer {
    Replacer repr;
    Writer w;
    WriterWrap ww;
    StringBuffer sb = new StringBuffer();
    PartialBuffer wrap = new PartialBuffer(this.sb);
    int pos;
    int epos;
    int interval = 128;
    int bufferSize = 2048;
    char EOLchar = (char)10;
    int max_lines = 2;

    public RegexWriter(Transformer transformer, Writer writer) {
        this.w = writer;
        this.ww = new WriterWrap(writer);
        this.repr = transformer.getReplacer();
        this.repr.setBuffer(new StringBufferLike(this.ww));
        this.repr.setSource(this.wrap);
    }

    public RegexWriter(Regex regex, Writer writer) {
        this.w = writer;
        this.ww = new WriterWrap(writer);
        this.repr = regex.getReplacer();
        this.repr.setBuffer(new StringBufferLike(this.ww));
        this.repr.setSource(this.wrap);
    }

    public char getEOLchar() {
        return this.EOLchar;
    }

    public void setEOLchar(char c) {
        this.EOLchar = c;
    }

    public int getMaxLines() {
        return this.max_lines;
    }

    public void setMaxLines(int n) {
        this.max_lines = n;
    }

    void write() throws IOException {
        int n;
        Regex regex = this.repr.getRegex();
        int n2 = this.epos;
        if (regex.matchAt(this.wrap, this.epos) && !this.wrap.overRun) {
            while (this.pos < this.epos) {
                this.w.write(this.sb.charAt(this.pos++));
            }
            n = regex.matchedTo();
            this.repr.setPos(n);
            Regex regex2 = regex;
            this.repr.apply(regex2, regex2.getReplaceRule());
            RegexWriter regexWriter = this;
            regexWriter.epos = regexWriter.pos = n;
            if (this.epos == n2 && this.epos < this.sb.length()) {
                ++this.epos;
            }
        } else if (!this.wrap.overRun && this.epos < this.sb.length()) {
            ++this.epos;
        }
        while (this.pos < this.epos) {
            this.w.write(this.sb.charAt(this.pos++));
        }
        if (this.epos == this.sb.length()) {
            this.sb.setLength(1);
            RegexWriter regexWriter = this;
            regexWriter.epos = 1;
            regexWriter.pos = 1;
            return;
        }
        if (this.pos > this.bufferSize) {
            n = this.bufferSize;
            while (n < this.sb.length()) {
                this.sb.setCharAt(n - this.bufferSize, this.sb.charAt(n));
                ++n;
            }
            this.pos -= this.bufferSize;
            this.epos -= this.bufferSize;
            this.sb.setLength(this.sb.length() - this.bufferSize);
        }
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            this.sb.append(cArray[n4]);
            if (this.sb.length() % this.interval == this.interval - 1) {
                this.wrap.overRun = false;
                while (this.epos + this.interval < this.sb.length() && !this.wrap.overRun) {
                    this.write();
                }
            }
            ++n4;
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        this.wrap.allowOverRun = false;
        this.wrap.overRun = false;
        while (this.epos < this.sb.length()) {
            this.write();
        }
        this.write();
        this.w.close();
    }

    public int length() {
        return this.sb.length();
    }

    public char charAt(int n) {
        return this.sb.charAt(n);
    }

    public void setInterval(int n) {
        this.interval = n;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    static void test(String string, String string2, int n) throws Exception {
        StringWriter stringWriter = new StringWriter();
        Regex regex = Regex.perlCode(string);
        String string3 = regex.replaceAll(string2);
        RegexWriter regexWriter = new RegexWriter(regex, (Writer)stringWriter);
        int n2 = 0;
        while (n2 < string2.length()) {
            regexWriter.write(string2.charAt(n2));
            ++n2;
        }
        regexWriter.close();
        String string4 = stringWriter.toString();
        if (!string3.equals(string4)) {
            System.out.println("nmax=" + n);
            System.out.println("re=" + string);
            System.out.println("inp=" + string2);
            System.out.println("res1=" + string3);
            System.out.println("res2=" + string4);
            System.exit(255);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        int n = 1;
        while (n <= 1) {
            RegexWriter.test("s/x/y/", "-----x123456789", n);
            RegexWriter.test("s/x/y/", "x123456789", n);
            RegexWriter.test("s/x/y/", "-----x", n);
            RegexWriter.test("s/x.*?x/y/", ".xx..x..x...x...x....x....x", n);
            RegexWriter.test("s/x.*x/[$&]/", "--x........x--xx", n);
            RegexWriter.test("s/x.*x/[$&]/", "--x........x------", n);
            RegexWriter.test("s/.$/a/m", "bb\nbbb\nbbbb\nbbbbb\nbbbbbb\nbbbbbbbbbbbb", n);
            RegexWriter.test("s/.$/a/", "123", n);
            RegexWriter.test("s/.$/a/", "bb\nbbb\nbbbb\nbbbbb\nbbbbbb\nbb", n);
            RegexWriter.test("s/^./a/", "bb\nbbb\nbbbb\nbbbbb\nbbbbbb\nbb", n);
            RegexWriter.test("s/$/a/", "bbb", n);
            RegexWriter.test("s/^/a/", "bbb", n);
            RegexWriter.test("s/^/a/", "", n);
            RegexWriter.test("s{.*}{N}", "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", n);
            RegexWriter.test("s/.{0,7}/y/", "AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA", n);
            RegexWriter.test("s/x/$&/", "xxx", n);
            ++n;
        }
        System.out.println("Success!!!");
    }
}

