/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlme.decoder;

import java.io.ObjectInputStream;
import javazoom.jlme.decoder.BitReserve;

final class HuffmanTables {
    public static HuffmanTables[] ht;
    private static final int MXOFF = 250;
    private static final int HTN = 34;
    private static final int[] bitbuf;
    private char tablename0 = (char)32;
    private char tablename1 = (char)32;
    private char tablename2 = (char)32;
    private int xlen;
    private int ylen;
    private int linbits;
    private int linmax;
    private int ref;
    private int[][] val = null;
    private int treelen;
    private static int dmask;
    private static int hs;
    private static int point;
    private static int error;
    private static int level;

    private HuffmanTables(String string, int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws Exception {
        this.tablename0 = string.charAt(0);
        this.tablename1 = string.charAt(1);
        this.tablename2 = string.charAt(2);
        this.xlen = n;
        this.ylen = n2;
        this.linbits = n3;
        this.linmax = n4;
        this.ref = n5;
        this.val = nArray;
        this.treelen = n6;
    }

    public static void decode(HuffmanTables huffmanTables, Huffman huffman, BitReserve bitReserve) {
        point = 0;
        level = dmask;
        do {
            if (huffmanTables.val[point][0] == 0) {
                Huffman.x = huffmanTables.val[point][1] >>> 4;
                Huffman.y = huffmanTables.val[point][1] & 0xF;
                break;
            }
            int[][] nArray = huffmanTables.val;
            if (bitReserve.hget1bit() != 0) {
                while (nArray[point][1] >= 250) {
                    point += nArray[point][1];
                }
                point += nArray[point][1];
                continue;
            }
            while (nArray[point][0] >= 250) {
                point += nArray[point][0];
            }
            point += nArray[point][0];
        } while ((level >>>= 1) != 0 || point < 0);
        if (huffmanTables.tablename0 == '3' && (huffmanTables.tablename1 == '2' || huffmanTables.tablename1 == '3')) {
            Huffman.v = Huffman.y >> 3 & 1;
            Huffman.w = Huffman.y >> 2 & 1;
            Huffman.x = Huffman.y >> 1 & 1;
            Huffman.y &= 1;
            if (Huffman.v != 0 && bitReserve.hget1bit() != 0) {
                Huffman.v *= -1;
            }
            if (Huffman.w != 0 && bitReserve.hget1bit() != 0) {
                Huffman.w *= -1;
            }
            if (Huffman.x != 0 && bitReserve.hget1bit() != 0) {
                Huffman.x *= -1;
            }
            if (Huffman.y != 0 && bitReserve.hget1bit() != 0) {
                Huffman.y *= -1;
            }
        } else {
            if (huffmanTables.linbits != 0) {
                if (huffmanTables.xlen - 1 == Huffman.x) {
                    Huffman.x += bitReserve.hgetbits(huffmanTables.linbits);
                }
            }
            if (Huffman.x != 0 && bitReserve.hget1bit() != 0) {
                Huffman.x *= -1;
            }
            if (huffmanTables.linbits != 0) {
                if (huffmanTables.ylen - 1 == Huffman.y) {
                    Huffman.y += bitReserve.hgetbits(huffmanTables.linbits);
                }
            }
            if (Huffman.y != 0 && bitReserve.hget1bit() != 0) {
                Huffman.y *= -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadTables() {
        ObjectInputStream objectInputStream = null;
        int[][] nArray = null;
        try {
            objectInputStream = new ObjectInputStream(this.getClass().getClassLoader().getResourceAsStream("huffman.ser"));
            ht = new HuffmanTables[34];
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[0] = new HuffmanTables("0  ", 0, 0, 0, 0, -1, nArray, 0);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[1] = new HuffmanTables("1  ", 2, 2, 0, 0, -1, nArray, 7);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[2] = new HuffmanTables("2  ", 3, 3, 0, 0, -1, nArray, 17);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[3] = new HuffmanTables("3  ", 3, 3, 0, 0, -1, nArray, 17);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[4] = new HuffmanTables("4  ", 0, 0, 0, 0, -1, nArray, 0);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[5] = new HuffmanTables("5  ", 4, 4, 0, 0, -1, nArray, 31);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[6] = new HuffmanTables("6  ", 4, 4, 0, 0, -1, nArray, 31);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[7] = new HuffmanTables("7  ", 6, 6, 0, 0, -1, nArray, 71);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[8] = new HuffmanTables("8  ", 6, 6, 0, 0, -1, nArray, 71);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[9] = new HuffmanTables("9  ", 6, 6, 0, 0, -1, nArray, 71);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[10] = new HuffmanTables("10 ", 8, 8, 0, 0, -1, nArray, 127);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[11] = new HuffmanTables("11 ", 8, 8, 0, 0, -1, nArray, 127);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[12] = new HuffmanTables("12 ", 8, 8, 0, 0, -1, nArray, 127);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[13] = new HuffmanTables("13 ", 16, 16, 0, 0, -1, nArray, 511);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[14] = new HuffmanTables("14 ", 0, 0, 0, 0, -1, nArray, 0);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[15] = new HuffmanTables("15 ", 16, 16, 0, 0, -1, nArray, 511);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[16] = new HuffmanTables("16 ", 16, 16, 1, 1, -1, nArray, 511);
            HuffmanTables.ht[17] = new HuffmanTables("17 ", 16, 16, 2, 3, 16, (int[][])nArray.clone(), 511);
            HuffmanTables.ht[18] = new HuffmanTables("18 ", 16, 16, 3, 7, 16, (int[][])nArray.clone(), 511);
            HuffmanTables.ht[19] = new HuffmanTables("19 ", 16, 16, 4, 15, 16, (int[][])nArray.clone(), 511);
            HuffmanTables.ht[20] = new HuffmanTables("20 ", 16, 16, 6, 63, 16, (int[][])nArray.clone(), 511);
            HuffmanTables.ht[21] = new HuffmanTables("21 ", 16, 16, 8, 255, 16, (int[][])nArray.clone(), 511);
            HuffmanTables.ht[22] = new HuffmanTables("22 ", 16, 16, 10, 1023, 16, (int[][])nArray.clone(), 511);
            HuffmanTables.ht[23] = new HuffmanTables("23 ", 16, 16, 13, 8191, 16, (int[][])nArray.clone(), 511);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[24] = new HuffmanTables("24 ", 16, 16, 4, 15, -1, nArray, 512);
            HuffmanTables.ht[25] = new HuffmanTables("25 ", 16, 16, 5, 31, 24, (int[][])nArray.clone(), 512);
            HuffmanTables.ht[26] = new HuffmanTables("26 ", 16, 16, 6, 63, 24, (int[][])nArray.clone(), 512);
            HuffmanTables.ht[27] = new HuffmanTables("27 ", 16, 16, 7, 127, 24, (int[][])nArray.clone(), 512);
            HuffmanTables.ht[28] = new HuffmanTables("28 ", 16, 16, 8, 255, 24, (int[][])nArray.clone(), 512);
            HuffmanTables.ht[29] = new HuffmanTables("29 ", 16, 16, 9, 511, 24, (int[][])nArray.clone(), 512);
            HuffmanTables.ht[30] = new HuffmanTables("30 ", 16, 16, 11, 2047, 24, (int[][])nArray.clone(), 512);
            HuffmanTables.ht[31] = new HuffmanTables("31 ", 16, 16, 13, 8191, 24, (int[][])nArray.clone(), 512);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[32] = new HuffmanTables("32 ", 1, 16, 0, 0, -1, nArray, 31);
            nArray = (int[][])objectInputStream.readObject();
            HuffmanTables.ht[33] = new HuffmanTables("33 ", 1, 16, 0, 0, -1, nArray, 31);
        }
        catch (Exception exception) {
            System.out.println("couldn't load the Huffman Tables");
            System.exit(1);
        }
        finally {
            try {
                objectInputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public HuffmanTables() {
        this.loadTables();
    }

    static {
        bitbuf = new int[32];
        dmask = Integer.MIN_VALUE;
        hs = 32;
    }

    public static class Huffman {
        static int x;
        static int y;
        static int v;
        static int w;
    }
}

