/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.SystemColor;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class myTableCellRenderer
extends DefaultTableCellRenderer {
    private static Color darkBG = null;
    private static Font boldFont = null;
    private static Font fixedFont = null;
    private static String selectionColorString = null;
    private static Color selectionColor = null;
    private static final Color darkGreen = new Color(0, 127, 0);
    private static final Color darkRed = new Color(127, 0, 0);
    private static final Color medBlue = new Color(0, 0, 191);
    private static final Color linuxSelection = new Color(204, 204, 255);
    private TableCellRenderer iconTCR = null;

    public static void resetBehavior() {
        darkBG = null;
        boldFont = null;
        fixedFont = null;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        n2 = jTable.convertColumnIndexToModel(n2);
        Component component = object instanceof Icon && this.iconTCR != null ? this.iconTCR.getTableCellRendererComponent(jTable, object, bl, false, n, n2) : super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        AuctionEntry auctionEntry = (AuctionEntry)jTable.getValueAt(n, -1);
        if (auctionEntry == null) {
            return component;
        }
        Color color = this.chooseForeground(auctionEntry, n2);
        Color color2 = this.chooseBackground(auctionEntry, n2, jTable.getBackground());
        if (n % 2 == 1) {
            if (darkBG == null) {
                int n3 = color2.getRed();
                int n4 = color2.getGreen();
                int n5 = color2.getBlue();
                n3 = Math.max(0, n3 - 20);
                n4 = Math.max(0, n4 - 20);
                n5 = Math.max(0, n5 - 20);
                darkBG = new Color(n3, n4, n5);
            }
            if (!(n2 == 2 && auctionEntry.isMultiSniped() || (n2 == 2 || n2 == 20) && auctionEntry.isMultiSniped())) {
                if (JConfig.queryConfiguration("display.alternate", "true").equals("true")) {
                    // empty if block
                }
                color2 = darkBG;
            }
        }
        if (bl) {
            if (JConfig.queryConfiguration("selection.invert", "false").equals("true")) {
                Color color3 = color;
                color = color2;
                color2 = color3;
            } else if (JConfig.queryConfiguration("selection.color") != null) {
                if (selectionColorString == null || !selectionColorString.equals(JConfig.queryConfiguration("selection.color"))) {
                    selectionColorString = JConfig.queryConfiguration("selection.color");
                    selectionColor = MultiSnipe.reverseColor(selectionColorString);
                }
                color2 = selectionColor;
            } else if (Platform.isMac() || Platform.isLinux()) {
                if (n2 == 2 && auctionEntry.isMultiSniped()) {
                    color = color2;
                }
                color2 = linuxSelection;
            } else {
                if (n2 == 2 && auctionEntry.isMultiSniped()) {
                    color = color2;
                } else if (color.equals(Color.BLACK)) {
                    color = SystemColor.textHighlightText;
                }
                color2 = SystemColor.textHighlight;
            }
        }
        Font font = this.chooseFont(component.getFont(), auctionEntry, n2);
        component.setFont(font);
        component.setForeground(color);
        component.setBackground(color2);
        return component;
    }

    private Color chooseForeground(AuctionEntry auctionEntry, int n) {
        switch (n) {
            case 0: {
                return this.chooseIDColor(auctionEntry);
            }
            case 2: 
            case 20: {
                return this.snipeBidColor(auctionEntry);
            }
            case 4: {
                return this.titleColor(auctionEntry);
            }
        }
        return Color.BLACK;
    }

    private Color chooseBackground(AuctionEntry auctionEntry, int n, Color color) {
        Color color2 = null;
        if (auctionEntry != null && (n == 2 || n == 20) && auctionEntry.isSniped()) {
            color2 = this.snipeBidBackground(auctionEntry);
        }
        if (color2 != null) {
            return color2;
        }
        return color;
    }

    private Font chooseFont(Font font, AuctionEntry auctionEntry, int n) {
        boolean bl;
        boolean bl2 = bl = auctionEntry.getComment() != null;
        if (fixedFont == null) {
            fixedFont = new Font("Monospaced", font.getStyle(), font.getSize());
        }
        if (boldFont == null) {
            boldFont = font.deriveFont(1);
        }
        if (n == 3) {
            return fixedFont;
        }
        if (bl && n == 0) {
            return boldFont;
        }
        if (auctionEntry.isShippingOverridden() && n == 7) {
            return boldFont;
        }
        return font;
    }

    private Color snipeBidBackground(AuctionEntry auctionEntry) {
        if (auctionEntry.isMultiSniped()) {
            return auctionEntry.getMultiSnipe().getColor();
        }
        return null;
    }

    Color titleColor(AuctionEntry auctionEntry) {
        if (auctionEntry != null && auctionEntry.getHighBidder() != null) {
            if (auctionEntry.isHighBidder()) {
                if (!auctionEntry.isReserve() || auctionEntry.isReserveMet()) {
                    return medBlue;
                }
                return darkRed;
            }
            if (auctionEntry.getNumBidders() > 0 && (!auctionEntry.isReserve() || auctionEntry.isReserveMet())) {
                return darkRed;
            }
        }
        return Color.BLACK;
    }

    private Color snipeBidColor(AuctionEntry auctionEntry) {
        if (auctionEntry != null) {
            if (auctionEntry.isSniped()) {
                if (!auctionEntry.isMultiSniped()) {
                    if (auctionEntry.isSnipeValid() || auctionEntry.isDutch()) {
                        return darkGreen;
                    }
                    return darkRed;
                }
                if (auctionEntry.snipeCancelled()) {
                    return darkRed;
                }
            } else {
                if (auctionEntry.isBidOn()) {
                    if (auctionEntry.isHighBidder()) {
                        return medBlue;
                    }
                    return darkRed;
                }
                if (auctionEntry.snipeCancelled()) {
                    return darkRed;
                }
            }
        }
        return Color.BLACK;
    }

    private Color chooseIDColor(AuctionEntry auctionEntry) {
        if (auctionEntry != null) {
            boolean bl = auctionEntry.getJustAdded() != 0L;
            boolean bl2 = auctionEntry.isUpdating();
            if (bl) {
                return darkGreen;
            }
            if (bl2) {
                return darkRed;
            }
        }
        return Color.BLACK;
    }

    public void setIconRenderer(TableCellRenderer tableCellRenderer) {
        this.iconTCR = tableCellRenderer;
    }
}

