/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;

public abstract class AuctionServer
implements XMLSerialize {
    public static final int BID_ERROR_UNKNOWN = -1;
    public static final int BID_ERROR_CANNOT = 1;
    public static final int BID_ERROR_AMOUNT = 2;
    public static final int BID_ERROR_OUTBID = 3;
    public static final int BID_WINNING = 4;
    public static final int BID_SELFWIN = 5;
    public static final int BID_DUTCH_CONFIRMED = 6;
    public static final int BID_ERROR_MULTI = 7;
    public static final int BID_ERROR_TOO_LOW = 8;
    public static final int BID_ERROR_ENDED = 9;
    public static final int BID_ERROR_BANNED = 10;
    public static final int BID_ERROR_RESERVE_NOT_MET = 11;
    public static final int BID_ERROR_CONNECTION = 12;
    public static final int BID_ERROR_TOO_LOW_SELF = 13;
    public static final int BID_ERROR_AUCTION_GONE = 14;
    public static final int BID_ERROR_NOT_BIN = 15;
    public static final int BID_BOUGHT_ITEM = 16;
    public static final int BID_ERROR_ACCOUNT_SUSPENDED = 17;
    public static final int BID_ERROR_CANT_SIGN_IN = 18;
    public static final int BID_ERROR_WONT_SHIP = 19;
    public static final int BID_ERROR_REQUIREMENTS_NOT_MET = 20;
    protected String siteId = null;
    private String userCfgString = null;
    private String passCfgString = null;
    private EntryManager _em = null;
    private static final int YEAR_BASE = 1990;
    private static GregorianCalendar midpointDate = new GregorianCalendar(1990, 0, 1);
    private static final int HIGHBIT_ASCII = 128;
    public static final String UPDATE_LOGIN_COOKIE = "Update login cookie";
    protected final Set _aucList = new TreeSet(new AuctionEntry.AuctionComparator());
    protected long _pageRequestTime = 0L;
    protected long _affRequestTime = 0L;
    protected long _officialServerTimeDelta = 0L;
    protected TimeZone _officialServerTimeZone = null;
    private Date mNow = new Date();
    private GregorianCalendar mCal;
    static long s_last_updated = 0L;

    public abstract void pingAffiliate(AuctionEntry var1);

    public abstract int buy(AuctionEntry var1, int var2);

    public abstract long getSnipePadding();

    public abstract String extractIdentifierFromURLString(String var1);

    public abstract CookieJar getNecessaryCookie(boolean var1);

    public abstract CookieJar getSignInCookie(CookieJar var1);

    public abstract void safeGetAffiliate(AuctionEntry var1);

    public abstract JHTML.Form getBidForm(CookieJar var1, AuctionEntry var2, Currency var3, int var4) throws BadBidException;

    public abstract int bid(AuctionEntry var1, Currency var2, int var3);

    public abstract int placeFinalBid(CookieJar var1, JHTML.Form var2, AuctionEntry var3, Currency var4, int var5);

    public abstract boolean checkIfIdentifierIsHandled(String var1);

    public abstract void establishMenu();

    public abstract Object getConfigurationTab();

    public abstract void cancelSearches();

    public abstract void addSearches(SearchManagerInterface var1);

    public abstract Currency getMinimumBidIncrement(Currency var1, int var2);

    public abstract boolean isHighDutch(AuctionEntry var1);

    public abstract void updateHighBid(AuctionEntry var1);

    protected abstract Date getOfficialTime();

    protected abstract String getBrowsableURLFromItem(String var1);

    protected abstract String getStringURLFromItem(String var1);

    protected abstract URL getURLFromItem(String var1);

    protected abstract SpecificAuction getNewSpecificAuction();

    public abstract boolean doHandleThisSite(URL var1);

    public abstract boolean checkIfSiteNameHandled(String var1);

    public void showBrowser(AuctionEntry auctionEntry) {
        String string;
        String string2 = auctionEntry.getIdentifier();
        String string3 = JConfig.queryConfiguration("server.enabled", "false");
        if (string3.equals("false")) {
            string = this.getBrowsableURLFromItem(string2);
        } else {
            String string4 = JConfig.queryConfiguration("server.port", "9099");
            string = auctionEntry.isInvalid() ? "http://localhost:" + string4 + "/cached_" + string2 : "http://localhost:" + string4 + '/' + string2;
        }
        MQFactory.getConcrete("browse").enqueue(string);
    }

    public String getTime() {
        TimeZone timeZone = this.getOfficialServerTimeZone();
        if (timeZone != null) {
            if (this.mCal == null) {
                this.mCal = new GregorianCalendar(timeZone);
                if (JConfig.queryConfiguration("display.ebayTime", "false").equals("true")) {
                    Constants.remoteClockFormat.setCalendar(this.mCal);
                }
            }
            if (JConfig.queryConfiguration("timesync.enabled", "true").equals("true")) {
                this.mNow.setTime(System.currentTimeMillis() + this.getOfficialServerTimeDelta() + this.getPageRequestTime());
            } else {
                this.mNow.setTime(System.currentTimeMillis());
            }
            this.mCal.setTime(this.mNow);
            this.mNow.setTime(this.mCal.getTimeInMillis());
            return this.getUserId() + '@' + this.getName() + ": " + Constants.remoteClockFormat.format(this.mNow);
        }
        this.mNow.setTime(System.currentTimeMillis());
        return this.getUserId() + '@' + this.getName() + ": " + Constants.localClockFormat.format(this.mNow);
    }

    public static URL getURLFromString(String string) {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            ErrorManagement.handleException("getURLFromString failed on " + string, malformedURLException);
        }
        return uRL;
    }

    public AuctionInfo addAuction(String string) {
        URL uRL = this.getURLFromItem(string);
        return this.addAuction(uRL, string);
    }

    private void checkUserPassStartup() {
        if (this.userCfgString == null) {
            this.userCfgString = this.siteId + ".user";
            this.passCfgString = this.siteId + ".password";
        }
    }

    public String getName() {
        return this.siteId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAuction(AuctionEntry auctionEntry) {
        Set set = this._aucList;
        synchronized (set) {
            this._aucList.add(auctionEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAuction(AuctionEntry auctionEntry) {
        Set set = this._aucList;
        synchronized (set) {
            this._aucList.remove(auctionEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuctionStats getStats() {
        Set set = this._aucList;
        synchronized (set) {
            AuctionStats auctionStats = new AuctionStats();
            auctionStats._count = this._aucList.size();
            long l = Long.MAX_VALUE;
            long l2 = Long.MAX_VALUE;
            long l3 = Long.MAX_VALUE;
            Iterator iterator = this._aucList.iterator();
            while (iterator.hasNext()) {
                long l4;
                AuctionEntry auctionEntry = (AuctionEntry)iterator.next();
                if (auctionEntry.isEnded()) {
                    auctionStats._completed++;
                    continue;
                }
                long l5 = auctionEntry.getEndDate().getTime();
                if (auctionEntry.isSniped()) {
                    auctionStats._snipes++;
                    if (l5 < l3) {
                        auctionStats._nextSnipe = auctionEntry;
                        l3 = l5;
                    }
                }
                if (l5 < l2) {
                    auctionStats._nextEnd = auctionEntry;
                    l2 = l5;
                }
                if ((l4 = auctionEntry.getNextUpdate()) >= l) continue;
                auctionStats._nextUpdate = auctionEntry;
                l = l4;
            }
            return auctionStats;
        }
    }

    public void fromXML(XMLElement xMLElement) {
        Object object;
        Object object2;
        this.siteId = xMLElement.getProperty("NAME", "unknown");
        this.checkUserPassStartup();
        String string = xMLElement.getProperty("USER", null);
        if (string != null) {
            JConfig.setConfiguration(this.userCfgString, string);
            object2 = xMLElement.getProperty("PASSWORD1");
            Object object3 = object = object2 != null ? Base64.decodeToString((String)object2) : xMLElement.getProperty("PASSWORD", null);
            if (object != null) {
                JConfig.setConfiguration(this.passCfgString, (String)object);
            }
        }
        object2 = xMLElement.getChildren();
        while (object2.hasNext()) {
            object = (XMLElement)object2.next();
            AuctionEntry auctionEntry = new AuctionEntry();
            auctionEntry.setServer(this);
            auctionEntry.fromXML((XMLElement)object);
            if (this._em == null) continue;
            this._em.addEntry(auctionEntry);
        }
    }

    public void setEntryManager(EntryManager entryManager) {
        this._em = entryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLElement toXML() {
        XMLElement xMLElement = new XMLElement("server");
        if (this.getUserId() != null) {
            xMLElement.setProperty("user", this.getUserId());
            xMLElement.setProperty("password1", Base64.encodeString(this.getPassword(), false));
        }
        xMLElement.setProperty("name", this.siteId);
        Set set = this._aucList;
        synchronized (set) {
            Iterator iterator = this._aucList.iterator();
            while (iterator.hasNext()) {
                AuctionEntry auctionEntry = (AuctionEntry)iterator.next();
                try {
                    xMLElement.addChild(auctionEntry.toXML());
                }
                catch (Exception exception) {
                    ErrorManagement.handleException("Exception trying to save auction " + auctionEntry.getIdentifier() + " (" + auctionEntry.getTitle() + ") -- Not saving", exception);
                }
            }
        }
        return xMLElement;
    }

    public int getAuctionCount() {
        return this._aucList.size();
    }

    public String getUserId() {
        this.checkUserPassStartup();
        return JConfig.queryConfiguration(this.userCfgString, "default");
    }

    public String getPassword() {
        this.checkUserPassStartup();
        return JConfig.queryConfiguration(this.passCfgString, "default");
    }

    public static void reloadTime() {
        if (JConfig.queryConfiguration("timesync.enabled", "true").equals("true")) {
            MQFactory.getConcrete("auction_manager").enqueue("TIMECHECK");
        }
    }

    public void reloadTimeNow() {
        if (this.setOfficialTimeDifference()) {
            MQFactory.getConcrete("Swing").enqueue("Successfully synchronized time with " + this.siteId + '.');
        } else {
            MQFactory.getConcrete("Swing").enqueue("Failed to synchronize time with " + this.siteId + '!');
        }
    }

    public long getPageRequestTime() {
        return this._pageRequestTime;
    }

    public long getAffiliateRequestTime() {
        return this._affRequestTime;
    }

    public long getOfficialServerTimeDelta() {
        return this._officialServerTimeDelta;
    }

    public TimeZone getOfficialServerTimeZone() {
        return this._officialServerTimeZone;
    }

    public AuctionInfo addAuction(URL uRL, String string) {
        SpecificAuction specificAuction = (SpecificAuction)this.loadAuction(uRL, string, null);
        return specificAuction;
    }

    public StringBuffer getAuction(URL uRL) throws FileNotFoundException {
        StringBuffer stringBuffer;
        try {
            CookieJar cookieJar = this.getNecessaryCookie(false);
            URLConnection uRLConnection = cookieJar != null ? cookieJar.getAllCookiesFromPage(uRL.toString(), null, false, null) : Http.makeRequest(uRL, null);
            stringBuffer = Http.receivePage(uRLConnection);
            if (stringBuffer != null && stringBuffer.length() == 0) {
                stringBuffer = null;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            ErrorManagement.logDebug("Item not found: " + uRL.toString());
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Error loading URL (" + uRL.toString() + ')', iOException);
            stringBuffer = null;
        }
        return stringBuffer;
    }

    private void markCommunicationError(AuctionEntry auctionEntry) {
        if (auctionEntry != null) {
            MQFactory.getConcrete("Swing").enqueue("LINK DOWN Communications failure talking to the server during item #" + auctionEntry.getIdentifier() + "( " + auctionEntry.getTitle() + " )");
        } else {
            MQFactory.getConcrete("Swing").enqueue("LINK DOWN Communications failure talking to the server");
        }
    }

    public AuctionInfo loadAuction(URL uRL, String string, AuctionEntry auctionEntry) {
        StringBuffer stringBuffer;
        SpecificAuction specificAuction = this.getNewSpecificAuction();
        if (string != null) {
            specificAuction.setIdentifier(string);
        }
        try {
            if (JConfig.queryConfiguration("timesync.enabled", "true").equals("true")) {
                long l = System.currentTimeMillis();
                stringBuffer = this.getAuction(uRL);
                long l2 = System.currentTimeMillis();
                this._pageRequestTime = l2 - l;
            } else {
                stringBuffer = this.getAuction(uRL);
            }
            if (stringBuffer != null) {
                specificAuction.setContent(stringBuffer, false);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            if (JConfig.debugging()) {
                ErrorManagement.handleException("Some unexpected error occurred during loading the auction.", exception);
            }
            stringBuffer = null;
        }
        boolean bl = true;
        if (stringBuffer == null) {
            this.checkLogError(auctionEntry);
            bl = false;
        }
        if (bl) {
            bl = specificAuction.preParseAuction();
            if (bl) {
                bl = specificAuction.parseAuction(auctionEntry);
            } else {
                ErrorManagement.logMessage("Bad Parse!");
                this.checkLogError(auctionEntry);
            }
        }
        if (!bl) {
            ErrorManagement.logDebug("Failed to parse auction!  Bad return result from auction server.");
            if (s_last_updated + 600000L > System.currentTimeMillis()) {
                s_last_updated = System.currentTimeMillis();
                MQFactory.getConcrete(this.siteId).enqueue(new AuctionQObject(4, UPDATE_LOGIN_COOKIE, null));
            }
            specificAuction = null;
        }
        if (specificAuction != null) {
            specificAuction.save();
        }
        return specificAuction;
    }

    private void checkLogError(AuctionEntry auctionEntry) {
        if (auctionEntry != null) {
            auctionEntry.logError();
        } else {
            this.markCommunicationError(auctionEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuctionInfo reloadAuction(AuctionEntry auctionEntry) {
        URL uRL = this.getURLFromItem(auctionEntry.getIdentifier());
        SpecificAuction specificAuction = (SpecificAuction)this.loadAuction(uRL, auctionEntry.getIdentifier(), auctionEntry);
        if (specificAuction != null) {
            Set set = this._aucList;
            synchronized (set) {
                this._aucList.remove(auctionEntry);
                auctionEntry.setAuctionInfo(specificAuction);
                auctionEntry.clearInvalid();
                this._aucList.add(auctionEntry);
            }
            MQFactory.getConcrete("Swing").enqueue("LINK UP");
        } else {
            if (!auctionEntry.getLastStatus().equals("Seller away - item unavailable.")) {
                auctionEntry.setLastStatus("Failed to load from server!");
            }
            auctionEntry.setInvalid();
        }
        return specificAuction;
    }

    public static String stripHigh(String string, String string2) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        char[] cArray2 = new char[string2.length()];
        string2.getChars(0, string2.length(), cArray2, 0);
        String string3 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-:,";
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] > '\u0080') {
                cArray[i] = 32;
            }
            if (i >= cArray2.length || cArray2[i] != ' ' || string3.indexOf(cArray[i]) != -1) continue;
            cArray[i] = 32;
        }
        return new String(cArray);
    }

    protected Date figureDate(String string, String string2, boolean bl) {
        return this.figureDate(string, string2, true, bl);
    }

    protected Date figureDate(String string, String string2, boolean bl, boolean bl2) {
        Date date;
        String string3 = string;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string2, Locale.US);
        simpleDateFormat.set2DigitYearStart(midpointDate.getTime());
        if (string == null) {
            return null;
        }
        if (bl) {
            string3 = AuctionServer.stripHigh(string, string2);
        }
        try {
            date = simpleDateFormat.parse(string3);
            this._officialServerTimeZone = simpleDateFormat.getCalendar().getTimeZone();
        }
        catch (ParseException parseException) {
            if (!bl2) {
                ErrorManagement.handleException("Error parsing date (" + string3 + "), setting to completed.", parseException);
                date = new Date();
            }
            date = null;
        }
        return date;
    }

    public boolean setOfficialTimeDifference() {
        long l = System.currentTimeMillis();
        Date date = this.getOfficialTime();
        if (date != null) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            this._officialServerTimeDelta = date.getTime() - l - l3 / 2L;
            return true;
        }
        ErrorManagement.logMessage(this.siteId + ": Error, can't accurately set delta to server's official time.");
        this._pageRequestTime = 0L;
        this._officialServerTimeDelta = 0L;
        return false;
    }

    protected static boolean isNumberOnly(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Character.isDigit(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public class AuctionStats {
        private int _snipes = 0;
        private int _count = 0;
        private int _completed = 0;
        private AuctionEntry _nextSnipe = null;
        private AuctionEntry _nextEnd = null;
        private AuctionEntry _nextUpdate = null;

        public int getCompleted() {
            return this._completed;
        }

        public int getSnipes() {
            return this._snipes;
        }

        public int getCount() {
            return this._count;
        }

        public AuctionEntry getNextSnipe() {
            return this._nextSnipe;
        }

        public AuctionEntry getNextEnd() {
            return this._nextEnd;
        }

        public AuctionEntry getNextUpdate() {
            return this._nextUpdate;
        }
    }

    public class BadBidException
    extends Exception {
        String _associatedString;
        int _aucResult;

        public BadBidException(String string, int n) {
            this._associatedString = string;
            this._aucResult = n;
        }

        public String toString() {
            return this._associatedString;
        }

        public int getResult() {
            return this._aucResult;
        }
    }
}

