/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;

public class AutoCompletion
extends PlainDocument {
    JComboBox comboBox;
    ComboBoxModel model;
    JTextComponent editor;
    boolean selecting = false;
    boolean hidePopupOnFocusLoss;
    boolean hitBackspace = false;
    boolean hitBackspaceOnSelection;
    KeyListener editorKeyListener;
    FocusListener editorFocusListener;
    private final boolean strict_match = false;

    public AutoCompletion(final JComboBox jComboBox) {
        this.comboBox = jComboBox;
        this.model = jComboBox.getModel();
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!AutoCompletion.this.selecting) {
                    AutoCompletion.this.highlightCompletedText(0);
                }
            }
        });
        jComboBox.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("editor")) {
                    AutoCompletion.this.configureEditor((ComboBoxEditor)propertyChangeEvent.getNewValue());
                }
                if (propertyChangeEvent.getPropertyName().equals("model")) {
                    AutoCompletion.this.model = (ComboBoxModel)propertyChangeEvent.getNewValue();
                }
            }
        });
        this.editorKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (jComboBox.isDisplayable()) {
                    jComboBox.setPopupVisible(true);
                }
                AutoCompletion.this.hitBackspace = false;
                switch (keyEvent.getKeyCode()) {
                    case 8: {
                        AutoCompletion.this.hitBackspace = true;
                        AutoCompletion.this.hitBackspaceOnSelection = AutoCompletion.this.editor.getSelectionStart() != AutoCompletion.this.editor.getSelectionEnd();
                        break;
                    }
                    case 127: {
                        keyEvent.consume();
                        jComboBox.getToolkit().beep();
                    }
                }
            }
        };
        this.hidePopupOnFocusLoss = System.getProperty("java.version").startsWith("1.5");
        this.editorFocusListener = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                AutoCompletion.this.highlightCompletedText(0);
            }

            public void focusLost(FocusEvent focusEvent) {
                if (AutoCompletion.this.hidePopupOnFocusLoss) {
                    jComboBox.setPopupVisible(false);
                }
            }
        };
        this.configureEditor(jComboBox.getEditor());
        Object object = jComboBox.getSelectedItem();
        if (object != null) {
            this.setText(object.toString());
        }
        this.highlightCompletedText(0);
    }

    public static void enable(JComboBox jComboBox) {
        jComboBox.setEditable(true);
        new AutoCompletion(jComboBox);
    }

    void configureEditor(ComboBoxEditor comboBoxEditor) {
        if (this.editor != null) {
            this.editor.removeKeyListener(this.editorKeyListener);
            this.editor.removeFocusListener(this.editorFocusListener);
        }
        if (comboBoxEditor != null) {
            this.editor = (JTextComponent)comboBoxEditor.getEditorComponent();
            this.editor.addKeyListener(this.editorKeyListener);
            this.editor.addFocusListener(this.editorFocusListener);
            this.editor.setDocument(this);
        }
    }

    public void remove(int n, int n2) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        if (this.hitBackspace) {
            if (n > 0) {
                if (this.hitBackspaceOnSelection) {
                    --n;
                }
            } else {
                this.comboBox.getToolkit().beep();
            }
            this.highlightCompletedText(n);
        } else {
            super.remove(n, n2);
        }
    }

    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (this.selecting) {
            return;
        }
        super.insertString(n, string, attributeSet);
        Object object = this.lookupItem(this.getText(0, this.getLength()));
        boolean bl = true;
        if (object == null) {
            object = this.getText(0, this.getLength());
            bl = false;
        } else {
            this.setSelectedItem(object);
        }
        this.setText(object.toString());
        if (bl) {
            this.highlightCompletedText(n + string.length());
        }
    }

    private void setText(String string) {
        try {
            super.remove(0, this.getLength());
            super.insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException(badLocationException.toString());
        }
    }

    private void highlightCompletedText(int n) {
        this.editor.setCaretPosition(this.getLength());
        this.editor.moveCaretPosition(n);
    }

    private void setSelectedItem(Object object) {
        this.selecting = true;
        this.model.setSelectedItem(object);
        this.selecting = false;
    }

    private Object lookupItem(String string) {
        Object object = this.model.getSelectedItem();
        if (object != null && this.startsWithIgnoreCase(object.toString(), string)) {
            return object;
        }
        int n = this.model.getSize();
        for (int i = 0; i < n; ++i) {
            Object e = this.model.getElementAt(i);
            if (e == null || !this.startsWithIgnoreCase(e.toString(), string)) continue;
            return e;
        }
        return null;
    }

    private boolean startsWithIgnoreCase(String string, String string2) {
        return string.toUpperCase().startsWith(string2.toUpperCase());
    }

    private static void createAndShowGUI() {
        JComboBox<Object> jComboBox = new JComboBox<Object>(new Object[]{"Ester", "Jordi", "Jordina", "Jorge", "Sergi"});
        AutoCompletion.enable(jComboBox);
        JFrame jFrame = new JFrame();
        jFrame.setDefaultCloseOperation(3);
        jFrame.getContentPane().add(jComboBox);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AutoCompletion.createAndShowGUI();
            }
        });
    }
}

