/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class EventLogger
implements XMLSerialize {
    private String _localId = null;
    private String _localTitle = null;
    private List _allStatus = new Vector();
    private final EntryStatus nullStatus = new EntryStatus("Nothing has happened.", new Date());

    public void fromXML(XMLElement xMLElement) {
        Iterator iterator = xMLElement.getChildren();
        while (iterator.hasNext()) {
            XMLElement xMLElement2 = (XMLElement)iterator.next();
            if (xMLElement2.getTagName().equals("entry")) {
                long l = System.currentTimeMillis();
                String string = "Nothing has happened.";
                int n = Integer.parseInt(xMLElement2.getProperty("COUNT"));
                Iterator iterator2 = xMLElement2.getChildren();
                while (iterator2.hasNext()) {
                    XMLElement xMLElement3 = (XMLElement)iterator2.next();
                    if (xMLElement3.getTagName().equals("message")) {
                        string = xMLElement3.getContents();
                    }
                    if (!xMLElement3.getTagName().equals("date")) continue;
                    l = Long.parseLong(xMLElement3.getContents());
                }
                EntryStatus entryStatus = new EntryStatus(string, new Date(l));
                entryStatus._count = n;
                this._allStatus.add(entryStatus);
                continue;
            }
            throw new XMLParseException(xMLElement2.getTagName(), "Expected 'entry' tag!");
        }
    }

    public XMLElement toXML() {
        if (this._allStatus.size() == 0) {
            return null;
        }
        XMLElement xMLElement = new XMLElement("log");
        for (int i = 0; i < this._allStatus.size(); ++i) {
            EntryStatus entryStatus = (EntryStatus)this._allStatus.get(i);
            XMLElement xMLElement2 = new XMLElement("entry");
            xMLElement2.setProperty("count", Integer.toString(entryStatus._count));
            XMLElement xMLElement3 = new XMLElement("message");
            xMLElement3.setContents(entryStatus._what);
            xMLElement2.addChild(xMLElement3);
            XMLElement xMLElement4 = new XMLElement("date");
            xMLElement4.setContents(Long.toString(entryStatus._when.getTime()));
            xMLElement2.addChild(xMLElement4);
            xMLElement.addChild(xMLElement2);
        }
        return xMLElement;
    }

    public EventLogger(String string, String string2) {
        this._localId = string;
        this._localTitle = string2;
    }

    public void setLastStatus(String string) {
        if (string != null) {
            EntryStatus entryStatus = this._allStatus.size() > 0 ? (EntryStatus)this._allStatus.get(this._allStatus.size() - 1) : this.nullStatus;
            if (string.equals(entryStatus._what)) {
                ++entryStatus._count;
            } else {
                EntryStatus entryStatus2 = new EntryStatus(string, new Date());
                this._allStatus.add(entryStatus2);
                ErrorManagement.logMessage(entryStatus2.toString());
            }
        }
    }

    public String getLastStatus() {
        return this.getLastStatus(false);
    }

    public int getStatusCount() {
        return this._allStatus.size();
    }

    public String getLastStatus(boolean bl) {
        if (this._allStatus.size() == 0) {
            if (bl) {
                return this.nullStatus.toBulkString() + "<br>";
            }
            return this.nullStatus.toString() + "<br>";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this._allStatus.size(); ++i) {
            EntryStatus entryStatus = (EntryStatus)this._allStatus.get(i);
            if (bl) {
                stringBuffer.append(entryStatus.toBulkString());
            } else {
                stringBuffer.append(entryStatus.toString());
            }
            stringBuffer.append("<br>");
        }
        return stringBuffer.toString();
    }

    private class EntryStatus {
        public String _what;
        public Date _when;
        public int _count;

        public EntryStatus(String string, Date date) {
            this._what = string;
            this._when = date;
            this._count = 1;
        }

        public String toBulkString() {
            String string = this._when + ": " + this._what + " (" + this._count + ")";
            return string;
        }

        public String toString() {
            String string = this._when + ": " + EventLogger.this._localId + " (" + EventLogger.this._localTitle + ") - " + this._what + " (" + this._count + ")";
            return string;
        }
    }
}

