/*
 * Decompiled with CFR 0.152.
 */
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Heap {
    protected Object[] nodes_;
    protected int count_ = 0;
    protected final Comparator cmp_;

    public Heap(int n, Comparator comparator) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.nodes_ = new Object[n];
        this.cmp_ = comparator;
    }

    public Heap(int n) {
        this(n, null);
    }

    protected int compare(Object object, Object object2) {
        if (this.cmp_ == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return this.cmp_.compare(object, object2);
    }

    protected final int parent(int n) {
        return (n - 1) / 2;
    }

    protected final int left(int n) {
        return 2 * n + 1;
    }

    protected final int right(int n) {
        return 2 * (n + 1);
    }

    public synchronized void insert(Object object) {
        int n;
        int n2;
        if (this.count_ >= this.nodes_.length) {
            n2 = 3 * this.nodes_.length / 2 + 1;
            Object[] objectArray = new Object[n2];
            System.arraycopy(this.nodes_, 0, objectArray, 0, this.nodes_.length);
            this.nodes_ = objectArray;
        }
        n2 = this.count_++;
        while (n2 > 0 && this.compare(object, this.nodes_[n = this.parent(n2)]) < 0) {
            this.nodes_[n2] = this.nodes_[n];
            n2 = n;
        }
        this.nodes_[n2] = object;
    }

    public synchronized Object extract() {
        if (this.count_ < 1) {
            return null;
        }
        int n = 0;
        return this.extractElementAt(n);
    }

    private Object extractElementAt(int n) {
        int n2;
        Object object = this.nodes_[n];
        --this.count_;
        Object object2 = this.nodes_[this.count_];
        while ((n2 = this.left(n)) < this.count_) {
            int n3;
            int n4 = this.right(n);
            int n5 = n3 = n4 >= this.count_ || this.compare(this.nodes_[n2], this.nodes_[n4]) < 0 ? n2 : n4;
            if (this.compare(object2, this.nodes_[n3]) <= 0) break;
            this.nodes_[n] = this.nodes_[n3];
            n = n3;
        }
        this.nodes_[n] = object2;
        this.nodes_[this.count_] = null;
        return object;
    }

    public synchronized Object peek() {
        if (this.count_ > 0) {
            return this.nodes_[0];
        }
        return null;
    }

    public synchronized int size() {
        return this.count_;
    }

    public synchronized void clear() {
        for (int i = 0; i < this.count_; ++i) {
            this.nodes_[i] = null;
        }
        this.count_ = 0;
    }

    public List getUnsorted() {
        List<Object> list = Arrays.asList(this.nodes_);
        return list.subList(0, this.count_);
    }

    public List getSorted() {
        List list = this.getUnsorted();
        Collections.sort(list);
        return list;
    }

    public boolean erase(Object object) {
        for (int i = 0; i < this.nodes_.length; ++i) {
            if (this.nodes_[i] != object) continue;
            this.extractElementAt(i);
            return true;
        }
        return false;
    }
}

