/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.Socket;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class JBidProxy
extends HTTPProxyClient {
    private static final String snipeCommand = "snipe?id=";
    private static final String addAuctionCommand = "addAuction?";
    private static final String activateSnipe = "activateSnipe?";
    private static final String cancelSnipe = "cancelSnipe?";
    private static final String findIDString = "id";
    private static final String findAmountString = "snipeamount";
    private static final String syndicate = "syndicate/";
    private static final String messageFinisher = "<br>Return to <a href=\"JBidWatcher\">auction list</a>.";
    private static List _item_list = null;
    private static final StringBuffer noSyndication = new StringBuffer("<error>No syndication at this address.</error>");
    Map labelToDescription = new HashMap();

    public JBidProxy(Socket socket) {
        super(socket);
        this.labelToDescription.put("ended", "List of items ended recently.");
        this.labelToDescription.put("ending", "List of items ending soon.");
        this.labelToDescription.put("bid", "List of items being bid/sniped on.");
        this.commonSetup();
        this.setName("JBidProxy");
    }

    private void commonSetup() {
        this.setServerName("JBidWatcher/1.0.2 (Java)");
    }

    protected boolean needsAuthorization(String string) {
        if (JConfig.queryConfiguration("allow.syndication", "true").equals("true")) {
            if (string.charAt(0) == '/') {
                string = string.substring(1);
            }
            if (string.startsWith(syndicate) || string.endsWith(".jpg")) {
                return false;
            }
        }
        return true;
    }

    protected boolean handleAuthorization(String string) {
        AuctionServer auctionServer = AuctionServerManager.getInstance().getDefaultServer();
        String string2 = auctionServer.getUserId() + ':' + auctionServer.getPassword();
        String string3 = Base64.decodeToString(string);
        return string3.equals(string2);
    }

    protected StringBuffer buildHeaders(String string, byte[][] byArray) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer(256);
        if (string2.charAt(0) == '/') {
            string2 = string2.substring(1);
        }
        if (string2.endsWith(".jpg")) {
            this.dumpImage(string2, stringBuffer, byArray);
            return stringBuffer;
        }
        if (string2.equals("synchronize") || string2.startsWith(syndicate)) {
            stringBuffer.append("Content-Type: text/xml\n");
        } else {
            stringBuffer.append("Content-Type: text/html; charset=").append(Externalized.getString("ebayServer.charset")).append('\n');
        }
        AuctionEntry auctionEntry = AuctionsManager.getInstance().getEntry(string2);
        AuctionServer auctionServer = auctionEntry != null ? auctionEntry.getServer() : AuctionServerManager.getInstance().getDefaultServer();
        CookieJar cookieJar = auctionServer.getNecessaryCookie(false);
        String string3 = null;
        if (cookieJar != null) {
            string3 = cookieJar.toString();
        }
        if (string3 != null) {
            stringBuffer.append("Set-Cookie: ");
            stringBuffer.append(string3);
            stringBuffer.append('\n');
        }
        return stringBuffer;
    }

    private void dumpImage(String string, StringBuffer stringBuffer, byte[][] byArray) {
        String string2 = JConfig.queryConfiguration("auctions.savepath");
        String string3 = string2 + System.getProperty("file.separator") + string;
        File file = new File(string3);
        if (file.exists()) {
            stringBuffer.append("Content-Type: image/jpeg\n");
            stringBuffer.append("Content-Length: ").append(file.length()).append('\n');
            this.cat(file, byArray);
        }
    }

    private void cat(File file, byte[][] byArray) {
        try {
            byArray[0] = new byte[(int)file.length()];
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = fileInputStream.read(byArray[0], 0, (int)file.length());
            if ((long)n != file.length()) {
                ErrorManagement.logDebug("Couldn't read any data from " + file.getName());
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Can't read file " + file.getName(), iOException);
        }
    }

    private StringBuffer setupSnipePage(String string) {
        Currency currency;
        AuctionEntry auctionEntry = AuctionsManager.getInstance().getEntry(string);
        if (auctionEntry == null) {
            return null;
        }
        try {
            currency = auctionEntry.getCurBid().add(auctionEntry.getServer().getMinimumBidIncrement(auctionEntry.getCurBid(), auctionEntry.getNumBidders()));
        }
        catch (Currency.CurrencyTypeException currencyTypeException) {
            currency = auctionEntry.getCurBid();
        }
        JHTMLOutput jHTMLOutput = new JHTMLOutput("Prepare snipe", new JHTMLDialog("Snipe", "./activateSnipe", "GET", findIDString, string, "snipe", "Enter snipe amount, with no currency symbols.", findAmountString, 20, currency.getValueString()) + messageFinisher);
        return jHTMLOutput.getStringBuffer();
    }

    private void addAuction(String string) {
        AuctionEntry auctionEntry;
        int n = string.indexOf("id=");
        String string2 = string.substring(n + 3);
        if (string2.indexOf(38) != -1) {
            string2 = string2.substring(0, string2.indexOf(38));
        }
        if ((auctionEntry = AuctionsManager.getInstance().newAuctionEntry(string2)) != null) {
            AuctionsManager.getInstance().addEntry(auctionEntry);
        }
    }

    private String extractField(String string, String string2) {
        String string3 = string2 + '=';
        int n = string.indexOf(string3);
        if (n == -1) {
            return null;
        }
        String string4 = string.substring(n + string3.length());
        int n2 = string4.indexOf("&");
        if (n2 != -1) {
            string4 = string4.substring(0, n2);
        }
        return string4;
    }

    private StringBuffer doSnipe(String string) {
        String string2 = this.extractField(string, findIDString);
        String string3 = this.extractField(string, findAmountString);
        AuctionEntry auctionEntry = AuctionsManager.getInstance().getEntry(string2);
        Currency currency = Currency.getCurrency(auctionEntry.getCurBid().fullCurrencyName(), string3);
        ErrorManagement.logDebug("Remote-controlled snipe activated against auction " + string2 + " for " + currency);
        auctionEntry.prepareSnipe(currency);
        JHTMLOutput jHTMLOutput = new JHTMLOutput("Activated snipe!", "Remote-controlled snipe activated on: " + string2 + " for " + currency + messageFinisher);
        return jHTMLOutput.getStringBuffer();
    }

    private StringBuffer cancelSnipe(String string) {
        String string2 = this.extractField(string, findIDString);
        AuctionEntry auctionEntry = AuctionsManager.getInstance().getEntry(string2);
        if (auctionEntry != null) {
            auctionEntry.cancelSnipe(false);
            return new JHTMLOutput("Snipe canceled!", "Cancellation of snipe successful.<br>Return to <a href=\"JBidWatcher\">auction list</a>.").getStringBuffer();
        }
        return new JHTMLOutput("Could not find auction!", "Cancellation of snipe failed, could not find auction " + string2 + '!' + messageFinisher).getStringBuffer();
    }

    protected StringBuffer checkError(StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            return stringBuffer;
        }
        return new JHTMLOutput("Invalid request", "Failed to correctly perform server-side actions.<br>Return to <a href=\"JBidWatcher\">auction list</a>.").getStringBuffer();
    }

    protected StringBuffer buildHTML(String string) {
        StringBuffer stringBuffer;
        String string2 = string;
        if (string2.charAt(0) == '/') {
            string2 = string2.substring(1);
        }
        if (string2.endsWith(".jpg")) {
            return null;
        }
        if (string2.startsWith(syndicate)) {
            if (string2.indexOf(".xml") == -1) {
                return noSyndication;
            }
            return this.syndicate(string2.substring(syndicate.length(), string2.indexOf(".xml")));
        }
        boolean bl = false;
        if (string2.startsWith("cached_")) {
            string2 = string2.substring(7);
            bl = true;
        }
        if (string2.startsWith(snipeCommand)) {
            return this.checkError(this.setupSnipePage(string2.substring(snipeCommand.length())));
        }
        if (string2.startsWith(addAuctionCommand)) {
            this.addAuction(string2.substring(addAuctionCommand.length()));
            HTMLDump hTMLDump = new HTMLDump();
            return this.checkError(hTMLDump.createFullTable());
        }
        if (string2.startsWith(activateSnipe)) {
            return this.checkError(this.doSnipe(string2));
        }
        if (string2.startsWith(cancelSnipe)) {
            return this.cancelSnipe(string2);
        }
        if (string2.equalsIgnoreCase("jbidwatcher")) {
            AuctionsManager.getInstance().saveAuctions();
            return this.checkError(JTransformer.outputHTML(JConfig.queryConfiguration("savefile", "auctions.xml")));
        }
        if (string2.equals("synchronize")) {
            StringBuffer stringBuffer2 = new StringBuffer(25000);
            stringBuffer2.append("<?xml version=\"1.0\"?>\n\n");
            stringBuffer2.append("<!DOCTYPE auctions SYSTEM \"http://www.jbidwatcher.com/auctions.dtd\">");
            AuctionServerManager.getInstance().toXML().toStringBuffer(stringBuffer2);
            return stringBuffer2;
        }
        AuctionEntry auctionEntry = AuctionsManager.getInstance().getEntry(string2);
        if (auctionEntry == null) {
            return new JHTMLOutput("Error!", "Error: No such auction in list!<br>Return to <a href=\"JBidWatcher\">auction list</a>.").getStringBuffer();
        }
        if (bl) {
            stringBuffer = new StringBuffer("<HTML><BODY><B>This is <a href=\"http://www.jbidwatcher.com\">JBidWatcher</a>'s cached copy.</B><br>");
            stringBuffer.append("Click here for the <a href=\"").append(auctionEntry.getServer().getBrowsableURLFromItem(auctionEntry.getIdentifier())).append("\">current page</a>.<hr>");
            stringBuffer.append(auctionEntry.getContent());
        } else {
            int n;
            stringBuffer = new StringBuffer("<HTML><BODY><B>JBidWatcher View</B><br>");
            stringBuffer.append("Click here for the <a href=\"").append(auctionEntry.getServer().getBrowsableURLFromItem(auctionEntry.getIdentifier())).append("\">current page</a>.<br>");
            if (_item_list != null && _item_list.size() > 1 && (n = _item_list.indexOf(string2 = auctionEntry.getIdentifier())) != -1) {
                if (n != 0) {
                    stringBuffer.append(this.getHTMLForEntry("Prev", (String)_item_list.get(n - 1)));
                    stringBuffer.append("&nbsp;");
                }
                for (int i = 0; i < _item_list.size(); ++i) {
                    String string3 = i == 0 ? "First" : (i == _item_list.size() - 1 ? "Last" : Integer.toString(i + 1));
                    if (i == n) {
                        stringBuffer.append('(').append(string3).append(')');
                    } else {
                        stringBuffer.append(this.getHTMLForEntry(string3, (String)_item_list.get(i)));
                    }
                    stringBuffer.append("&nbsp;");
                }
                if (n != _item_list.size() - 1) {
                    stringBuffer.append(this.getHTMLForEntry("Next", (String)_item_list.get(n + 1)));
                }
            }
            stringBuffer.append("<hr><br>");
            AuctionServer auctionServer = auctionEntry.getServer();
            try {
                stringBuffer.append(this.checkError(auctionServer.getAuction(AuctionServer.getURLFromString(auctionServer.getBrowsableURLFromItem(auctionEntry.getIdentifier())))));
            }
            catch (FileNotFoundException fileNotFoundException) {
                stringBuffer.append("<b><i>Item no longer appears on the server.</i></b><br>\n");
            }
        }
        return stringBuffer;
    }

    private StringBuffer genItems(String string) {
        StringBuffer stringBuffer = new StringBuffer(1500);
        Iterator iterator = AuctionsManager.getAuctionIterator();
        ArrayList<AuctionEntry> arrayList = new ArrayList<AuctionEntry>();
        boolean bl = false;
        if (string.equals("ended")) {
            bl = true;
        }
        boolean bl2 = false;
        if (string.equals("ending")) {
            bl2 = true;
        }
        boolean bl3 = false;
        if (string.equals("bid")) {
            bl3 = true;
        }
        boolean bl4 = false;
        int n = 0;
        while (!bl4 && iterator.hasNext()) {
            AuctionEntry auctionEntry = (AuctionEntry)iterator.next();
            if (bl) {
                if (auctionEntry.isEnded()) {
                    arrayList.add(auctionEntry);
                } else {
                    bl4 = true;
                }
            }
            if (bl2 && !auctionEntry.isEnded()) {
                arrayList.add(auctionEntry);
                if (++n >= 15) {
                    bl4 = true;
                }
            }
            if (!bl3 || !auctionEntry.isBidOn() && !auctionEntry.isSniped()) continue;
            arrayList.add(auctionEntry);
            if (++n < 15) continue;
            bl4 = true;
        }
        int n2 = Math.max(0, arrayList.size() - 15);
        for (int i = arrayList.size() - 1; i >= n2; --i) {
            AuctionEntry auctionEntry = (AuctionEntry)arrayList.get(i);
            stringBuffer.append("<item>\n");
            stringBuffer.append("<title><![CDATA[");
            stringBuffer.append(JBidMouse.stripHigh(auctionEntry.getTitle()));
            stringBuffer.append("]]></title>\n");
            stringBuffer.append("<link><![CDATA[");
            stringBuffer.append(auctionEntry.getServer().getBrowsableURLFromItem(auctionEntry.getIdentifier()));
            stringBuffer.append("]]></link>\n");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
            stringBuffer.append("<pubDate>");
            stringBuffer.append(simpleDateFormat.format(auctionEntry.getEndDate()));
            stringBuffer.append("</pubDate>");
            stringBuffer.append("<description><![CDATA[");
            stringBuffer.append(JBidMouse.buildInfoHTML(auctionEntry, false, true));
            stringBuffer.append("]]></description>\n</item>\n");
        }
        return stringBuffer;
    }

    private StringBuffer syndicate(String string) {
        return new StringBuffer(15000).append("<?xml version=\"1.0\" ?>\n").append("<rss version=\"0.91\">\n").append("  <channel>\n").append("    <title>JBidwatcher Auctions</title>\n").append("    <link>/syndicate/").append(string).append(".xml</link>\n").append("    <description>").append(this.labelToDescription.get(string)).append("</description>").append("    <language>en-us</language>").append(this.genItems(string)).append("  </channel>\n").append("</rss>\n");
    }

    public static void setItems(Vector vector) {
        _item_list = vector;
    }

    private String getHTMLForEntry(String string, String string2) {
        AuctionEntry auctionEntry = AuctionsManager.getInstance().getEntry(string2);
        if (auctionEntry.isInvalid()) {
            return "<a href=\"./cached_" + string2 + "\">" + string + "</a>";
        }
        return "<a href=\"./" + string2 + "\">" + string + "</a>";
    }
}

