/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JConfigFilePathTab
extends JConfigTab {
    JTextField filePath;

    public String getTabName() {
        return "Paths";
    }

    public void cancel() {
    }

    public boolean apply() {
        JConfig.setConfiguration("savefile", this.filePath.getText());
        return true;
    }

    public void updateValues() {
        this.filePath.setText(JConfig.queryConfiguration("savefile", JConfig.getCanonicalFile("auctions.xml", "jbidwatcher", false)));
    }

    private JPanel buildFilePathSettings() {
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel("What is the path to the auctions save file:");
        jPanel.setBorder(BorderFactory.createTitledBorder("Save File Path"));
        jPanel.setLayout(new BorderLayout());
        this.filePath = new JTextField();
        this.filePath.addMouseListener(JPasteListener.getInstance());
        this.filePath.setToolTipText("Full path and filename to load auctions save file from.");
        this.updateValues();
        this.filePath.setEditable(true);
        this.filePath.getAccessibleContext().setAccessibleName("Full path and filename to load auctions save file from.");
        jPanel.add((Component)jLabel, "North");
        JPanel jPanel2 = new JPanel();
        JButton jButton = new JButton("Browse...");
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.add(this.filePath);
        jPanel2.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("Browse...")) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setCurrentDirectory(new File(JConfig.getHomeDirectory("jbidwatcher")));
                    jFileChooser.setApproveButtonText("Choose");
                    int n = jFileChooser.showOpenDialog(null);
                    if (n == 0) {
                        try {
                            JConfigFilePathTab.this.filePath.setText(jFileChooser.getSelectedFile().getCanonicalPath());
                        }
                        catch (IOException iOException) {
                            JConfigFilePathTab.this.filePath.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                        }
                    }
                }
            }
        });
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    public JConfigFilePathTab() {
        this.setLayout(new BorderLayout());
        this.add((Component)JConfigFilePathTab.panelPack(this.buildFilePathSettings()), "North");
    }
}

