/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JConfigGeneralTab
extends JConfigTab {
    private JCheckBox doVersionUpdateCheckBox;
    private JCheckBox debuggingBox;
    private JCheckBox loggingBox;
    private JCheckBox affiliateBox;
    private JCheckBox ignoreDeletedBox;
    private JCheckBox allowConfigUpdateBox;
    private JCheckBox allowArchival;
    private JCheckBox timeSyncBox;
    private JCheckBox disableThumbnailBox;
    private JCheckBox limitsBox = null;
    private JCheckBox macMetalBox = null;
    private JCheckBox winTrayBox = null;
    private JCheckBox minimizeTrayBox = null;
    private JTextField spendLimit = null;
    private JComboBox dclickAction = null;
    private String[] dclick_choices = new String[]{"Update the double-clicked auction", "Open the chosen auction in the browser", "Initiate a snipe on the given auction", "Place a bid on the chosen auction", "Show information about the double-clicked auction", "Make a comment on the auction", "Copy useful information about the selected auction"};
    private String[] dclick_options = new String[]{"Update", "Browse", "Snipe", "Bid", "Information", "Comment", "Copy"};
    private static boolean enable_affiliate_configuration = false;

    public String getTabName() {
        return "General";
    }

    public void cancel() {
    }

    public boolean apply() {
        String string;
        int n;
        boolean bl = JConfig.queryConfiguration("config.firstrun", "false").equals("true");
        JConfig.setConfiguration("updates.enabled", this.doVersionUpdateCheckBox.isSelected() ? "true" : "false");
        JConfig.setConfiguration("debugging", this.debuggingBox.isSelected() ? "true" : "false");
        JConfig.setConfiguration("logging", this.loggingBox.isSelected() ? "true" : "false");
        if (!this.loggingBox.isSelected()) {
            ErrorManagement.closeLog();
        }
        if (this.affiliateBox != null) {
            JConfig.setConfiguration("ebay.affiliate", this.affiliateBox.isSelected() ? "true" : "false");
        }
        JConfig.setConfiguration("deleted.ignore", this.ignoreDeletedBox.isSelected() ? "true" : "false");
        JConfig.setConfiguration("limits.enabled", this.limitsBox.isSelected() ? "true" : "false");
        if (this.limitsBox.isSelected()) {
            JConfig.setConfiguration("limits.amount", this.spendLimit.getText());
        }
        if (JConfig.queryConfiguration("limits.amount", "null").equals("null")) {
            JConfig.setConfiguration("limits.amount", "0.00");
        }
        if ((n = this.dclickAction.getSelectedIndex()) != -1) {
            JConfig.setConfiguration("doubleclick.action", this.dclick_options[n]);
        }
        JConfig.setConfiguration("updates.allowConfig", this.allowConfigUpdateBox.isSelected() ? "true" : "false");
        JConfig.setConfiguration("store.auctionHTML", this.allowArchival.isSelected() ? "true" : "false");
        String string2 = null;
        String string3 = JConfig.queryConfiguration("timesync.enabled", "true");
        JConfig.setConfiguration("timesync.enabled", this.timeSyncBox.isSelected() ? "true" : "false");
        if (!bl && !string3.equals(JConfig.queryConfiguration("timesync.enabled", "true"))) {
            string2 = "You have to close and restart JBidwatcher for the Time Synchronisation\nchange to be recognized, as it requires resetting the user interface.";
        }
        JConfig.setConfiguration("display.thumbnail", this.disableThumbnailBox.isSelected() ? "true" : "false");
        if (Platform.isMac() && this.macMetalBox != null) {
            string = JConfig.queryConfiguration("mac.useMetal", "true");
            JConfig.setConfiguration("mac.useMetal", this.macMetalBox.isSelected() ? "true" : "false");
            String string4 = JConfig.queryConfiguration("mac.useMetal", "true");
            if (!bl && !string.equals(string4)) {
                string2 = "You have to close and restart JBidwatcher for the Brushed\nMetal change to be recognized, as it requires resetting\nthe user interface.";
            }
        }
        if (Platform.isWindows()) {
            string = JConfig.queryConfiguration("windows.tray");
            JConfig.setConfiguration("windows.tray", this.winTrayBox.isSelected() ? "true" : "false");
            Platform.setTrayEnabled(this.winTrayBox.isSelected());
            JConfig.setConfiguration("windows.minimize", this.minimizeTrayBox.isSelected() ? "true" : "false");
            if (string == null || !string.equals(JConfig.queryConfiguration("windows.tray"))) {
                MQFactory.getConcrete("tray").enqueue("TRAY " + (this.winTrayBox.isSelected() ? "on" : "off"));
            }
        }
        if (string2 != null) {
            JOptionPane.showMessageDialog(null, string2, "Shut down and restart JBidwatcher", -1);
        }
        if (bl) {
            JConfig.setConfiguration("config.firstrun", "false");
        }
        return true;
    }

    public void updateValues() {
        String string = JConfig.queryConfiguration("updates.enabled", "true");
        String string2 = JConfig.queryConfiguration("debugging", "false");
        String string3 = JConfig.queryConfiguration("logging", "true");
        String string4 = JConfig.queryConfiguration("ebay.affiliate", "true");
        String string5 = JConfig.queryConfiguration("deleted.ignore", "true");
        String string6 = JConfig.queryConfiguration("updates.allowConfig", "true");
        String string7 = JConfig.queryConfiguration("limits.enabled", "false");
        String string8 = JConfig.queryConfiguration("mac.useMetal", "true");
        String string9 = JConfig.queryConfiguration("windows.tray", "true");
        String string10 = JConfig.queryConfiguration("windows.minimize", "true");
        String string11 = JConfig.queryConfiguration("store.auctionHTML", "true");
        String string12 = JConfig.queryConfiguration("timesync.enabled", "true");
        String string13 = JConfig.queryConfiguration("display.thumbnail", "true");
        this.doVersionUpdateCheckBox.setSelected(string.equals("true"));
        this.debuggingBox.setSelected(string2.equals("true"));
        this.loggingBox.setSelected(string3.equals("true"));
        if (this.affiliateBox != null) {
            this.affiliateBox.setSelected(string4.equals("true"));
        }
        this.ignoreDeletedBox.setSelected(string5.equals("true"));
        this.allowConfigUpdateBox.setSelected(string6.equals("true"));
        this.allowArchival.setSelected(string11.equals("true"));
        this.timeSyncBox.setSelected(string12.equals("true"));
        this.disableThumbnailBox.setSelected(string13.equals("true"));
        if (Platform.isWindows() && this.winTrayBox != null) {
            this.winTrayBox.setSelected(string9.equals("true"));
            this.minimizeTrayBox.setEnabled(string9.equals("true"));
            this.minimizeTrayBox.setSelected(string10.equals("true"));
        }
        if (Platform.isMac() && this.macMetalBox != null) {
            this.macMetalBox.setSelected(string8.equals("true"));
        }
        if (this.limitsBox != null) {
            this.limitsBox.setSelected(string7.equals("true"));
        }
        if (this.spendLimit != null) {
            this.spendLimit.setEnabled(string7.equals("true"));
            this.spendLimit.setText(this.getLimitsString());
        }
    }

    private JPanel buildSpendingLimits() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Spending Limits"));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        String string = JConfig.queryConfiguration("limits.enabled", "false");
        this.limitsBox = new JCheckBox("Enable spending limits");
        this.limitsBox.setSelected(string.equals("true"));
        this.limitsBox.addActionListener(new limitAction());
        jPanel.add(this.limitsBox);
        this.spendLimit = new JTextField();
        this.spendLimit.addMouseListener(JPasteListener.getInstance());
        this.spendLimit.setText(this.getLimitsString());
        this.spendLimit.setEditable(true);
        this.spendLimit.getAccessibleContext().setAccessibleName("Maximum amount to spend at any given time");
        this.spendLimit.setEnabled(this.limitsBox.isSelected());
        jPanel.add(new JLabel("Spending limit:"));
        jPanel.add(this.spendLimit);
        return jPanel;
    }

    private String getLimitsString() {
        if (this.limitsBox.isSelected()) {
            return JConfig.queryConfiguration("limits.amount", "0.00");
        }
        return "<disabled>";
    }

    private JPanel buildCheckboxPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("General Options"));
        jPanel.setLayout(new GridLayout(0, 2));
        this.doVersionUpdateCheckBox = new JCheckBox("Regularly check for new versions");
        this.doVersionUpdateCheckBox.setToolTipText("Once a day check for updates, config changes or notices necessary to keep JBidwatcher running smoothly.");
        jPanel.add(this.doVersionUpdateCheckBox);
        this.allowConfigUpdateBox = new JCheckBox("Allow live configuration updates");
        this.allowConfigUpdateBox.setToolTipText("<html><body>Some eBay changes may be fixable with simple updates to configuration values,<br>or search strings.  This option allows JBidwatcher to look for those updates<br>during the new version check.  This only works if 'Regularly check for new versions'<br>is enabled.  This is <b>strongly</b> recommended.</body></html>");
        jPanel.add(this.allowConfigUpdateBox);
        this.doVersionUpdateCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JConfigGeneralTab.this.allowConfigUpdateBox.setEnabled(JConfigGeneralTab.this.doVersionUpdateCheckBox.isSelected());
            }
        });
        this.debuggingBox = new JCheckBox("Debugging");
        this.debuggingBox.setToolTipText("Enable tracking a lot more information about the state of the program as it's working.");
        jPanel.add(this.debuggingBox);
        this.loggingBox = new JCheckBox("Logging");
        this.loggingBox.setToolTipText("Enable logging to error[.###].log files in the JBidwatcher home directory.");
        jPanel.add(this.loggingBox);
        this.affiliateBox = enable_affiliate_configuration ? new JCheckBox("Enable Browse-To via Affiliate") : null;
        if (this.affiliateBox != null) {
            this.affiliateBox.setToolTipText("<html><body>Enable/disable using the affiliate program when browsing to an item through the program.<br>If enabled, the author may make a few nickels, at no cost to you.  More info in Help | FAQ.</body></html>");
        }
        if (this.affiliateBox != null) {
            jPanel.add(this.affiliateBox);
        }
        this.ignoreDeletedBox = new JCheckBox("Ignore deleted items in search results");
        this.ignoreDeletedBox.setToolTipText("<html><body>Ignore previously deleted items when loading in the results from a search.<br>This prevents having to delete the same items repeatedly, every time a search executes.<br>STRONGLY recommended.</body></html>");
        jPanel.add(this.ignoreDeletedBox);
        this.allowArchival = new JCheckBox("Allow archival storage of auctions");
        this.allowArchival.setToolTipText("JBidwatcher will save auctions in compressed format, readable even after eBay has removed the item.");
        jPanel.add(this.allowArchival);
        this.timeSyncBox = new JCheckBox("Time Synchronisation");
        this.timeSyncBox.setToolTipText("Enable/disable time synchronisation");
        jPanel.add(this.timeSyncBox);
        this.disableThumbnailBox = new JCheckBox("Display Thumbnails");
        this.disableThumbnailBox.setToolTipText("Display thumbnails when the cursor hovers over an item.");
        jPanel.add(this.disableThumbnailBox);
        if (Platform.isMac()) {
            this.macMetalBox = new JCheckBox("Use Brushed Metal UI");
            this.macMetalBox.setToolTipText("Turn on / off brushed metal look under MacOSX.");
            jPanel.add(this.macMetalBox);
        }
        if (Platform.isWindows()) {
            this.winTrayBox = new JCheckBox("Use Windows System Tray");
            this.winTrayBox.setToolTipText("Allow JBidwatcher to put an icon in the system tray with some statistics on hover and some messages will use balloon-style popups.");
            jPanel.add(this.winTrayBox);
            this.minimizeTrayBox = new JCheckBox("Minimize to System Tray");
            this.minimizeTrayBox.setToolTipText("If checked, minimizing the window will send JBidwatcher to the tray instead of the task bar.");
            this.winTrayBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JConfigGeneralTab.this.minimizeTrayBox.setEnabled(JConfigGeneralTab.this.winTrayBox.isSelected());
                }
            });
            jPanel.add(this.minimizeTrayBox);
        }
        this.updateValues();
        return jPanel;
    }

    private JPanel buildDropdownPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder("Doubleclick setting"));
        jPanel.setLayout(new BorderLayout());
        String string = JConfig.queryConfiguration("doubleclick.action", "Update");
        this.dclickAction = new JComboBox<String>(this.dclick_choices);
        for (int i = 0; i < this.dclick_options.length; ++i) {
            if (!string.equals(this.dclick_options[i])) continue;
            this.dclickAction.setSelectedIndex(i);
        }
        jPanel.add((Component)JConfigGeneralTab.makeLine(new JLabel("Action: "), this.dclickAction), "North");
        return jPanel;
    }

    public JConfigGeneralTab() {
        super.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)JConfigGeneralTab.panelPack(this.buildCheckboxPanel()), "North");
        this.buildSpendingLimits();
        jPanel.add((Component)JConfigGeneralTab.panelPack(this.buildDropdownPanel()), "Center");
        super.add((Component)jPanel, "North");
    }

    private class limitAction
    implements ActionListener {
        private limitAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JConfigGeneralTab.this.spendLimit.setEnabled(JConfigGeneralTab.this.limitsBox.isSelected());
            JConfigGeneralTab.this.spendLimit.setText(JConfigGeneralTab.this.getLimitsString());
        }
    }
}

