/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.MouseInputAdapter;

public class JFilterField
extends JTextField {
    private static final Border CANCEL_BORDER = new CancelBorder();
    private boolean sendsNotificationForEachKeystroke = false;
    private boolean showingPlaceholderText = false;
    private boolean armed = false;

    public JFilterField(String string, int n) {
        super(n);
        this.addFocusListener(new PlaceholderText(string));
        this.initBorder();
        this.initKeyListener();
    }

    public JFilterField() {
        this("Search", 15);
    }

    public JFilterField(int n) {
        this("Search", n);
    }

    public JFilterField(String string) {
        this(string, 15);
    }

    private void initBorder() {
        this.setBorder(new CompoundBorder(this.getBorder(), CANCEL_BORDER));
        CancelListener cancelListener = new CancelListener();
        this.addMouseListener(cancelListener);
        this.addMouseMotionListener(cancelListener);
    }

    private void initKeyListener() {
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    JFilterField.this.cancel();
                } else if (JFilterField.this.sendsNotificationForEachKeystroke) {
                    JFilterField.this.maybeNotify();
                }
            }
        });
    }

    private void cancel() {
        this.setText("");
        this.postActionEvent();
    }

    private void maybeNotify() {
        if (this.showingPlaceholderText) {
            return;
        }
        this.postActionEvent();
    }

    public void setSendsNotificationForEachKeystroke(boolean bl) {
        this.sendsNotificationForEachKeystroke = bl;
    }

    class PlaceholderText
    implements FocusListener {
        private String placeholderText;
        private String previousText = "";
        private Color previousColor;

        PlaceholderText(String string) {
            this.placeholderText = string;
            this.focusLost(null);
        }

        public void focusGained(FocusEvent focusEvent) {
            JFilterField.this.setForeground(this.previousColor);
            JFilterField.this.setText(this.previousText);
            JFilterField.this.showingPlaceholderText = false;
        }

        public void focusLost(FocusEvent focusEvent) {
            this.previousText = JFilterField.this.getText();
            this.previousColor = JFilterField.this.getForeground();
            if (this.previousText.length() == 0) {
                JFilterField.this.showingPlaceholderText = true;
                JFilterField.this.setForeground(Color.GRAY);
                JFilterField.this.setText(this.placeholderText);
            }
        }
    }

    class CancelListener
    extends MouseInputAdapter {
        CancelListener() {
        }

        private boolean isOverButton(MouseEvent mouseEvent) {
            if (!JFilterField.this.contains(mouseEvent.getPoint())) {
                return false;
            }
            Rectangle rectangle = SwingUtilities.calculateInnerArea(JFilterField.this, null);
            return !rectangle.contains(mouseEvent.getPoint());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.arm(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.arm(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.disarm();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.arm(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (JFilterField.this.armed) {
                JFilterField.this.cancel();
            }
            this.disarm();
        }

        private void arm(MouseEvent mouseEvent) {
            JFilterField.this.armed = this.isOverButton(mouseEvent) && SwingUtilities.isLeftMouseButton(mouseEvent);
            JFilterField.this.repaint();
        }

        private void disarm() {
            JFilterField.this.armed = false;
            JFilterField.this.repaint();
        }
    }

    static class CancelBorder
    extends EmptyBorder {
        private static final Color GRAY = new Color(0.7f, 0.7f, 0.7f);

        CancelBorder() {
            super(0, 0, 0, 15);
        }

        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            JFilterField jFilterField = (JFilterField)component;
            if (jFilterField.showingPlaceholderText || jFilterField.getText().length() == 0) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int n5 = n + n3 - 14;
            int n6 = n2 + (n4 - 1 - 14) / 2;
            graphics2D.setColor(jFilterField.armed ? Color.GRAY : GRAY);
            graphics2D.fillOval(n5, n6, 14, 14);
            int n7 = n5 + 4;
            int n8 = n6 + 4;
            graphics2D.setColor(Color.WHITE);
            graphics2D.drawLine(n7, n8, n7 + 6, n8 + 6);
            graphics2D.drawLine(n7, n8 + 6, n7 + 6, n8);
        }
    }
}

