/*
 * Decompiled with CFR 0.152.
 */
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class JInvoiceParser
implements JParser {
    private static final int TOK_BUYER = 1;
    private static final int TOK_BUYER_EMAIL = 2;
    private static final int TOK_AUCTIONID = 3;
    private static final int TOK_TITLE = 4;
    private static final int TOK_PRICE = 5;
    private static final int TOK_PLUS = 6;
    private static final int TOK_CURRENCY_PLUS = 7;
    private static final int TOK_REPEAT = 8;
    private static final int TOK_SUM = 9;
    private static final int TOK_INVALID = -1;
    AuctionInfo _auction;
    List _auctions;
    Object[][] cmdList = new Object[][]{{"buyer", new Integer(1)}, {"buyer_email", new Integer(2)}, {"auctionid", new Integer(3)}, {"title", new Integer(4)}, {"price", new Integer(5)}, {"+", new Integer(6)}, {"$+", new Integer(7)}, {"repeat", new Integer(8)}, {"$sum", new Integer(9)}};

    JInvoiceParser(AuctionInfo auctionInfo) {
        this._auction = auctionInfo;
        this._auctions = new Vector(1);
        this._auctions.add(auctionInfo);
    }

    JInvoiceParser(List list) {
        this._auctions = list;
        this._auction = (AuctionInfo)list.get(0);
    }

    protected String sum(String string) {
        Currency currency = null;
        Iterator iterator = this._auctions.iterator();
        while (iterator.hasNext()) {
            if (!string.equals("price")) continue;
            if (currency == null) {
                currency = ((AuctionInfo)iterator.next()).getCurBid();
                continue;
            }
            try {
                currency = currency.add(((AuctionInfo)iterator.next()).getCurBid());
            }
            catch (Exception exception) {
                return "$x.xx";
            }
        }
        if (currency == null) {
            return "$x.xx";
        }
        return currency.toString();
    }

    protected String repeat(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = string.replace('[', '<');
        string2 = string2.replace(']', '>');
        Iterator iterator = this._auctions.iterator();
        while (iterator.hasNext()) {
            JInvoiceParser jInvoiceParser = new JInvoiceParser((AuctionInfo)iterator.next());
            JTemplate jTemplate = new JTemplate(jInvoiceParser);
            stringBuffer.append(jTemplate.expand(string2));
            System.err.println("-> " + string2 + " <-");
        }
        return stringBuffer.toString();
    }

    private int cmdMatch(String string) {
        for (int i = 0; i < this.cmdList.length; ++i) {
            if (!string.equalsIgnoreCase((String)this.cmdList[i][0])) continue;
            return (Integer)this.cmdList[i][1];
        }
        return -1;
    }

    public String evaluate(String string) {
        int n = string.indexOf(32);
        String string2 = n == -1 ? string : string.substring(0, n);
        int n2 = this.cmdMatch(string2);
        switch (n2) {
            case 1: {
                return this._auction.getHighBidder();
            }
            case 2: {
                return this._auction.getHighBidderEmail();
            }
            case 3: {
                return this._auction.getIdentifier();
            }
            case 4: {
                return this._auction.getTitle();
            }
            case 5: {
                return this._auction.getCurBid().toString();
            }
            case 6: {
                return this.plus(string.substring(n + 1));
            }
            case 7: {
                return this.currency_plus(string.substring(n + 1));
            }
            case 8: {
                return this.repeat(string.substring(n + 1));
            }
            case 9: {
                return this.sum(string.substring(n + 1));
            }
        }
        return string;
    }

    protected String plus(String string) {
        int n = string.indexOf(32);
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            return Double.toString(Double.parseDouble(string2) + Double.parseDouble(string3));
        }
        catch (Exception exception) {
            return "0.0";
        }
    }

    protected String currency_plus(String string) {
        int n = string.indexOf(32);
        if (n == -1) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            Currency currency = Currency.getCurrency(string2).add(Currency.getCurrency(string3));
            return currency.toString();
        }
        catch (Exception exception) {
            return "$x.xx";
        }
    }
}

