/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;

public class JSearchContext
extends JBidMouse {
    private static SearchInfoDialog _searchDetail = null;
    private static final int EXECUTE = 0;
    private static final int ENABLE = 1;
    private static final int DISABLE = 2;
    private static final int EDIT = 3;
    private static final int NEW = 4;

    private void addMenu(JPopupMenu jPopupMenu, String string, String string2) {
        jPopupMenu.add(this.makeMenuItem(string, string2)).addActionListener(this);
    }

    private void addMenu(JPopupMenu jPopupMenu, String string) {
        jPopupMenu.add(this.makeMenuItem(string)).addActionListener(this);
    }

    protected void internalDoubleClick(MouseEvent mouseEvent) {
        if (!(mouseEvent.getComponent() instanceof JComponent)) {
            return;
        }
        JComponent jComponent = (JComponent)mouseEvent.getComponent();
        if (jComponent instanceof JTable) {
            JTable jTable = (JTable)jComponent;
            int n = jTable.rowAtPoint(new Point(mouseEvent.getX(), mouseEvent.getY()));
            Searcher searcher = (Searcher)jTable.getValueAt(n, -1);
            searcher.execute();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        Searcher searcher = null;
        if (string.startsWith("NC-")) {
            string = string.substring("NC-".length());
        } else if (this._inTable != null) {
            int n = this._inTable.rowAtPoint(new Point(this.getPopupX(), this.getPopupY()));
            searcher = (Searcher)this._inTable.getValueAt(n, -1);
        }
        this.DoAction(string, searcher);
    }

    protected final JPopupMenu constructTablePopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.addMenu(jPopupMenu, "Do Search", "Execute");
        this.addMenu(jPopupMenu, "Load Searches");
        this.addMenu(jPopupMenu, "Edit Search");
        jPopupMenu.add(new JPopupMenu.Separator());
        this.addMenu(jPopupMenu, "Enable");
        this.addMenu(jPopupMenu, "Disable");
        jPopupMenu.add(new JPopupMenu.Separator());
        this.addMenu(jPopupMenu, "Delete");
        return jPopupMenu;
    }

    private void changeTable() {
        TableSorter tableSorter = (TableSorter)this._inTable.getModel();
        tableSorter.tableChanged(new TableModelEvent(tableSorter));
    }

    private void handleSave(boolean bl) {
        if (bl) {
            JOptionPane.showMessageDialog(null, "Searches Saved!", "Save Complete", 1);
        } else {
            String string = JConfig.queryConfiguration("search.savefile", "searches.xml");
            string = JConfig.getCanonicalFile(string, "jbidwatcher", false);
            MQFactory.getConcrete("Swing").enqueue("ERROR Failed to save searches.  Check that the directory for\n" + string + " exists, and is writable.");
        }
    }

    private void showEdit(Searcher searcher) {
        if (_searchDetail == null) {
            _searchDetail = new SearchInfoDialog();
        }
        _searchDetail.prepare(searcher);
        _searchDetail.pack();
        _searchDetail.setVisible(true);
        this.changeTable();
    }

    private void doSingle(Searcher searcher, int n) {
        switch (n) {
            case 0: {
                searcher.execute();
                break;
            }
            case 1: {
                searcher.enable();
                break;
            }
            case 2: {
                searcher.disable();
                break;
            }
            case 3: {
                this.showEdit(searcher);
                break;
            }
            case 4: {
                this.showEdit(searcher);
                break;
            }
        }
    }

    private void doCommand(Searcher searcher, int n, String string) {
        int[] nArray = this.getPossibleRows();
        if (nArray.length == 0 && searcher != null) {
            this.doSingle(searcher, n);
        } else if (nArray.length == 0) {
            JOptionPane.showMessageDialog(this._inTable, string, "No search(es) chosen", 1);
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.doSingle((Searcher)this._inTable.getValueAt(nArray[i], -1), n);
            }
        }
        this.changeTable();
    }

    private void DoExecute(Searcher searcher) {
        this.doCommand(searcher, 0, "You must select at least one search to execute first.");
    }

    private void DoEnable(Searcher searcher) {
        this.doCommand(searcher, 1, "You must select at least one search to enable first.");
    }

    private void DoDisable(Searcher searcher) {
        this.doCommand(searcher, 2, "You must select at least one search to disable first.");
    }

    private void DoEdit(Searcher searcher) {
        this.doCommand(searcher, 3, "You must select at least one search to edit first.");
    }

    private void DoNew() {
        this.doSingle(null, 4);
    }

    private void DoDelete(Searcher searcher) {
        Searcher searcher2 = searcher;
        int[] nArray = this.getPossibleRows();
        if (nArray.length <= 1 && searcher2 != null) {
            String string;
            if (nArray.length == 1) {
                searcher2 = (Searcher)this._inTable.getValueAt(nArray[0], -1);
            }
            if (this.confirmDeletion(null, string = "<HTML><BODY>Are you sure you want to remove this search?<br><b>" + searcher2.getName() + "</b></body></html>")) {
                SearchManager.getInstance().deleteSearch(searcher2);
            }
        } else if (nArray.length == 0) {
            JOptionPane.showMessageDialog(this._inTable, "You must select what searches to delete first.", "No search", 1);
        } else {
            String string = "Are you sure you want to remove all selected searches?";
            if (this.confirmDeletion(null, string)) {
                int n;
                ArrayList<Searcher> arrayList = new ArrayList<Searcher>();
                for (n = 0; n < nArray.length; ++n) {
                    searcher2 = (Searcher)this._inTable.getValueAt(nArray[n], -1);
                    arrayList.add(searcher2);
                }
                for (n = 0; n < arrayList.size(); ++n) {
                    Searcher searcher3 = (Searcher)arrayList.get(n);
                    SearchManager.getInstance().deleteSearch(searcher3);
                }
            }
        }
        this.changeTable();
    }

    public void DoAction(String string, Object object) {
        Searcher searcher = (Searcher)object;
        if (string.equals("Execute")) {
            this.DoExecute(searcher);
        } else if (string.equals("Edit Search")) {
            this.DoEdit(searcher);
        } else if (string.equals("New")) {
            this.DoNew();
        } else if (string.equals("Delete")) {
            this.DoDelete(searcher);
        } else if (string.equals("Enable")) {
            this.DoEnable(searcher);
        } else if (string.equals("Disable")) {
            this.DoDisable(searcher);
        } else if (string.equals("Save All")) {
            this.handleSave(SearchManager.getInstance().saveSearches());
        } else if (string.equals("Load Searches")) {
            SearchManager.getInstance().loadSearches();
            this.changeTable();
        } else {
            System.out.println("Cannot figure out what '" + string + "'.");
        }
    }

    public JSearchContext() {
        this.localPopup = this.constructTablePopup();
    }

    protected void DoAction(Object object, String string, Object object2) {
        this.DoAction(string, object2);
    }
}

