/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public final class PlainMessageQueue
extends MessageQueue {
    List _postpone = new ArrayList();
    Thread _myself = new Thread(this);

    protected void handleListener() {
        if (this._postpone != null) {
            Iterator iterator = this._postpone.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.enqueue(e);
            }
            this._postpone.clear();
            this._postpone = null;
        }
    }

    public PlainMessageQueue(String string) {
        this._myself.setDaemon(true);
        this._myself.setName("MQ_" + string);
        this._myself.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            Object object = null;
            try {
                LinkedList linkedList = this._queue;
                synchronized (linkedList) {
                    if (this._queue.isEmpty()) {
                        this._queue.wait();
                    }
                    object = this.dequeueObject();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (object == null) continue;
            boolean bl = false;
            do {
                if (this._listener != null) {
                    try {
                        this._listener.messageAction(object);
                    }
                    catch (Exception exception) {
                        ErrorManagement.handleException("PMQ Caught exception: " + exception, exception);
                        this.clear();
                    }
                } else {
                    ErrorManagement.logDebug(this._myself.getName() + ": Postponing Message: " + object);
                    if (this._postpone != null) {
                        this._postpone.add(object);
                    }
                }
                LinkedList linkedList = this._queue;
                synchronized (linkedList) {
                    bl = this._queue.isEmpty();
                    if (!bl) {
                        object = this.dequeueObject();
                    }
                }
            } while (!bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueue(Object object) {
        LinkedList linkedList = this._queue;
        synchronized (linkedList) {
            if (this._queue.isEmpty() || this._queue.getLast() != object) {
                this._queue.addLast(object);
                this._queue.notifyAll();
            }
        }
    }
}

