/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class RuntimeInfo
extends JFrame
implements ActionListener {
    private static final double BYTES_PER_MB = 1048576.0;
    private static final String UPDATE_CMD = "update";
    private static final String GC_CMD = "gc";
    private static final DecimalFormat myValueFormatter = new DecimalFormat("##0.0");
    private Runtime myRuntime = Runtime.getRuntime();
    private JLabel myMaxMemoryLbl;
    private JLabel myMemoryUseLbl;

    public RuntimeInfo() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.add((Component)this.makeInfoPanel(), "Center");
        jPanel.add((Component)this.makeBtnPanel(), "South");
        this.pack();
        this.setVisible(true);
    }

    private JPanel makeInfoPanel() {
        JPanel jPanel = new JPanel(new GridLayout(2, 2));
        jPanel.add(new JLabel("Max Memory:"));
        this.myMaxMemoryLbl = new JLabel(this.getMaxMemory());
        jPanel.add(this.myMaxMemoryLbl);
        jPanel.add(new JLabel("Memory use:"));
        this.myMemoryUseLbl = new JLabel(this.getMemoryUse());
        jPanel.add(this.myMemoryUseLbl);
        return jPanel;
    }

    private JPanel makeBtnPanel() {
        JButton jButton = new JButton("GC");
        jButton.setActionCommand(GC_CMD);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton("Update");
        jButton2.setActionCommand(UPDATE_CMD);
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        return jPanel;
    }

    private void updateInfo() {
        this.myMaxMemoryLbl.setText(this.getMaxMemory());
        this.myMemoryUseLbl.setText(this.getMemoryUse());
    }

    private long getBytesUsed() {
        long l = this.myRuntime.totalMemory();
        long l2 = this.myRuntime.freeMemory();
        return l - l2;
    }

    private String getMemoryUse() {
        long l = this.getBytesUsed();
        double d = (double)l / 1048576.0;
        return myValueFormatter.format(d) + " MB";
    }

    private String getMaxMemory() {
        long l = this.myRuntime.maxMemory();
        double d = (double)l / 1048576.0;
        return myValueFormatter.format(d) + " MB";
    }

    private void doGarbageCollection() {
        try {
            System.gc();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.sleep(100L);
            System.gc();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(UPDATE_CMD)) {
            this.updateInfo();
        } else if (string.equals(GC_CMD)) {
            this.doGarbageCollection();
            this.updateInfo();
        }
    }
}

