/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;

public class SearchFrame
implements ActionListener {
    JPanel tablePanel;
    JFrame mainFrame;
    JComboBox newType;
    JTextField searchString;
    SearchTableModel _stm;
    TableSorter _ts;
    String[] search_types = new String[]{"Text Search", "Seller Search", "URL Load", "My Items"};

    public SearchFrame() {
        this.mainFrame = this.createSearchFrame();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.min(305, dimension.height / 2);
        int n2 = Math.min(566, dimension.width / 2);
        int n3 = (dimension.width - n2) / 2;
        int n4 = (dimension.height - n) / 2;
        String string = JConfig.queryDisplayProperty("searches.x");
        String string2 = JConfig.queryDisplayProperty("searches.y");
        String string3 = JConfig.queryDisplayProperty("searches.width");
        String string4 = JConfig.queryDisplayProperty("searches.height");
        try {
            if (string != null) {
                n3 = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (string != null && string2 != null) {
                n4 = Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (string != null && string3 != null) {
                n2 = Integer.parseInt(string3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            if (string != null && string4 != null) {
                n = Integer.parseInt(string4);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.mainFrame.setLocation(n3, n4);
        this.mainFrame.setSize(n2, n);
        this.mainFrame.setVisible(true);
    }

    private void savePosition() {
        JConfig.setAuxConfiguration("searches.x", Integer.toString(this.mainFrame.getX()));
        JConfig.setAuxConfiguration("searches.y", Integer.toString(this.mainFrame.getY()));
        JConfig.setAuxConfiguration("searches.width", Integer.toString(this.mainFrame.getWidth()));
        JConfig.setAuxConfiguration("searches.height", Integer.toString(this.mainFrame.getHeight()));
    }

    public JFrame createSearchFrame() {
        JPanel jPanel = new JPanel(new BorderLayout(), true);
        JPanel jPanel2 = new JPanel(new BorderLayout(), true);
        JPanel jPanel3 = new JPanel(new BorderLayout(), true);
        Box box = Box.createHorizontalBox();
        JSearchContext jSearchContext = new JSearchContext();
        final JFrame jFrame = new JFrame("Search Manager");
        Platform.setMacFrameMenu(jFrame);
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Saved Searches"));
        jPanel.add((Component)this.buildSearchTable(jSearchContext), "Center");
        box.add(jSearchContext.makeButton("Search", "Execute"));
        box.add(jSearchContext.makeButton("New"));
        box.add(jSearchContext.makeButton("Edit", "Edit Search"));
        box.add(jSearchContext.makeButton("Enable"));
        box.add(jSearchContext.makeButton("Disable"));
        box.add(Box.createHorizontalGlue());
        box.add(jSearchContext.makeButton("Delete"));
        jPanel3.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel3.add((Component)box, "South");
        jPanel.add((Component)jPanel3, "South");
        container.add((Component)jPanel, "Center");
        container.add((Component)jPanel2, "South");
        jFrame.pack();
        jFrame.setResizable(true);
        jFrame.setDefaultCloseOperation(1);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SearchFrame.this.savePosition();
                SearchManager.getInstance().saveSearches();
            }

            public void windowIconified(WindowEvent windowEvent) {
                SearchFrame.this.savePosition();
                if (Platform.isWindows() && Platform.isTrayEnabled() && JConfig.queryConfiguration("windows.tray", "true").equals("true") && JConfig.queryConfiguration("windows.minimize", "true").equals("true")) {
                    jFrame.setVisible(false);
                }
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                if (Platform.isWindows() && Platform.isTrayEnabled() && JConfig.queryConfiguration("windows.tray", "true").equals("true") && JConfig.queryConfiguration("windows.minimize", "true").equals("true")) {
                    jFrame.setState(0);
                    jFrame.setVisible(true);
                }
            }
        });
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SearchFrame.this.savePosition();
                jFrame.setVisible(false);
            }
        };
        jFrame.getRootPane().getInputMap(2).put(keyStroke, "ESCAPE");
        jFrame.getRootPane().getActionMap().put("ESCAPE", abstractAction);
        return jFrame;
    }

    private JScrollPane buildSearchTable(JSearchContext jSearchContext) {
        this._stm = new SearchTableModel();
        this._ts = new TableSorter("search", "Name", this._stm);
        JTable jTable = new JTable(this._ts);
        jTable.addMouseListener(jSearchContext);
        jTable.setShowGrid(false);
        jTable.setIntercellSpacing(new Dimension(0, 0));
        jTable.setDoubleBuffered(true);
        jTable.setShowHorizontalLines(true);
        jTable.setToolTipText("Double-click on a search to execute it!");
        jTable.getTableHeader().setReorderingAllowed(false);
        this._ts.addMouseListenerToHeaderInTable(jTable);
        JScrollPane jScrollPane = new JScrollPane(jTable, 20, 31);
        jScrollPane.getViewport().setBackground(UIManager.getColor("window"));
        jSearchContext.setTable(jTable);
        return jScrollPane;
    }

    public void show() {
        this.mainFrame.setState(0);
        this.mainFrame.setVisible(true);
    }

    private Searcher add(String string, String string2, String string3, String string4) {
        int n = 0;
        String string5 = string2 + Integer.toString(n);
        SearchManager searchManager = SearchManager.getInstance();
        Searcher searcher = searchManager.buildSearch(System.currentTimeMillis(), string, string5, string3, string4, null, -1);
        this._ts.insert(searcher);
        return searcher;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Add") || string.equals("Search")) {
            String string2 = this.searchString.getText();
            Searcher searcher = this.add((String)this.newType.getSelectedItem(), "New Search ", string2, "ebay");
            this._stm.fireTableDataChanged();
            this.newType.setSelectedIndex(0);
            this.searchString.setText("");
            if (string.equals("Search")) {
                if (JConfig.debugging) {
                    System.out.println("Doing a " + this.newType.getSelectedItem() + " for " + string2);
                }
                searcher.execute();
            }
        }
    }
}

