/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class XMLElement {
    public static final int NANOXML_MAJOR_VERSION = 1;
    public static final int NANOXML_MINOR_VERSION = 7;
    private static boolean mRejectBadHTML = false;
    protected HashMap _attributes;
    protected List _children;
    protected String _tagName;
    protected boolean _empty;
    protected String _contents;
    protected HashMap _conversionTable;
    protected boolean _skipLeadingWhitespace;
    protected int _lineNr;
    private static final int INITIAL_BLOCKSIZE = 20480;

    public static void rejectBadHTML(boolean bl) {
        mRejectBadHTML = bl;
    }

    public XMLElement() {
        this(null, false, true);
    }

    public XMLElement(HashMap hashMap) {
        this(hashMap, false, true);
    }

    public XMLElement(boolean bl) {
        this(null, bl, true);
    }

    public XMLElement(HashMap hashMap, boolean bl) {
        this(hashMap, bl, true);
    }

    private XMLElement(HashMap hashMap, boolean bl, boolean bl2) {
        this._skipLeadingWhitespace = bl;
        this._tagName = null;
        this._contents = null;
        this._attributes = new HashMap(10);
        this._children = new ArrayList(10);
        this._conversionTable = hashMap == null ? new HashMap(10) : new HashMap(hashMap);
        this._lineNr = 0;
        if (bl2) {
            this._conversionTable.put("lt", "<");
            this._conversionTable.put("gt", ">");
            this._conversionTable.put("quot", "\"");
            this._conversionTable.put("apos", "'");
            this._conversionTable.put("amp", "&");
            this._conversionTable.put("pound", "#");
        }
    }

    public XMLElement(String string) {
        this(null, false, true);
        this._tagName = string;
    }

    public int countChildren() {
        return this._children.size();
    }

    public Iterator getAttributes() {
        return this._attributes.keySet().iterator();
    }

    public Iterator getChildren() {
        return this._children.iterator();
    }

    public XMLElement getChild(String string) {
        Iterator iterator = this.getChildren();
        while (iterator.hasNext()) {
            XMLElement xMLElement = (XMLElement)iterator.next();
            if (!xMLElement.getTagName().equals(string)) continue;
            return xMLElement;
        }
        return null;
    }

    public String getContents() {
        return this._contents;
    }

    public int getLineNr() {
        return this._lineNr;
    }

    public String getProperty(String string) {
        return (String)this._attributes.get(string.toLowerCase());
    }

    public String getProperty(String string, String string2) {
        String string3 = (String)this._attributes.get(string.toLowerCase());
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public void setProperty(String string, String string2) {
        String string3 = string.toLowerCase();
        this._attributes.put(string3, string2);
    }

    public String getTagName() {
        return this._tagName;
    }

    public void setEmpty() {
        this._empty = true;
    }

    public void setNonEmpty() {
        this._empty = false;
    }

    public void setTagName(String string) {
        this._tagName = string;
    }

    public void setContents(String string) {
        if (this._children.size() != 0) {
            throw new XMLParseException(this._tagName, this._lineNr, "Cannot add contents to an XML element that already has children.");
        }
        this._contents = string;
    }

    public void addChild(XMLElement xMLElement) {
        if (this._contents != null) {
            throw new XMLParseException(this._tagName, this._lineNr, "Cannot add children to an XML element that already has contents.");
        }
        this._children.add(xMLElement);
    }

    private StringBuffer allAttribs(StringBuffer stringBuffer) {
        Iterator iterator = this.getAttributes();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(' ');
            stringBuffer.append(string);
            stringBuffer.append("=\"");
            stringBuffer.append(XMLElement.encodeString(this.getProperty(string)));
            stringBuffer.append('\"');
        }
        return stringBuffer;
    }

    public String toString() {
        return this.toStringBuffer().toString();
    }

    public String toString(int n) {
        return this.toStringBuffer(new StringBuffer(), n).toString();
    }

    public StringBuffer toStringBuffer() {
        return this.toStringBuffer(new StringBuffer(), 0);
    }

    public StringBuffer toStringBuffer(StringBuffer stringBuffer) {
        return this.toStringBuffer(stringBuffer, 0);
    }

    public StringBuffer toStringBuffer(StringBuffer stringBuffer, int n) {
        XMLElement.prependSpaces(stringBuffer, n);
        stringBuffer.append('<').append(this._tagName);
        this.allAttribs(stringBuffer);
        if (this._empty) {
            stringBuffer.append("/>");
        } else {
            stringBuffer.append('>');
            if (this._contents == null) {
                Iterator iterator = this.getChildren();
                stringBuffer.append('\n');
                while (iterator.hasNext()) {
                    ((XMLElement)iterator.next()).toStringBuffer(stringBuffer, n + 1);
                }
                XMLElement.prependSpaces(stringBuffer, n);
            } else {
                stringBuffer.append(XMLElement.encodeString(this._contents));
            }
            stringBuffer.append("</").append(this._tagName).append('>');
        }
        stringBuffer.append('\n');
        return stringBuffer;
    }

    private static void prependSpaces(StringBuffer stringBuffer, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
    }

    protected static boolean isIdentifierChar(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || ".-_:".indexOf(c) >= 0;
    }

    public void parseFromReader(Reader reader) throws IOException, XMLParseException {
        this.parseFromReader(reader, 1);
    }

    public void parseFromReader(Reader reader, int n) throws IOException, XMLParseException {
        int n2 = 20480;
        char[] cArray = null;
        int n3 = 0;
        while (reader.ready()) {
            if (cArray == null) {
                cArray = new char[n2];
            } else {
                char[] cArray2 = cArray;
                cArray = new char[cArray.length * 3];
                n2 = cArray2.length * 2;
                System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
            }
            int n4 = reader.read(cArray, n3, n2);
            if (n4 < 0) break;
            n3 += n4;
        }
        this.parseCharArray(cArray, 0, n3, n);
    }

    public void parseString(String string) throws XMLParseException {
        this.parseCharArray(string.toCharArray(), 0, string.length(), 1);
    }

    public int parseString(String string, int n) throws XMLParseException {
        return this.parseCharArray(string.toCharArray(), n, string.length(), 1);
    }

    public int parseString(String string, int n, int n2) throws XMLParseException {
        return this.parseCharArray(string.toCharArray(), n, n2, 1);
    }

    public int parseString(String string, int n, int n2, int n3) throws XMLParseException {
        return this.parseCharArray(string.toCharArray(), n, n2, n3);
    }

    public int parseCharArray(char[] cArray, int n, int n2) throws XMLParseException {
        return this.parseCharArray(cArray, n, n2, 1);
    }

    public int parseCharArray(char[] cArray, int n, int n2, int n3) throws XMLParseException {
        int[] nArray = new int[]{n3};
        return this.parseCharArray(cArray, n, n2, nArray);
    }

    protected int parseCharArray(char[] cArray, int n, int n2, int[] nArray) throws XMLParseException {
        int n3 = n;
        n3 = this.skipWhitespace(cArray, n3, n2, nArray);
        n3 = this.skipPreamble(cArray, n3, n2, nArray);
        n3 = this.scanTagName(cArray, n3, n2, nArray);
        this._lineNr = nArray[0];
        n3 = this.scanAttributes(cArray, n3, n2, nArray);
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int n4 = nArray[0];
        n3 = this.scanContent(cArray, n3, n2, nArray2, nArray3, nArray);
        if (nArray3[0] > 0) {
            this.scanChildren(cArray, nArray2[0], nArray3[0], n4);
            if (this._children.size() > 0) {
                this._contents = null;
            } else {
                this.processContents(cArray, nArray2[0], nArray3[0], n4);
            }
        }
        return n3;
    }

    protected void processContents(char[] cArray, int n, int n2, int n3) throws XMLParseException {
        int[] nArray = new int[]{n3};
        if (!this._skipLeadingWhitespace) {
            String string = new String(cArray, n, n2);
            this._contents = this.decodeString(string, nArray[0]);
            if (this._contents.startsWith("<![CDATA[")) {
                this._contents = this._contents.substring(9, this._contents.length() - 3);
            }
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n4 = n2 + n;
        for (int i = n; i < n4; ++i) {
            char c = cArray[i];
            while (c == '\r' || c == '\n') {
                nArray[0] = nArray[0] + 1;
                stringBuffer.append(c);
                c = cArray[++i];
                if (c != '\n') {
                    stringBuffer.append(c);
                }
                while ((c = cArray[++i]) == ' ' || c == '\t') {
                }
            }
            if (i >= n4) continue;
            stringBuffer.append(c);
        }
        this._contents = this.decodeString(stringBuffer.toString(), nArray[0]);
        if (this._contents.startsWith("<![CDATA[")) {
            this._contents = this._contents.substring(9, this._contents.length() - 3);
        }
    }

    protected int scanAttributes(char[] cArray, int n, int n2, int[] nArray) throws XMLParseException {
        int n3 = n;
        boolean bl = false;
        while (!bl) {
            n3 = this.skipWhitespace(cArray, n3, n2, nArray);
            char c = cArray[n3];
            if (n3 + 1 < n2 && c == '/' && cArray[n3 + 1] == '>' || c == '>') {
                bl = true;
                continue;
            }
            n3 = this.scanOneAttribute(cArray, n3, n2, nArray);
        }
        return n3;
    }

    protected void scanChildren(char[] cArray, int n, int n2, int n3) throws XMLParseException {
        int n4 = n + n2;
        int n5 = n;
        int[] nArray = new int[]{n3};
        if (n2 > 11 && cArray[n5 + 0] == '<' && cArray[n5 + 1] == '!' && cArray[n5 + 2] == '[' && cArray[n5 + 3] == 'C' && cArray[n5 + 4] == 'D' && cArray[n5 + 5] == 'A' && cArray[n5 + 6] == 'T' && cArray[n5 + 7] == 'A' && cArray[n5 + 8] == '[' && cArray[n5 + n2 - 3] == ']' && cArray[n5 + n2 - 2] == ']' && cArray[n5 + n2 - 1] == '>') {
            return;
        }
        while (n5 < n4) {
            try {
                n5 = this.skipWhitespace(cArray, n5, n4, nArray);
            }
            catch (XMLParseException xMLParseException) {
                return;
            }
            if (cArray[n5] != '<') {
                return;
            }
            XMLElement xMLElement = new XMLElement(this._conversionTable, this._skipLeadingWhitespace, false);
            n5 = xMLElement.parseCharArray(cArray, n5, n4, nArray);
            this._children.add(xMLElement);
        }
    }

    protected int scanContent(char[] cArray, int n, int n2, int[] nArray, int[] nArray2, int[] nArray3) throws XMLParseException {
        int n3;
        int n4 = n;
        int n5 = n2;
        char c = cArray[n4];
        if (c == '/') {
            this._empty = true;
            nArray2[0] = 0;
            if (cArray[n4 + 1] == '>') {
                return n4 + 2;
            }
            throw this.expectedInput("'>'", nArray3[0]);
        }
        if (c != '>') {
            throw this.expectedInput("'>'", nArray3[0]);
        }
        if (this._skipLeadingWhitespace) {
            n4 = this.skipWhitespace(cArray, n4 + 1, n5, nArray3);
        }
        nArray[0] = ++n4;
        char[] cArray2 = this._tagName.toCharArray();
        n5 -= cArray2.length + 2;
        int n6 = 0;
        while (n4 < n5 && n6 >= 0) {
            c = cArray[n4];
            if (c == '<') {
                int n7;
                n3 = 1;
                for (n7 = 0; n3 != 0 && n7 < cArray2.length; n3 &= cArray[n4 + (n7 + 1)] == cArray2[n7] ? 1 : 0, ++n7) {
                }
                if (n3 != 0) {
                    n7 = n4 + cArray2.length + 1;
                    c = cArray[n4 = this.skipWhitespace(cArray, n7, n5, nArray3)];
                    if (c != '>' && (n7 == n4 || c == '/')) continue;
                    ++n6;
                    continue;
                }
                if (cArray[n4 + 1] == '/') {
                    n3 = 1;
                    for (n7 = 0; n3 != 0 && n7 < cArray2.length; n3 &= cArray[n4 + (n7 + 2)] == cArray2[n7] ? 1 : 0, ++n7) {
                    }
                    if (n3 != 0) {
                        nArray2[0] = n4 - nArray[0];
                        n4 += cArray2.length + 2;
                        if (cArray[n4 = this.skipWhitespace(cArray, n4, n5, nArray3)] != '>') continue;
                        --n6;
                        ++n4;
                        continue;
                    }
                    ++n4;
                    continue;
                }
            }
            if (c == '\r') {
                nArray3[0] = nArray3[0] + 1;
                if (n4 != n5 && cArray[n4 + 1] == '\n') {
                    ++n4;
                }
            } else if (c == '\n') {
                nArray3[0] = nArray3[0] + 1;
            }
            ++n4;
        }
        if (n6 >= 0) {
            throw this.unexpectedEndOfData(nArray3[0]);
        }
        if (this._skipLeadingWhitespace) {
            n3 = nArray[0] + nArray2[0] - 1;
            while (nArray2[0] >= 0 && cArray[n3] <= ' ') {
                --n3;
                nArray2[0] = nArray2[0] - 1;
            }
        }
        return n4;
    }

    protected String scanIdentifier(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n < n2 && (XMLElement.isIdentifierChar(cArray[n]) || cArray[n] == '/' && cArray[n + 1] != '>')) {
            ++n;
        }
        if (n == n2 || n == n3) {
            return null;
        }
        return new String(cArray, n3, n - n3);
    }

    protected int scanOneAttribute(char[] cArray, int n, int n2, int[] nArray) throws XMLParseException {
        String string;
        int n3 = n;
        String string2 = this.scanIdentifier(cArray, n3, n2);
        if (string2 == null) {
            throw this.syntaxError("an attribute key", nArray[0]);
        }
        n3 = this.skipWhitespace(cArray, n3 + string2.length(), n2, nArray);
        string2 = string2.toLowerCase();
        if (cArray[n3] == '=') {
            string = this.scanString(cArray, n3 = this.skipWhitespace(cArray, n3 + 1, n2, nArray), n2, nArray);
            if (string == null) {
                throw this.syntaxError("an attribute value", nArray[0]);
            }
            if (string.charAt(0) == '\"') {
                string = string.substring(1, string.length() - 1);
                n3 += 2;
            }
        } else {
            string = "";
            if (!string2.equals("disabled") && !string2.equals("checked") && !string2.equals("/") && mRejectBadHTML) {
                throw this.valueMissingForAttribute(string2, nArray[0]);
            }
        }
        if (!string2.equals("/")) {
            this._attributes.put(string2, this.decodeString(string, nArray[0]));
        }
        return n3 + string.length();
    }

    protected String scanString(char[] cArray, int n, int n2, int[] nArray) throws XMLParseException {
        int n3 = n;
        char c = cArray[n3];
        if (c == '\"') {
            int n4 = n3++;
            while (n3 < n2 && cArray[n3] != c) {
                n3 += XMLElement.nextCharCountSkipEOL(cArray, n3, n2, nArray);
            }
            if (n3 == n2) {
                return null;
            }
            return new String(cArray, n4, n3 - n4 + 1);
        }
        return this.scanIdentifier(cArray, n3, n2);
    }

    protected int scanTagName(char[] cArray, int n, int n2, int[] nArray) throws XMLParseException {
        this._tagName = this.scanIdentifier(cArray, n, n2);
        if (this._tagName == null) {
            throw this.syntaxError("a tag name", nArray[0]);
        }
        return n + this._tagName.length();
    }

    protected int skipBogusTag(char[] cArray, int n, int n2, int[] nArray) {
        int n3 = n;
        if (cArray[n3 + 1] == '-' && cArray[n3 + 2] == '-') {
            while (n3 < n2 && (cArray[n3] != '-' || cArray[n3 + 1] != '-' || cArray[n3 + 2] != '>')) {
                n3 += XMLElement.nextCharCountSkipEOL(cArray, n3, n2, nArray);
            }
            if (n3 == n2) {
                throw this.unexpectedEndOfData(nArray[0]);
            }
            return n3 + 3;
        }
        int n4 = 1;
        block7: while (n3 < n2) {
            char c = cArray[n3++];
            switch (c) {
                case '\r': {
                    if (n3 < n2 && cArray[n3] == '\n') {
                        ++n3;
                    }
                    nArray[0] = nArray[0] + 1;
                    continue block7;
                }
                case '\n': {
                    nArray[0] = nArray[0] + 1;
                    continue block7;
                }
                case '<': {
                    ++n4;
                    continue block7;
                }
                case '>': {
                    if (--n4 != 0) continue block7;
                    return n3;
                }
            }
        }
        throw this.unexpectedEndOfData(nArray[0]);
    }

    protected int skipPreamble(char[] cArray, int n, int n2, int[] nArray) throws XMLParseException {
        char c;
        int n3 = n;
        do {
            if (cArray[n3 = this.skipWhitespace(cArray, n3, n2, nArray)] != '<') {
                this.expectedInput("'<'", nArray[0]);
            }
            if (++n3 >= n2) {
                throw this.unexpectedEndOfData(nArray[0]);
            }
            c = cArray[n3];
            if (c != '!' && c != '?') continue;
            n3 = this.skipBogusTag(cArray, n3, n2, nArray);
        } while (!XMLElement.isIdentifierChar(c));
        return n3;
    }

    protected static int nextCharCountSkipEOL(char[] cArray, int n, int n2, int[] nArray) {
        int n3 = n;
        if (cArray[n] == '\r') {
            nArray[0] = nArray[0] + 1;
            if (n != n2 && cArray[n + 1] == '\n') {
                ++n;
            }
        } else if (cArray[n] == '\n') {
            nArray[0] = nArray[0] + 1;
        }
        if (n == n3) {
            return 1;
        }
        return n - n3;
    }

    protected int skipWhitespace(char[] cArray, int n, int n2, int[] nArray) {
        int n3;
        for (n3 = n; n3 < n2 && cArray[n3] <= ' '; n3 += XMLElement.nextCharCountSkipEOL(cArray, n3, n2, nArray)) {
        }
        if (n3 == n2) {
            throw this.unexpectedEndOfData(nArray[0]);
        }
        return n3;
    }

    public static String encodeString(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n = 0;
        String string2 = null;
        StringBuffer stringBuffer = null;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            switch (c) {
                case '<': {
                    string2 = "&lt;";
                    break;
                }
                case '>': {
                    string2 = "&gt;";
                    break;
                }
                case '\"': {
                    string2 = "&quot;";
                    break;
                }
                case '\'': {
                    string2 = "&apos;";
                    break;
                }
                case '&': {
                    string2 = "&amp;";
                    break;
                }
                case '#': {
                    if (i != 0 && (i <= 0 || cArray[i - 1] == '&')) break;
                    string2 = "&pound;";
                    break;
                }
                default: {
                    string2 = null;
                }
            }
            if (c > '\u0080') {
                string2 = "&#" + c + ";";
            }
            if (string2 == null) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            }
            stringBuffer.append(string.substring(n, i));
            n = i + 1;
            stringBuffer.append(string2);
        }
        if (string2 == null && n != 0) {
            stringBuffer.append(string.substring(n));
        }
        if (n == 0) {
            return string;
        }
        if (stringBuffer == null) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String decodeString(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n2 = 0;
        while (true) {
            int n3 = (string + '&').indexOf(38, n2);
            stringBuffer.append(string.substring(n2, n3));
            if (n3 == string.length()) break;
            n2 = string.indexOf(59, n3);
            if (n2 < 0) {
                stringBuffer.append(string.substring(n3));
                break;
            }
            String string2 = string.substring(n3 + 1, n2);
            if (string2.charAt(0) == '#') {
                if (string2.charAt(1) == 'x') {
                    stringBuffer.append((char)Integer.parseInt(string2.substring(2), 16));
                } else {
                    stringBuffer.append((char)Integer.parseInt(string2.substring(1), 10));
                }
            } else {
                String string3 = (String)this._conversionTable.get(string2);
                if (string3 == null) {
                    stringBuffer.append('&').append(string2).append(';');
                } else {
                    stringBuffer.append(string3);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected XMLParseException invalidValueSet(String string) {
        String string2 = "Invalid value set (key = \"" + string + "\")";
        return new XMLParseException(this.getTagName(), string2);
    }

    protected XMLParseException invalidValue(String string, String string2, int n) {
        String string3 = "Attribute \"" + string + "\" does not contain a valid " + "value (\"" + string2 + "\")";
        return new XMLParseException(this.getTagName(), n, string3);
    }

    protected XMLParseException unexpectedEndOfData(int n) {
        String string = "Unexpected end of data reached";
        return new XMLParseException(this.getTagName(), n, string);
    }

    protected XMLParseException syntaxError(String string, int n) {
        String string2 = "Syntax error while parsing " + string;
        return new XMLParseException(this.getTagName(), n, string2);
    }

    protected XMLParseException expectedInput(String string, int n) {
        String string2 = "Expected: " + string;
        return new XMLParseException(this.getTagName(), n, string2);
    }

    protected XMLParseException valueMissingForAttribute(String string, int n) {
        String string2 = "Value missing for attribute with key \"" + string + '\"';
        return new XMLParseException(this.getTagName(), n, string2);
    }
}

