/*
 * Decompiled with CFR 0.152.
 */
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import javax.swing.ImageIcon;

public class auctionTableModel
extends BaseTransformation {
    private static final String neverBid = "--";
    private List dispList;
    private Date futureForever = new Date(Long.MAX_VALUE);
    private XMLElement cvt = new XMLElement();
    private static final ImageIcon dummyIcon = new ImageIcon((class$auctionTableModel == null ? (class$auctionTableModel = auctionTableModel.class$("auctionTableModel")) : class$auctionTableModel).getResource("icons/white_ball.gif"));
    private static final ImageIcon greenIcon = new ImageIcon((class$auctionTableModel == null ? (class$auctionTableModel = auctionTableModel.class$("auctionTableModel")) : class$auctionTableModel).getResource("icons/green_ball.gif"));
    private static final ImageIcon binIcon = new ImageIcon((class$auctionTableModel == null ? (class$auctionTableModel = auctionTableModel.class$("auctionTableModel")) : class$auctionTableModel).getResource("icons/bin_item.gif"));
    private static final ImageIcon resIcon = new ImageIcon((class$auctionTableModel == null ? (class$auctionTableModel = auctionTableModel.class$("auctionTableModel")) : class$auctionTableModel).getResource("icons/unmet_reserve.gif"));
    private static final ImageIcon resMetIcon = new ImageIcon((class$auctionTableModel == null ? (class$auctionTableModel = auctionTableModel.class$("auctionTableModel")) : class$auctionTableModel).getResource("icons/met_reserve.gif"));
    private static final ImageIcon imageIcon = new ImageIcon((class$auctionTableModel == null ? (class$auctionTableModel = auctionTableModel.class$("auctionTableModel")) : class$auctionTableModel).getResource("icons/camera.gif"));
    private static final ImageIcon commentIcon = new ImageIcon((class$auctionTableModel == null ? (class$auctionTableModel = auctionTableModel.class$("auctionTableModel")) : class$auctionTableModel).getResource("icons/note3.gif"));
    private static final ImageIcon winningIcon = new ImageIcon((class$auctionTableModel == null ? (class$auctionTableModel = auctionTableModel.class$("auctionTableModel")) : class$auctionTableModel).getResource("icons/winning.gif"));
    private static final ImageIcon invalidIcon = new ImageIcon((class$auctionTableModel == null ? (class$auctionTableModel = auctionTableModel.class$("auctionTableModel")) : class$auctionTableModel).getResource("icons/invalid.gif"));
    private static final ImageIcon paypalIcon = new ImageIcon((class$auctionTableModel == null ? (class$auctionTableModel = auctionTableModel.class$("auctionTableModel")) : class$auctionTableModel).getResource("icons/paypal16x16.gif"));
    Integer Zero = new Integer(0);
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$Icon;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$auctionTableModel;

    public int getRowCount() {
        return this.dispList.size();
    }

    public int getColumnCount() {
        return 21;
    }

    public String getColumnName(int n) {
        return TableColumnController.getInstance().getColumnName(n);
    }

    public void delete(int n) {
        this.dispList.remove(n);
    }

    public int insert(Object object) {
        this.dispList.add(object);
        return this.dispList.size() - 1;
    }

    public Object find(Comparison comparison) {
        for (int i = 0; i < this.dispList.size(); ++i) {
            if (!comparison.match(this.dispList.get(i))) continue;
            return this.dispList.get(i);
        }
        return null;
    }

    public int getColumnNumber(String string) {
        return TableColumnController.getInstance().getColumnNumber(string);
    }

    public Class getColumnClass(int n) {
        if (n != 5) {
            return class$java$lang$String == null ? (class$java$lang$String = auctionTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        return class$javax$swing$Icon == null ? (class$javax$swing$Icon = auctionTableModel.class$("javax.swing.Icon")) : class$javax$swing$Icon;
    }

    public Class getSortByColumnClass(int n) {
        if (n == 5 || n == 14 || n == 17 || n == 15) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = auctionTableModel.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (n == -1) {
            return class$java$lang$String == null ? (class$java$lang$String = auctionTableModel.class$("java.lang.String")) : class$java$lang$String;
        }
        Object object = this.getDummyValueAtColumn(n);
        return object.getClass();
    }

    private Object getDummyValueAtColumn(int n) {
        switch (n) {
            case -1: {
                return null;
            }
            case 1: 
            case 2: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 18: 
            case 19: {
                return Currency.NoValue();
            }
            case 3: 
            case 12: {
                return this.futureForever;
            }
            case 5: {
                return dummyIcon;
            }
        }
        return "";
    }

    private int buildEntryFlags(AuctionEntry auctionEntry) {
        if (auctionEntry == null) {
            return 1;
        }
        return auctionEntry.getFlags();
    }

    private ImageIcon getEntryIcon(AuctionEntry auctionEntry) {
        ImageIcon imageIcon = null;
        if (auctionEntry.isFixed()) {
            imageIcon = null;
        }
        if (auctionEntry.getHighBidder() != null) {
            if (auctionEntry.isHighBidder()) {
                imageIcon = winningIcon;
            } else if (auctionEntry.isSeller() && auctionEntry.getNumBidders() > 0 && (!auctionEntry.isReserve() || auctionEntry.isReserveMet())) {
                imageIcon = greenIcon;
            }
        }
        if (!auctionEntry.getBuyNow().isNull()) {
            imageIcon = IconFactory.getCombination(imageIcon, binIcon);
        }
        if (auctionEntry.isReserve()) {
            imageIcon = auctionEntry.isReserveMet() ? IconFactory.getCombination(imageIcon, resMetIcon) : IconFactory.getCombination(imageIcon, resIcon);
        }
        if (auctionEntry.getThumbnail() != null) {
            imageIcon = IconFactory.getCombination(imageIcon, auctionTableModel.imageIcon);
        }
        if (auctionEntry.getComment() != null) {
            imageIcon = IconFactory.getCombination(imageIcon, commentIcon);
        }
        if (auctionEntry.isInvalid()) {
            imageIcon = IconFactory.getCombination(imageIcon, invalidIcon);
        }
        if (auctionEntry.hasPaypal()) {
            imageIcon = IconFactory.getCombination(imageIcon, paypalIcon);
        }
        return imageIcon;
    }

    public Object getSortByValueAt(int n, int n2) {
        try {
            AuctionEntry auctionEntry = (AuctionEntry)this.dispList.get(n);
            switch (n2) {
                case -1: {
                    return auctionEntry;
                }
                case 0: {
                    return auctionEntry.getIdentifier();
                }
                case 1: {
                    return auctionEntry.getUSCurBid();
                }
                case 2: {
                    return Currency.convertToUSD(auctionEntry.getUSCurBid(), auctionEntry.getCurBid(), this.getMaxOrSnipe(auctionEntry));
                }
                case 3: {
                    return auctionEntry.getEndDate();
                }
                case 4: {
                    return auctionEntry.getTitle();
                }
                case 5: {
                    return new Integer(this.buildEntryFlags(auctionEntry));
                }
                case 6: {
                    return auctionEntry.getSeller();
                }
                case 13: {
                    return Currency.convertToUSD(auctionEntry.getUSCurBid(), auctionEntry.getCurBid(), auctionEntry.getBuyNow());
                }
                case 7: {
                    Currency currency = !auctionEntry.getShipping().isNull() ? auctionEntry.getShippingWithInsurance() : Currency.NoValue();
                    return Currency.convertToUSD(auctionEntry.getUSCurBid(), auctionEntry.getCurBid(), currency);
                }
                case 8: {
                    return auctionEntry.getHighBidder();
                }
                case 9: {
                    Currency currency = auctionEntry.isBidOn() ? auctionEntry.getBid() : Currency.NoValue();
                    return Currency.convertToUSD(auctionEntry.getUSCurBid(), auctionEntry.getCurBid(), currency);
                }
                case 10: {
                    Currency currency = auctionEntry.isSniped() ? auctionEntry.getSnipeBid() : Currency.NoValue();
                    return Currency.convertToUSD(auctionEntry.getUSCurBid(), auctionEntry.getCurBid(), currency);
                }
                case 11: {
                    String string = auctionEntry.getComment();
                    return string == null ? "" : string;
                }
                case 12: {
                    return auctionEntry.getEndDate();
                }
                case 14: {
                    if (auctionEntry.getFeedbackScore() == 0) {
                        return this.Zero;
                    }
                    return new Integer(auctionEntry.getFeedbackScore());
                }
                case 16: {
                    return auctionEntry.getItemLocation();
                }
                case 17: {
                    return new Integer(auctionEntry.getNumBidders());
                }
                case 18: {
                    return auctionEntry.getUSCurBid();
                }
                case 15: {
                    try {
                        int n3 = (int)(Double.parseDouble(auctionEntry.getPostiveFeedbackPercentage()) * 10.0);
                        return new Integer(n3);
                    }
                    catch (Exception exception) {
                        return this.Zero;
                    }
                }
                case 19: {
                    Currency currency = auctionEntry.getShippingWithInsurance();
                    if (currency.getCurrencyType() == 0) {
                        return currency;
                    }
                    Currency currency2 = Currency.convertToUSD(auctionEntry.getUSCurBid(), auctionEntry.getCurBid(), auctionEntry.getShippingWithInsurance());
                    try {
                        return auctionEntry.getUSCurBid().add(currency2);
                    }
                    catch (Currency.CurrencyTypeException currencyTypeException) {
                        ErrorManagement.handleException("Threw a bad currency exception, which should be unlikely.", currencyTypeException);
                        return Currency.NoValue();
                    }
                }
                case 20: {
                    Currency currency = auctionEntry.getShippingWithInsurance();
                    if (currency.getCurrencyType() == 0) {
                        return currency;
                    }
                    Currency currency3 = Currency.convertToUSD(auctionEntry.getUSCurBid(), auctionEntry.getCurBid(), auctionEntry.getShippingWithInsurance());
                    try {
                        return Currency.convertToUSD(auctionEntry.getUSCurBid(), auctionEntry.getCurBid(), auctionEntry.getSnipeBid()).add(currency3);
                    }
                    catch (Currency.CurrencyTypeException currencyTypeException) {
                        ErrorManagement.handleException("Currency addition or conversion threw a bad currency exception, which should be unlikely.", currencyTypeException);
                        return Currency.NoValue();
                    }
                }
            }
            return "";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.getDummyValueAtColumn(n2);
        }
    }

    private Currency getMaxOrSnipe(AuctionEntry auctionEntry) {
        if (auctionEntry.isSniped()) {
            return auctionEntry.getSnipeBid();
        }
        if (auctionEntry.isBidOn()) {
            return auctionEntry.getBid();
        }
        if (auctionEntry.snipeCancelled() && auctionEntry.isEnded()) {
            return auctionEntry.getCancelledSnipe();
        }
        return Currency.NoValue();
    }

    private String formatSnipeAndBid(AuctionEntry auctionEntry) {
        String string = "";
        if (auctionEntry.getErrorPage() != null) {
            string = "*";
        }
        if (auctionEntry.isSniped()) {
            return this.formatSnipe(auctionEntry, string);
        }
        if (auctionEntry.isBidOn()) {
            return this.formatBid(auctionEntry, string);
        }
        if (auctionEntry.snipeCancelled() && auctionEntry.isEnded()) {
            return string + '(' + auctionEntry.getCancelledSnipe() + ')';
        }
        return neverBid;
    }

    private String formatBid(AuctionEntry auctionEntry, String string) {
        String string2 = "";
        if (auctionEntry.getBidQuantity() != 1) {
            string2 = " x " + auctionEntry.getBidQuantity();
        }
        return string + auctionEntry.getBid().toString() + string2;
    }

    private String formatSnipe(AuctionEntry auctionEntry, String string) {
        String string2 = "";
        if (auctionEntry.getSnipeQuantity() != 1) {
            string2 = " x " + auctionEntry.getSnipeQuantity();
        }
        if (auctionEntry.isMultiSniped()) {
            if (auctionEntry.isSnipeValid() || auctionEntry.isDutch()) {
                return string + "Multi: " + auctionEntry.getSnipeBid() + string2;
            }
            return string + "Multi: (" + auctionEntry.getSnipeBid() + string2 + ')';
        }
        if (auctionEntry.isSnipeValid() || auctionEntry.isDutch()) {
            return string + auctionEntry.getSnipeBid().toString() + string2;
        }
        return string + '(' + auctionEntry.getSnipeBid() + string2 + ')';
    }

    private String formatTotalSnipe(AuctionEntry auctionEntry, String string) {
        Currency currency;
        if (!auctionEntry.isSniped()) {
            return neverBid;
        }
        Currency currency2 = auctionEntry.getShippingWithInsurance();
        if (currency2.getCurrencyType() == 0 || auctionEntry.getSnipeBid().getCurrencyType() == 0) {
            return neverBid;
        }
        try {
            currency = auctionEntry.getSnipeBid().add(currency2);
        }
        catch (Currency.CurrencyTypeException currencyTypeException) {
            ErrorManagement.handleException("Currency addition threw a bad currency exception, which should be very difficult to cause to happen.", currencyTypeException);
            return neverBid;
        }
        String string2 = "";
        if (auctionEntry.getSnipeQuantity() != 1) {
            string2 = " x " + auctionEntry.getSnipeQuantity();
        }
        if (auctionEntry.isMultiSniped()) {
            if (auctionEntry.isSnipeValid() || auctionEntry.isDutch()) {
                return string + "Multi: " + currency + string2;
            }
            return string + "Multi: (" + currency + string2 + ')';
        }
        if (auctionEntry.isSnipeValid() || auctionEntry.isDutch()) {
            return string + currency.toString() + string2;
        }
        return string + '(' + currency + string2 + ')';
    }

    public Object getValueAt(int n, int n2) {
        try {
            AuctionEntry auctionEntry = (AuctionEntry)this.dispList.get(n);
            String string = auctionEntry.getErrorPage() == null ? "" : "*";
            switch (n2) {
                case -1: {
                    return auctionEntry;
                }
                case 0: {
                    return auctionEntry.getIdentifier();
                }
                case 1: {
                    if (auctionEntry.isFixed()) {
                        return auctionEntry.getCurBid() + " (FP)";
                    }
                    if (auctionEntry.isDutch()) {
                        return auctionEntry.getCurBid() + " x " + Integer.toString(auctionEntry.getQuantity());
                    }
                    return auctionEntry.getCurBid() + " (" + Integer.toString(auctionEntry.getNumBidders()) + ')';
                }
                case 2: {
                    return this.formatSnipeAndBid(auctionEntry);
                }
                case 9: {
                    return auctionEntry.isBidOn() ? this.formatBid(auctionEntry, string) : neverBid;
                }
                case 10: {
                    if (auctionEntry.isSniped()) {
                        return this.formatSnipe(auctionEntry, string);
                    }
                    if (auctionEntry.snipeCancelled() && auctionEntry.isEnded()) {
                        return string + '(' + auctionEntry.getCancelledSnipe() + ')';
                    }
                    return neverBid;
                }
                case 3: {
                    if (auctionEntry.getEndDate() == null || auctionEntry.getEndDate().equals(Constants.FAR_FUTURE)) {
                        return "N/A";
                    }
                    String string2 = auctionEntry.getTimeLeft();
                    if (string2.equals("Auction ended.")) {
                        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy HH:mm:ss zzz");
                        string2 = simpleDateFormat.format(auctionEntry.getEndDate());
                        if (!auctionEntry.isEnded()) {
                            string2 = "<html><body color=\"red\">" + string2 + "</body></html>";
                        }
                    }
                    return string2;
                }
                case 12: {
                    if (auctionEntry.getEndDate() == null || auctionEntry.getEndDate().equals(Constants.FAR_FUTURE)) {
                        return "N/A";
                    }
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yy HH:mm:ss zzz");
                    String string3 = simpleDateFormat.format(auctionEntry.getEndDate());
                    return string3;
                }
                case 4: {
                    return this.cvt.decodeString(auctionEntry.getTitle(), 0);
                }
                case 5: {
                    return this.getEntryIcon(auctionEntry);
                }
                case 6: {
                    return auctionEntry.getSeller();
                }
                case 11: {
                    String string4 = auctionEntry.getComment();
                    return string4 == null ? "" : string4;
                }
                case 8: {
                    if (auctionEntry.getHighBidder() != null) {
                        return auctionEntry.getHighBidder();
                    }
                    return neverBid;
                }
                case 13: {
                    Currency currency = auctionEntry.getBuyNow();
                    if (currency.isNull()) {
                        return neverBid;
                    }
                    return currency;
                }
                case 7: {
                    Currency currency = auctionEntry.getShippingWithInsurance();
                    if (currency.isNull()) {
                        return neverBid;
                    }
                    return currency;
                }
                case 16: {
                    return auctionEntry.getItemLocation();
                }
                case 17: {
                    if (auctionEntry.getNumBidders() < 0) {
                        return "(FP)";
                    }
                    return Integer.toString(auctionEntry.getNumBidders());
                }
                case 18: {
                    return auctionEntry.getCurBid();
                }
                case 14: {
                    return new Integer(auctionEntry.getFeedbackScore());
                }
                case 15: {
                    String string5 = auctionEntry.getPostiveFeedbackPercentage();
                    return string5 == null || string5.length() == 0 ? neverBid : string5 + '%';
                }
                case 19: {
                    Currency currency = auctionEntry.getShippingWithInsurance();
                    if (currency.getCurrencyType() == 0) {
                        return neverBid;
                    }
                    try {
                        return auctionEntry.getCurBid().add(currency);
                    }
                    catch (Currency.CurrencyTypeException currencyTypeException) {
                        ErrorManagement.handleException("Currency addition threw a bad currency exception, which is odd...", currencyTypeException);
                        return neverBid;
                    }
                }
                case 20: {
                    return this.formatTotalSnipe(auctionEntry, string);
                }
            }
            return "";
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return this.getDummyValueAtColumn(n2);
        }
    }

    public auctionTableModel() {
        this.dispList = new Vector();
    }

    public int compare(int n, int n2, ColumnStateList columnStateList) {
        int n3 = 0;
        ListIterator listIterator = columnStateList.listIterator();
        while (listIterator.hasNext()) {
            Object object;
            ColumnState columnState = (ColumnState)listIterator.next();
            Class clazz = this.getSortByColumnClass(columnState.getColumn());
            Object object2 = this.getSortByValueAt(n, columnState.getColumn());
            n3 = auctionTableModel.compareByClass(object2, object = this.getSortByValueAt(n2, columnState.getColumn()), clazz) * columnState.getSort();
            if (n3 == 0) continue;
            break;
        }
        return n3;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

