/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat;

import com.stevesoft.pat.AmpersandRule;
import com.stevesoft.pat.BackRefRule;
import com.stevesoft.pat.ChangeRule;
import com.stevesoft.pat.CodeRule;
import com.stevesoft.pat.Ctrl;
import com.stevesoft.pat.LeftRule;
import com.stevesoft.pat.PopRule;
import com.stevesoft.pat.PushRule;
import com.stevesoft.pat.RegRes;
import com.stevesoft.pat.Regex;
import com.stevesoft.pat.RightRule;
import com.stevesoft.pat.RuleHolder;
import com.stevesoft.pat.StringBufferLike;
import com.stevesoft.pat.StringRule;
import com.stevesoft.pat.Transformer;
import com.stevesoft.pat.WantMoreTextReplaceRule;
import java.util.Hashtable;

public abstract class ReplaceRule {
    protected ReplaceRule next;
    static Regex getvar = null;
    static Hashtable defs = new Hashtable();
    String name = this.getClass().getName();

    public abstract void apply(StringBufferLike var1, RegRes var2);

    public Object clone1() {
        return new RuleHolder(this);
    }

    public final Object clone() {
        ReplaceRule replaceRule;
        ReplaceRule replaceRule2 = replaceRule = (ReplaceRule)this.clone1();
        ReplaceRule replaceRule3 = this;
        while (replaceRule3.next != null) {
            replaceRule.next = (ReplaceRule)replaceRule3.next.clone1();
            replaceRule.name = replaceRule3.name;
            replaceRule = replaceRule.next;
            replaceRule3 = replaceRule3.next;
        }
        return replaceRule2;
    }

    static ReplaceRule add(ReplaceRule replaceRule, ReplaceRule replaceRule2) {
        if (replaceRule == null) {
            return replaceRule2;
        }
        replaceRule.addRule(replaceRule2);
        return replaceRule;
    }

    public ReplaceRule add(ReplaceRule replaceRule) {
        return ReplaceRule.add(this, replaceRule);
    }

    public void addRule(ReplaceRule replaceRule) {
        if (this.next == null) {
            this.next = replaceRule;
            return;
        }
        this.next.addRule(replaceRule);
    }

    static final Regex getv() {
        if (getvar != null) {
            return (Regex)getvar.clone();
        }
        getvar = new Regex("(?:\\\\(\\d+)|\\$(?:(\\d+)|(\\w+)|([&'`])|\\{(?:(\\d+)|([^\n}\\\\]+))})|\\\\([nrbtaef])|\\\\c([\u0000-\uffff])|\\\\x([A-Fa-f0-9]{2})|\\\\([\u0000-\uffff]))");
        getvar.optimize();
        return getvar;
    }

    public static ReplaceRule perlCode(String string) {
        int n = 0;
        Regex regex = ReplaceRule.getv();
        ReplaceRule replaceRule = null;
        while (regex.searchFrom(string, n)) {
            int n2;
            String string2;
            int n3 = Regex.BackRefOffset - 1;
            int n4 = regex.matchedFrom();
            if (n4 > n) {
                replaceRule = ReplaceRule.add(replaceRule, new StringRule(string.substring(n, n4)));
            }
            if ((string2 = regex.stringMatched(1 + n3)) != null || (string2 = regex.stringMatched(2 + n3)) != null || (string2 = regex.stringMatched(5 + n3)) != null) {
                int n5 = 0;
                n2 = 0;
                while (n2 < string2.length()) {
                    n5 = 8 * n5 + (string2.charAt(n2) - 48);
                    ++n2;
                }
                replaceRule = string2.length() == 1 ? ReplaceRule.add(replaceRule, new BackRefRule(n5)) : new StringRule(String.valueOf((char)n5));
            } else {
                string2 = regex.stringMatched(10 + n3);
                if (string2 != null) {
                    replaceRule = "QELlUu".indexOf(string2) >= 0 ? ReplaceRule.add(replaceRule, new CodeRule(string2.charAt(0))) : ReplaceRule.add(replaceRule, new StringRule(string2));
                } else {
                    string2 = regex.stringMatched(3 + n3);
                    if (string2 != null || (string2 = regex.stringMatched(4 + n3)) != null || (string2 = regex.stringMatched(6 + n3)) != null) {
                        Object v;
                        String string3 = "";
                        n2 = string2.indexOf(58);
                        if (n2 > 0) {
                            string3 = string2.substring(n2 + 1);
                            string2 = string2.substring(0, n2);
                        }
                        if (string2.equals("&") || string2.equals("MATCH")) {
                            replaceRule = ReplaceRule.add(replaceRule, new AmpersandRule());
                        } else if (string2.equals("`") || string2.equals("PREMATCH")) {
                            replaceRule = ReplaceRule.add(replaceRule, new LeftRule());
                        } else if (string2.equals("'") || string2.equals("POSTMATCH")) {
                            replaceRule = ReplaceRule.add(replaceRule, new RightRule());
                        } else if (string2.equals("WANT_MORE_TEXT")) {
                            replaceRule = ReplaceRule.add(replaceRule, new WantMoreTextReplaceRule());
                        } else if (string2.equals("POP")) {
                            replaceRule = ReplaceRule.add(replaceRule, new PopRule());
                        } else if (string2.startsWith("+") && (v = defs.get(string2.substring(1))) != null) {
                            replaceRule = v instanceof Regex ? ReplaceRule.add(replaceRule, new PushRule(string2.substring(1), (Regex)v)) : (v instanceof Transformer ? ReplaceRule.add(replaceRule, new PushRule(string2.substring(1), (Transformer)v)) : ReplaceRule.add(replaceRule, new StringRule("${" + string2 + "}")));
                        } else if (string2.startsWith("=") && (v = defs.get(string2.substring(1))) != null) {
                            replaceRule = v instanceof Regex ? ReplaceRule.add(replaceRule, new ChangeRule(string2.substring(1), (Regex)v)) : (v instanceof Transformer ? ReplaceRule.add(replaceRule, new ChangeRule(string2.substring(1), (Transformer)v)) : ReplaceRule.add(replaceRule, new StringRule("${" + string2 + "}")));
                        } else {
                            v = defs.get(string2);
                            if (v != null) {
                                if (v instanceof ReplaceRule) {
                                    ReplaceRule replaceRule2 = ((ReplaceRule)v).arg(string3);
                                    if (replaceRule2 == null) {
                                        replaceRule2 = (ReplaceRule)v;
                                    }
                                    replaceRule = ReplaceRule.add(replaceRule, (ReplaceRule)replaceRule2.clone());
                                }
                            } else {
                                replaceRule = ReplaceRule.add(replaceRule, new StringRule("${" + string2 + "}"));
                            }
                        }
                    } else {
                        string2 = regex.stringMatched(7 + n3);
                        if (string2 != null) {
                            char c = string2.charAt(0);
                            if (c == 'n') {
                                replaceRule = ReplaceRule.add(replaceRule, new StringRule("\n"));
                            } else if (c == 't') {
                                replaceRule = ReplaceRule.add(replaceRule, new StringRule("\t"));
                            } else if (c == 'r') {
                                replaceRule = ReplaceRule.add(replaceRule, new StringRule("\r"));
                            } else if (c == 'b') {
                                replaceRule = ReplaceRule.add(replaceRule, new StringRule("\r"));
                            } else if (c == 'a') {
                                replaceRule = ReplaceRule.add(replaceRule, new StringRule(String.valueOf('\u0007')));
                            } else if (c == 'e') {
                                replaceRule = ReplaceRule.add(replaceRule, new StringRule(String.valueOf('\u001b')));
                            } else if (c == 'f') {
                                replaceRule = ReplaceRule.add(replaceRule, new StringRule(String.valueOf('\f')));
                            }
                        } else {
                            string2 = regex.stringMatched(8 + n3);
                            if (string2 != null) {
                                char c = string2.charAt(0);
                                if (c < Ctrl.cmap.length) {
                                    c = Ctrl.cmap[c];
                                }
                                replaceRule = ReplaceRule.add(replaceRule, new StringRule(String.valueOf(c)));
                            } else {
                                string2 = regex.stringMatched(9 + n3);
                                if (string2 != null) {
                                    int n6 = 16 * ReplaceRule.getHexDigit(string2.charAt(0)) + ReplaceRule.getHexDigit(string2.charAt(1));
                                    replaceRule = ReplaceRule.add(replaceRule, new StringRule(String.valueOf((char)n6)));
                                }
                            }
                        }
                    }
                }
            }
            n = regex.matchedTo();
        }
        if (n <= string.length()) {
            replaceRule = ReplaceRule.add(replaceRule, new StringRule(string.substring(n)));
        }
        return replaceRule;
    }

    public static boolean isDefined(String string) {
        return defs.get(string) != null;
    }

    public static void define(String string, Regex regex) {
        defs.put(string, regex);
    }

    public static void define(String string, ReplaceRule replaceRule) {
        defs.put(string, replaceRule);
        replaceRule.name = string;
    }

    public static void define(String string, Transformer transformer) {
        defs.put(string, transformer);
    }

    public static void undefine(String string) {
        defs.remove(string);
    }

    public String toString1() {
        return "${" + this.name + "}";
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString1());
        ReplaceRule replaceRule = this.next;
        while (replaceRule != null) {
            stringBuffer.append(replaceRule.toString1());
            replaceRule = replaceRule.next;
        }
        return stringBuffer.toString();
    }

    public ReplaceRule arg(String string) {
        return null;
    }

    static int getHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        return c - 65 + 10;
    }
}

