/*
 * Decompiled with CFR 0.152.
 */
import com.stevesoft.pat.Regex;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public final class ebayServer
extends AuctionServer
implements MessageQueue.Listener,
CleanupHandler,
JConfig.ConfigListener {
    protected static final int THIRTY_MINUTES = 1800000;
    private HashMap _resultHash = null;
    private Regex _bidResultRegex = null;
    private volatile CookieJar _signinCookie = null;
    private eBayTimeQueueManager _etqm;
    private Searcher _my_ebay = null;
    private Searcher sellerSearch = null;
    private static final String eBayDisplayName = "eBay";
    private static final String eBayServerName = "ebay";
    private String eBayHost;
    private String eBayViewHost;
    private String eBayBrowseHost;
    private String eBayDetectionHost;
    private String eBayTWDetectionHost;
    private String eBayESDetectionHost;
    private String eBayBidHost;
    private String eBayDutchRequest;
    private String eBayProtocol;
    private String eBayFile;
    private String eBayV3File;
    private String eBayWS3File;
    private String eBayViewItemCmd;
    private String eBayParseItemURL;
    private String eBayViewItemCGI;
    private String eBayViewDutchWinners;
    private String eBaySearchURL1;
    private String eBaySearchURL2;
    private String eBaySearchURLNoDesc;
    private String eBayBidItem;
    private String eBayItemCGI;
    private String eBayItemNumber;
    private String eBayPrequelTimeString;
    private String eBayPrequelTimeString2;
    private String eBayDateFormat;
    private String eBayOfficialTimeFormat;
    private String eBayAdultLoginPageTitle;
    private String[] eBayTitles;
    private String eBayCurrentBid;
    private String eBayLowestBid;
    private String eBayFirstBid;
    private String eBayQuantity;
    private String eBayBidCount;
    private String eBayStartTime;
    private String eBaySeller;
    private String eBayHighBidder;
    private String eBayBuyer;
    private String eBayShippingRegex;
    private String eBayInsurance;
    private String eBayItemEnded;
    private String eBayTemporarilyUnavailable;
    private String eBayPrice;
    private String eBayDescStart;
    private String eBayMotorsDescStart;
    private String eBayDescEnd;
    private String eBayPayInstructions;
    private String eBayClosedDescEnd;
    private static final int ITEMS_PER_PAGE = 100;
    private TimerHandler eQueue;
    private Map snipeMap = new HashMap();
    private String mBadPassword = null;
    private String mBadUsername = null;
    private String[] site_choices;
    private static Currency[][] incrementTable = new Currency[][]{{new Currency("$0.99"), new Currency("$0.05")}, {new Currency("$4.99"), new Currency("$0.25")}, {new Currency("$24.99"), new Currency("$0.50")}, {new Currency("$99.99"), new Currency("$1.00")}, {new Currency("$249.99"), new Currency("$2.50")}, {new Currency("$499.99"), new Currency("$5.00")}, {new Currency("$999.99"), new Currency("$10.00")}, {new Currency("$2499.99"), new Currency("$25.00")}, {new Currency("$4999.99"), new Currency("$50.00")}, {Currency.NoValue(), new Currency("$100.00")}};
    private static Currency[][] au_incrementTable = new Currency[][]{{new Currency("AUD0.99"), new Currency("AUD0.05")}, {new Currency("AUD4.99"), new Currency("AUD0.25")}, {new Currency("AUD24.99"), new Currency("AUD0.50")}, {new Currency("AUD99.99"), new Currency("AUD1.00")}, {new Currency("AUD249.99"), new Currency("AUD2.50")}, {new Currency("AUD499.99"), new Currency("AUD5.00")}, {new Currency("AUD999.99"), new Currency("AUD10.00")}, {new Currency("AUD2499.99"), new Currency("AUD25.00")}, {new Currency("AUD4999.99"), new Currency("AUD50.00")}, {Currency.NoValue(), new Currency("AUD100.00")}};
    private static Currency[][] ca_incrementTable = new Currency[][]{{new Currency("CAD0.99"), new Currency("CAD0.05")}, {new Currency("CAD4.99"), new Currency("CAD0.25")}, {new Currency("CAD24.99"), new Currency("CAD0.50")}, {new Currency("CAD99.99"), new Currency("CAD1.00")}, {Currency.NoValue(), new Currency("CAD2.50")}};
    private static Currency[][] uk_incrementTable = new Currency[][]{{new Currency("GBP0.99"), new Currency("GBP0.05")}, {new Currency("GBP4.99"), new Currency("GBP0.20")}, {new Currency("GBP14.99"), new Currency("GBP0.50")}, {new Currency("GBP59.99"), new Currency("GBP1.00")}, {new Currency("GBP149.99"), new Currency("GBP2.00")}, {new Currency("GBP299.99"), new Currency("GBP5.00")}, {new Currency("GBP599.99"), new Currency("GBP10.00")}, {new Currency("GBP1499.99"), new Currency("GBP25.00")}, {new Currency("GBP2999.99"), new Currency("GBP50.00")}, {Currency.NoValue(), new Currency("GBP100.00")}};
    private static Currency[][] fr_incrementTable = new Currency[][]{{new Currency("FRF4.99"), new Currency("FRF0.25")}, {new Currency("FRF24.99"), new Currency("FRF0.50")}, {new Currency("FRF99.99"), new Currency("FRF1.00")}, {new Currency("FRF249.99"), new Currency("FRF2.50")}, {new Currency("FRF499.99"), new Currency("FRF5.00")}, {new Currency("FRF999.99"), new Currency("FRF10.00")}, {new Currency("FRF2499.99"), new Currency("FRF25.00")}, {new Currency("FRF9999.99"), new Currency("FRF100.00")}, {new Currency("FRF49999.99"), new Currency("FRF250.00")}, {Currency.NoValue(), new Currency("FRF500.00")}};
    private static Currency[][] eu_incrementTable = new Currency[][]{{new Currency("EUR49.99"), new Currency("EUR0.50")}, {new Currency("EUR499.99"), new Currency("EUR1.00")}, {new Currency("EUR999.99"), new Currency("EUR5.00")}, {new Currency("EUR4999.99"), new Currency("EUR10.00")}, {Currency.NoValue(), new Currency("EUR50.00")}};
    private static Currency[][] tw_incrementTable = new Currency[][]{{new Currency("NTD500"), new Currency("NTD15")}, {new Currency("NTD2500"), new Currency("NTD30")}, {new Currency("NTD5000"), new Currency("NTD50")}, {new Currency("NTD25000"), new Currency("NTD100")}, {Currency.NoValue(), new Currency("NTD200")}};
    private static Currency[][] ch_incrementTable = new Currency[][]{{new Currency("CHF49.99"), new Currency("CHF0.50")}, {new Currency("CHF499.99"), new Currency("CHF1.00")}, {new Currency("CHF999.99"), new Currency("CHF5.00")}, {new Currency("CHF4999.99"), new Currency("CHF10.00")}, {Currency.NoValue(), new Currency("CHF50.00")}};
    private static Currency zeroDollars = new Currency("$0.00");
    private static Currency zeroPounds = new Currency("GBP 0.00");
    private static Currency zeroFrancs = new Currency("FR 0.00");
    private static Currency zeroSwissFrancs = new Currency("CHF0.00");
    private static Currency zeroEuros = new Currency("EUR 0.00");
    private static Currency zeroAustralian = new Currency("AUD0.00");
    private static Currency zeroTaiwanese = new Currency("NTD0.00");
    private static Currency zeroCanadian = new Currency("CAD0.00");
    private static final String srcMatch = "(?i)src=\"([^\"]*?)\"";
    private static final Regex srcRegex = new Regex("(?i)src=\"([^\"]*?)\"");
    private static final String dateMatch = "(?i)(Ends|end.time).([A-Za-z]+(.[0-9]+)+.[A-Z]+)";
    private static final Regex dateRegex = new Regex("(?i)(Ends|end.time).([A-Za-z]+(.[0-9]+)+.[A-Z]+)");
    private static final int THREE_SECONDS = 3000;

    private void loadStrings() {
        this.eBayHost = Externalized.getString("ebayServer.host");
        this.eBayViewHost = Externalized.getString("ebayServer.viewHost");
        this.eBayBrowseHost = Externalized.getString("ebayServer.browseHost");
        this.eBayDetectionHost = Externalized.getString("ebayServer.detectionHost");
        this.eBayTWDetectionHost = Externalized.getString("ebayServer.TaiwanDetectionHost");
        this.eBayESDetectionHost = Externalized.getString("ebayServer.SpainDetectionHost");
        this.eBayBidHost = Externalized.getString("ebayServer.bidHost");
        this.eBayDutchRequest = Externalized.getString("ebayServer.dutchRequestHost");
        this.eBayProtocol = Externalized.getString("ebayServer.protocol");
        this.eBayFile = Externalized.getString("ebayServer.file");
        this.eBayV3File = Externalized.getString("ebayServer.V3file");
        this.eBayWS3File = Externalized.getString("ebayServer.V3WS3File");
        this.eBayViewItemCmd = Externalized.getString("ebayServer.viewCmd");
        this.eBayParseItemURL = Externalized.getString("ebayServer.itemNumberMatch");
        this.eBayViewItemCGI = Externalized.getString("ebayServer.viewCGI");
        this.eBayViewDutchWinners = Externalized.getString("ebayServer.viewDutch");
        this.eBaySearchURL1 = Externalized.getString("ebayServer.searchURL1");
        this.eBaySearchURL2 = Externalized.getString("ebayServer.searchURL2");
        this.eBaySearchURLNoDesc = Externalized.getString("ebayServer.searchURLNoDesc");
        this.eBayBidItem = Externalized.getString("ebayServer.bidCmd");
        this.eBayPrequelTimeString = Externalized.getString("ebayServer.timePrequel1");
        this.eBayPrequelTimeString2 = Externalized.getString("ebayServer.timePrequel2");
        this.eBayDateFormat = Externalized.getString("ebayServer.dateFormat");
        this.eBayOfficialTimeFormat = Externalized.getString("ebayServer.officialTimeFormat");
        this.eBayAdultLoginPageTitle = Externalized.getString("ebayServer.adultPageTitle");
        this.eBayTitles = new String[]{Externalized.getString("ebayServer.titleEbay"), Externalized.getString("ebayServer.titleEbay2"), Externalized.getString("ebayServer.titleMotors"), Externalized.getString("ebayServer.titleMotors2"), Externalized.getString("ebayServer.titleDisney"), Externalized.getString("ebayServer.titleCollections")};
        this.eBayCurrentBid = Externalized.getString("ebayServer.currentBid");
        this.eBayLowestBid = Externalized.getString("ebayServer.lowestBid");
        this.eBayFirstBid = Externalized.getString("ebayServer.firstBid");
        this.eBayQuantity = Externalized.getString("ebayServer.quantity");
        this.eBayBidCount = Externalized.getString("ebayServer.bidCount");
        this.eBayStartTime = Externalized.getString("ebayServer.startTime");
        this.eBaySeller = Externalized.getString("ebayServer.seller");
        this.eBayHighBidder = Externalized.getString("ebayServer.highBidder");
        this.eBayBuyer = Externalized.getString("ebayServer.buyer");
        this.eBayShippingRegex = Externalized.getString("ebayServer.shipping");
        this.eBayInsurance = Externalized.getString("ebayServer.shippingInsurance");
        this.eBayItemEnded = Externalized.getString("ebayServer.ended");
        this.eBayTemporarilyUnavailable = Externalized.getString("ebayServer.unavailable");
        this.eBayPrice = Externalized.getString("ebayServer.price");
        this.eBayDescStart = Externalized.getString("ebayServer.description");
        this.eBayMotorsDescStart = Externalized.getString("ebayServer.descriptionMotors");
        this.eBayDescEnd = Externalized.getString("ebayServer.descriptionEnd");
        this.eBayPayInstructions = Externalized.getString("ebayServer.paymentInstructions");
        this.eBayClosedDescEnd = Externalized.getString("ebayServer.descriptionClosedEnd");
        this.eBayItemCGI = Externalized.getString("ebayServer.itemCGI");
        this.eBayItemNumber = Externalized.getString("ebayServer.itemNum");
    }

    public boolean doHandleThisSite(URL uRL) {
        if (uRL == null) {
            return false;
        }
        if (uRL.getHost().startsWith(this.eBayDetectionHost)) {
            return true;
        }
        if (uRL.getHost().startsWith(this.eBayTWDetectionHost)) {
            return true;
        }
        return uRL.getHost().startsWith(this.eBayESDetectionHost);
    }

    public Currency getMinimumBidIncrement(Currency currency, int n) {
        Currency[][] currencyArray;
        Currency currency2 = currency;
        Currency currency3 = zeroDollars;
        switch (currency.getCurrencyType()) {
            default: {
                currency2 = zeroDollars;
                currencyArray = incrementTable;
                break;
            }
            case 1: {
                currencyArray = incrementTable;
                break;
            }
            case 2: {
                currencyArray = uk_incrementTable;
                currency3 = zeroPounds;
                break;
            }
            case 5: {
                currencyArray = fr_incrementTable;
                currency3 = zeroFrancs;
                break;
            }
            case 9: {
                currencyArray = ch_incrementTable;
                currency3 = zeroSwissFrancs;
                break;
            }
            case 7: {
                currencyArray = eu_incrementTable;
                currency3 = zeroEuros;
                break;
            }
            case 10: {
                currencyArray = tw_incrementTable;
                currency3 = zeroTaiwanese;
                break;
            }
            case 6: {
                currencyArray = ca_incrementTable;
                currency3 = zeroCanadian;
                break;
            }
            case 8: {
                currencyArray = au_incrementTable;
                currency3 = zeroAustralian;
            }
        }
        if (n == 0) {
            return currency3;
        }
        for (int i = 0; i < currencyArray.length; ++i) {
            Currency currency4 = currencyArray[i][0];
            Currency currency5 = currencyArray[i][1];
            if (currency4 == null || currency4.isNull()) {
                return currency5;
            }
            try {
                if (currency2.less(currency4)) {
                    return currency5;
                }
                if (currency4.less(currency2)) continue;
                return currency5;
            }
            catch (Currency.CurrencyTypeException currencyTypeException) {
                ErrorManagement.handleException("Currency comparison threw a bad currency exception, which should be impossible.", currencyTypeException);
            }
        }
        return null;
    }

    public void updateConfiguration() {
        this.sellerSearch = SearchManager.getInstance().buildSearch(System.currentTimeMillis(), "Seller", "My Selling Items", this.getUserId(), this.getName(), null, 0);
    }

    public Object getConfigurationTab() {
        return new JConfigEbayTab();
    }

    public void establishMenu() {
        ebayServerMenu ebayServerMenu2 = new ebayServerMenu(eBayDisplayName, 'b');
        ebayServerMenu2.initialize();
    }

    public boolean checkIfIdentifierIsHandled(String string) {
        return string != null && ebayServer.isNumberOnly(string);
    }

    public boolean isHighDutch(AuctionEntry auctionEntry) {
        String string = this.eBayProtocol + this.eBayDutchRequest + this.eBayWS3File + this.eBayViewDutchWinners + auctionEntry.getIdentifier();
        CookieJar cookieJar = this.getNecessaryCookie(false);
        String string2 = null;
        if (cookieJar != null) {
            string2 = cookieJar.toString();
        }
        JHTML jHTML = new JHTML(string, string2, this);
        String string3 = null;
        if (jHTML.isLoaded()) {
            string3 = jHTML.getNextContentAfterContent(this.getUserId());
        }
        return string3 != null;
    }

    public void updateHighBid(AuctionEntry auctionEntry) {
        JHTML jHTML;
        String string = this.eBayProtocol + this.eBayBidHost + this.eBayV3File + Externalized.getString("ebayServer.viewBidsCGI") + auctionEntry.getIdentifier();
        CookieJar cookieJar = this.getNecessaryCookie(false);
        String string2 = null;
        if (cookieJar != null) {
            string2 = cookieJar.toString();
        }
        if ((jHTML = new JHTML(string, string2, this)).isLoaded()) {
            String string3 = jHTML.getNextContentAfterContent(this.getUserId());
            if (string3 == null) {
                return;
            }
            if (ebayServer.isNumberOnly(string3)) {
                string3 = jHTML.getNextContent();
            }
            int n = 1;
            for (int i = 0; i < 2; ++i) {
                Currency currency = Currency.getCurrency(string3);
                if (!currency.isNull()) {
                    if (auctionEntry.isDutch()) {
                        String string4 = jHTML.getNextContent();
                        try {
                            n = Integer.parseInt(string4);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n = 1;
                        }
                    }
                    try {
                        if (!auctionEntry.isBidOn() || auctionEntry.getBid().less(currency)) {
                            auctionEntry.setBid(currency);
                            auctionEntry.setBidQuantity(n);
                        }
                    }
                    catch (Currency.CurrencyTypeException currencyTypeException) {
                        // empty catch block
                    }
                }
                string3 = jHTML.getNextContent();
            }
        }
    }

    public boolean checkIfSiteNameHandled(String string) {
        return string.equalsIgnoreCase(eBayServerName);
    }

    private void loadAllFromURLString(Object object, String string) {
        String string2 = ((Searcher)object).getSearch();
        MQFactory.getConcrete("Swing").enqueue("Loading from URL " + string2);
        EbayAuctionURLPager ebayAuctionURLPager = new EbayAuctionURLPager(string2, this, this);
        int n = 0;
        ListIterator listIterator = ebayAuctionURLPager.listIterator();
        while (listIterator.hasNext()) {
            MQFactory.getConcrete("Swing").enqueue("Loading page " + listIterator.nextIndex() + "/" + ebayAuctionURLPager.size() + " from URL " + string2);
            JHTML jHTML = (JHTML)listIterator.next();
            if (jHTML == null) continue;
            n += ebayServer.addAllItemsOnPage(jHTML, string, !((Searcher)object).shouldSkipDeleted());
        }
        if (n == 0) {
            MQFactory.getConcrete("Swing").enqueue("Failed to load from URL " + string2);
        } else {
            MQFactory.getConcrete("Swing").enqueue("Done loading from URL " + string2);
        }
    }

    private void loadSearchString(Object object, String string, boolean bl) {
        String string2;
        String string3 = ((Searcher)object).getSearch();
        try {
            string2 = URLEncoder.encode(string3, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string2 = null;
            ErrorManagement.logMessage("Failed to search because of encoding transformation failure.");
        }
        int n = 0;
        if (string2 != null) {
            boolean bl2;
            MQFactory.getConcrete("Swing").enqueue("Searching for: " + string3);
            String string4 = "";
            String string5 = ((Searcher)object).getCurrency();
            if (string5 != null) {
                string4 = "&sacur=" + string5;
            }
            String string6 = bl ? this.eBaySearchURL1 + string2 + string4 + this.eBaySearchURLNoDesc : this.eBaySearchURL1 + string2 + string4 + this.eBaySearchURL2;
            int n2 = 0;
            do {
                int n3;
                JHTML jHTML;
                bl2 = true;
                CookieJar cookieJar = this.getNecessaryCookie(false);
                String string7 = null;
                if (cookieJar != null) {
                    string7 = cookieJar.toString();
                }
                if (!(jHTML = new JHTML(string6, string7, this)).isLoaded() || (n3 = ebayServer.addAllItemsOnPage(jHTML, string, !((Searcher)object).shouldSkipDeleted())) == 0) continue;
                if (n3 >= 100) {
                    string6 = this.eBaySearchURL1 + string2 + string4 + (bl ? this.eBaySearchURLNoDesc : this.eBaySearchURL2) + "&skip=" + (n2 += 100);
                    bl2 = false;
                }
                n += n3;
            } while (!bl2);
        }
        if (n == 0) {
            MQFactory.getConcrete("Swing").enqueue("No results found for search: " + string3);
        } else {
            MQFactory.getConcrete("Swing").enqueue("Done searching for: " + string3);
        }
    }

    public void messageAction(Object object) {
        AuctionQObject auctionQObject = (AuctionQObject)object;
        String string = null;
        boolean bl = this.getUserId().equals("default");
        switch (auctionQObject.getCommand()) {
            case 7: {
                this.loadStrings();
                return;
            }
            case 0: {
                this.loadAllFromURLString(auctionQObject.getData(), auctionQObject.getLabel());
                return;
            }
            case 1: {
                this.loadSearchString(auctionQObject.getData(), auctionQObject.getLabel(), false);
                return;
            }
            case 6: {
                this.loadSearchString(auctionQObject.getData(), auctionQObject.getLabel(), true);
                return;
            }
            case 2: {
                this.doGetSelling(auctionQObject.getData(), auctionQObject.getLabel());
                return;
            }
            case 3: {
                if (bl) {
                    string = Externalized.getString("ebayServer.cantLoadWithoutUsername1") + " " + this.getName() + Externalized.getString("ebayServer.cantLoadWithoutUsername2");
                    break;
                }
                this.doMyEbaySynchronize(auctionQObject.getLabel());
                return;
            }
            case 10: {
                AuctionEntry auctionEntry = (AuctionEntry)auctionQObject.getData();
                String string2 = auctionEntry.getIdentifier();
                AuctionQObject auctionQObject2 = (AuctionQObject)this.snipeMap.get(string2);
                this._etqm.erase(auctionQObject2);
                this.snipeMap.remove(string2);
                return;
            }
            case 8: {
                AuctionEntry auctionEntry = (AuctionEntry)auctionQObject.getData();
                AuctionQObject auctionQObject3 = (AuctionQObject)this.snipeMap.get(auctionEntry.getIdentifier());
                if (auctionQObject3 != null) {
                    this._etqm.erase(auctionQObject3);
                    this.snipeMap.remove(auctionEntry.getIdentifier());
                }
                long l = 120000L;
                AuctionQObject auctionQObject4 = new AuctionQObject(9, new Snipe(auctionEntry), null);
                this._etqm.add(auctionQObject4, "snipes", auctionEntry.getEndDate().getTime() - auctionEntry.getSnipeTime() - l);
                this._etqm.add(auctionQObject4, "snipes", auctionEntry.getEndDate().getTime() - auctionEntry.getSnipeTime());
                this.snipeMap.put(auctionEntry.getIdentifier(), auctionQObject4);
                return;
            }
            case 5: {
                AuctionAction auctionAction = (AuctionAction)auctionQObject.getData();
                String string3 = auctionAction.activate();
                String string4 = auctionAction.isSuccessful() ? "prompt.hide_bidalert" : "prompt.hide_bidfailalert";
                MQFactory.getConcrete("Swing").enqueue("IGNORE " + string4 + ' ' + string3);
                AuctionsManager.getInstance().changed();
                return;
            }
        }
        if (auctionQObject.getData() != null) {
            if (auctionQObject.getData().equals("Get My eBay Items")) {
                if (this._my_ebay != null) {
                    this._my_ebay.execute();
                    return;
                }
                if (bl) {
                    string = Externalized.getString("ebayServer.cantLoadWithoutUsername1") + " " + this.getName() + Externalized.getString("ebayServer.cantLoadWithoutUsername2");
                } else {
                    this.doMyEbaySynchronize(null);
                    return;
                }
            }
            if (auctionQObject.getData().equals("Get Selling Items")) {
                if (bl) {
                    string = Externalized.getString("ebayServer.cantLoadSellerWithoutUser1") + " " + this.getName() + Externalized.getString("ebayServer.cantLoadWithoutUsername2");
                } else {
                    if (this.sellerSearch == null) {
                        this.updateConfiguration();
                    }
                    if (this.sellerSearch != null) {
                        this.sellerSearch.fire();
                    }
                    return;
                }
            }
            if (auctionQObject.getData().equals("Update login cookie")) {
                if (bl) {
                    string = Externalized.getString("ebayServer.cantUpdateCookieWithoutUser1") + " " + this.getName() + Externalized.getString("ebayServer.cantLoadWithoutUsername2");
                } else {
                    this._signinCookie = null;
                    this.getNecessaryCookie(true);
                    return;
                }
            }
            if (auctionQObject.getData().equals("[Dump eBay activity queue]")) {
                this._etqm.dumpQueue();
                return;
            }
        }
        if (string != null && string.length() != 0 && bl) {
            JOptionPane.showMessageDialog(null, string, "No auction account error", -1);
        } else if (auctionQObject.getData() instanceof String) {
            String string5 = (String)auctionQObject.getData();
            ErrorManagement.logMessage("Dequeue'd unexpected command or fell through: " + auctionQObject.getCommand() + ':' + string5);
        } else {
            ErrorManagement.logMessage("Can't recognize ebay-queued data: " + auctionQObject.getData());
        }
    }

    public ebayServer() {
        this.loadStrings();
        this.site_choices = new String[]{"ebay.com", "ebay.de", "ebay.ca", "ebay.co.uk", "tw.ebay.com", "es.ebay.com", "ebay.fr", "ebay.it", "ebay.com.au", "ebay.at", "benl.ebay.be", "ebay.nl", "ebay.com.sg", "ebaysweden.com", "ebay.ch", "befr.ebay.be", "ebay.ie"};
        this.siteId = eBayServerName;
        if (this._resultHash == null) {
            this._resultHash = new HashMap();
            this._resultHash.put("you are not permitted to bid on their listings.", new Integer(10));
            this._resultHash.put("the item is no longer available because the auction has ended.", new Integer(9));
            this._resultHash.put("cannot proceed", new Integer(1));
            this._resultHash.put("problem with bid amount", new Integer(2));
            this._resultHash.put("your bid must be at least ", new Integer(8));
            this._resultHash.put("you have been outbid by another bidder", new Integer(3));
            this._resultHash.put("you've been outbid by another bidder", new Integer(3));
            this._resultHash.put("your bid is confirmed!", new Integer(6));
            this._resultHash.put("you are bidding on this multiple item auction", new Integer(6));
            this._resultHash.put("you are the high bidder on all items you bid on", new Integer(6));
            this._resultHash.put("you are the current high bidder", new Integer(4));
            this._resultHash.put("you purchased the item", new Integer(4));
            this._resultHash.put("the reserve price has not been met", new Integer(11));
            this._resultHash.put("your new total must be higher than your current total", new Integer(13));
            this._resultHash.put("this exceeds or is equal to your current bid", new Integer(13));
            this._resultHash.put("you bought this item", new Integer(16));
            this._resultHash.put("you committed to buy", new Integer(16));
            this._resultHash.put("congratulations! you won!", new Integer(16));
            this._resultHash.put("account suspended", new Integer(17));
            this._resultHash.put("to enter a higher maximum bid, please enter", new Integer(13));
            this._resultHash.put("you are registered in a country to which the seller doesn.t ship.", new Integer(19));
            this._resultHash.put("this seller has set buyer requirements for this item and only sells to buyers who meet those requirements.", new Integer(20));
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        Iterator iterator = this._resultHash.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringBuffer.append(string);
            if (iterator.hasNext()) {
                stringBuffer.append('|');
            } else {
                stringBuffer.append(')');
            }
            this._bidResultRegex = new Regex(stringBuffer.toString());
            this._bidResultRegex.setIgnoreCase(true);
            this._bidResultRegex.optimize();
        }
        this._resultHash.put("sign in", new Integer(18));
        this._etqm = new eBayTimeQueueManager();
        this.eQueue = new TimerHandler(this._etqm);
        this.eQueue.setName("eBay SuperQueue");
        this.eQueue.start();
        MQFactory.getConcrete("snipes").registerListener(new SnipeListener());
        MQFactory.getConcrete(eBayServerName).registerListener(this);
        JConfig.registerListener(this);
    }

    protected Date getOfficialTime() {
        Auctions.startBlocking();
        String string = Externalized.getString("ebayServer.timeURL");
        JHTML jHTML = new JHTML(string, null, this);
        Date date = null;
        String string2 = jHTML.getNextContent();
        while (date == null && string2 != null) {
            if (string2.equals(this.eBayPrequelTimeString) || string2.equals(this.eBayPrequelTimeString2)) {
                date = this.figureDate(jHTML.getNextContent(), this.eBayOfficialTimeFormat, false, false);
            }
            string2 = jHTML.getNextContent();
        }
        Auctions.endBlocking();
        return date;
    }

    public String extractIdentifierFromURLString(String string) {
        int n;
        String string2;
        Object object;
        Regex regex = new Regex(this.eBayParseItemURL);
        if (regex.search(string) && ebayServer.isNumberOnly((String)(object = regex.stringMatched(2)))) {
            return object;
        }
        object = ebayServer.getURLFromString(string);
        if (object != null && (string2 = ((URL)object).toString()).indexOf(this.eBayViewItemCmd) != -1 && (n = string2.indexOf(this.eBayViewItemCGI)) != -1) {
            String string3 = string2.substring(n + this.eBayViewItemCGI.length());
            if (string3.indexOf("&") != -1) {
                string3 = string3.substring(0, string3.indexOf("&"));
            }
            if (string3.indexOf("#") != -1) {
                string3 = string3.substring(0, string3.indexOf("#"));
            }
            return string3;
        }
        ErrorManagement.logDebug("extractIdentifierFromURLString failed.");
        return null;
    }

    protected String getStringURLFromItem(String string) {
        return this.eBayProtocol + this.eBayViewHost + this.eBayFile + '?' + this.eBayViewItemCmd + this.eBayViewItemCGI + string;
    }

    protected String getBrowsableURLFromItem(String string) {
        int n = Integer.parseInt(JConfig.queryConfiguration(this.siteId + ".browse.site", "0"));
        if (JBConfig.doAffiliate(0L)) {
            return "http://www.jbidwatcher.com/ebay_aff.php?country=" + n + "&item=" + string;
        }
        return this.eBayProtocol + this.eBayBrowseHost + this.site_choices[n] + this.eBayFile + '?' + this.eBayViewItemCmd + this.eBayViewItemCGI + string;
    }

    protected URL getURLFromItem(String string) {
        return ebayServer.getURLFromString(this.getStringURLFromItem(string));
    }

    protected SpecificAuction getNewSpecificAuction() {
        return new ebayAuction();
    }

    public JHTML.Form getBidForm(CookieJar cookieJar, AuctionEntry auctionEntry, Currency currency, int n) throws AuctionServer.BadBidException {
        String string;
        String string2 = this.eBayProtocol + this.eBayBidHost + this.eBayV3File;
        String string3 = auctionEntry.isDutch() ? this.eBayBidItem + "&co_partnerid=" + this.eBayItemCGI + auctionEntry.getIdentifier() + "&fb=2" + Externalized.getString("ebayServer.quantCGI") + n + Externalized.getString("ebayServer.bidCGI") + currency.getValue() : this.eBayBidItem + "&co_partnerid=" + this.eBayItemCGI + auctionEntry.getIdentifier() + "&fb=2" + Externalized.getString("ebayServer.bidCGI") + currency.getValue();
        StringBuffer stringBuffer = null;
        JHTML jHTML = null;
        try {
            string = string2 + '?' + string3;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            while (!bl3) {
                Object object;
                bl3 = true;
                if (JConfig.debugging) {
                    auctionEntry.setLastStatus("Loading bid request...");
                }
                URLConnection uRLConnection = cookieJar.getAllCookiesFromPage(string, null, bl4);
                bl4 = false;
                if (uRLConnection == null) {
                    return null;
                }
                stringBuffer = Http.receivePage(uRLConnection);
                if (stringBuffer == null) {
                    return null;
                }
                jHTML = new JHTML(stringBuffer);
                JHTML.Form form = jHTML.getFormWithInput("key");
                if (form != null) {
                    if (JConfig.debugging) {
                        auctionEntry.setLastStatus("Done loading bid request, got form...");
                    }
                    return form;
                }
                if (!bl) {
                    bl = true;
                    object = jHTML.getFirstContent();
                    if (object != null) {
                        ErrorManagement.logDebug("Checking sign in as bid key load failed!");
                        if (((String)object).equalsIgnoreCase("Sign In")) {
                            ErrorManagement.logDebug("Being prompted again for sign in, retrying.");
                            if (JConfig.debugging) {
                                auctionEntry.setLastStatus("Not done loading bid request, got re-login request...");
                            }
                            this._signinCookie = null;
                            this.getNecessaryCookie(true);
                            if (JConfig.debugging) {
                                auctionEntry.setLastStatus("Done re-logging in, retrying load bid request.");
                            }
                            bl3 = false;
                        }
                    }
                }
                if (bl2 || jHTML.grep(Externalized.getString("ebayServer.warningPage")) == null) continue;
                bl2 = true;
                object = jHTML.getFormWithInput("firedFilterId");
                if (object == null) continue;
                auctionEntry.setLastStatus("Trying to 'continue' for the actual bid.");
                string = ((JHTML.Form)object).getCGI();
                string = string.replaceFirst("%[A-F][A-F0-9]%A0", "%A0");
                bl3 = false;
                bl4 = false;
            }
        }
        catch (IOException iOException) {
            ErrorManagement.handleException("Failure to get the bid key!  BID FAILURE!", iOException);
        }
        if (jHTML != null) {
            String string4;
            string = jHTML.getFirstContent();
            if (string != null && string.equalsIgnoreCase("Sign In")) {
                throw new AuctionServer.BadBidException("sign in", 18);
            }
            String string5 = jHTML.grep(this._bidResultRegex);
            if (string5 != null) {
                String string6 = this._bidResultRegex.stringMatched().toLowerCase();
                throw new AuctionServer.BadBidException(string6, (Integer)this._resultHash.get(string6));
            }
            String string7 = jHTML.getNextContentAfterRegex("Enter");
            if (string7 != null && (string4 = jHTML.getNextContent()) != null && string4.indexOf("or more") != -1) {
                throw new AuctionServer.BadBidException("Enter " + string7 + string4, 8);
            }
        }
        if (JConfig.debugging) {
            auctionEntry.setLastStatus("Failed to bid. 'Show Last Error' from context menu to see the failure page from the bid attempt.");
        }
        auctionEntry.setErrorPage(stringBuffer);
        ErrorManagement.logFile(string3, stringBuffer);
        return null;
    }

    public long getSnipePadding() {
        return 1L;
    }

    public void pingAffiliate(AuctionEntry auctionEntry) {
        try {
            if (this.doAffiliate(auctionEntry)) {
                AffiliateRetrieve.getAuctionViaAffiliate(this.getNecessaryCookie(false), auctionEntry.getIdentifier());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean doAffiliate(AuctionEntry auctionEntry) {
        Date date;
        long l = 1L;
        if (auctionEntry != null && (date = auctionEntry.getEndDate()) != null) {
            l = date.getTime();
        }
        return JBConfig.doAffiliate(l);
    }

    public void safeGetAffiliate(AuctionEntry auctionEntry) {
        if (auctionEntry.getTitle().toLowerCase().indexOf("test") == -1) {
            if (JConfig.queryConfiguration("ebay.affiliate.bidbuy", "true").equals("false")) {
                return;
            }
            if (this.doAffiliate(auctionEntry)) {
                if (JConfig.debugging) {
                    auctionEntry.setLastStatus("Loading item...");
                }
                this.pingAffiliate(auctionEntry);
                if (JConfig.debugging) {
                    auctionEntry.setLastStatus("Done loading item...");
                }
            }
        }
    }

    public int buy(AuctionEntry auctionEntry, int n) {
        StringBuffer stringBuffer;
        String string = "http://offer.ebay.com/ws/eBayISAPI.dll?MfcISAPICommand=BinConfirm&fb=1&co_partnerid=&item=" + auctionEntry.getIdentifier() + "&quantity=" + n;
        this.safeGetAffiliate(auctionEntry);
        try {
            stringBuffer = this.getNecessaryCookie(false).getAllCookiesAndPage(string, null, false);
            JHTML jHTML = new JHTML(stringBuffer);
            JHTML.Form form = jHTML.getFormWithInput("uiid");
            if (form != null) {
                form.delInput("BIN_button");
                CookieJar cookieJar = this.getNecessaryCookie(false);
                StringBuffer stringBuffer2 = cookieJar.getAllCookiesAndPage(form.getCGI(), string, false);
                if (stringBuffer2 == null) {
                    return 12;
                }
                return this.handlePostBidBuyPage(cookieJar, stringBuffer2, form, auctionEntry);
            }
        }
        catch (CookieJar.CookieException cookieException) {
            return 12;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorManagement.handleException("UTF-8 not supported locally, can't URLEncode buy form.", unsupportedEncodingException);
            return 12;
        }
        auctionEntry.setErrorPage(stringBuffer);
        return -1;
    }

    public int bid(AuctionEntry auctionEntry, Currency currency, int n) {
        JHTML.Form form;
        Auctions.startBlocking();
        if (JConfig.queryConfiguration("sound.enable", "false").equals("true")) {
            MQFactory.getConcrete("audio").enqueue("audio/bid.mp3");
        }
        this.safeGetAffiliate(auctionEntry);
        try {
            form = this.getBidForm(this.getNecessaryCookie(false), auctionEntry, currency, n);
        }
        catch (AuctionServer.BadBidException badBidException) {
            Auctions.endBlocking();
            return badBidException.getResult();
        }
        if (form != null) {
            int n2 = this.placeFinalBid(this.getNecessaryCookie(false), form, auctionEntry, currency, n);
            Auctions.endBlocking();
            return n2;
        }
        ErrorManagement.logMessage("Bad/nonexistent key read in bid, or connection failure!");
        Auctions.endBlocking();
        return -1;
    }

    public int placeFinalBid(CookieJar cookieJar, JHTML.Form form, AuctionEntry auctionEntry, Currency currency, int n) {
        String string = this.eBayProtocol + this.eBayBidHost + this.eBayV3File;
        String string2 = this.eBayBidItem + this.eBayItemCGI + auctionEntry.getIdentifier() + Externalized.getString("ebayServer.quantCGI") + n + Externalized.getString("ebayServer.bidCGI") + currency.getValue();
        String string3 = string + '?' + string2;
        form.delInput("BIN_button");
        StringBuffer stringBuffer = null;
        try {
            if (JConfig.debugging) {
                auctionEntry.setLastStatus("Submitting bid form.");
            }
            stringBuffer = cookieJar.getAllCookiesAndPage(form.getCGI(), string3, false);
            if (JConfig.debugging) {
                auctionEntry.setLastStatus("Done submitting bid form.");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorManagement.handleException("UTF-8 not supported locally, can't URLEncode bid form.", unsupportedEncodingException);
        }
        catch (CookieJar.CookieException cookieException) {
            return 12;
        }
        if (stringBuffer == null) {
            return 12;
        }
        return this.handlePostBidBuyPage(cookieJar, stringBuffer, form, auctionEntry);
    }

    private int handlePostBidBuyPage(CookieJar cookieJar, StringBuffer stringBuffer, JHTML.Form form, AuctionEntry auctionEntry) {
        Object object;
        String string;
        JHTML jHTML;
        JHTML.Form form2;
        if (JConfig.debugging) {
            auctionEntry.setLastStatus("Loading post-bid data.");
        }
        if ((form2 = (jHTML = new JHTML(stringBuffer)).getFormWithInput("firedFilterId")) != null) {
            try {
                auctionEntry.setLastStatus("Trying to 'continue' to the bid result page.");
                string = form2.getCGI();
                string = string.replaceFirst("%[A-F][A-F0-9]%A0", "%A0");
                object = cookieJar.getAllCookiesFromPage(string, null, false);
                if (object == null) {
                    return 12;
                }
                stringBuffer = Http.receivePage((URLConnection)object);
                if (stringBuffer == null) {
                    return 12;
                }
                jHTML = new JHTML(stringBuffer);
            }
            catch (Exception exception) {
                return 12;
            }
        }
        if ((string = jHTML.grep(this._bidResultRegex)) != null) {
            Object object2;
            object = (Integer)this._resultHash.get(this._bidResultRegex.stringMatched().toLowerCase());
            int n = 0;
            if (object != null) {
                n = (Integer)object;
                if (n == 10 || n == 19 || n == 20) {
                    auctionEntry.setErrorPage(stringBuffer);
                }
            } else {
                String string2;
                object2 = jHTML.getNextContentAfterRegex("Enter");
                if (object2 != null && (string2 = jHTML.getNextContent()) != null && string2.indexOf("or more") != -1) {
                    n = 8;
                }
            }
            if (auctionEntry.getTitle().toLowerCase().indexOf("test") == -1 && this.doAffiliate(auctionEntry)) {
                object2 = new ImageFetcher(jHTML);
                ((Thread)object2).start();
            }
            if (JConfig.debugging) {
                auctionEntry.setLastStatus("Done loading post-bid data.");
            }
            if (object != null) {
                return n;
            }
        }
        form.setText("user", "HIDDEN");
        form.setText("pass", "HIDDEN");
        object = "";
        try {
            object = form.getCGI();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorManagement.handleException("UTF-8 not supported locally, can't URLEncode CGI for debugging.", unsupportedEncodingException);
        }
        if (JConfig.debugging) {
            auctionEntry.setLastStatus("Failed to load post-bid data. 'Show Last Error' from context menu to see the failure page from the post-bid page.");
        }
        auctionEntry.setErrorPage(stringBuffer);
        ErrorManagement.logFile((String)object, stringBuffer);
        return -1;
    }

    public synchronized CookieJar getNecessaryCookie(boolean bl) {
        if (this._signinCookie == null || bl) {
            this._signinCookie = this.getSignInCookie(this._signinCookie);
        }
        return this._signinCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void dump2File(String string, StringBuffer stringBuffer) {
        FileWriter fileWriter = null;
        fileWriter = new FileWriter(string);
        fileWriter.write(stringBuffer.toString());
        Object var5_3 = null;
        if (fileWriter == null) return;
        try {
            fileWriter.close();
            return;
        }
        catch (IOException iOException) {}
        return;
        {
            catch (IOException iOException) {
                ErrorManagement.handleException("Threw exception in dump2File!", iOException);
                Object var5_4 = null;
                if (fileWriter == null) return;
                try {
                    fileWriter.close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (fileWriter == null) throw throwable;
            try {
                fileWriter.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    private URLConnection checkFollowRedirector(URLConnection uRLConnection, CookieJar cookieJar, String string) throws IOException, CaptchaException {
        JHTML jHTML;
        StringBuffer stringBuffer = Http.receivePage(uRLConnection);
        if (JConfig.queryConfiguration("debug.filedump", "false").equals("true")) {
            ebayServer.dump2File("sign_in-a1.html", stringBuffer);
        }
        if (this.checkSecurityConfirmation(jHTML = new JHTML(stringBuffer))) {
            return null;
        }
        return ebayServer.checkHTMLFollowRedirect(jHTML, string, cookieJar);
    }

    private static URLConnection checkHTMLFollowRedirect(JHTML jHTML, String string, CookieJar cookieJar) {
        jHTML.reset();
        List list = jHTML.getAllURLsOnPage(false);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n;
            String string2 = (String)iterator.next();
            if (string2.indexOf(string) == -1) continue;
            string2 = string2.replaceAll("&amp;", "&");
            string2 = string2.replaceAll("\n", "");
            if (string.equals("BidBin") && (n = string2.indexOf("BidBinInfo=")) != -1) {
                n += "BidBinInfo=".length();
                try {
                    String string3 = URLEncoder.encode(string2.substring(n), "UTF-8");
                    string2 = string2.substring(0, n) + string3;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    ErrorManagement.logMessage("Failed to build a URL because of encoding transformation failure.");
                }
            }
            return cookieJar.getAllCookiesFromPage(string2, null, false);
        }
        return null;
    }

    private boolean getAdultRedirector(URLConnection uRLConnection, CookieJar cookieJar) throws IOException, CaptchaException {
        return (uRLConnection = this.checkFollowRedirector(uRLConnection, cookieJar, "Adult")) != null && ebayServer.getAdultConfirmation(uRLConnection, cookieJar);
    }

    private static boolean getAdultConfirmation(URLConnection uRLConnection, CookieJar cookieJar) throws IOException {
        StringBuffer stringBuffer = Http.receivePage(uRLConnection);
        if (JConfig.queryConfiguration("debug.filedump", "false").equals("true")) {
            ebayServer.dump2File("sign_in-a2.html", stringBuffer);
        }
        JHTML jHTML = new JHTML(stringBuffer);
        List list = jHTML.getForms();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JHTML jHTML2;
            JHTML.Form form;
            JHTML.Form form2 = (JHTML.Form)iterator.next();
            if (!form2.hasInput("MfcISAPICommand")) continue;
            uRLConnection = cookieJar.getAllCookiesFromPage(form2.getCGI(), null, false);
            StringBuffer stringBuffer2 = Http.receivePage(uRLConnection);
            if (JConfig.queryConfiguration("debug.filedump", "false").equals("true")) {
                ebayServer.dump2File("sign_in-a2.html", stringBuffer2);
            }
            if ((form = (jHTML2 = new JHTML(stringBuffer2)).getFormWithInput("pass")) == null) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CookieJar getSignInCookie(CookieJar cookieJar, String string, String string2) {
        boolean bl = JConfig.queryConfiguration(this.siteId + ".adult", "false").equals("true");
        CookieJar cookieJar2 = cookieJar == null ? new CookieJar() : cookieJar;
        String string3 = Externalized.getString("ebayServer.signInPage");
        if (bl) {
            string3 = Externalized.getString("ebayServer.adultPageLogin");
        }
        URLConnection uRLConnection = cookieJar2.getAllCookiesFromPage(string3, null, false);
        try {
            JHTML jHTML;
            JHTML jHTML2;
            JHTML.Form form;
            StringBuffer stringBuffer = Http.receivePage(uRLConnection);
            if (JConfig.queryConfiguration("debug.filedump", "false").equals("true")) {
                ebayServer.dump2File("sign_in-1.html", stringBuffer);
            }
            if ((form = (jHTML2 = new JHTML(stringBuffer)).getFormWithInput("pass")) == null) return cookieJar2;
            form.setText("userid", string);
            form.setText("pass", string2);
            uRLConnection = cookieJar2.getAllCookiesFromPage(form.getCGI(), null, false);
            if (bl) {
                if (this.getAdultRedirector(uRLConnection, cookieJar2)) {
                    MQFactory.getConcrete("Swing").enqueue("VALID LOGIN");
                    return cookieJar2;
                }
                ErrorManagement.logMessage("Disabling 'adult' mode and retrying.");
                JConfig.setConfiguration(this.siteId + ".adult", "false");
                cookieJar2 = this.getSignInCookie(cookieJar2, string, string2);
                if (cookieJar2 != null) return cookieJar2;
                JConfig.setConfiguration(this.siteId + ".adult", "true");
                return cookieJar2;
            }
            StringBuffer stringBuffer2 = Http.receivePage(uRLConnection);
            if (JConfig.queryConfiguration("debug.filedump", "false").equals("true")) {
                ebayServer.dump2File("sign_in-2.html", stringBuffer2);
            }
            if (this.checkSecurityConfirmation(jHTML = new JHTML(stringBuffer2))) {
                return null;
            }
            MQFactory.getConcrete("Swing").enqueue("VALID LOGIN");
            return cookieJar2;
        }
        catch (IOException iOException) {
            MQFactory.getConcrete("Swing").enqueue("INVALID LOGIN " + iOException.getMessage());
            ErrorManagement.handleException("Couldn't sign in!", iOException);
            return null;
        }
        catch (CaptchaException captchaException) {
            MQFactory.getConcrete("Swing").enqueue("INVALID LOGIN eBay's increased security monitoring has been triggered, JBidwatcher cannot log in for a while.");
            this.notifySecurityIssue();
            ErrorManagement.handleException("Couldn't sign in, captcha interference!", captchaException);
            return null;
        }
    }

    private void notifySecurityIssue() {
        MQFactory.getConcrete("Swing").enqueue("NOTIFY eBay's security monitoring has been triggered, and temporarily requires\nhuman intervention to log in.  JBidwatcher will not be able to log in\n(including bids, snipes, and retrieving My eBay items) until this is fixed.");
    }

    private void notifyBadSignin() {
        MQFactory.getConcrete("Swing").enqueue("NOTIFY Your sign in information appears to be incorrect, according to\neBay.  Please fix it in the eBay tab in the Configuration Manager.");
    }

    private boolean checkSecurityConfirmation(JHTML jHTML) throws IOException, CaptchaException {
        if (jHTML.grep("Security.Measure") != null || jHTML.grep("Enter verification code:") != null || jHTML.grep("please enter the verification code") != null) {
            ErrorManagement.logMessage("eBay's security monitoring has been triggered, and temporarily requires human intervention to log in.");
            this.mBadPassword = this.getPassword();
            this.mBadUsername = this.getUserId();
            throw new CaptchaException("Failed eBay security check/captcha; verification code required.");
        }
        if (jHTML.grep("Your sign in information is not valid.") != null) {
            ErrorManagement.logMessage("Your sign in information is not valid.");
            MQFactory.getConcrete("Swing").enqueue("INVALID LOGIN Your sign in information is not correct.  Fix it in the eBay tab in the Configuration Manager.");
            this.notifyBadSignin();
            this.mBadPassword = this.getPassword();
            this.mBadUsername = this.getUserId();
            return true;
        }
        return false;
    }

    public synchronized CookieJar getSignInCookie(CookieJar cookieJar) {
        if (this.getPassword().equals(this.mBadPassword) && this.getUserId().equals(this.mBadUsername)) {
            return cookieJar;
        }
        String string = "Getting the sign in cookie.";
        if (JConfig.queryConfiguration("debug.verbose", "false").equals("true")) {
            ErrorManagement.logDebug(string);
        }
        MQFactory.getConcrete("Swing").enqueue(string);
        CookieJar cookieJar2 = this.getSignInCookie(cookieJar, this.getUserId(), this.getPassword());
        String string2 = "Done getting the sign in cookie.";
        MQFactory.getConcrete("Swing").enqueue(string2);
        if (JConfig.queryConfiguration("debug.verbose", "false").equals("true")) {
            ErrorManagement.logDebug(string2);
        }
        return cookieJar2;
    }

    private static int addAllItemsOnPage(JHTML jHTML, String string, boolean bl) {
        List list = jHTML.getAllURLsOnPage(true);
        int n = 0;
        if (list == null) {
            ErrorManagement.logDebug("No items on page!");
        } else {
            ListIterator listIterator = list.listIterator();
            while (listIterator.hasNext()) {
                boolean bl2;
                String string2;
                String string3 = (String)listIterator.next();
                string3 = string3.replaceAll("\n|\r", "");
                if (listIterator.hasNext()) {
                    string2 = (String)listIterator.next();
                    string2 = string2.replaceAll("\n|\r", "");
                    bl2 = true;
                } else {
                    string2 = "";
                    bl2 = false;
                }
                if (string2.equals(string3)) {
                    if (!bl2) continue;
                    listIterator.previous();
                    continue;
                }
                if (bl2) {
                    listIterator.previous();
                }
                string3 = string3.trim();
                AuctionServer auctionServer = AuctionServerManager.getInstance().getServerForUrlString(string3);
                String string4 = auctionServer.extractIdentifierFromURLString(string3);
                if (string4 == null) continue;
                MQFactory.getConcrete("drop").enqueue(new DropQObject(string3.trim(), string, bl));
                ++n;
            }
        }
        return n;
    }

    public void cancelSearches() {
        MQFactory.getConcrete(eBayServerName).clear();
    }

    public void addSearches(SearchManagerInterface searchManagerInterface) {
        String string = JConfig.queryConfiguration(this.siteId + ".synchronize", "false");
        if (!string.equals("ignore")) {
            this._my_ebay = string.equalsIgnoreCase("true") ? searchManagerInterface.addSearch("My Items", "My eBay", "", eBayServerName, 1, 1L) : searchManagerInterface.addSearch("My Items", "My eBay", "", eBayServerName, -1, 1L);
            JConfig.setConfiguration(this.siteId + ".synchronize", "ignore");
        }
    }

    public List getBidderNames(AuctionEntry auctionEntry) {
        JHTML jHTML;
        String string;
        CookieJar cookieJar = this.getNecessaryCookie(false);
        String string2 = null;
        if (cookieJar != null) {
            string2 = cookieJar.toString();
        }
        if ((string = (jHTML = new JHTML(this.eBayProtocol + Externalized.getString("ebayServer.bidderNamesHost") + this.eBayFile + Externalized.getString("ebayServer.viewBidsCGI") + auctionEntry.getIdentifier(), string2, this)).getNextContentAfterContent(Externalized.getString("ebayServer.bidListPrequel"))) == null) {
            ErrorManagement.logMessage("Problem with loaded page when getting bidder names for auction " + auctionEntry.getIdentifier());
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            if (!arrayList.contains(string)) {
                arrayList.add(string);
            }
            string = jHTML.getNextContent();
            while (string != null && !string.endsWith("PDT") && !string.endsWith("PST")) {
                string = jHTML.getNextContent();
            }
            if (string != null) {
                string = jHTML.getNextContent();
            }
            if (string == null || string.indexOf(Externalized.getString("ebayServer.earlierCheck")) == -1) continue;
            string = null;
        } while (string != null);
        return arrayList;
    }

    private void getSellingItems(String string, String string2) {
        CookieJar cookieJar = this.getNecessaryCookie(false);
        String string3 = null;
        if (cookieJar != null) {
            string3 = cookieJar.toString();
        }
        if (string == null || string.equals("default")) {
            ErrorManagement.logMessage("Cannot load selling pages without at least a userid.");
            return;
        }
        String string4 = this.eBayProtocol + Externalized.getString("ebayServer.sellingListHost") + this.eBayV3File + Externalized.getString("ebayServer.listedCGI") + Externalized.getString("ebayServer.sortOrderCGI") + Externalized.getString("ebayServer.userIdCGI") + string;
        JHTML jHTML = new JHTML(string4, string3, this);
        if (jHTML.isLoaded()) {
            int n = ebayServer.addAllItemsOnPage(jHTML, string2, string.equals(this.getUserId()));
            MQFactory.getConcrete("Swing").enqueue("Loaded " + n + " items for seller " + string);
        } else {
            ErrorManagement.logMessage("getSellingItems failed!");
        }
    }

    private void getMyEbayItems(String string) {
        Object object;
        Object object2;
        String string2 = this.getUserId();
        CookieJar cookieJar = this.getNecessaryCookie(false);
        String string3 = null;
        if (cookieJar != null) {
            string3 = cookieJar.toString();
        }
        if (string2 == null || string2.equals("default")) {
            ErrorManagement.logMessage("Cannot load My eBay pages without a userid and password.");
            return;
        }
        int n = 0;
        boolean bl = false;
        while (!bl) {
            String string4 = Externalized.getString("ebayServer.bigWatchingURL1") + this.getUserId() + Externalized.getString("ebayServer.bigWatchingURL2") + n + Externalized.getString("ebayServer.bigWatchingURL3") + (n + 1);
            ErrorManagement.logDebug("Loading page " + n + " of My eBay for user " + this.getUserId());
            ErrorManagement.logDebug("URL: " + string4);
            object2 = new JHTML(string4, string3, this);
            ebayServer.addAllItemsOnPage((JHTML)object2, string, true);
            object = ((JHTML)object2).getNextContentAfterRegex("Page " + (n + 1));
            if (object == null || !((String)object).startsWith("of ")) {
                bl = true;
            } else {
                try {
                    bl = n + 1 == Integer.parseInt(((String)object).substring(3));
                }
                catch (NumberFormatException numberFormatException) {
                    bl = true;
                }
            }
            if (bl) continue;
            ++n;
        }
        boolean bl2 = false;
        while (!bl2) {
            object2 = Externalized.getString("ebayServer.biddingURL");
            ErrorManagement.logDebug("Loading page: " + (String)object2);
            object = new JHTML((String)object2, string3, this);
            ebayServer.addAllItemsOnPage((JHTML)object, string, true);
            bl2 = true;
        }
    }

    private static boolean deleteRange(StringBuffer stringBuffer, int n, int n2) {
        if (n < n2 && n != -1 && n2 != -1) {
            stringBuffer.delete(n, n2);
            return true;
        }
        return false;
    }

    private static boolean deleteFirstToLast(StringBuffer stringBuffer, String string, String string2, String string3, String string4) {
        int n;
        String string5 = stringBuffer.toString();
        int n2 = string5.indexOf(string);
        if (n2 == -1) {
            n2 = string5.indexOf(string2);
        }
        if (n2 > (n = string5.lastIndexOf(string3))) {
            n = string5.lastIndexOf(string4);
        }
        return ebayServer.deleteRange(stringBuffer, n2, n);
    }

    private static boolean deleteRegexPair(StringBuffer stringBuffer, String string, String string2) {
        String string3 = stringBuffer.toString();
        Regex regex = new Regex(string);
        Regex regex2 = new Regex(string2);
        regex.setIgnoreCase(true);
        regex2.setIgnoreCase(true);
        regex.optimize();
        regex2.optimize();
        if (regex.search(string3) && regex2.searchFrom(string3, regex.matchedFrom() + 1)) {
            int n = regex.matchedFrom();
            int n2 = regex2.matchedTo();
            return ebayServer.deleteRange(stringBuffer, n, n2);
        }
        return false;
    }

    private static void killScripts(StringBuffer stringBuffer) {
        boolean bl;
        while (bl = ebayServer.deleteRegexPair(stringBuffer, Externalized.getString("ebayServer.stripScript"), Externalized.getString("ebayServer.stripScriptEnd"))) {
        }
    }

    private static void internalCleanup(StringBuffer stringBuffer) {
        boolean bl;
        ebayServer.killScripts(stringBuffer);
        while (bl = ebayServer.deleteRegexPair(stringBuffer, Externalized.getString("ebayServer.stripComment"), Externalized.getString("ebayServer.stripCommentEnd"))) {
        }
    }

    public void cleanup(StringBuffer stringBuffer) {
        ebayServer.internalCleanup(stringBuffer);
    }

    private void doMyEbaySynchronize(String string) {
        MQFactory.getConcrete("Swing").enqueue("Synchronizing with My eBay...");
        this.getMyEbayItems(string);
        MQFactory.getConcrete("Swing").enqueue("Done synchronizing with My eBay...");
    }

    private void doGetSelling(Object object, String string) {
        String string2 = ((Searcher)object).getSearch();
        MQFactory.getConcrete("Swing").enqueue("Getting Selling Items for " + string2);
        this.getSellingItems(string2, string);
        MQFactory.getConcrete("Swing").enqueue("Done Getting Selling Items for " + string2);
    }

    protected static void doLoadAuctions() {
        OptionUI optionUI = new OptionUI();
        String string = optionUI.promptString(null, "Enter the URL to load auctions from", "Loading Auctions");
        if (string == null) {
            return;
        }
        MQFactory.getConcrete(eBayServerName).enqueue(new AuctionQObject(0, string, null));
    }

    private class SnipeListener
    implements MessageQueue.Listener {
        private SnipeListener() {
        }

        public void messageAction(Object object) {
            AuctionQObject auctionQObject = (AuctionQObject)object;
            if (auctionQObject.getCommand() == 9) {
                Snipe snipe = (Snipe)auctionQObject.getData();
                int n = snipe.fire();
                switch (n) {
                    case 1: {
                        long l = snipe.getItem().getEndDate().getTime() - ebayServer.this._etqm.getCurrentTime();
                        if (l <= 3000L) break;
                        long l2 = l / 10L * 2L;
                        if (l2 < 3000L) {
                            l2 = 3000L;
                        }
                        ebayServer.this._etqm.erase(object);
                        ebayServer.this._etqm.add(object, "snipes", ebayServer.this._etqm.getCurrentTime() + l2);
                        break;
                    }
                    case 2: {
                        ebayServer.this._etqm.erase(object);
                    }
                    case 3: {
                        ebayServer.this.snipeMap.remove(snipe.getItem().getIdentifier());
                        break;
                    }
                }
            }
        }
    }

    public class JConfigEbayTab
    extends JConfigTab {
        JCheckBox adultBox;
        JCheckBox synchBox = null;
        JTextField username;
        JTextField password;
        JComboBox siteSelect;

        public String getTabName() {
            return ebayServer.eBayDisplayName;
        }

        public void cancel() {
        }

        public boolean apply() {
            int n = this.siteSelect.getSelectedIndex();
            String string = JConfig.queryConfiguration(ebayServer.this.siteId + ".adult");
            JConfig.setConfiguration(ebayServer.this.siteId + ".adult", this.adultBox.isSelected() ? "true" : "false");
            String string2 = JConfig.queryConfiguration(ebayServer.this.siteId + ".adult");
            if (JConfig.queryConfiguration("prompt.ebay_synchronize", "false").equals("true")) {
                JConfig.setConfiguration(ebayServer.this.siteId + ".synchronize", this.synchBox.isSelected() ? "true" : "false");
                if (ebayServer.this._my_ebay == null) {
                    ebayServer.this._my_ebay = SearchManager.getInstance().getSearchByName("My eBay");
                }
                if (ebayServer.this._my_ebay != null) {
                    if (this.synchBox.isSelected()) {
                        ebayServer.this._my_ebay.enable();
                    } else {
                        ebayServer.this._my_ebay.disable();
                    }
                }
            }
            String string3 = JConfig.queryConfiguration(ebayServer.this.siteId + ".user");
            JConfig.setConfiguration(ebayServer.this.siteId + ".user", this.username.getText());
            String string4 = JConfig.queryConfiguration(ebayServer.this.siteId + ".user");
            String string5 = JConfig.queryConfiguration(ebayServer.this.siteId + ".password");
            JConfig.setConfiguration(ebayServer.this.siteId + ".password", this.password.getText());
            String string6 = JConfig.queryConfiguration(ebayServer.this.siteId + ".password");
            if (n != -1) {
                JConfig.setConfiguration(ebayServer.this.siteId + ".browse.site", Integer.toString(n));
            }
            if (!(string5 != null && string6.equals(string5) && string3 != null && string4.equals(string3) && string != null && string2.equals(string))) {
                MQFactory.getConcrete(ebayServer.eBayServerName).enqueue(new AuctionQObject(4, "Update login cookie", null));
            }
            return true;
        }

        public void updateValues() {
            String string = JConfig.queryConfiguration(ebayServer.this.siteId + ".adult", "false");
            this.adultBox.setSelected(string.equals("true"));
            if (JConfig.queryConfiguration("prompt.ebay_synchronize", "false").equals("true")) {
                String string2 = JConfig.queryConfiguration(ebayServer.this.siteId + ".synchronize", "false");
                if (string2.equals("ignore")) {
                    if (ebayServer.this._my_ebay != null) {
                        this.synchBox.setSelected(ebayServer.this._my_ebay.isEnabled());
                    }
                } else {
                    this.synchBox.setSelected(string2.equals("true"));
                }
            }
            this.username.setText(JConfig.queryConfiguration(ebayServer.this.siteId + ".user", "default"));
            this.password.setText(JConfig.queryConfiguration(ebayServer.this.siteId + ".password", "default"));
        }

        private JPanel buildUsernamePanel() {
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("eBay User ID"));
            jPanel.setLayout(new BorderLayout());
            this.username = new JTextField();
            this.username.addMouseListener(JPasteListener.getInstance());
            this.username.setText(JConfig.queryConfiguration(ebayServer.this.siteId + ".user", "default"));
            this.username.setEditable(true);
            this.username.getAccessibleContext().setAccessibleName("User name to log into eBay");
            this.password = new JPasswordField(JConfig.queryConfiguration(ebayServer.this.siteId + ".password"));
            this.password.addMouseListener(JPasteListener.getInstance());
            this.password.setEditable(true);
            this.password.getAccessibleContext().setAccessibleName("eBay Password");
            this.password.getAccessibleContext().setAccessibleDescription("This is the user password to log into eBay.");
            Box box = Box.createVerticalBox();
            box.add(JConfigEbayTab.makeLine(new JLabel("Username: "), this.username));
            box.add(JConfigEbayTab.makeLine(new JLabel("Password:  "), this.password));
            jPanel.add(box);
            return jPanel;
        }

        private JPanel buildCheckboxPanel() {
            String string = JConfig.queryConfiguration(ebayServer.this.siteId + ".adult", "false");
            String string2 = JConfig.queryConfiguration(ebayServer.this.siteId + ".synchronize", "false");
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("General eBay Options"));
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            this.adultBox = new JCheckBox("Registered adult");
            this.adultBox.setSelected(string.equals("true"));
            jPanel.add(this.adultBox);
            if (JConfig.queryConfiguration("prompt.ebay_synchronize", "false").equals("true")) {
                this.synchBox = new JCheckBox("Synchronize w/ My eBay");
                if (ebayServer.this._my_ebay == null) {
                    ebayServer.this._my_ebay = SearchManager.getInstance().getSearchByName("My eBay");
                }
                if (string2.equals("ignore")) {
                    if (ebayServer.this._my_ebay != null) {
                        this.synchBox.setSelected(ebayServer.this._my_ebay.isEnabled());
                    }
                } else {
                    this.synchBox.setSelected(string2.equals("true"));
                }
                jPanel.add(this.synchBox);
            } else {
                jPanel.add(new JLabel("     To have JBidwatcher regularly retrieve auctions listed on your My eBay"));
                jPanel.add(new JLabel("     page, go to the Search Manager and enable the search also named 'My eBay'."));
            }
            return jPanel;
        }

        private JPanel buildBrowseTargetPanel() {
            int n;
            JPanel jPanel = new JPanel();
            jPanel.setBorder(BorderFactory.createTitledBorder("Browse target"));
            jPanel.setLayout(new BorderLayout());
            String string = JConfig.queryConfiguration(ebayServer.this.siteId + ".browse.site", "0");
            try {
                n = Integer.parseInt(string);
            }
            catch (Exception exception) {
                n = 0;
            }
            this.siteSelect = new JComboBox<String>(ebayServer.this.site_choices);
            this.siteSelect.setSelectedIndex(n);
            jPanel.add((Component)JConfigEbayTab.makeLine(new JLabel("Browse to site: "), this.siteSelect), "North");
            return jPanel;
        }

        public JConfigEbayTab() {
            this.setLayout(new BorderLayout());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)JConfigEbayTab.panelPack(this.buildCheckboxPanel()), "North");
            jPanel.add((Component)JConfigEbayTab.panelPack(this.buildUsernamePanel()), "Center");
            this.add((Component)jPanel, "North");
            this.add((Component)JConfigEbayTab.panelPack(this.buildBrowseTargetPanel()), "Center");
        }
    }

    class ebayServerMenu
    extends ServerMenu {
        public void initialize() {
            this.addMenuItem("Search eBay", 'F');
            this.addMenuItem("Get My eBay Items", 'M');
            this.addMenuItem("Get Selling Items", 'S');
            this.addMenuItem("Refresh eBay session", "Update login cookie", 'U');
            if (JConfig.debugging) {
                this.addMenuItem("[Dump eBay activity queue]", 'Q');
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Search eBay")) {
                MQFactory.getConcrete("user").enqueue("SEARCH");
            } else {
                MQFactory.getConcrete(ebayServer.eBayServerName).enqueue(new AuctionQObject(4, string, null));
            }
        }

        protected ebayServerMenu(String string, char c) {
            super(string, c);
        }
    }

    protected class ebayAuction
    extends SpecificAuction {
        String _bidCountScript = null;
        String _startComment = null;
        private static final int TITLE_LENGTH = 60;
        private static final int HIGH_BIT_SET = 128;
        private final Pattern p = Pattern.compile(Externalized.getString("ebayServer.thumbSearch"), 42);
        private final Pattern p2 = Pattern.compile(Externalized.getString("ebayServer.thumbSearch2"), 42);
        private String potentialThumbnail = null;

        protected ebayAuction() {
        }

        private void checkThumb(StringBuffer stringBuffer) {
            Matcher matcher = this.p.matcher(stringBuffer);
            if (matcher.find()) {
                this.potentialThumbnail = matcher.group(1);
            } else {
                matcher = this.p2.matcher(stringBuffer);
                if (matcher.find()) {
                    this.potentialThumbnail = matcher.group(1);
                }
            }
        }

        public void cleanup(StringBuffer stringBuffer) {
            this.checkThumb(stringBuffer);
            ebayServer.deleteFirstToLast(stringBuffer, ebayServer.this.eBayDescStart, ebayServer.this.eBayMotorsDescStart, ebayServer.this.eBayDescEnd, ebayServer.this.eBayClosedDescEnd);
            ebayServer.deleteFirstToLast(stringBuffer, Externalized.getString("ebayServer.descStart"), ebayServer.this.eBayMotorsDescStart, Externalized.getString("ebayServer.descEnd"), ebayServer.this.eBayClosedDescEnd);
            String string = stringBuffer.toString();
            Regex regex = new Regex(Externalized.getString("ebayServer.startedRegex"));
            regex.search(string);
            this._startComment = regex.stringMatched(1);
            Regex regex2 = new Regex(Externalized.getString("ebayServer.bidCountRegex"));
            regex2.search(string);
            this._bidCountScript = regex2.stringMatched(1);
            ebayServer.internalCleanup(stringBuffer);
        }

        boolean checkValidTitle(String string) {
            if (string.startsWith(Externalized.getString("ebayServer.liveAuctionsTitle"))) {
                ErrorManagement.logMessage("JBidWatcher cannot handle live auctions!");
                return false;
            }
            if (string.startsWith(Externalized.getString("ebayServer.greatCollectionsTitle"))) {
                ErrorManagement.logMessage("JBidWatcher cannot handle Great Collections items yet.");
                return false;
            }
            for (int i = 0; i < ebayServer.this.eBayTitles.length; ++i) {
                if (!string.matches(ebayServer.this.eBayTitles[i])) continue;
                return true;
            }
            return false;
        }

        private Currency getUSCurrency(Currency currency, JHTML jHTML) {
            Currency currency2 = zeroDollars;
            if (currency != null && !currency.isNull()) {
                if (currency.getCurrencyType() == 1) {
                    currency2 = currency;
                } else {
                    String string = Externalized.getString("ebayServer.USD");
                    String string2 = "";
                    int n = 0;
                    int n2 = -1;
                    do {
                        string2 = jHTML.getNextContent();
                        string2 = AuctionServer.stripHigh(string2, "");
                        n2 = string2.indexOf(string);
                    } while (n++ < 6 && n2 == -1);
                    if (n2 != -1) {
                        string2 = string2.substring(n2);
                        currency2 = Currency.getCurrency(string2);
                    }
                }
            }
            return currency2;
        }

        int getDigits(String string) {
            Regex regex = new Regex("([0-9]+)");
            regex.search(string);
            String string2 = regex.stringMatched();
            if (string2 != null) {
                return Integer.parseInt(string2);
            }
            return -1;
        }

        private void handle_bad_title(String string) {
            if (string.indexOf(ebayServer.this.eBayTemporarilyUnavailable) != -1) {
                MQFactory.getConcrete("Swing").enqueue("LINK DOWN eBay (or the link to eBay) appears to be down.");
                MQFactory.getConcrete("Swing").enqueue("eBay (or the link to eBay) appears to be down for the moment.");
            } else if (string.indexOf(Externalized.getString("ebayServer.invalidItem")) != -1) {
                ErrorManagement.logDebug("Found bad/deleted item.");
            } else {
                ErrorManagement.logDebug("Failed to load auction title from header: \"" + string + '\"');
            }
        }

        private String buildTitle(JHTML jHTML) {
            htmlToken htmlToken2;
            jHTML.reset();
            jHTML.getNextTag();
            StringBuffer stringBuffer = new StringBuffer(60);
            do {
                if ((htmlToken2 = jHTML.nextToken()).getTokenType() != 4) continue;
                stringBuffer.append(htmlToken2.getToken());
            } while (htmlToken2.getTokenType() != 2 || !htmlToken2.getToken().equalsIgnoreCase("/title"));
            return stringBuffer.toString();
        }

        private void load_shipping_insurance(Currency currency) {
            String string = this._htmlDocument.getNextContentAfterRegex(ebayServer.this.eBayShippingRegex);
            Regex regex = new Regex("(([0-9]+\\.[0-9]+|(?i)free))");
            if (string != null && !regex.search(string) && (string = this._htmlDocument.getNextContent()) != null) {
                regex.search(string);
            }
            if (string != null) {
                string = regex.stringMatched();
            }
            String string2 = this._htmlDocument.getPrevContent(2);
            String string3 = this._htmlDocument.getNextContentAfterRegex(ebayServer.this.eBayInsurance);
            String string4 = this._htmlDocument.getNextContent();
            boolean bl = this._insurance_optional = string4 == null || string4.toLowerCase().indexOf(Externalized.getString("ebayServer.requiredInsurance")) == -1;
            if (string3 != null) {
                string3 = string3.equals("-") || string3.equals("--") ? null : string3.trim();
            }
            if (string2 != null && !string2.equals(ebayServer.this.eBayPayInstructions)) {
                if (string != null) {
                    string = string.equals("-") ? null : string.trim();
                }
            } else {
                string = null;
            }
            this._shipping = string != null ? (string.equalsIgnoreCase("free") ? Currency.getCurrency(currency.fullCurrencyName(), "0.0") : Currency.getCurrency(currency.fullCurrencyName(), string)) : Currency.NoValue();
            this._insurance = Currency.getCurrency(string3);
        }

        private void load_buy_now() {
            this._buy_now = Currency.NoValue();
            this._buy_now_us = zeroDollars;
            String string = this._htmlDocument.getNextContentAfterRegexIgnoring(ebayServer.this.eBayPrice, "([Ii]tem.[Nn]umber|^\\s*[0-9]+\\s*$)");
            if (string != null) {
                string = string.trim();
            }
            if (string != null && string.length() != 0) {
                this._buy_now = Currency.getCurrency(string);
                this._buy_now_us = this.getUSCurrency(this._buy_now, this._htmlDocument);
            }
        }

        private String getEndDate(String string) {
            String string2 = null;
            if (dateRegex.search(string)) {
                string2 = dateRegex.stringMatched(2);
            }
            return string2;
        }

        private String decodeLatin(String string) {
            if (!Platform.isMac()) {
                return string;
            }
            try {
                return new String(string.getBytes(), "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return string;
            }
        }

        private Object ensureSafeValue(Object object, Object object2, Object object3) {
            return object == object3 ? object2 : object;
        }

        private String getResult(JHTML jHTML, String string, int n) {
            Regex regex = new Regex(string);
            String string2 = jHTML.grep(regex);
            if (string2 != null) {
                if (n == 0) {
                    return string2;
                }
                return regex.stringMatched(n);
            }
            return null;
        }

        private void loadOptionalInformation(JHTML jHTML) {
            try {
                String string;
                String string2;
                String string3;
                String string4 = this.getResult(jHTML, Externalized.getString("ebayServer.feedbackRegex"), 1);
                if (string4 != null && AuctionServer.isNumberOnly(string4)) {
                    this._feedback = Integer.parseInt(string4);
                }
                if ((string3 = this.getResult(jHTML, Externalized.getString("ebayServer.feedbackPercentageRegex"), 1)) != null) {
                    this._postivePercentage = string3;
                }
                if ((string2 = jHTML.getNextContentAfterRegex(Externalized.getString("ebayServer.itemLocationRegex"))) != null) {
                    this._itemLocation = string2;
                }
                if ((string = this.getResult(jHTML, Externalized.getString("ebayServer.paypalMatcherRegex"), 0)) != null) {
                    this._paypal = true;
                } else {
                    String string5 = jHTML.getNextContentAfterRegex("PayPal.?");
                    if (string5 != null) {
                        if (string5.indexOf("preferred") != -1) {
                            this._paypal = true;
                        }
                        if (string5.indexOf("accepted") != -1) {
                            this._paypal = true;
                        }
                    }
                    String string6 = jHTML.getNextContentAfterRegex("Payment methods:?");
                    for (int i = 0; i < 3 && !this._paypal; ++i) {
                        if (string6 != null && string6.equalsIgnoreCase("paypal")) {
                            this._paypal = true;
                            continue;
                        }
                        string6 = jHTML.getNextContent();
                    }
                }
            }
            catch (Throwable throwable) {
                ErrorManagement.logDebug(throwable.getMessage());
            }
        }

        public boolean parseAuction(AuctionEntry auctionEntry) {
            String string = this.checkTitle();
            if (string == null) {
                this.finish();
                return false;
            }
            this._quantity = this.getNumberFromLabel(this._htmlDocument, ebayServer.this.eBayQuantity, Externalized.getString("ebayServer.postTitleIgnore"));
            this._fixed_price = false;
            this._numBids = this.getBidCount(this._htmlDocument, this._quantity);
            try {
                this.load_buy_now();
            }
            catch (Exception exception) {
                ErrorManagement.handleException("Buy It Now Loading error", exception);
            }
            if (this._fixed_price) {
                this.establishCurrentBidFixedPrice(auctionEntry);
            } else {
                Currency currency = this.establishCurrentBid(auctionEntry);
                this._outbid = this._htmlDocument.grep(Externalized.getString("ebayServer.outbid")) != null;
                this.setMaxBidFromServer(auctionEntry, currency);
            }
            if (this._minBid == null && this._buy_now != null && !this._buy_now.isNull()) {
                this._minBid = this._buy_now;
            }
            try {
                this.load_shipping_insurance(this._curBid);
            }
            catch (Exception exception) {
                ErrorManagement.handleException("Shipping / Insurance Loading Failed", exception);
            }
            if (this.checkSeller(auctionEntry)) {
                return false;
            }
            this.checkDates(string, auctionEntry);
            this.checkHighBidder();
            this.checkReserve();
            this.checkPrivate();
            this.loadOptionalInformation(this._htmlDocument);
            this.checkThumbnail();
            this.finish();
            return true;
        }

        private String checkTitle() {
            boolean bl;
            String string = this._htmlDocument.getFirstContent();
            if (string == null) {
                string = ebayServer.this.eBayTemporarilyUnavailable;
            }
            if (string.equals(ebayServer.this.eBayAdultLoginPageTitle) || string.indexOf("Terms of Use: ") != -1) {
                bl = JConfig.queryConfiguration(ebayServer.this.siteId + ".adult", "false").equals("true");
                if (bl) {
                    ebayServer.this.getNecessaryCookie(true);
                } else {
                    ErrorManagement.logDebug("Failed to load adult item, user not registered as Adult.  Check eBay configuration.");
                }
                string = null;
            }
            if (string != null && !this.checkValidTitle(string)) {
                this.handle_bad_title(string);
                string = null;
            }
            if (string != null) {
                Regex regex;
                MQFactory.getConcrete("Swing").enqueue("LINK UP");
                bl = false;
                if (string.matches(Externalized.getString("ebayServer.ebayMotorsTitle"))) {
                    bl = true;
                }
                if (this.doesLabelExist(Externalized.getString("ebayServer.ebayMotorsTitle"))) {
                    bl = true;
                }
                this._end = null;
                this._title = null;
                if ((string.matches(Externalized.getString("ebayServer.titleEbay2")) || string.matches(Externalized.getString("ebayServer.titleMotors2"))) && (regex = new Regex(Externalized.getString("ebayServer.titleMatch"))).search(string)) {
                    this._title = this.decodeLatin(regex.stringMatched(1));
                    String string2 = regex.stringMatched(4);
                    if (string2 != null) {
                        this._end = ebayServer.this.figureDate(string2, ebayServer.this.eBayDateFormat, true);
                    }
                }
                if (this._title == null) {
                    boolean bl2 = false;
                    int n = string.indexOf(") - ");
                    if (n == -1) {
                        n = string.indexOf(") -");
                        bl2 = true;
                    }
                    this._title = bl2 ? this.decodeLatin(this.buildTitle(this._htmlDocument)) : this.decodeLatin(string.substring(n + 4).trim());
                }
                if (this._title.length() == 0) {
                    this._title = "(bad title)";
                }
                this._title = JHTML.deAmpersand(this._title);
                if (bl) {
                    this.extractMotorsTitle();
                }
            } else {
                string = null;
            }
            return string;
        }

        private void checkDates(String string, AuctionEntry auctionEntry) {
            String string2;
            this._start = ebayServer.this.figureDate(this._htmlDocument.getNextContentAfterRegexIgnoring(ebayServer.this.eBayStartTime, Externalized.getString("ebayServer.postTitleIgnore")), ebayServer.this.eBayDateFormat, false);
            if (this._start == null) {
                this._start = ebayServer.this.figureDate(this._startComment, ebayServer.this.eBayDateFormat, false);
            }
            this._start = (Date)this.ensureSafeValue(this._start, auctionEntry != null ? auctionEntry.getStartDate() : null, null);
            if (this._end == null) {
                string2 = this.getEndDate(string);
                this._end = ebayServer.this.figureDate(string2, ebayServer.this.eBayDateFormat, true);
            }
            if (this._end == null) {
                this._end = ebayServer.this.figureDate(this._htmlDocument.getNextContentAfterRegex(Externalized.getString("ebayServer.endsPrequel")), ebayServer.this.eBayDateFormat, true);
                if (this._end == null) {
                    string2 = this._htmlDocument.getNextContent().replaceAll("[()]", "");
                    this._end = ebayServer.this.figureDate(string2, ebayServer.this.eBayDateFormat, true);
                }
            }
            this._end = (Date)this.ensureSafeValue(this._end, auctionEntry != null ? auctionEntry.getEndDate() : null, null);
            if (this._end != null) {
                if (this._end.getTime() > System.currentTimeMillis() && auctionEntry != null) {
                    auctionEntry.setEnded(false);
                    auctionEntry.setSticky(false);
                }
            } else {
                if (auctionEntry != null) {
                    this._end = auctionEntry.getEndDate();
                }
                if (this._htmlDocument.grep(ebayServer.this.eBayItemEnded) != null) {
                    if (auctionEntry != null) {
                        auctionEntry.setEnded(true);
                    }
                    this._end = new Date();
                } else if (this._fixed_price) {
                    string2 = this._htmlDocument.getNextContentAfterContent("Duration:");
                    if (string2 != null) {
                        String string3 = string2.replaceAll("[^0-9]", "");
                        long l = Long.parseLong(string3);
                        if (this._start != null && !this._start.equals(Constants.LONG_AGO)) {
                            long l2 = this._start.getTime() + 86400000L * l;
                            this._end = new Date(l2);
                        } else {
                            this._end = Constants.FAR_FUTURE;
                        }
                    } else {
                        ErrorManagement.logMessage("Setting auction #" + this._identifier + " to be a 'Far Future' listing, as it has no date info.");
                        this._end = Constants.FAR_FUTURE;
                    }
                }
            }
            if (this._start == null) {
                this._start = Constants.LONG_AGO;
            }
            if (this._end == null) {
                this._end = Constants.FAR_FUTURE;
            }
        }

        private void setMaxBidFromServer(AuctionEntry auctionEntry, Currency currency) {
            if (auctionEntry != null && !currency.isNull()) {
                try {
                    if (!auctionEntry.isBidOn() || auctionEntry.getBid().less(currency)) {
                        auctionEntry.setBid(currency);
                    }
                }
                catch (Currency.CurrencyTypeException currencyTypeException) {
                    ErrorManagement.handleException("eBay says my max bid is a different type of currency than I have stored!", currencyTypeException);
                }
            }
        }

        private Currency establishCurrentBid(AuctionEntry auctionEntry) {
            Regex regex;
            String string;
            String string2 = this._htmlDocument.getNextContentAfterRegex(ebayServer.this.eBayCurrentBid);
            this._curBid = Currency.getCurrency(string2);
            this._us_cur = this.getUSCurrency(this._curBid, this._htmlDocument);
            if ((this._curBid == null || this._curBid.isNull()) && this._quantity > 1) {
                this._curBid = Currency.getCurrency(this._htmlDocument.getNextContentAfterContent(ebayServer.this.eBayLowestBid));
                this._us_cur = this.getUSCurrency(this._curBid, this._htmlDocument);
            }
            this._minBid = Currency.getCurrency(this._htmlDocument.getNextContentAfterContent(ebayServer.this.eBayFirstBid));
            Currency currency = Currency.getCurrency(this._htmlDocument.getNextContentAfterContent(Externalized.getString("ebayServer.yourMaxBid")));
            this._minBid = (Currency)this.ensureSafeValue(this._minBid, auctionEntry != null ? auctionEntry.getMinBid() : Currency.NoValue(), Currency.NoValue());
            this._curBid = (Currency)this.ensureSafeValue(this._curBid, auctionEntry != null ? auctionEntry.getCurBid() : Currency.NoValue(), Currency.NoValue());
            this._us_cur = (Currency)this.ensureSafeValue(this._us_cur, auctionEntry != null ? auctionEntry.getUSCurBid() : zeroDollars, Currency.NoValue());
            if (this._numBids == 0 && (this._minBid == null || this._minBid.isNull())) {
                this._minBid = this._curBid;
            }
            if ((this._minBid == null || this._minBid.isNull()) && (string = this._htmlDocument.grep(Externalized.getString("ebayServer.originalBid"))) != null && (regex = new Regex(Externalized.getString("ebayServer.originalBid"))).search(string)) {
                this._minBid = Currency.getCurrency(regex.stringMatched(1));
            }
            return currency;
        }

        private void establishCurrentBidFixedPrice(AuctionEntry auctionEntry) {
            if (this._buy_now != null && !this._buy_now.isNull()) {
                this._minBid = this._buy_now;
                this._curBid = this._buy_now;
                this._us_cur = this._buy_now_us;
            } else {
                String string = this._htmlDocument.getNextContentAfterRegex(ebayServer.this.eBayCurrentBid);
                this._curBid = Currency.getCurrency(string);
                this._us_cur = this.getUSCurrency(this._curBid, this._htmlDocument);
                this._curBid = (Currency)this.ensureSafeValue(this._curBid, auctionEntry != null ? auctionEntry.getCurBid() : Currency.NoValue(), Currency.NoValue());
                this._us_cur = (Currency)this.ensureSafeValue(this._us_cur, auctionEntry != null ? auctionEntry.getUSCurBid() : zeroDollars, Currency.NoValue());
            }
        }

        private boolean checkSeller(AuctionEntry auctionEntry) {
            this._seller = this._htmlDocument.getNextContentAfterRegex(ebayServer.this.eBaySeller);
            if (this._seller == null) {
                this._seller = this._htmlDocument.getNextContentAfterContent(Externalized.getString("ebayServer.sellerInfoPrequel"), false, true);
            }
            if (this._seller == null) {
                if (this._htmlDocument.grep(Externalized.getString("ebayServer.sellerAway")) != null) {
                    if (auctionEntry != null) {
                        auctionEntry.setLastStatus("Seller away - item unavailable.");
                    }
                    this.finish();
                    return true;
                }
                this._seller = "(unknown)";
            }
            this._seller = this._seller.trim();
            return false;
        }

        private void checkThumbnail() {
            try {
                if (JConfig.queryConfiguration("show.images", "true").equals("true") && !this._no_thumbnail && !this.hasThumbnail()) {
                    MQFactory.getConcrete("thumbnail").enqueue(this);
                }
            }
            catch (Exception exception) {
                ErrorManagement.handleException("Error handling thumbnail loading", exception);
            }
        }

        private void checkPrivate() {
            if (this._highBidder.indexOf(Externalized.getString("ebayServer.keptPrivate")) != -1) {
                this._isPrivate = true;
                this._highBidder = "(private)";
            }
        }

        private void checkReserve() {
            if (this.doesLabelExist(Externalized.getString("ebayServer.reserveNotMet1")) || this.doesLabelExist(Externalized.getString("ebayServer.reserveNotMet2"))) {
                this._isReserve = true;
                this._reserveMet = false;
            } else if (this.doesLabelExist(Externalized.getString("ebayServer.reserveMet1")) || this.doesLabelExist(Externalized.getString("ebayServer.reserveMet2"))) {
                this._isReserve = true;
                this._reserveMet = true;
            }
        }

        private void checkHighBidder() {
            if (this._fixed_price) {
                this._highBidder = this._htmlDocument.getNextContentAfterRegex(ebayServer.this.eBayBuyer);
                if (this._highBidder != null) {
                    this._numBids = 1;
                    this._highBidder = this._highBidder.trim();
                    this._highBidderEmail = this._htmlDocument.getNextContentAfterContent(this._highBidder, true, false);
                    if (this._highBidderEmail != null) {
                        this._highBidderEmail = this._highBidderEmail.trim();
                        if (this._highBidderEmail.charAt(0) == '(' && this._highBidderEmail.charAt(this._highBidderEmail.length() - 1) == ')' && this._highBidderEmail.indexOf(64) != -1) {
                            this._highBidderEmail = this._highBidderEmail.substring(1, this._highBidderEmail.length() - 1);
                        }
                    }
                    if (this._highBidderEmail == null || this._highBidderEmail.equals("(")) {
                        this._highBidderEmail = "(unknown)";
                    }
                } else {
                    this._highBidder = "";
                }
            } else if (this._quantity > 1) {
                this._highBidder = "(dutch)";
                this._isDutch = true;
            } else {
                this._highBidder = "";
                if (this._numBids != 0) {
                    this._highBidder = this._htmlDocument.getNextContentAfterRegex(ebayServer.this.eBayHighBidder);
                    if (this._highBidder != null) {
                        this._highBidder = this._highBidder.trim();
                        this._highBidderEmail = this._htmlDocument.getNextContentAfterContent(this._highBidder, true, false);
                        if (this._highBidderEmail.charAt(0) == '(' && this._highBidderEmail.charAt(this._highBidderEmail.length() - 1) == ')' && this._highBidderEmail.indexOf(64) != -1) {
                            this._highBidderEmail = this._highBidderEmail.substring(1, this._highBidderEmail.length() - 1);
                        }
                    } else {
                        this._highBidder = "(unknown)";
                    }
                }
            }
        }

        private int getBidCount(JHTML jHTML, int n) {
            String string = jHTML.getNextContentAfterRegex(ebayServer.this.eBayBidCount);
            int n2 = 0;
            if (string != null) {
                if (string.equals(Externalized.getString("ebayServer.purchasesBidCount")) || string.endsWith(Externalized.getString("ebayServer.offerRecognition")) || string.equals(Externalized.getString("ebayServer.offerRecognition"))) {
                    this._fixed_price = true;
                    n2 = -1;
                } else {
                    n2 = string.equals(Externalized.getString("ebayServer.bidderListCount")) ? Integer.parseInt(this._bidCountScript) : this.getDigits(string);
                }
            }
            if (string == null || this._numBids == -1) {
                this._highBidder = Externalized.getString("ebayServer.fixedPrice");
                this._fixed_price = true;
                if (this.doesLabelExist(Externalized.getString("ebayServer.hasBeenPurchased")) || this.doesLabelPrefixExist(Externalized.getString("ebayServer.endedEarly"))) {
                    n2 = n;
                    this._end = new Date();
                    if (this._start == null) {
                        this._start = this._end;
                    }
                } else {
                    n2 = 0;
                }
            }
            return n2;
        }

        public ByteBuffer getSiteThumbnail() {
            ByteBuffer byteBuffer = null;
            if (this.potentialThumbnail != null) {
                byteBuffer = this.getThumbnailByURL(this.potentialThumbnail);
            }
            if (byteBuffer == null) {
                byteBuffer = this.getThumbnailById(this.getIdentifier());
            }
            return byteBuffer;
        }

        public ByteBuffer getAlternateSiteThumbnail() {
            return this.getThumbnailById(this.getIdentifier() + "6464");
        }

        private ByteBuffer getThumbnailById(String string) {
            return this.getThumbnailByURL("http://thumbs.ebaystatic.com/pict/" + string + ".jpg");
        }

        private ByteBuffer getThumbnailByURL(String string) {
            ByteBuffer byteBuffer;
            try {
                byteBuffer = ThumbnailManager.downloadThumbnail(new URL(string));
            }
            catch (Exception exception) {
                byteBuffer = null;
            }
            return byteBuffer;
        }

        private int getNumberFromLabel(JHTML jHTML, String string, String string2) {
            String string3 = string2 == null ? jHTML.getNextContentAfterRegex(string) : jHTML.getNextContentAfterRegexIgnoring(string, string2);
            int n = string3 != null ? this.getDigits(string3) : 1;
            return n;
        }

        private void extractMotorsTitle() {
            String string = this._htmlDocument.getContentBeforeContent(ebayServer.this.eBayItemNumber);
            if (string != null) {
                string = string.trim();
            }
            if (!(string == null || string.length() == 0 || this._title.equals(string) || string.length() == 1 && string.charAt(0) >= '\u0080')) {
                this._title = this._title.length() == 0 ? this.decodeLatin(string) : this.decodeLatin(string + " (" + this._title + ')');
            }
        }
    }

    public class CaptchaException
    extends Exception {
        private String _associatedString;

        public CaptchaException(String string) {
            this._associatedString = string;
        }

        public String toString() {
            return this._associatedString;
        }
    }

    private class ImageFetcher
    extends Thread {
        private JHTML mDoc = null;

        public ImageFetcher(JHTML jHTML) {
            this.mDoc = jHTML;
        }

        public void run() {
            this.fetchImagesFromPage(this.mDoc);
        }

        private void fetchImagesFromPage(JHTML jHTML) {
            List list = jHTML.getAllImages();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!srcRegex.search(string)) continue;
                int n = 2;
                do {
                    StringBuffer stringBuffer = null;
                    try {
                        stringBuffer = ebayServer.this.getNecessaryCookie(false).getAllCookiesAndPage(srcRegex.stringMatched(1), "http://offer.ebay.com/ws/eBayISAPI.dll", false);
                    }
                    catch (CookieJar.CookieException cookieException) {
                        // empty catch block
                    }
                    if (stringBuffer == null) {
                        --n;
                        continue;
                    }
                    n = 0;
                } while (n != 0);
            }
        }
    }

    private class eBayTimeQueueManager
    extends TimeQueueManager {
        private eBayTimeQueueManager() {
        }

        public long getCurrentTime() {
            return super.getCurrentTime() + ebayServer.this.getOfficialServerTimeDelta();
        }
    }
}

