/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlme.decoder;

import javazoom.jlme.decoder.BitReserve;
import javazoom.jlme.decoder.BitStream;
import javazoom.jlme.decoder.Header;
import javazoom.jlme.decoder.HuffmanTables;
import javazoom.jlme.decoder.SampleBuffer;
import javazoom.jlme.decoder.SynthesisFilter;

final class LayerIIIDecoder {
    private static final int[] pretab;
    private static final float[] two_to_negative_half_pow;
    private static final float[] t_43;
    private static final float[] TAN12;
    private static final float[][] win;
    private static int[][] reorder_table;
    private static final int SSLIMIT = 18;
    private static final int SBLIMIT = 32;
    static final int[] slen0;
    static final int[] slen1;
    private static final HuffmanTables.Huffman huff;
    private static final int[] is_pos;
    private static final float[] is_ratio;
    private static final float[] tsOutCopy;
    private static final float[] rawout;
    private static final int[] is_1d;
    private static final float[][][] ro;
    private static final float[][][] lr;
    private static final float[] out_1d;
    private static final float[][] prevblck;
    private static final float[][] k;
    private static int nonzero0;
    private static int nonzero1;
    private static BitStream stream;
    private static Header header;
    private static SynthesisFilter filter1;
    private static SynthesisFilter filter2;
    private static SampleBuffer buffer;
    private static int which_channels;
    private static BitReserve br;
    private static SideInfo si;
    public static int[] scalefac0L;
    public static int[][] scalefac0S;
    public static int[] scalefac1L;
    public static int[][] scalefac1S;
    private static int max_gr;
    private static int frame_start;
    private static int part2_start;
    private static int channels;
    private static int first_channel;
    private static int last_channel;
    private static int sfreq;
    private static final float[] samples1;
    private static final float[] samples2;
    private static int[] sfBandIndexL;
    private static int[] sfBandIndexS;
    private static HuffmanTables h;
    private static final byte[][][] stab;
    private static int[] n_slen2;
    private static int[] i_slen2;
    static int freq;
    static int freq3;
    static int src_line;
    static int des_line;
    static int sfb_start;
    static int sfb_start3;
    static int sfb_lines;
    static int reste;
    static int quotien;
    private static final float[] cs;
    private static final float[] ca;

    public LayerIIIDecoder(BitStream bitStream, Header header, SynthesisFilter synthesisFilter, SynthesisFilter synthesisFilter2, SampleBuffer sampleBuffer, int n) {
        stream = bitStream;
        LayerIIIDecoder.header = header;
        filter1 = synthesisFilter;
        filter2 = synthesisFilter2;
        buffer = sampleBuffer;
        which_channels = n;
        frame_start = 0;
        channels = LayerIIIDecoder.header.mode() == 3 ? 1 : 2;
        max_gr = LayerIIIDecoder.header.version() == 1 ? 2 : 1;
        sfreq = LayerIIIDecoder.header.sample_frequency() + (LayerIIIDecoder.header.version() == 1 ? 3 : 0);
        switch (sfreq) {
            case 0: {
                sfBandIndexL = new int[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576};
                sfBandIndexS = new int[]{0, 4, 8, 12, 18, 24, 32, 42, 56, 74, 100, 132, 174, 192};
                break;
            }
            case 1: {
                sfBandIndexL = new int[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 114, 136, 162, 194, 232, 278, 330, 394, 464, 540, 576};
                sfBandIndexS = new int[]{0, 4, 8, 12, 18, 26, 36, 48, 62, 80, 104, 136, 180, 192};
                break;
            }
            case 2: {
                sfBandIndexL = new int[]{0, 6, 12, 18, 24, 30, 36, 44, 54, 66, 80, 96, 116, 140, 168, 200, 238, 284, 336, 396, 464, 522, 576};
                sfBandIndexS = new int[]{0, 4, 8, 12, 18, 26, 36, 48, 62, 80, 104, 134, 174, 192};
                break;
            }
            case 3: {
                sfBandIndexL = new int[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 52, 62, 74, 90, 110, 134, 162, 196, 238, 288, 342, 418, 576};
                sfBandIndexS = new int[]{0, 4, 8, 12, 16, 22, 30, 40, 52, 66, 84, 106, 136, 192};
                break;
            }
            case 4: {
                sfBandIndexL = new int[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 60, 72, 88, 106, 128, 156, 190, 230, 276, 330, 384, 576};
                sfBandIndexS = new int[]{0, 4, 8, 12, 16, 22, 28, 38, 50, 64, 80, 100, 126, 192};
                break;
            }
            case 5: {
                sfBandIndexL = new int[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 54, 66, 82, 102, 126, 156, 194, 240, 296, 364, 448, 550, 576};
                sfBandIndexS = new int[]{0, 4, 8, 12, 16, 22, 30, 42, 58, 78, 104, 138, 180, 192};
            }
        }
        if (channels == 2) {
            switch (which_channels) {
                case 1: 
                case 3: {
                    last_channel = 0;
                    first_channel = 0;
                    break;
                }
                case 2: {
                    last_channel = 1;
                    first_channel = 1;
                    break;
                }
                default: {
                    first_channel = 0;
                    last_channel = 1;
                    break;
                }
            }
        } else {
            last_channel = 0;
            first_channel = 0;
        }
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 576; ++j) {
                LayerIIIDecoder.prevblck[i][j] = 0.0f;
            }
        }
        nonzero1 = 576;
        nonzero0 = 576;
        br = new BitReserve();
        si = new SideInfo();
        h = new HuffmanTables();
    }

    public final void decodeFrame() {
        int n;
        int n2 = header.slots();
        this.get_side_info();
        for (n = 0; n < n2; ++n) {
            br.hputbuf(stream.readbits(8));
        }
        n = BitReserve.totbit >>> 3;
        int n3 = BitReserve.totbit & 7;
        if (n3 != 0) {
            br.hgetbits(8 - n3);
            ++n;
        }
        int n4 = frame_start - n - si.main_data_begin;
        frame_start += n2;
        if (n4 < 0) {
            return;
        }
        if (n > 4096) {
            frame_start -= 4096;
            br.rewindNbytes(4096);
        }
        while (n4-- > 0) {
            br.hgetbits(8);
        }
        for (int i = 0; i < max_gr; ++i) {
            int n5;
            for (n5 = 0; n5 < channels; ++n5) {
                part2_start = BitReserve.totbit;
                if (header.version() == 1) {
                    this.get_scale_factors_1(n5, i);
                } else {
                    this.get_scale_factors_2(n5, i);
                }
                this.huffman_decode(n5, i);
                this.dequantize_sample(ro[n5], n5, i);
            }
            this.stereo(i);
            for (n5 = first_channel; n5 <= last_channel; ++n5) {
                int n6;
                int n7;
                int n8;
                this.reorder(lr[n5], n5, i);
                this.antialias(n5, i);
                this.hybrid(n5, i);
                for (n8 = 18; n8 < 576; n8 += 36) {
                    for (n7 = 1; n7 < 18; n7 += 2) {
                        int n9 = n8 + n7;
                        out_1d[n9] = out_1d[n9] * -1.0f;
                    }
                }
                if (n5 == 0 || which_channels == 2) {
                    for (n8 = 0; n8 < 18; ++n8) {
                        n6 = 0;
                        for (n7 = 0; n7 < 576; n7 += 18) {
                            LayerIIIDecoder.samples1[n6++] = out_1d[n7 + n8];
                        }
                        filter1.calculateSamples(samples1, buffer);
                    }
                    continue;
                }
                for (n8 = 0; n8 < 18; ++n8) {
                    n6 = 0;
                    for (n7 = 0; n7 < 576; n7 += 18) {
                        LayerIIIDecoder.samples2[n6++] = out_1d[n7 + n8];
                    }
                    filter2.calculateSamples(samples2, buffer);
                }
            }
        }
    }

    public void invMDCT(float[] fArray, float[] fArray2, int n) {
        if (n == 2) {
            int n2;
            for (n2 = 0; n2 < 36; ++n2) {
                fArray2[n2] = 0.0f;
            }
            n2 = 0;
            for (int i = 0; i < 3; ++i) {
                int n3 = 15 + i;
                int n4 = 12 + i;
                int n5 = 9 + i;
                int n6 = 6 + i;
                int n7 = 3 + i;
                int n8 = n3;
                fArray[n8] = fArray[n8] + fArray[n4];
                int n9 = n4;
                fArray[n9] = fArray[n9] + fArray[n5];
                int n10 = n5;
                fArray[n10] = fArray[n10] + fArray[n6];
                int n11 = n6;
                fArray[n11] = fArray[n11] + fArray[n7];
                int n12 = n7;
                fArray[n12] = fArray[n12] + fArray[i];
                int n13 = n3;
                fArray[n13] = fArray[n13] + fArray[n5];
                int n14 = n5;
                fArray[n14] = fArray[n14] + fArray[n7];
                float f = fArray[n4] * 0.5f;
                float f2 = fArray[n6] * 0.8660254f;
                float f3 = fArray[i] + f;
                float f4 = fArray[i] - fArray[n4];
                float f5 = f3 + f2;
                float f6 = f3 - f2;
                f = fArray[n3] * 0.5f;
                f2 = fArray[n5] * 0.8660254f;
                f3 = fArray[n7] + f;
                float f7 = fArray[n7] - fArray[n3];
                float f8 = f3 + f2;
                float f9 = f3 - f2;
                f9 *= 1.9318516f;
                float f10 = f5;
                f5 += (f8 *= 0.5176381f);
                f8 = f10 - f8;
                f10 = f4;
                f4 += (f7 *= 0.70710677f);
                f7 = f10 - f7;
                f10 = f6;
                f6 += f9;
                f9 = f10 - f9;
                f5 *= 0.5043145f;
                f4 *= 0.5411961f;
                f6 *= 0.6302362f;
                f9 *= 0.8213398f;
                f7 *= 1.306563f;
                f8 *= 3.830649f;
                float f11 = -f5 * 0.7933533f;
                float f12 = -f5 * 0.6087614f;
                float f13 = -f4 * 0.9238795f;
                float f14 = -f4 * 0.38268343f;
                float f15 = -f6 * 0.9914449f;
                float f16 = -f6 * 0.13052619f;
                f5 = f9;
                f4 = f7 * 0.38268343f;
                f6 = f8 * 0.6087614f;
                f9 = -f8 * 0.7933533f;
                f7 = -f7 * 0.9238795f;
                f8 = -f5 * 0.9914449f;
                int n15 = n2 + 6;
                fArray2[n15] = fArray2[n15] + (f5 *= 0.13052619f);
                int n16 = n2 + 7;
                fArray2[n16] = fArray2[n16] + f4;
                int n17 = n2 + 8;
                fArray2[n17] = fArray2[n17] + f6;
                int n18 = n2 + 9;
                fArray2[n18] = fArray2[n18] + f9;
                int n19 = n2 + 10;
                fArray2[n19] = fArray2[n19] + f7;
                int n20 = n2 + 11;
                fArray2[n20] = fArray2[n20] + f8;
                int n21 = n2 + 12;
                fArray2[n21] = fArray2[n21] + f15;
                int n22 = n2 + 13;
                fArray2[n22] = fArray2[n22] + f13;
                int n23 = n2 + 14;
                fArray2[n23] = fArray2[n23] + f11;
                int n24 = n2 + 15;
                fArray2[n24] = fArray2[n24] + f12;
                int n25 = n2 + 16;
                fArray2[n25] = fArray2[n25] + f14;
                int n26 = n2 + 17;
                fArray2[n26] = fArray2[n26] + f16;
                n2 += 6;
            }
        } else {
            fArray[17] = fArray[17] + fArray[16];
            fArray[16] = fArray[16] + fArray[15];
            fArray[15] = fArray[15] + fArray[14];
            fArray[14] = fArray[14] + fArray[13];
            fArray[13] = fArray[13] + fArray[12];
            fArray[12] = fArray[12] + fArray[11];
            fArray[11] = fArray[11] + fArray[10];
            fArray[10] = fArray[10] + fArray[9];
            fArray[9] = fArray[9] + fArray[8];
            fArray[8] = fArray[8] + fArray[7];
            fArray[7] = fArray[7] + fArray[6];
            fArray[6] = fArray[6] + fArray[5];
            fArray[5] = fArray[5] + fArray[4];
            fArray[4] = fArray[4] + fArray[3];
            fArray[3] = fArray[3] + fArray[2];
            fArray[2] = fArray[2] + fArray[1];
            fArray[1] = fArray[1] + fArray[0];
            fArray[17] = fArray[17] + fArray[15];
            fArray[15] = fArray[15] + fArray[13];
            fArray[13] = fArray[13] + fArray[11];
            fArray[11] = fArray[11] + fArray[9];
            fArray[9] = fArray[9] + fArray[7];
            fArray[7] = fArray[7] + fArray[5];
            fArray[5] = fArray[5] + fArray[3];
            fArray[3] = fArray[3] + fArray[1];
            float f = fArray[0] + fArray[0];
            float f17 = f + fArray[12];
            float f18 = f17 + fArray[4] * 1.8793852f + fArray[8] * 1.5320889f + fArray[16] * 0.34729636f;
            float f19 = f + fArray[4] - fArray[8] - fArray[12] - fArray[12] - fArray[16];
            float f20 = f17 - fArray[4] * 0.34729636f - fArray[8] * 1.8793852f + fArray[16] * 1.5320889f;
            float f21 = f17 - fArray[4] * 1.5320889f + fArray[8] * 0.34729636f - fArray[16] * 1.8793852f;
            float f22 = fArray[0] - fArray[4] + fArray[8] - fArray[12] + fArray[16];
            float f23 = fArray[6] * 1.7320508f;
            float f24 = fArray[2] * 1.9696155f + f23 + fArray[10] * 1.2855753f + fArray[14] * 0.6840403f;
            float f25 = (fArray[2] - fArray[10] - fArray[14]) * 1.7320508f;
            float f26 = fArray[2] * 1.2855753f - f23 - fArray[10] * 0.6840403f + fArray[14] * 1.9696155f;
            float f27 = fArray[2] * 0.6840403f - f23 + fArray[10] * 1.9696155f - fArray[14] * 1.2855753f;
            float f28 = fArray[1] + fArray[1];
            float f29 = f28 + fArray[13];
            float f30 = f29 + fArray[5] * 1.8793852f + fArray[9] * 1.5320889f + fArray[17] * 0.34729636f;
            float f31 = f28 + fArray[5] - fArray[9] - fArray[13] - fArray[13] - fArray[17];
            float f32 = f29 - fArray[5] * 0.34729636f - fArray[9] * 1.8793852f + fArray[17] * 1.5320889f;
            float f33 = f29 - fArray[5] * 1.5320889f + fArray[9] * 0.34729636f - fArray[17] * 1.8793852f;
            float f34 = (fArray[1] - fArray[5] + fArray[9] - fArray[13] + fArray[17]) * 0.70710677f;
            float f35 = fArray[7] * 1.7320508f;
            float f36 = fArray[3] * 1.9696155f + f35 + fArray[11] * 1.2855753f + fArray[15] * 0.6840403f;
            float f37 = (fArray[3] - fArray[11] - fArray[15]) * 1.7320508f;
            float f38 = fArray[3] * 1.2855753f - f35 - fArray[11] * 0.6840403f + fArray[15] * 1.9696155f;
            float f39 = fArray[3] * 0.6840403f - f35 + fArray[11] * 1.9696155f - fArray[15] * 1.2855753f;
            float f40 = f18 + f24;
            float f41 = (f30 + f36) * 0.5019099f;
            float f42 = f40 + f41;
            float f43 = f40 - f41;
            f40 = f19 + f25;
            f41 = (f31 + f37) * 0.5176381f;
            float f44 = f40 + f41;
            float f45 = f40 - f41;
            f40 = f20 + f26;
            f41 = (f32 + f38) * 0.55168897f;
            float f46 = f40 + f41;
            float f47 = f40 - f41;
            f40 = f21 + f27;
            f41 = (f33 + f39) * 0.61038727f;
            float f48 = f40 + f41;
            float f49 = f40 - f41;
            float f50 = f22 + f34;
            float f51 = f22 - f34;
            f40 = f21 - f27;
            f41 = (f33 - f39) * 0.8717234f;
            float f52 = f40 + f41;
            float f53 = f40 - f41;
            f40 = f20 - f26;
            f41 = (f32 - f38) * 1.1831008f;
            float f54 = f40 + f41;
            float f55 = f40 - f41;
            f40 = f19 - f25;
            f41 = (f31 - f37) * 1.9318516f;
            float f56 = f40 + f41;
            float f57 = f40 - f41;
            f40 = f18 - f24;
            f41 = (f30 - f36) * 5.7368565f;
            float f58 = f40 + f41;
            float f59 = f40 - f41;
            float[] fArray3 = win[n];
            fArray2[0] = -f59 * fArray3[0];
            fArray2[1] = -f57 * fArray3[1];
            fArray2[2] = -f55 * fArray3[2];
            fArray2[3] = -f53 * fArray3[3];
            fArray2[4] = -f51 * fArray3[4];
            fArray2[5] = -f49 * fArray3[5];
            fArray2[6] = -f47 * fArray3[6];
            fArray2[7] = -f45 * fArray3[7];
            fArray2[8] = -f43 * fArray3[8];
            fArray2[9] = f43 * fArray3[9];
            fArray2[10] = f45 * fArray3[10];
            fArray2[11] = f47 * fArray3[11];
            fArray2[12] = f49 * fArray3[12];
            fArray2[13] = f51 * fArray3[13];
            fArray2[14] = f53 * fArray3[14];
            fArray2[15] = f55 * fArray3[15];
            fArray2[16] = f57 * fArray3[16];
            fArray2[17] = f59 * fArray3[17];
            fArray2[18] = f58 * fArray3[18];
            fArray2[19] = f56 * fArray3[19];
            fArray2[20] = f54 * fArray3[20];
            fArray2[21] = f52 * fArray3[21];
            fArray2[22] = f50 * fArray3[22];
            fArray2[23] = f48 * fArray3[23];
            fArray2[24] = f46 * fArray3[24];
            fArray2[25] = f44 * fArray3[25];
            fArray2[26] = f42 * fArray3[26];
            fArray2[27] = f42 * fArray3[27];
            fArray2[28] = f44 * fArray3[28];
            fArray2[29] = f46 * fArray3[29];
            fArray2[30] = f48 * fArray3[30];
            fArray2[31] = f50 * fArray3[31];
            fArray2[32] = f52 * fArray3[32];
            fArray2[33] = f54 * fArray3[33];
            fArray2[34] = f56 * fArray3[34];
            fArray2[35] = f58 * fArray3[35];
        }
    }

    private final boolean get_side_info() {
        if (header.version() == 1) {
            Object object;
            int n;
            si.main_data_begin = LayerIIIDecoder.stream.readbits(9);
            if (channels == 1) {
                si.private_bits = LayerIIIDecoder.stream.readbits(5);
            } else {
                si.private_bits = LayerIIIDecoder.stream.readbits(3);
            }
            for (n = 0; n < channels; ++n) {
                object = si.ch[n];
                ((Channel)object).scfsi[0] = stream.readbits(1);
                ((Channel)object).scfsi[1] = stream.readbits(1);
                ((Channel)object).scfsi[2] = stream.readbits(1);
                ((Channel)object).scfsi[3] = stream.readbits(1);
            }
            for (int i = 0; i < 2; ++i) {
                for (n = 0; n < channels; ++n) {
                    object = si.ch[n].gr[i];
                    ((GRInfo)object).part2_3_length = LayerIIIDecoder.stream.readbits(12);
                    ((GRInfo)object).big_values = LayerIIIDecoder.stream.readbits(9);
                    ((GRInfo)object).global_gain = LayerIIIDecoder.stream.readbits(8);
                    ((GRInfo)object).scalefac_compress = LayerIIIDecoder.stream.readbits(4);
                    ((GRInfo)object).window_switching_flag = LayerIIIDecoder.stream.readbits(1);
                    if (((GRInfo)object).window_switching_flag != 0) {
                        ((GRInfo)object).block_type = LayerIIIDecoder.stream.readbits(2);
                        ((GRInfo)object).mixed_block_flag = LayerIIIDecoder.stream.readbits(1);
                        ((GRInfo)object).table_select[0] = stream.readbits(5);
                        ((GRInfo)object).table_select[1] = stream.readbits(5);
                        ((GRInfo)object).subblock_gain[0] = stream.readbits(3);
                        ((GRInfo)object).subblock_gain[1] = stream.readbits(3);
                        ((GRInfo)object).subblock_gain[2] = stream.readbits(3);
                        if (((GRInfo)object).block_type == 0) {
                            return false;
                        }
                        if (((GRInfo)object).block_type == 2 && ((GRInfo)object).mixed_block_flag == 0) {
                            ((GRInfo)object).region0_count = 8;
                        } else {
                            ((GRInfo)object).region0_count = 7;
                        }
                        ((GRInfo)object).region1_count = 20 - ((GRInfo)object).region0_count;
                    } else {
                        ((GRInfo)object).table_select[0] = stream.readbits(5);
                        ((GRInfo)object).table_select[1] = stream.readbits(5);
                        ((GRInfo)object).table_select[2] = stream.readbits(5);
                        ((GRInfo)object).region0_count = LayerIIIDecoder.stream.readbits(4);
                        ((GRInfo)object).region1_count = LayerIIIDecoder.stream.readbits(3);
                        ((GRInfo)object).block_type = 0;
                    }
                    ((GRInfo)object).preflag = LayerIIIDecoder.stream.readbits(1);
                    ((GRInfo)object).scalefac_scale = LayerIIIDecoder.stream.readbits(1);
                    ((GRInfo)object).count1table_select = LayerIIIDecoder.stream.readbits(1);
                }
            }
        } else {
            si.main_data_begin = LayerIIIDecoder.stream.readbits(8);
            if (channels == 1) {
                si.private_bits = LayerIIIDecoder.stream.readbits(1);
            } else {
                si.private_bits = LayerIIIDecoder.stream.readbits(2);
            }
            for (int i = 0; i < channels; ++i) {
                GRInfo gRInfo = si.ch[i].gr[0];
                gRInfo.part2_3_length = LayerIIIDecoder.stream.readbits(12);
                gRInfo.big_values = LayerIIIDecoder.stream.readbits(9);
                gRInfo.global_gain = LayerIIIDecoder.stream.readbits(8);
                gRInfo.scalefac_compress = LayerIIIDecoder.stream.readbits(9);
                gRInfo.window_switching_flag = LayerIIIDecoder.stream.readbits(1);
                if (gRInfo.window_switching_flag != 0) {
                    gRInfo.block_type = LayerIIIDecoder.stream.readbits(2);
                    gRInfo.mixed_block_flag = LayerIIIDecoder.stream.readbits(1);
                    ((GRInfo)gRInfo).table_select[0] = stream.readbits(5);
                    ((GRInfo)gRInfo).table_select[1] = stream.readbits(5);
                    ((GRInfo)gRInfo).subblock_gain[0] = stream.readbits(3);
                    ((GRInfo)gRInfo).subblock_gain[1] = stream.readbits(3);
                    ((GRInfo)gRInfo).subblock_gain[2] = stream.readbits(3);
                    if (gRInfo.block_type == 0) {
                        return false;
                    }
                    if (gRInfo.block_type == 2 && gRInfo.mixed_block_flag == 0) {
                        gRInfo.region0_count = 8;
                    } else {
                        gRInfo.region0_count = 7;
                        gRInfo.region1_count = 20 - gRInfo.region0_count;
                    }
                } else {
                    ((GRInfo)gRInfo).table_select[0] = stream.readbits(5);
                    ((GRInfo)gRInfo).table_select[1] = stream.readbits(5);
                    ((GRInfo)gRInfo).table_select[2] = stream.readbits(5);
                    gRInfo.region0_count = LayerIIIDecoder.stream.readbits(4);
                    gRInfo.region1_count = LayerIIIDecoder.stream.readbits(3);
                    gRInfo.block_type = 0;
                    gRInfo.mixed_block_flag = 0;
                }
                gRInfo.scalefac_scale = LayerIIIDecoder.stream.readbits(1);
                gRInfo.count1table_select = LayerIIIDecoder.stream.readbits(1);
            }
        }
        return true;
    }

    private final void get_scale_factors_2(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int[] nArray = null;
        int[][] nArray2 = null;
        int n5 = 0;
        boolean bl = header.mode() == 1 && (header.mode_extension() & 1) != 0;
        GRInfo gRInfo = si.ch[n].gr[n2];
        if (n == 0) {
            nArray = scalefac0L;
            nArray2 = scalefac0S;
        } else {
            nArray = scalefac1L;
            nArray2 = scalefac1S;
        }
        int n6 = n > 0 && bl ? i_slen2[gRInfo.scalefac_compress >> 1] : n_slen2[gRInfo.scalefac_compress];
        gRInfo.preflag = n6 >> 15 & 1;
        n3 = 0;
        if (gRInfo.block_type == 2) {
            int n7;
            int n8;
            ++n3;
            if (gRInfo.mixed_block_flag != 0) {
                System.out.println("mixed mode is unsupported!");
                ++n3;
            }
            byte[] byArray = stab[n3][n6 >> 12 & 7];
            for (n8 = 0; n8 < 4; ++n8) {
                int n9;
                int n10 = n6 & 7;
                n6 >>= 3;
                if (n10 != 0) {
                    for (n9 = 0; n9 < byArray[n8]; n9 += 3) {
                        for (n7 = 0; n7 < 3; ++n7) {
                            nArray2[n7][n5] = br.hgetbits(n10);
                        }
                        ++n5;
                    }
                    n4 += byArray[n8] * n10;
                    continue;
                }
                for (n9 = 0; n9 < byArray[n8]; n9 += 3) {
                    for (n7 = 0; n7 < 3; ++n7) {
                        nArray2[n7][n5] = 0;
                    }
                    ++n5;
                }
            }
            n3 = (n3 << 1) + 1;
            for (n8 = 0; n8 < n3; n8 += 3) {
                for (n7 = 0; n7 < 3; ++n7) {
                    nArray2[n7][n5] = 0;
                }
                ++n5;
            }
        } else {
            int n11;
            byte[] byArray = stab[n3][n6 >> 12 & 7];
            for (n11 = 0; n11 < 4; ++n11) {
                int n12;
                int n13 = n6 & 7;
                n6 >>= 3;
                if (n13 != 0) {
                    for (n12 = 0; n12 < byArray[n11]; ++n12) {
                        nArray[n5++] = br.hgetbits(n13);
                    }
                    n4 += byArray[n11] * n13;
                    continue;
                }
                for (n12 = 0; n12 < byArray[n11]; ++n12) {
                    nArray[n5++] = 0;
                }
            }
            n3 = (n3 << 1) + 1;
            for (n11 = 0; n11 < n3; ++n11) {
                nArray[n5++] = 0;
            }
        }
    }

    private final void get_scale_factors_1(int n, int n2) {
        GRInfo gRInfo = si.ch[n].gr[n2];
        int n3 = gRInfo.scalefac_compress;
        int n4 = slen0[n3];
        int n5 = slen1[n3];
        int[] nArray = null;
        int[][] nArray2 = null;
        if (n == 0) {
            nArray = scalefac0L;
            nArray2 = scalefac0S;
        } else {
            nArray = scalefac1L;
            nArray2 = scalefac1S;
        }
        if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2) {
            if (gRInfo.mixed_block_flag != 0) {
                int n6;
                int n7;
                for (n7 = 0; n7 < 8; ++n7) {
                    nArray[n7] = br.hgetbits(slen0[gRInfo.scalefac_compress]);
                }
                for (n7 = 3; n7 < 6; ++n7) {
                    for (n6 = 0; n6 < 3; ++n6) {
                        nArray2[n6][n7] = br.hgetbits(slen0[gRInfo.scalefac_compress]);
                    }
                }
                for (n7 = 6; n7 < 12; ++n7) {
                    for (n6 = 0; n6 < 3; ++n6) {
                        nArray2[n6][n7] = br.hgetbits(slen1[gRInfo.scalefac_compress]);
                    }
                }
                n7 = 12;
                for (n6 = 0; n6 < 3; ++n6) {
                    nArray2[n6][n7] = 0;
                }
            } else {
                nArray2[0][0] = br.hgetbits(n4);
                nArray2[1][0] = br.hgetbits(n4);
                nArray2[2][0] = br.hgetbits(n4);
                nArray2[0][1] = br.hgetbits(n4);
                nArray2[1][1] = br.hgetbits(n4);
                nArray2[2][1] = br.hgetbits(n4);
                nArray2[0][2] = br.hgetbits(n4);
                nArray2[1][2] = br.hgetbits(n4);
                nArray2[2][2] = br.hgetbits(n4);
                nArray2[0][3] = br.hgetbits(n4);
                nArray2[1][3] = br.hgetbits(n4);
                nArray2[2][3] = br.hgetbits(n4);
                nArray2[0][4] = br.hgetbits(n4);
                nArray2[1][4] = br.hgetbits(n4);
                nArray2[2][4] = br.hgetbits(n4);
                nArray2[0][5] = br.hgetbits(n4);
                nArray2[1][5] = br.hgetbits(n4);
                nArray2[2][5] = br.hgetbits(n4);
                nArray2[0][6] = br.hgetbits(n5);
                nArray2[1][6] = br.hgetbits(n5);
                nArray2[2][6] = br.hgetbits(n5);
                nArray2[0][7] = br.hgetbits(n5);
                nArray2[1][7] = br.hgetbits(n5);
                nArray2[2][7] = br.hgetbits(n5);
                nArray2[0][8] = br.hgetbits(n5);
                nArray2[1][8] = br.hgetbits(n5);
                nArray2[2][8] = br.hgetbits(n5);
                nArray2[0][9] = br.hgetbits(n5);
                nArray2[1][9] = br.hgetbits(n5);
                nArray2[2][9] = br.hgetbits(n5);
                nArray2[0][10] = br.hgetbits(n5);
                nArray2[1][10] = br.hgetbits(n5);
                nArray2[2][10] = br.hgetbits(n5);
                nArray2[0][11] = br.hgetbits(n5);
                nArray2[1][11] = br.hgetbits(n5);
                nArray2[2][11] = br.hgetbits(n5);
                nArray2[2][12] = 0;
                nArray2[1][12] = 0;
                nArray2[0][12] = 0;
            }
        } else {
            int[] nArray3 = si.ch[n].scfsi;
            if (n2 == 0) {
                nArray[0] = br.hgetbits(n4);
                nArray[1] = br.hgetbits(n4);
                nArray[2] = br.hgetbits(n4);
                nArray[3] = br.hgetbits(n4);
                nArray[4] = br.hgetbits(n4);
                nArray[5] = br.hgetbits(n4);
                nArray[6] = br.hgetbits(n4);
                nArray[7] = br.hgetbits(n4);
                nArray[8] = br.hgetbits(n4);
                nArray[9] = br.hgetbits(n4);
                nArray[10] = br.hgetbits(n4);
                nArray[11] = br.hgetbits(n5);
                nArray[12] = br.hgetbits(n5);
                nArray[13] = br.hgetbits(n5);
                nArray[14] = br.hgetbits(n5);
                nArray[15] = br.hgetbits(n5);
                nArray[16] = br.hgetbits(n5);
                nArray[17] = br.hgetbits(n5);
                nArray[18] = br.hgetbits(n5);
                nArray[19] = br.hgetbits(n5);
                nArray[20] = br.hgetbits(n5);
            } else {
                if (nArray3[0] == 0) {
                    nArray[0] = br.hgetbits(n4);
                    nArray[1] = br.hgetbits(n4);
                    nArray[2] = br.hgetbits(n4);
                    nArray[3] = br.hgetbits(n4);
                    nArray[4] = br.hgetbits(n4);
                    nArray[5] = br.hgetbits(n4);
                }
                if (nArray3[1] == 0) {
                    nArray[6] = br.hgetbits(n4);
                    nArray[7] = br.hgetbits(n4);
                    nArray[8] = br.hgetbits(n4);
                    nArray[9] = br.hgetbits(n4);
                    nArray[10] = br.hgetbits(n4);
                }
                if (nArray3[2] == 0) {
                    nArray[11] = br.hgetbits(n5);
                    nArray[12] = br.hgetbits(n5);
                    nArray[13] = br.hgetbits(n5);
                    nArray[14] = br.hgetbits(n5);
                    nArray[15] = br.hgetbits(n5);
                }
                if (nArray3[3] == 0) {
                    nArray[16] = br.hgetbits(n5);
                    nArray[17] = br.hgetbits(n5);
                    nArray[18] = br.hgetbits(n5);
                    nArray[19] = br.hgetbits(n5);
                    nArray[20] = br.hgetbits(n5);
                }
            }
            nArray[22] = 0;
            nArray[21] = 0;
        }
    }

    private final void huffman_decode(int n, int n2) {
        GRInfo gRInfo = si.ch[n].gr[n2];
        int n3 = part2_start + gRInfo.part2_3_length;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2) {
            n5 = 36;
            n6 = 576;
        } else {
            int n7 = gRInfo.region0_count + 1;
            int n8 = n7 + gRInfo.region1_count + 1;
            if (n8 > sfBandIndexL.length - 1) {
                n8 = sfBandIndexL.length - 1;
            }
            n5 = sfBandIndexL[n7];
            n6 = sfBandIndexL[n8];
        }
        int n9 = 0;
        int n10 = gRInfo.big_values << 1;
        int n11 = is_1d.length;
        for (int i = 0; i < n10 && i < n11; i += 2) {
            h = i < n5 ? HuffmanTables.ht[gRInfo.table_select[0]] : (i < n6 ? HuffmanTables.ht[gRInfo.table_select[1]] : HuffmanTables.ht[gRInfo.table_select[2]]);
            HuffmanTables.decode(h, huff, br);
            int n12 = n9++;
            LayerIIIDecoder.is_1d[n12] = HuffmanTables.Huffman.x;
            int n13 = n9++;
            LayerIIIDecoder.is_1d[n13] = HuffmanTables.Huffman.y;
        }
        h = HuffmanTables.ht[gRInfo.count1table_select + 32];
        n4 = BitReserve.totbit;
        while (n4 < n3 && n9 < 576) {
            HuffmanTables.decode(h, huff, br);
            int n14 = n9++;
            LayerIIIDecoder.is_1d[n14] = HuffmanTables.Huffman.v;
            int n15 = n9++;
            LayerIIIDecoder.is_1d[n15] = HuffmanTables.Huffman.w;
            int n16 = n9++;
            LayerIIIDecoder.is_1d[n16] = HuffmanTables.Huffman.x;
            int n17 = n9++;
            LayerIIIDecoder.is_1d[n17] = HuffmanTables.Huffman.y;
            n4 = BitReserve.totbit;
        }
        if (n4 > n3) {
            br.rewindNbits(n4 - n3);
            n9 -= 4;
        }
        if ((n4 = BitReserve.totbit) < n3) {
            br.hgetbits(n3 - n4);
        }
        if (n9 < 576) {
            if (n == 0) {
                nonzero0 = n9;
            } else {
                nonzero1 = n9;
            }
        } else if (n == 0) {
            nonzero0 = 576;
        } else {
            nonzero1 = 576;
        }
        if (n9 < 0) {
            n9 = 0;
        }
    }

    private final void dequantize_sample(float[][] fArray, int n, int n2) {
        int n3;
        int n4;
        GRInfo gRInfo = si.ch[n].gr[n2];
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        float f = 0.0f;
        if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2) {
            if (gRInfo.mixed_block_flag != 0) {
                n6 = sfBandIndexL[1];
            } else {
                n8 = sfBandIndexS[1];
                n6 = (n8 << 2) - n8;
                n7 = 0;
            }
        } else {
            n6 = sfBandIndexL[1];
        }
        f = (float)Math.pow(2.0, 0.25 * ((double)gRInfo.global_gain - 210.0));
        int n9 = n == 0 ? nonzero0 : nonzero1;
        for (n4 = 0; n4 < n9; ++n4) {
            reste = n4 % 18;
            quotien = (n4 - reste) / 18;
            if (is_1d[n4] == 0) {
                fArray[LayerIIIDecoder.quotien][LayerIIIDecoder.reste] = 0.0f;
                continue;
            }
            n3 = is_1d[n4];
            fArray[LayerIIIDecoder.quotien][LayerIIIDecoder.reste] = is_1d[n4] > 0 ? f * t_43[n3] : -f * t_43[-n3];
        }
        n4 = 0;
        n3 = 0;
        while (n3 < n9) {
            int n10;
            int[] nArray;
            reste = n3 % 18;
            quotien = (n3 - reste) / 18;
            if (n4 == n6) {
                if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2) {
                    if (gRInfo.mixed_block_flag != 0) {
                        if (n4 == sfBandIndexL[8]) {
                            n6 = sfBandIndexS[4];
                            n6 = (n6 << 2) - n6;
                            n5 = 3;
                            n8 = sfBandIndexS[4] - sfBandIndexS[3];
                            n7 = sfBandIndexS[3];
                            n7 = (n7 << 2) - n7;
                        } else if (n4 < sfBandIndexL[8]) {
                            n6 = sfBandIndexL[++n5 + 1];
                        } else {
                            n6 = sfBandIndexS[++n5 + 1];
                            n6 = (n6 << 2) - n6;
                            n7 = sfBandIndexS[n5];
                            n8 = sfBandIndexS[n5 + 1] - n7;
                            n7 = (n7 << 2) - n7;
                        }
                    } else {
                        n6 = sfBandIndexS[++n5 + 1];
                        n6 = (n6 << 2) - n6;
                        n7 = sfBandIndexS[n5];
                        n8 = sfBandIndexS[n5 + 1] - n7;
                        n7 = (n7 << 2) - n7;
                    }
                } else {
                    n6 = sfBandIndexL[++n5 + 1];
                }
            }
            int[][] nArray2 = n == 0 ? scalefac0S : scalefac1S;
            int[] nArray3 = nArray = n == 0 ? scalefac0L : scalefac1L;
            if (gRInfo.window_switching_flag != 0 && (gRInfo.block_type == 2 && gRInfo.mixed_block_flag == 0 || gRInfo.block_type == 2 && gRInfo.mixed_block_flag != 0 && n3 >= 36)) {
                n10 = (n4 - n7) / n8;
                int n11 = nArray2[n10][n5] << gRInfo.scalefac_scale;
                float[] fArray2 = fArray[quotien];
                int n12 = reste;
                fArray2[n12] = fArray2[n12] * two_to_negative_half_pow[n11 += gRInfo.subblock_gain[n10] << 2];
            } else {
                n10 = nArray[n5];
                if (gRInfo.preflag != 0) {
                    n10 += pretab[n5];
                }
                float[] fArray3 = fArray[quotien];
                int n13 = reste;
                fArray3[n13] = fArray3[n13] * two_to_negative_half_pow[n10 <<= gRInfo.scalefac_scale];
            }
            ++n3;
            ++n4;
        }
        for (int i = n9; i < 576; ++i) {
            n4 = i % 18;
            n3 = (i - n4) / 18;
            fArray[n3][n4] = 0.0f;
        }
    }

    private final void reorder(float[][] fArray, int n, int n2) {
        GRInfo gRInfo = si.ch[n].gr[n2];
        if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2) {
            if (gRInfo.mixed_block_flag != 0) {
                int n3 = 36;
                while (--n3 >= 0) {
                    reste = n3 % 18;
                    quotien = (n3 - reste) / 18;
                    LayerIIIDecoder.out_1d[n3] = fArray[quotien][reste];
                }
                n3 = 3;
                int n4 = sfBandIndexS[3];
                int n5 = sfBandIndexS[4] - n4;
                while (n3 < 13) {
                    sfb_start3 = (n4 << 2) - n4;
                    freq = 0;
                    freq3 = 0;
                    while (freq < n5) {
                        src_line = sfb_start3 + freq;
                        des_line = sfb_start3 + freq3;
                        reste = src_line % 18;
                        quotien = (src_line - reste) / 18;
                        LayerIIIDecoder.out_1d[LayerIIIDecoder.des_line] = fArray[quotien][reste];
                        reste = (src_line += n5) % 18;
                        quotien = (src_line - reste) / 18;
                        LayerIIIDecoder.out_1d[++LayerIIIDecoder.des_line] = fArray[quotien][reste];
                        reste = (src_line += n5) % 18;
                        quotien = (src_line - reste) / 18;
                        LayerIIIDecoder.out_1d[++LayerIIIDecoder.des_line] = fArray[quotien][reste];
                        ++freq;
                        freq3 += 3;
                    }
                    n4 = sfBandIndexS[++n3];
                    n5 = sfBandIndexS[n3 + 1] - n4;
                }
            } else {
                int[] nArray = reorder_table[sfreq];
                int n6 = 576;
                while (--n6 >= 0) {
                    int n7 = nArray[n6];
                    reste = n7 % 18;
                    quotien = (n7 - reste) / 18;
                    LayerIIIDecoder.out_1d[n6] = fArray[quotien][reste];
                }
            }
        } else {
            int n8 = 576;
            while (--n8 >= 0) {
                reste = n8 % 18;
                quotien = (n8 - reste) / 18;
                LayerIIIDecoder.out_1d[n8] = fArray[quotien][reste];
            }
        }
    }

    private final void stereo(int n) {
        if (channels == 1) {
            int n2 = 32;
            while (--n2 >= 0) {
                float[] fArray = lr[0][n2];
                float[] fArray2 = ro[0][n2];
                for (int i = 0; i < 18; i += 3) {
                    fArray[i] = fArray2[i];
                    fArray[i + 1] = fArray2[i + 1];
                    fArray[i + 2] = fArray2[i + 2];
                }
            }
        } else {
            int n3;
            int n4;
            int n5;
            GRInfo gRInfo = si.ch[0].gr[n];
            int n6 = header.mode_extension();
            boolean bl = header.mode() == 1 && (n6 & 1) != 0;
            int n7 = gRInfo.scalefac_compress & 1;
            for (n5 = 0; n5 < is_pos.length; ++n5) {
                LayerIIIDecoder.is_pos[n5] = 7;
            }
            if (bl) {
                int n8;
                int n9;
                if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2) {
                    if (gRInfo.mixed_block_flag != 0) {
                        n5 = 0;
                        for (n4 = 0; n4 < 3; ++n4) {
                            int n10;
                            int n11;
                            n9 = 2;
                            for (n8 = 12; n8 >= 3; --n8) {
                                int n12 = sfBandIndexS[n8];
                                n11 = sfBandIndexS[n8 + 1] - n12;
                                n12 = (n12 << 2) - n12 + (n4 + 1) * n11 - 1;
                                while (n11 > 0) {
                                    if (ro[1][n12 / 18][n12 % 18] != 0.0f) {
                                        n9 = n8;
                                        n8 = -10;
                                        n11 = -10;
                                    }
                                    --n11;
                                    --n12;
                                }
                            }
                            n8 = n9 + 1;
                            if (n8 > n5) {
                                n5 = n8;
                            }
                            int[][] nArray = scalefac1S;
                            while (n8 < 12) {
                                n11 = sfBandIndexS[n8];
                                n10 = (n11 << 2) - n11 + n4 * n3;
                                for (n3 = sfBandIndexS[n8 + 1] - n11; n3 > 0; --n3) {
                                    LayerIIIDecoder.is_pos[n10] = nArray[n4][n8];
                                    if (is_pos[n10] != 7) {
                                        LayerIIIDecoder.is_ratio[n10] = TAN12[is_pos[n10]];
                                    }
                                    ++n10;
                                }
                                ++n8;
                            }
                            n8 = sfBandIndexS[10];
                            n11 = sfBandIndexS[11] - n8;
                            n8 = (n8 << 2) - n8 + n4 * n11;
                            n3 = sfBandIndexS[11];
                            n10 = (n3 << 2) - n3 + n4 * n11;
                            for (n11 = sfBandIndexS[12] - n3; n11 > 0; --n11) {
                                LayerIIIDecoder.is_pos[n10] = is_pos[n8];
                                LayerIIIDecoder.is_ratio[n10] = is_ratio[n8];
                                ++n10;
                            }
                        }
                        if (n5 <= 3) {
                            n4 = 2;
                            n9 = 17;
                            n8 = -1;
                            while (n4 >= 0) {
                                if (ro[1][n4][n9] != 0.0f) {
                                    n8 = (n4 << 4) + (n4 << 1) + n9;
                                    n4 = -1;
                                    continue;
                                }
                                if (--n9 >= 0) continue;
                                --n4;
                                n9 = 17;
                            }
                            n4 = 0;
                            while (sfBandIndexL[n4] <= n8) {
                                ++n4;
                            }
                            int n13 = n4;
                            n4 = sfBandIndexL[n4];
                            int[] nArray = scalefac1L;
                            while (n13 < 8) {
                                for (n8 = sfBandIndexL[n13 + 1] - sfBandIndexL[n13]; n8 > 0; --n8) {
                                    LayerIIIDecoder.is_pos[n4] = nArray[n13];
                                    if (is_pos[n4] != 7) {
                                        LayerIIIDecoder.is_ratio[n4] = TAN12[is_pos[n4]];
                                    }
                                    ++n4;
                                }
                                ++n13;
                            }
                        }
                    } else {
                        for (n5 = 0; n5 < 3; ++n5) {
                            int n14;
                            int n15;
                            n4 = -1;
                            for (n9 = 12; n9 >= 0; --n9) {
                                n8 = sfBandIndexS[n9];
                                n15 = sfBandIndexS[n9 + 1] - n8;
                                n14 = (n8 << 2) - n8 + (n5 + 1) * n15 - 1;
                                while (n15 > 0) {
                                    if (ro[1][n14 / 18][n14 % 18] != 0.0f) {
                                        n4 = n9;
                                        n9 = -10;
                                        n15 = -10;
                                    }
                                    --n15;
                                    --n14;
                                }
                            }
                            for (n9 = n4 + 1; n9 < 12; ++n9) {
                                n8 = sfBandIndexS[n9];
                                n14 = (n8 << 2) - n8 + n5 * n15;
                                for (n15 = sfBandIndexS[n9 + 1] - n8; n15 > 0; --n15) {
                                    LayerIIIDecoder.is_pos[n14] = scalefac1S[n5][n9];
                                    if (is_pos[n14] != 7) {
                                        LayerIIIDecoder.is_ratio[n14] = TAN12[is_pos[n14]];
                                    }
                                    ++n14;
                                }
                            }
                            n8 = sfBandIndexS[10];
                            n15 = sfBandIndexS[11];
                            n14 = n15 - n8;
                            n9 = (n8 << 2) - n8 + n5 * n14;
                            n3 = (n15 << 2) - n15 + n5 * n14;
                            float f = k[0][n9];
                            float f2 = k[1][n9];
                            for (n14 = sfBandIndexS[12] - n15; n14 > 0; --n14) {
                                LayerIIIDecoder.is_pos[n3] = is_pos[n9];
                                LayerIIIDecoder.is_ratio[n3] = is_ratio[n9];
                                ++n3;
                            }
                        }
                    }
                } else {
                    n5 = 31;
                    n4 = 17;
                    n9 = 0;
                    while (n5 >= 0) {
                        if (ro[1][n5][n4] != 0.0f) {
                            n9 = (n5 << 4) + (n5 << 1) + n4;
                            n5 = -1;
                            continue;
                        }
                        if (--n4 >= 0) continue;
                        --n5;
                        n4 = 17;
                    }
                    n5 = 0;
                    while (sfBandIndexL[n5] <= n9) {
                        ++n5;
                    }
                    n8 = n5;
                    n5 = sfBandIndexL[n5];
                    while (n8 < 21) {
                        for (n9 = sfBandIndexL[n8 + 1] - sfBandIndexL[n8]; n9 > 0; --n9) {
                            int n16;
                            LayerIIIDecoder.is_pos[n5] = n16 = scalefac1L[n8];
                            if (n16 != 7) {
                                LayerIIIDecoder.is_ratio[n5] = TAN12[n16];
                            }
                            ++n5;
                        }
                        ++n8;
                    }
                    n8 = sfBandIndexL[20];
                    for (n9 = 576 - sfBandIndexL[21]; n9 > 0 && n5 < 576; --n9, ++n5) {
                        LayerIIIDecoder.is_pos[n5] = is_pos[n8];
                        LayerIIIDecoder.is_ratio[n5] = is_ratio[n8];
                    }
                }
            }
            n5 = 0;
            for (n4 = 0; n4 < 32; ++n4) {
                float[] fArray = lr[0][n4];
                float[] fArray3 = lr[1][n4];
                float[] fArray4 = ro[0][n4];
                float[] fArray5 = ro[1][n4];
                n3 = 0;
                while (n3 < 18) {
                    if (is_pos[n5] == 7) {
                        if (header.mode() == 1 && (n6 & 2) != 0) {
                            fArray[n3] = (fArray4[n3] + fArray5[n3]) * 0.70710677f;
                            fArray3[n3] = (fArray4[n3] - fArray5[n3]) * 0.70710677f;
                        } else {
                            fArray[n3] = fArray4[n3];
                            fArray3[n3] = fArray5[n3];
                        }
                    } else if (bl) {
                        fArray3[n3] = fArray4[n3] / (1.0f + is_ratio[n5]);
                        fArray[n3] = fArray3[n3] * is_ratio[n5];
                    }
                    ++n3;
                    ++n5;
                }
            }
        }
    }

    private final void antialias(int n, int n2) {
        GRInfo gRInfo = si.ch[n].gr[n2];
        int n3 = 0;
        if (gRInfo.window_switching_flag != 0 && gRInfo.block_type == 2 && gRInfo.mixed_block_flag == 0) {
            return;
        }
        n3 = gRInfo.window_switching_flag != 0 && gRInfo.mixed_block_flag != 0 && gRInfo.block_type == 2 ? 18 : 558;
        for (int i = 0; i < n3; i += 18) {
            int n4 = i + 17;
            int n5 = i + 18;
            float f = out_1d[n4];
            float f2 = out_1d[n5];
            float f3 = cs[0];
            float f4 = ca[0];
            LayerIIIDecoder.out_1d[n4--] = f * f3 - f2 * f4;
            LayerIIIDecoder.out_1d[n5++] = f2 * f3 + f * f4;
            f = out_1d[n4];
            f2 = out_1d[n5];
            f3 = cs[1];
            f4 = ca[1];
            LayerIIIDecoder.out_1d[n4--] = f * f3 - f2 * f4;
            LayerIIIDecoder.out_1d[n5++] = f2 * f3 + f * f4;
            f = out_1d[n4];
            f2 = out_1d[n5];
            f3 = cs[2];
            f4 = ca[2];
            LayerIIIDecoder.out_1d[n4--] = f * f3 - f2 * f4;
            LayerIIIDecoder.out_1d[n5++] = f2 * f3 + f * f4;
            f = out_1d[n4];
            f2 = out_1d[n5];
            f3 = cs[3];
            f4 = ca[3];
            LayerIIIDecoder.out_1d[n4--] = f * f3 - f2 * f4;
            LayerIIIDecoder.out_1d[n5++] = f2 * f3 + f * f4;
            f = out_1d[n4];
            f2 = out_1d[n5];
            f3 = cs[4];
            f4 = ca[4];
            LayerIIIDecoder.out_1d[n4--] = f * f3 - f2 * f4;
            LayerIIIDecoder.out_1d[n5++] = f2 * f3 + f * f4;
            f = out_1d[n4];
            f2 = out_1d[n5];
            f3 = cs[5];
            f4 = ca[5];
            LayerIIIDecoder.out_1d[n4--] = f * f3 - f2 * f4;
            LayerIIIDecoder.out_1d[n5++] = f2 * f3 + f * f4;
            f = out_1d[n4];
            f2 = out_1d[n5];
            f3 = cs[6];
            f4 = ca[6];
            LayerIIIDecoder.out_1d[n4--] = f * f3 - f2 * f4;
            LayerIIIDecoder.out_1d[n5++] = f2 * f3 + f * f4;
            f = out_1d[n4];
            f2 = out_1d[n5];
            f3 = cs[7];
            f4 = ca[7];
            LayerIIIDecoder.out_1d[n4] = f * f3 - f2 * f4;
            LayerIIIDecoder.out_1d[n5] = f2 * f3 + f * f4;
        }
    }

    private final void hybrid(int n, int n2) {
        GRInfo gRInfo = si.ch[n].gr[n2];
        for (int i = 0; i < 576; i += 18) {
            int n3;
            int n4 = gRInfo.window_switching_flag != 0 && gRInfo.mixed_block_flag != 0 && i < 36 ? 0 : gRInfo.block_type;
            for (n3 = 0; n3 < 18; ++n3) {
                LayerIIIDecoder.tsOutCopy[n3] = out_1d[n3 + i];
            }
            this.invMDCT(tsOutCopy, rawout, n4);
            for (n3 = 0; n3 < 18; ++n3) {
                LayerIIIDecoder.out_1d[n3 + i] = tsOutCopy[n3];
            }
            n3 = i;
            LayerIIIDecoder.out_1d[n3] = rawout[0] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[18];
            LayerIIIDecoder.out_1d[n3] = rawout[1] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[19];
            LayerIIIDecoder.out_1d[n3] = rawout[2] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[20];
            LayerIIIDecoder.out_1d[n3] = rawout[3] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[21];
            LayerIIIDecoder.out_1d[n3] = rawout[4] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[22];
            LayerIIIDecoder.out_1d[n3] = rawout[5] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[23];
            LayerIIIDecoder.out_1d[n3] = rawout[6] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[24];
            LayerIIIDecoder.out_1d[n3] = rawout[7] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[25];
            LayerIIIDecoder.out_1d[n3] = rawout[8] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[26];
            LayerIIIDecoder.out_1d[n3] = rawout[9] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[27];
            LayerIIIDecoder.out_1d[n3] = rawout[10] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[28];
            LayerIIIDecoder.out_1d[n3] = rawout[11] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[29];
            LayerIIIDecoder.out_1d[n3] = rawout[12] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[30];
            LayerIIIDecoder.out_1d[n3] = rawout[13] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[31];
            LayerIIIDecoder.out_1d[n3] = rawout[14] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[32];
            LayerIIIDecoder.out_1d[n3] = rawout[15] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[33];
            LayerIIIDecoder.out_1d[n3] = rawout[16] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3++] = rawout[34];
            LayerIIIDecoder.out_1d[n3] = rawout[17] + prevblck[n][n3];
            LayerIIIDecoder.prevblck[n][n3] = rawout[35];
        }
    }

    /*
     * Opcode count of 15806 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        int n;
        int n2;
        int n3;
        int n4;
        pretab = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 2, 2, 3, 3, 3, 2, 0};
        two_to_negative_half_pow = new float[]{1.0f, 0.70710677f, 0.5f, 0.35355338f, 0.25f, 0.17677669f, 0.125f, 0.088388346f, 0.0625f, 0.044194173f, 0.03125f, 0.022097087f, 0.015625f, 0.011048543f, 0.0078125f, 0.0055242716f, 0.00390625f, 0.0027621358f, 0.001953125f, 0.0013810679f, 9.765625E-4f, 6.9053395E-4f, 4.8828125E-4f, 3.4526698E-4f, 2.4414062E-4f, 1.7263349E-4f, 1.2207031E-4f, 8.6316744E-5f, 6.1035156E-5f, 4.3158372E-5f, 3.0517578E-5f, 2.1579186E-5f, 1.5258789E-5f, 1.0789593E-5f, 7.6293945E-6f, 5.3947965E-6f, 3.8146973E-6f, 2.6973983E-6f, 1.9073486E-6f, 1.3486991E-6f, 9.536743E-7f, 6.7434956E-7f, 4.7683716E-7f, 3.3717478E-7f, 2.3841858E-7f, 1.6858739E-7f, 1.1920929E-7f, 8.4293696E-8f, 5.9604645E-8f, 4.2146848E-8f, 2.9802322E-8f, 2.1073424E-8f, 1.4901161E-8f, 1.0536712E-8f, 7.450581E-9f, 5.268356E-9f, 3.7252903E-9f, 2.634178E-9f, 1.8626451E-9f, 1.317089E-9f, 9.313226E-10f, 6.585445E-10f, 4.656613E-10f, 3.2927225E-10f};
        t_43 = new float[8192];
        double d = 1.3333333333333333;
        for (n4 = 0; n4 < 8192; ++n4) {
            LayerIIIDecoder.t_43[n4] = (float)Math.pow(n4, d);
        }
        TAN12 = new float[]{0.0f, 0.2679492f, 0.57735026f, 1.0f, 1.7320508f, 3.732051f, 1.0E11f, -3.732051f, -1.7320508f, -1.0f, -0.57735026f, -0.2679492f, 0.0f, 0.2679492f, 0.57735026f, 1.0f};
        win = new float[][]{{-0.016141215f, -0.05360318f, -0.100707136f, -0.16280818f, -0.5f, -0.38388735f, -0.6206114f, -1.1659756f, -3.8720753f, -4.225629f, -1.519529f, -0.97416484f, -0.73744076f, -1.2071068f, -0.5163616f, -0.45426053f, -0.40715656f, -0.3696946f, -0.3387627f, -0.31242222f, -0.28939587f, -0.26880082f, -0.5f, -0.23251417f, -0.21596715f, -0.20004979f, -0.18449493f, -0.16905846f, -0.15350361f, -0.13758625f, -0.12103922f, -0.20710678f, -0.084752575f, -0.06415752f, -0.041131172f, -0.014790705f}, {-0.016141215f, -0.05360318f, -0.100707136f, -0.16280818f, -0.5f, -0.38388735f, -0.6206114f, -1.1659756f, -3.8720753f, -4.225629f, -1.519529f, -0.97416484f, -0.73744076f, -1.2071068f, -0.5163616f, -0.45426053f, -0.40715656f, -0.3696946f, -0.33908543f, -0.3151181f, -0.29642227f, -0.28184548f, -0.5411961f, -0.2621323f, -0.25387916f, -0.2329629f, -0.19852729f, -0.15233535f, -0.0964964f, -0.03342383f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.0483008f, -0.15715657f, -0.28325045f, -0.42953748f, -1.2071068f, -0.8242648f, -1.1451749f, -1.769529f, -4.5470223f, -3.489053f, -0.7329629f, -0.15076515f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -0.15076514f, -0.7329629f, -3.489053f, -4.5470223f, -1.769529f, -1.1451749f, -0.8313774f, -1.306563f, -0.54142016f, -0.46528974f, -0.4106699f, -0.3700468f, -0.3387627f, -0.31242222f, -0.28939587f, -0.26880082f, -0.5f, -0.23251417f, -0.21596715f, -0.20004979f, -0.18449493f, -0.16905846f, -0.15350361f, -0.13758625f, -0.12103922f, -0.20710678f, -0.084752575f, -0.06415752f, -0.041131172f, -0.014790705f}};
        reorder_table = new int[][]{{0, 4, 8, 1, 5, 9, 2, 6, 10, 3, 7, 11, 12, 16, 20, 13, 17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30, 34, 27, 31, 35, 36, 42, 48, 37, 43, 49, 38, 44, 50, 39, 45, 51, 40, 46, 52, 41, 47, 53, 54, 60, 66, 55, 61, 67, 56, 62, 68, 57, 63, 69, 58, 64, 70, 59, 65, 71, 72, 80, 88, 73, 81, 89, 74, 82, 90, 75, 83, 91, 76, 84, 92, 77, 85, 93, 78, 86, 94, 79, 87, 95, 96, 106, 116, 97, 107, 117, 98, 108, 118, 99, 109, 119, 100, 110, 120, 101, 111, 121, 102, 112, 122, 103, 113, 123, 104, 114, 124, 105, 115, 125, 126, 140, 154, 127, 141, 155, 128, 142, 156, 129, 143, 157, 130, 144, 158, 131, 145, 159, 132, 146, 160, 133, 147, 161, 134, 148, 162, 135, 149, 163, 136, 150, 164, 137, 151, 165, 138, 152, 166, 139, 153, 167, 168, 186, 204, 169, 187, 205, 170, 188, 206, 171, 189, 207, 172, 190, 208, 173, 191, 209, 174, 192, 210, 175, 193, 211, 176, 194, 212, 177, 195, 213, 178, 196, 214, 179, 197, 215, 180, 198, 216, 181, 199, 217, 182, 200, 218, 183, 201, 219, 184, 202, 220, 185, 203, 221, 222, 248, 274, 223, 249, 275, 224, 250, 276, 225, 251, 277, 226, 252, 278, 227, 253, 279, 228, 254, 280, 229, 255, 281, 230, 256, 282, 231, 257, 283, 232, 258, 284, 233, 259, 285, 234, 260, 286, 235, 261, 287, 236, 262, 288, 237, 263, 289, 238, 264, 290, 239, 265, 291, 240, 266, 292, 241, 267, 293, 242, 268, 294, 243, 269, 295, 244, 270, 296, 245, 271, 297, 246, 272, 298, 247, 273, 299, 300, 332, 364, 301, 333, 365, 302, 334, 366, 303, 335, 367, 304, 336, 368, 305, 337, 369, 306, 338, 370, 307, 339, 371, 308, 340, 372, 309, 341, 373, 310, 342, 374, 311, 343, 375, 312, 344, 376, 313, 345, 377, 314, 346, 378, 315, 347, 379, 316, 348, 380, 317, 349, 381, 318, 350, 382, 319, 351, 383, 320, 352, 384, 321, 353, 385, 322, 354, 386, 323, 355, 387, 324, 356, 388, 325, 357, 389, 326, 358, 390, 327, 359, 391, 328, 360, 392, 329, 361, 393, 330, 362, 394, 331, 363, 395, 396, 438, 480, 397, 439, 481, 398, 440, 482, 399, 441, 483, 400, 442, 484, 401, 443, 485, 402, 444, 486, 403, 445, 487, 404, 446, 488, 405, 447, 489, 406, 448, 490, 407, 449, 491, 408, 450, 492, 409, 451, 493, 410, 452, 494, 411, 453, 495, 412, 454, 496, 413, 455, 497, 414, 456, 498, 415, 457, 499, 416, 458, 500, 417, 459, 501, 418, 460, 502, 419, 461, 503, 420, 462, 504, 421, 463, 505, 422, 464, 506, 423, 465, 507, 424, 466, 508, 425, 467, 509, 426, 468, 510, 427, 469, 511, 428, 470, 512, 429, 471, 513, 430, 472, 514, 431, 473, 515, 432, 474, 516, 433, 475, 517, 434, 476, 518, 435, 477, 519, 436, 478, 520, 437, 479, 521, 522, 540, 558, 523, 541, 559, 524, 542, 560, 525, 543, 561, 526, 544, 562, 527, 545, 563, 528, 546, 564, 529, 547, 565, 530, 548, 566, 531, 549, 567, 532, 550, 568, 533, 551, 569, 534, 552, 570, 535, 553, 571, 536, 554, 572, 537, 555, 573, 538, 556, 574, 539, 557, 575}, {0, 4, 8, 1, 5, 9, 2, 6, 10, 3, 7, 11, 12, 16, 20, 13, 17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30, 34, 27, 31, 35, 36, 42, 48, 37, 43, 49, 38, 44, 50, 39, 45, 51, 40, 46, 52, 41, 47, 53, 54, 62, 70, 55, 63, 71, 56, 64, 72, 57, 65, 73, 58, 66, 74, 59, 67, 75, 60, 68, 76, 61, 69, 77, 78, 88, 98, 79, 89, 99, 80, 90, 100, 81, 91, 101, 82, 92, 102, 83, 93, 103, 84, 94, 104, 85, 95, 105, 86, 96, 106, 87, 97, 107, 108, 120, 132, 109, 121, 133, 110, 122, 134, 111, 123, 135, 112, 124, 136, 113, 125, 137, 114, 126, 138, 115, 127, 139, 116, 128, 140, 117, 129, 141, 118, 130, 142, 119, 131, 143, 144, 158, 172, 145, 159, 173, 146, 160, 174, 147, 161, 175, 148, 162, 176, 149, 163, 177, 150, 164, 178, 151, 165, 179, 152, 166, 180, 153, 167, 181, 154, 168, 182, 155, 169, 183, 156, 170, 184, 157, 171, 185, 186, 204, 222, 187, 205, 223, 188, 206, 224, 189, 207, 225, 190, 208, 226, 191, 209, 227, 192, 210, 228, 193, 211, 229, 194, 212, 230, 195, 213, 231, 196, 214, 232, 197, 215, 233, 198, 216, 234, 199, 217, 235, 200, 218, 236, 201, 219, 237, 202, 220, 238, 203, 221, 239, 240, 264, 288, 241, 265, 289, 242, 266, 290, 243, 267, 291, 244, 268, 292, 245, 269, 293, 246, 270, 294, 247, 271, 295, 248, 272, 296, 249, 273, 297, 250, 274, 298, 251, 275, 299, 252, 276, 300, 253, 277, 301, 254, 278, 302, 255, 279, 303, 256, 280, 304, 257, 281, 305, 258, 282, 306, 259, 283, 307, 260, 284, 308, 261, 285, 309, 262, 286, 310, 263, 287, 311, 312, 344, 376, 313, 345, 377, 314, 346, 378, 315, 347, 379, 316, 348, 380, 317, 349, 381, 318, 350, 382, 319, 351, 383, 320, 352, 384, 321, 353, 385, 322, 354, 386, 323, 355, 387, 324, 356, 388, 325, 357, 389, 326, 358, 390, 327, 359, 391, 328, 360, 392, 329, 361, 393, 330, 362, 394, 331, 363, 395, 332, 364, 396, 333, 365, 397, 334, 366, 398, 335, 367, 399, 336, 368, 400, 337, 369, 401, 338, 370, 402, 339, 371, 403, 340, 372, 404, 341, 373, 405, 342, 374, 406, 343, 375, 407, 408, 452, 496, 409, 453, 497, 410, 454, 498, 411, 455, 499, 412, 456, 500, 413, 457, 501, 414, 458, 502, 415, 459, 503, 416, 460, 504, 417, 461, 505, 418, 462, 506, 419, 463, 507, 420, 464, 508, 421, 465, 509, 422, 466, 510, 423, 467, 511, 424, 468, 512, 425, 469, 513, 426, 470, 514, 427, 471, 515, 428, 472, 516, 429, 473, 517, 430, 474, 518, 431, 475, 519, 432, 476, 520, 433, 477, 521, 434, 478, 522, 435, 479, 523, 436, 480, 524, 437, 481, 525, 438, 482, 526, 439, 483, 527, 440, 484, 528, 441, 485, 529, 442, 486, 530, 443, 487, 531, 444, 488, 532, 445, 489, 533, 446, 490, 534, 447, 491, 535, 448, 492, 536, 449, 493, 537, 450, 494, 538, 451, 495, 539, 540, 552, 564, 541, 553, 565, 542, 554, 566, 543, 555, 567, 544, 556, 568, 545, 557, 569, 546, 558, 570, 547, 559, 571, 548, 560, 572, 549, 561, 573, 550, 562, 574, 551, 563, 575}, {0, 4, 8, 1, 5, 9, 2, 6, 10, 3, 7, 11, 12, 16, 20, 13, 17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30, 34, 27, 31, 35, 36, 42, 48, 37, 43, 49, 38, 44, 50, 39, 45, 51, 40, 46, 52, 41, 47, 53, 54, 62, 70, 55, 63, 71, 56, 64, 72, 57, 65, 73, 58, 66, 74, 59, 67, 75, 60, 68, 76, 61, 69, 77, 78, 88, 98, 79, 89, 99, 80, 90, 100, 81, 91, 101, 82, 92, 102, 83, 93, 103, 84, 94, 104, 85, 95, 105, 86, 96, 106, 87, 97, 107, 108, 120, 132, 109, 121, 133, 110, 122, 134, 111, 123, 135, 112, 124, 136, 113, 125, 137, 114, 126, 138, 115, 127, 139, 116, 128, 140, 117, 129, 141, 118, 130, 142, 119, 131, 143, 144, 158, 172, 145, 159, 173, 146, 160, 174, 147, 161, 175, 148, 162, 176, 149, 163, 177, 150, 164, 178, 151, 165, 179, 152, 166, 180, 153, 167, 181, 154, 168, 182, 155, 169, 183, 156, 170, 184, 157, 171, 185, 186, 204, 222, 187, 205, 223, 188, 206, 224, 189, 207, 225, 190, 208, 226, 191, 209, 227, 192, 210, 228, 193, 211, 229, 194, 212, 230, 195, 213, 231, 196, 214, 232, 197, 215, 233, 198, 216, 234, 199, 217, 235, 200, 218, 236, 201, 219, 237, 202, 220, 238, 203, 221, 239, 240, 264, 288, 241, 265, 289, 242, 266, 290, 243, 267, 291, 244, 268, 292, 245, 269, 293, 246, 270, 294, 247, 271, 295, 248, 272, 296, 249, 273, 297, 250, 274, 298, 251, 275, 299, 252, 276, 300, 253, 277, 301, 254, 278, 302, 255, 279, 303, 256, 280, 304, 257, 281, 305, 258, 282, 306, 259, 283, 307, 260, 284, 308, 261, 285, 309, 262, 286, 310, 263, 287, 311, 312, 342, 372, 313, 343, 373, 314, 344, 374, 315, 345, 375, 316, 346, 376, 317, 347, 377, 318, 348, 378, 319, 349, 379, 320, 350, 380, 321, 351, 381, 322, 352, 382, 323, 353, 383, 324, 354, 384, 325, 355, 385, 326, 356, 386, 327, 357, 387, 328, 358, 388, 329, 359, 389, 330, 360, 390, 331, 361, 391, 332, 362, 392, 333, 363, 393, 334, 364, 394, 335, 365, 395, 336, 366, 396, 337, 367, 397, 338, 368, 398, 339, 369, 399, 340, 370, 400, 341, 371, 401, 402, 442, 482, 403, 443, 483, 404, 444, 484, 405, 445, 485, 406, 446, 486, 407, 447, 487, 408, 448, 488, 409, 449, 489, 410, 450, 490, 411, 451, 491, 412, 452, 492, 413, 453, 493, 414, 454, 494, 415, 455, 495, 416, 456, 496, 417, 457, 497, 418, 458, 498, 419, 459, 499, 420, 460, 500, 421, 461, 501, 422, 462, 502, 423, 463, 503, 424, 464, 504, 425, 465, 505, 426, 466, 506, 427, 467, 507, 428, 468, 508, 429, 469, 509, 430, 470, 510, 431, 471, 511, 432, 472, 512, 433, 473, 513, 434, 474, 514, 435, 475, 515, 436, 476, 516, 437, 477, 517, 438, 478, 518, 439, 479, 519, 440, 480, 520, 441, 481, 521, 522, 540, 558, 523, 541, 559, 524, 542, 560, 525, 543, 561, 526, 544, 562, 527, 545, 563, 528, 546, 564, 529, 547, 565, 530, 548, 566, 531, 549, 567, 532, 550, 568, 533, 551, 569, 534, 552, 570, 535, 553, 571, 536, 554, 572, 537, 555, 573, 538, 556, 574, 539, 557, 575}, {0, 4, 8, 1, 5, 9, 2, 6, 10, 3, 7, 11, 12, 16, 20, 13, 17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30, 34, 27, 31, 35, 36, 40, 44, 37, 41, 45, 38, 42, 46, 39, 43, 47, 48, 54, 60, 49, 55, 61, 50, 56, 62, 51, 57, 63, 52, 58, 64, 53, 59, 65, 66, 74, 82, 67, 75, 83, 68, 76, 84, 69, 77, 85, 70, 78, 86, 71, 79, 87, 72, 80, 88, 73, 81, 89, 90, 100, 110, 91, 101, 111, 92, 102, 112, 93, 103, 113, 94, 104, 114, 95, 105, 115, 96, 106, 116, 97, 107, 117, 98, 108, 118, 99, 109, 119, 120, 132, 144, 121, 133, 145, 122, 134, 146, 123, 135, 147, 124, 136, 148, 125, 137, 149, 126, 138, 150, 127, 139, 151, 128, 140, 152, 129, 141, 153, 130, 142, 154, 131, 143, 155, 156, 170, 184, 157, 171, 185, 158, 172, 186, 159, 173, 187, 160, 174, 188, 161, 175, 189, 162, 176, 190, 163, 177, 191, 164, 178, 192, 165, 179, 193, 166, 180, 194, 167, 181, 195, 168, 182, 196, 169, 183, 197, 198, 216, 234, 199, 217, 235, 200, 218, 236, 201, 219, 237, 202, 220, 238, 203, 221, 239, 204, 222, 240, 205, 223, 241, 206, 224, 242, 207, 225, 243, 208, 226, 244, 209, 227, 245, 210, 228, 246, 211, 229, 247, 212, 230, 248, 213, 231, 249, 214, 232, 250, 215, 233, 251, 252, 274, 296, 253, 275, 297, 254, 276, 298, 255, 277, 299, 256, 278, 300, 257, 279, 301, 258, 280, 302, 259, 281, 303, 260, 282, 304, 261, 283, 305, 262, 284, 306, 263, 285, 307, 264, 286, 308, 265, 287, 309, 266, 288, 310, 267, 289, 311, 268, 290, 312, 269, 291, 313, 270, 292, 314, 271, 293, 315, 272, 294, 316, 273, 295, 317, 318, 348, 378, 319, 349, 379, 320, 350, 380, 321, 351, 381, 322, 352, 382, 323, 353, 383, 324, 354, 384, 325, 355, 385, 326, 356, 386, 327, 357, 387, 328, 358, 388, 329, 359, 389, 330, 360, 390, 331, 361, 391, 332, 362, 392, 333, 363, 393, 334, 364, 394, 335, 365, 395, 336, 366, 396, 337, 367, 397, 338, 368, 398, 339, 369, 399, 340, 370, 400, 341, 371, 401, 342, 372, 402, 343, 373, 403, 344, 374, 404, 345, 375, 405, 346, 376, 406, 347, 377, 407, 408, 464, 520, 409, 465, 521, 410, 466, 522, 411, 467, 523, 412, 468, 524, 413, 469, 525, 414, 470, 526, 415, 471, 527, 416, 472, 528, 417, 473, 529, 418, 474, 530, 419, 475, 531, 420, 476, 532, 421, 477, 533, 422, 478, 534, 423, 479, 535, 424, 480, 536, 425, 481, 537, 426, 482, 538, 427, 483, 539, 428, 484, 540, 429, 485, 541, 430, 486, 542, 431, 487, 543, 432, 488, 544, 433, 489, 545, 434, 490, 546, 435, 491, 547, 436, 492, 548, 437, 493, 549, 438, 494, 550, 439, 495, 551, 440, 496, 552, 441, 497, 553, 442, 498, 554, 443, 499, 555, 444, 500, 556, 445, 501, 557, 446, 502, 558, 447, 503, 559, 448, 504, 560, 449, 505, 561, 450, 506, 562, 451, 507, 563, 452, 508, 564, 453, 509, 565, 454, 510, 566, 455, 511, 567, 456, 512, 568, 457, 513, 569, 458, 514, 570, 459, 515, 571, 460, 516, 572, 461, 517, 573, 462, 518, 574, 463, 519, 575}, {0, 4, 8, 1, 5, 9, 2, 6, 10, 3, 7, 11, 12, 16, 20, 13, 17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30, 34, 27, 31, 35, 36, 40, 44, 37, 41, 45, 38, 42, 46, 39, 43, 47, 48, 54, 60, 49, 55, 61, 50, 56, 62, 51, 57, 63, 52, 58, 64, 53, 59, 65, 66, 72, 78, 67, 73, 79, 68, 74, 80, 69, 75, 81, 70, 76, 82, 71, 77, 83, 84, 94, 104, 85, 95, 105, 86, 96, 106, 87, 97, 107, 88, 98, 108, 89, 99, 109, 90, 100, 110, 91, 101, 111, 92, 102, 112, 93, 103, 113, 114, 126, 138, 115, 127, 139, 116, 128, 140, 117, 129, 141, 118, 130, 142, 119, 131, 143, 120, 132, 144, 121, 133, 145, 122, 134, 146, 123, 135, 147, 124, 136, 148, 125, 137, 149, 150, 164, 178, 151, 165, 179, 152, 166, 180, 153, 167, 181, 154, 168, 182, 155, 169, 183, 156, 170, 184, 157, 171, 185, 158, 172, 186, 159, 173, 187, 160, 174, 188, 161, 175, 189, 162, 176, 190, 163, 177, 191, 192, 208, 224, 193, 209, 225, 194, 210, 226, 195, 211, 227, 196, 212, 228, 197, 213, 229, 198, 214, 230, 199, 215, 231, 200, 216, 232, 201, 217, 233, 202, 218, 234, 203, 219, 235, 204, 220, 236, 205, 221, 237, 206, 222, 238, 207, 223, 239, 240, 260, 280, 241, 261, 281, 242, 262, 282, 243, 263, 283, 244, 264, 284, 245, 265, 285, 246, 266, 286, 247, 267, 287, 248, 268, 288, 249, 269, 289, 250, 270, 290, 251, 271, 291, 252, 272, 292, 253, 273, 293, 254, 274, 294, 255, 275, 295, 256, 276, 296, 257, 277, 297, 258, 278, 298, 259, 279, 299, 300, 326, 352, 301, 327, 353, 302, 328, 354, 303, 329, 355, 304, 330, 356, 305, 331, 357, 306, 332, 358, 307, 333, 359, 308, 334, 360, 309, 335, 361, 310, 336, 362, 311, 337, 363, 312, 338, 364, 313, 339, 365, 314, 340, 366, 315, 341, 367, 316, 342, 368, 317, 343, 369, 318, 344, 370, 319, 345, 371, 320, 346, 372, 321, 347, 373, 322, 348, 374, 323, 349, 375, 324, 350, 376, 325, 351, 377, 378, 444, 510, 379, 445, 511, 380, 446, 512, 381, 447, 513, 382, 448, 514, 383, 449, 515, 384, 450, 516, 385, 451, 517, 386, 452, 518, 387, 453, 519, 388, 454, 520, 389, 455, 521, 390, 456, 522, 391, 457, 523, 392, 458, 524, 393, 459, 525, 394, 460, 526, 395, 461, 527, 396, 462, 528, 397, 463, 529, 398, 464, 530, 399, 465, 531, 400, 466, 532, 401, 467, 533, 402, 468, 534, 403, 469, 535, 404, 470, 536, 405, 471, 537, 406, 472, 538, 407, 473, 539, 408, 474, 540, 409, 475, 541, 410, 476, 542, 411, 477, 543, 412, 478, 544, 413, 479, 545, 414, 480, 546, 415, 481, 547, 416, 482, 548, 417, 483, 549, 418, 484, 550, 419, 485, 551, 420, 486, 552, 421, 487, 553, 422, 488, 554, 423, 489, 555, 424, 490, 556, 425, 491, 557, 426, 492, 558, 427, 493, 559, 428, 494, 560, 429, 495, 561, 430, 496, 562, 431, 497, 563, 432, 498, 564, 433, 499, 565, 434, 500, 566, 435, 501, 567, 436, 502, 568, 437, 503, 569, 438, 504, 570, 439, 505, 571, 440, 506, 572, 441, 507, 573, 442, 508, 574, 443, 509, 575}, {0, 4, 8, 1, 5, 9, 2, 6, 10, 3, 7, 11, 12, 16, 20, 13, 17, 21, 14, 18, 22, 15, 19, 23, 24, 28, 32, 25, 29, 33, 26, 30, 34, 27, 31, 35, 36, 40, 44, 37, 41, 45, 38, 42, 46, 39, 43, 47, 48, 54, 60, 49, 55, 61, 50, 56, 62, 51, 57, 63, 52, 58, 64, 53, 59, 65, 66, 74, 82, 67, 75, 83, 68, 76, 84, 69, 77, 85, 70, 78, 86, 71, 79, 87, 72, 80, 88, 73, 81, 89, 90, 102, 114, 91, 103, 115, 92, 104, 116, 93, 105, 117, 94, 106, 118, 95, 107, 119, 96, 108, 120, 97, 109, 121, 98, 110, 122, 99, 111, 123, 100, 112, 124, 101, 113, 125, 126, 142, 158, 127, 143, 159, 128, 144, 160, 129, 145, 161, 130, 146, 162, 131, 147, 163, 132, 148, 164, 133, 149, 165, 134, 150, 166, 135, 151, 167, 136, 152, 168, 137, 153, 169, 138, 154, 170, 139, 155, 171, 140, 156, 172, 141, 157, 173, 174, 194, 214, 175, 195, 215, 176, 196, 216, 177, 197, 217, 178, 198, 218, 179, 199, 219, 180, 200, 220, 181, 201, 221, 182, 202, 222, 183, 203, 223, 184, 204, 224, 185, 205, 225, 186, 206, 226, 187, 207, 227, 188, 208, 228, 189, 209, 229, 190, 210, 230, 191, 211, 231, 192, 212, 232, 193, 213, 233, 234, 260, 286, 235, 261, 287, 236, 262, 288, 237, 263, 289, 238, 264, 290, 239, 265, 291, 240, 266, 292, 241, 267, 293, 242, 268, 294, 243, 269, 295, 244, 270, 296, 245, 271, 297, 246, 272, 298, 247, 273, 299, 248, 274, 300, 249, 275, 301, 250, 276, 302, 251, 277, 303, 252, 278, 304, 253, 279, 305, 254, 280, 306, 255, 281, 307, 256, 282, 308, 257, 283, 309, 258, 284, 310, 259, 285, 311, 312, 346, 380, 313, 347, 381, 314, 348, 382, 315, 349, 383, 316, 350, 384, 317, 351, 385, 318, 352, 386, 319, 353, 387, 320, 354, 388, 321, 355, 389, 322, 356, 390, 323, 357, 391, 324, 358, 392, 325, 359, 393, 326, 360, 394, 327, 361, 395, 328, 362, 396, 329, 363, 397, 330, 364, 398, 331, 365, 399, 332, 366, 400, 333, 367, 401, 334, 368, 402, 335, 369, 403, 336, 370, 404, 337, 371, 405, 338, 372, 406, 339, 373, 407, 340, 374, 408, 341, 375, 409, 342, 376, 410, 343, 377, 411, 344, 378, 412, 345, 379, 413, 414, 456, 498, 415, 457, 499, 416, 458, 500, 417, 459, 501, 418, 460, 502, 419, 461, 503, 420, 462, 504, 421, 463, 505, 422, 464, 506, 423, 465, 507, 424, 466, 508, 425, 467, 509, 426, 468, 510, 427, 469, 511, 428, 470, 512, 429, 471, 513, 430, 472, 514, 431, 473, 515, 432, 474, 516, 433, 475, 517, 434, 476, 518, 435, 477, 519, 436, 478, 520, 437, 479, 521, 438, 480, 522, 439, 481, 523, 440, 482, 524, 441, 483, 525, 442, 484, 526, 443, 485, 527, 444, 486, 528, 445, 487, 529, 446, 488, 530, 447, 489, 531, 448, 490, 532, 449, 491, 533, 450, 492, 534, 451, 493, 535, 452, 494, 536, 453, 495, 537, 454, 496, 538, 455, 497, 539, 540, 552, 564, 541, 553, 565, 542, 554, 566, 543, 555, 567, 544, 556, 568, 545, 557, 569, 546, 558, 570, 547, 559, 571, 548, 560, 572, 549, 561, 573, 550, 562, 574, 551, 563, 575}};
        slen0 = new int[]{0, 0, 0, 0, 3, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4};
        slen1 = new int[]{0, 1, 2, 3, 0, 1, 2, 3, 1, 2, 3, 1, 2, 3, 2, 3};
        huff = new HuffmanTables.Huffman();
        is_pos = new int[576];
        is_ratio = new float[576];
        tsOutCopy = new float[18];
        rawout = new float[36];
        is_1d = new int[580];
        ro = new float[2][32][18];
        lr = new float[2][32][18];
        out_1d = new float[576];
        prevblck = new float[2][576];
        k = new float[2][576];
        scalefac0L = new int[23];
        scalefac0S = new int[3][13];
        scalefac1L = new int[23];
        scalefac1S = new int[3][13];
        samples1 = new float[32];
        samples2 = new float[32];
        stab = new byte[][][]{new byte[][]{{6, 5, 5, 5}, {6, 5, 7, 3}, {11, 10, 0, 0}, {7, 7, 7, 0}, {6, 6, 6, 3}, {8, 8, 5, 0}}, new byte[][]{{9, 9, 9, 9}, {9, 9, 12, 6}, {18, 18, 0, 0}, {12, 12, 12, 0}, {12, 9, 9, 6}, {15, 12, 9, 0}}, new byte[][]{{6, 9, 9, 9}, {6, 9, 12, 6}, {15, 18, 0, 0}, {6, 15, 12, 0}, {6, 12, 9, 6}, {6, 18, 9, 0}}};
        n_slen2 = new int[512];
        i_slen2 = new int[256];
        for (n3 = 0; n3 < 5; ++n3) {
            for (n2 = 0; n2 < 6; ++n2) {
                for (n4 = 0; n4 < 6; ++n4) {
                    n = n4 + n2 * 6 + n3 * 36;
                    LayerIIIDecoder.i_slen2[n] = n3 | n2 << 3 | n4 << 6 | 0x3000;
                }
            }
        }
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < 4; ++n2) {
                for (n4 = 0; n4 < 4; ++n4) {
                    n = n4 + n2 * 4 + n3 * 16;
                    LayerIIIDecoder.i_slen2[n + 180] = n3 | n2 << 3 | n4 << 6 | 0x4000;
                }
            }
        }
        for (n3 = 0; n3 < 4; ++n3) {
            for (n2 = 0; n2 < 3; ++n2) {
                n = n2 + n3 * 3;
                LayerIIIDecoder.i_slen2[n + 244] = n3 | n2 << 3 | 0x5000;
                LayerIIIDecoder.n_slen2[n + 500] = n3 | n2 << 3 | 0x2000 | 0x8000;
            }
        }
        for (n3 = 0; n3 < 5; ++n3) {
            for (n2 = 0; n2 < 5; ++n2) {
                for (n4 = 0; n4 < 4; ++n4) {
                    for (int i = 0; i < 4; ++i) {
                        n = i + n4 * 4 + n2 * 16 + n3 * 80;
                        LayerIIIDecoder.n_slen2[n] = n3 | n2 << 3 | n4 << 6 | i << 9 | 0;
                    }
                }
            }
        }
        for (n3 = 0; n3 < 5; ++n3) {
            for (n2 = 0; n2 < 5; ++n2) {
                for (n4 = 0; n4 < 4; ++n4) {
                    n = n4 + n2 * 4 + n3 * 20;
                    LayerIIIDecoder.n_slen2[n + 400] = n3 | n2 << 3 | n4 << 6 | 0x1000;
                }
            }
        }
        cs = new float[]{0.8574929f, 0.881742f, 0.94962865f, 0.9833146f, 0.9955178f, 0.9991606f, 0.9998992f, 0.99999315f};
        ca = new float[]{-0.51449573f, -0.47173196f, -0.31337744f, -0.1819132f, -0.09457419f, -0.040965583f, -0.014198569f, -0.0036999746f};
    }

    private static final class Channel {
        private final int[] scfsi = new int[4];
        private final GRInfo[] gr = new GRInfo[2];

        public Channel() {
            this.gr[0] = new GRInfo();
            this.gr[1] = new GRInfo();
        }
    }

    private static final class SideInfo {
        private int main_data_begin;
        private int private_bits;
        private final Channel[] ch = new Channel[2];

        public SideInfo() {
            this.ch[0] = new Channel();
            this.ch[1] = new Channel();
        }
    }

    private static final class GRInfo {
        private int part2_3_length;
        private int big_values;
        private int global_gain;
        private int scalefac_compress;
        private int window_switching_flag;
        private int block_type;
        private int mixed_block_flag;
        private final int[] table_select = new int[3];
        private final int[] subblock_gain = new int[3];
        private int region0_count;
        private int region1_count;
        private int preflag;
        private int scalefac_scale;
        private int count1table_select;

        private GRInfo() {
        }
    }
}

