/*
 *  kaction_32.h  -  kdelibs KToggleAction class for KDE < 3.3 compatibility
 *  Program:  kalarm
 *  Copyright (c) 2004 by David Jarvie <software@astrojar.org.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __kaction_32_h__
#define __kaction_32_h__

#ifdef KToggleAction
#undef KToggleAction
#endif

#include <kdeversion.h>
#include <kaction.h>

class KToggleAction_32 : public KToggleAction
{
  public:
#if KDE_VERSION >= 290
    KToggleAction_32(const QString& text, const KShortcut& cut = KShortcut(), QObject* parent = 0, const char* name = 0)
		: KToggleAction(text, cut, parent, name) { }
    KToggleAction_32(const QString& text, const KShortcut& cut, const QObject* receiver, const char* slot, QObject* parent, const char* name = 0)
		: KToggleAction(text, cut, receiver, slot, parent, name) { }
    KToggleAction_32(const QString& text, const QString& icon, const KShortcut& cut, const QObject* receiver, const char* slot, QObject* parent, const char* name = 0)
		: KToggleAction(text, icon, cut, receiver, slot, parent, name) { }
#else
    KToggleAction_32(const QString& text, int cut = 0, QObject* parent = 0, const char* name = 0)
		: KToggleAction(text, cut, parent, name) { }
    KToggleAction_32(const QString& text, int cut, const QObject* receiver, const char* slot, QObject* parent, const char* name = 0)
		: KToggleAction(text, cut, receiver, slot, parent, name) { }
    KToggleAction_32(const QString& text, const QString& icon, int cut, const QObject* receiver, const char* slot, QObject* parent, const char* name = 0)
		: KToggleAction(text, icon, cut, receiver, slot, parent, name) { }
#endif
    void  setCheckedState(const QString&)  { }
};

#define KToggleAction KToggleAction_32

#endif
