/*
 *  kdialogbase_32.h  -  kdelibs KDialogBase class for KDE < 3.3 compatibility
 *  Program:  kalarm
 *  Copyright (c) 2006 by David Jarvie <software@astrojar.org.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __kdialogbase_32_h__
#define __kdialogbase_32_h__

#ifdef KDialogBase
#undef KDialogBase
#endif

#include <kdialogbase.h>

class KDialogBase_32 : public KDialogBase
{
  public:
    KDialogBase_32(QWidget *parent=0, const char *name=0, bool modal=true, const QString &caption=QString::null,
                   int buttonMask=Ok|Apply|Cancel, ButtonCode defaultButton=Ok, bool separator=false,
                   const KGuiItem &user1=KGuiItem(), const KGuiItem &user2=KGuiItem(), const KGuiItem &user3=KGuiItem())
        : KDialogBase(parent, name, modal, caption, buttonMask, defaultButton, separator, user1, user2, user3) { }
    KDialogBase_32(int dialogFace, const QString &caption, int buttonMask, ButtonCode defaultButton,
                   QWidget *parent=0, const char *name=0, bool modal=true, bool separator=false,
                   const KGuiItem &user1=KGuiItem(), const KGuiItem &user2=KGuiItem(), const KGuiItem &user3=KGuiItem())
        : KDialogBase(dialogFace, caption, buttonMask, defaultButton, parent, name, modal, separator, user1, user2, user3) { }
    KDialogBase_32(KDialogBase::DialogType dialogFace, WFlags f,
                   QWidget *parent=0, const char *name=0, bool modal=true, const QString &caption=QString::null,
                   int buttonMask=Ok|Apply|Cancel, ButtonCode defaultButton=Ok, bool separator=false,
                   const KGuiItem &user1=KGuiItem(), const KGuiItem &user2=KGuiItem(), const KGuiItem &user3=KGuiItem())
        : KDialogBase(dialogFace, f, parent, name, modal, caption, buttonMask, defaultButton, separator, user1, user2, user3) { }
    KDialogBase_32(const QString &caption, int buttonMask=Yes|No|Cancel,
                   ButtonCode defaultButton=Yes, ButtonCode escapeButton=Cancel,
                   QWidget *parent=0, const char *name=0, bool modal=true, bool separator=false,
                   const KGuiItem &yes = KStdGuiItem::yes(), const KGuiItem &no = KStdGuiItem::no(), const KGuiItem &cancel = KStdGuiItem::cancel())
        : KDialogBase(caption, buttonMask, defaultButton, escapeButton, parent, name, modal, separator, yes, no, cancel) { }
    void setButtonGuiItem(ButtonCode id, const KGuiItem &item);
};

#define KDialogBase KDialogBase_32

#endif
