/*
 *  kstdguiitem_33.h  -  kdelibs KStdGuiItem class for KDE < 3.4 compatibility
 *  Program:  kalarm
 *  Copyright (c) 2004,2006 by David Jarvie <software@astrojar.org.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __kstdguiitem_33_h__
#define __kstdguiitem_33_h__

#ifdef KStdGuiItem
#undef KStdGuiItem
#endif

#include <kstdguiitem.h>
#include <kaction.h>
#include <klocale.h>

class KStdGuiItem_33 : public KStdGuiItem
{
  public:
    class quit
    {
      public:
        static QString text()
        {
          KAction* action = KStdAction::quit(0, 0, 0);
          QString label = action->text();
          delete action;
          return label;
        }
        operator QString() const   { return text(); }
        operator KGuiItem() const  { return KGuiItem(text()); }
      private:
        static QString label;
    };
    class remove
    {
      public:
        static QString text()
        {
          if (label.isEmpty())
            label = i18n("Remove");
          return label;
        }
        operator QString() const   { return text(); }
        operator KGuiItem() const  { return KGuiItem(text(), "remove"); }
      private:
        static QString label;
    };
};

#define KStdGuiItem KStdGuiItem_33

#endif
