/*
 *  editdlgtypes.h  -  dialogues to create or edit alarm or template types
 *  Program:  kalarm
 *  Copyright © 2001-2008 by David Jarvie <software@astrojar.org.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef EDITDLGTYPES_H
#define EDITDLGTYPES_H

#include <kurl.h>

#include "alarmevent.h"
#include "alarmtext.h"
#include "editdlg.h"

class QButton;
class QGroupBox;
class QComboBox;
class QHBoxLayout;
class EmailIdCombo;
class FontColourButton;
class ColourButton;
class ButtonGroup;
class RadioButton;
class Reminder;
class SpecialActionsButton;
class CommandEdit;
class LineEdit;
class TextEdit;


class EditDisplayAlarmDlg : public EditAlarmDlg
{
		Q_OBJECT
	public:
		EditDisplayAlarmDlg(bool Template, bool newAlarm, QWidget* parent = 0,
		                    const char* name = 0, GetResourceType = RES_PROMPT);
		EditDisplayAlarmDlg(bool Template, const KAEvent*, bool newAlarm, QWidget* parent = 0,
		                    const char* name = 0, GetResourceType = RES_PROMPT, bool readOnly = false);
		virtual void    setAction(KAEvent::Action, const AlarmText& = AlarmText());

		virtual Reminder*   createReminder(QWidget* parent, const char* name = 0);
		static CheckBox*    createConfirmAckCheckbox(QWidget* parent, const char* name = 0);

		static QString  i18n_ConfirmAck();         // plain text of 'Confirm acknowledgement' checkbox
		static QString  i18n_k_ConfirmAck();       // text of 'Confirm acknowledgement' checkbox, with 'k' shortcut

	protected:
		virtual QString type_caption(bool newAlarm) const;
		virtual void    type_init(QWidget* parent, QVBoxLayout* frameLayout);
		virtual void    type_initValues(const KAEvent*);
		virtual void    type_showOptions(bool more);
		virtual void    setReadOnly(bool readOnly);
		virtual void    saveState(const KAEvent*);
		virtual bool    type_stateChanged() const;
		virtual void    type_setEvent(KAEvent&, const KDateTime&, const QString& text, int lateCancel, bool trial);
		virtual int     getAlarmFlags() const;
		virtual bool    type_validate(bool trial) { Q_UNUSED(trial); return true; }
		virtual void    type_trySuccessMessage(ShellProcess*, const QString&)  {}
		virtual CheckBox* type_createConfirmAckCheckbox(QWidget* parent, const char* name = 0)  { mConfirmAck = createConfirmAckCheckbox(parent, name); return mConfirmAck; }
		virtual bool    checkText(QString& result, bool showErrorMessage = true) const;

	private slots:
		void            slotAlarmTypeChanged(int index);
		void            slotPickFile();
		void            slotCmdScriptToggled(bool);
		void            setColours(const QColor& bg, const QColor& fg);

	private:
		void            setSoundPicker();

		// Display alarm options
		ComboBox*           mTypeCombo;
		QHBox*              mFileBox;
		QHBox*              mFilePadding;
		SoundPicker*        mSoundPicker;
		CheckBox*           mConfirmAck;
		FontColourButton*   mFontColourButton;
		SpecialActionsButton* mSpecialActionsButton;
		unsigned long       mKMailSerialNumber;  // if email text, message's KMail serial number, else 0
		bool                mReminderDeferral;
		bool                mReminderArchived;
		// Text message alarm widgets
		TextEdit*           mTextMessageEdit;    // text message edit box
		// Text file alarm widgets
		LineEdit*           mFileMessageEdit;    // text file URL edit box
		QPushButton*        mFileBrowseButton;   // text file browse button
		QString             mFileDefaultDir;     // default directory for browse button
		// Command output alarm widgets
		CommandEdit*        mCmdEdit;

		// Initial state of all controls
		int                 mSavedType;             // mTypeCombo index
		SoundPicker::Type   mSavedSoundType;        // mSoundPicker sound type
		bool                mSavedSound;            // mSoundPicker sound status
		bool                mSavedRepeatSound;      // mSoundPicker repeat status
		QString             mSavedSoundFile;        // mSoundPicker sound file
		float               mSavedSoundVolume;      // mSoundPicker volume
		float               mSavedSoundFadeVolume;  // mSoundPicker fade volume
		int                 mSavedSoundFadeSeconds; // mSoundPicker fade time
		bool                mSavedCmdScript;        // mCmdEdit->isScript() status
		bool                mSavedConfirmAck;       // mConfirmAck status
		QFont               mSavedFont;             // mFontColourButton font
		QColor              mSavedBgColour;         // mFontColourButton background colour
		QColor              mSavedFgColour;         // mFontColourButton foreground colour
		QString             mSavedPreAction;        // mSpecialActionsButton pre-alarm action
		QString             mSavedPostAction;       // mSpecialActionsButton post-alarm action
		int                 mSavedReminder;         // mReminder value
		bool                mSavedAutoClose;        // mLateCancel->isAutoClose() value
		bool                mSavedOnceOnly;         // mReminder once-only status
		bool                mSavedPreActionCancel;  // mSpecialActionsButton cancel on pre-alarm action error
};


class EditCommandAlarmDlg : public EditAlarmDlg
{
		Q_OBJECT
	public:
		EditCommandAlarmDlg(bool Template, bool newAlarm, QWidget* parent = 0,
		                    const char* name = 0, GetResourceType = RES_PROMPT);
		EditCommandAlarmDlg(bool Template, const KAEvent*, bool newAlarm, QWidget* parent = 0,
		                    const char* name = 0, GetResourceType = RES_PROMPT, bool readOnly = false);
		virtual void    setAction(KAEvent::Action, const AlarmText& = AlarmText());

		static QString  i18n_EnterScript();        // plain text of 'Enter a script' checkbox
		static QString  i18n_p_EnterScript();      // text of 'Enter a script' checkbox, with 'P' shortcut
		static QString  i18n_ExecInTermWindow();   // plain text of 'Execute in terminal window' checkbox
		static QString  i18n_w_ExecInTermWindow(); // text of 'Execute in terminal window' radio button, with 'W' shortcut
		static QString  i18n_u_ExecInTermWindow(); // text of 'Execute in terminal window' radio button, with 'U' shortcut

	protected:
		virtual QString type_caption(bool newAlarm) const;
		virtual void    type_init(QWidget* parent, QVBoxLayout* frameLayout);
		virtual void    type_initValues(const KAEvent*);
		virtual void    type_showOptions(bool more);
		virtual void    setReadOnly(bool readOnly);
		virtual void    saveState(const KAEvent*);
		virtual bool    type_stateChanged() const;
		virtual void    type_setEvent(KAEvent&, const KDateTime&, const QString& text, int lateCancel, bool trial);
		virtual int     getAlarmFlags() const;
		virtual bool    type_validate(bool trial);
		virtual void    type_trySuccessMessage(ShellProcess*, const QString& text);
		virtual bool    checkText(QString& result, bool showErrorMessage = true) const;

	private slots:
		void            slotCmdScriptToggled(bool);

	private:
		// Command alarm options
		CommandEdit*        mCmdEdit;
		ButtonGroup*        mCmdOutputGroup;     // what to do with command output
		RadioButton*        mCmdExecInTerm;
		RadioButton*        mCmdLogToFile;
		RadioButton*        mCmdDiscardOutput;
		LineEdit*           mCmdLogFileEdit;     // log file URL edit box
		QWidget*            mCmdPadding;

		// Initial state of all controls
		bool                mSavedCmdScript;        // mCmdEdit->isScript() status
		QButton*            mSavedCmdOutputRadio;   // selected button in mCmdOutputGroup
		QString             mSavedCmdLogFile;       // mCmdLogFileEdit value
};


class EditEmailAlarmDlg : public EditAlarmDlg
{
		Q_OBJECT
	public:
		EditEmailAlarmDlg(bool Template, bool newAlarm, QWidget* parent = 0,
		                  const char* name = 0, GetResourceType = RES_PROMPT);
		EditEmailAlarmDlg(bool Template, const KAEvent*, bool newAlarm, QWidget* parent = 0,
		                  const char* name = 0, GetResourceType = RES_PROMPT, bool readOnly = false);
		virtual void    setAction(KAEvent::Action, const AlarmText& = AlarmText());

		static QString  i18n_CopyEmailToSelf();    // plain text of 'Copy email to self' checkbox
		static QString  i18n_e_CopyEmailToSelf();  // text of 'Copy email to self' checkbox, with 'E' shortcut
		static QString  i18n_s_CopyEmailToSelf();  // text of 'Copy email to self' checkbox, with 'S' shortcut
		static QString  i18n_EmailFrom();          // plain text of 'From:' (email address)
		static QString  i18n_f_EmailFrom();        // text of 'From:' (email address), with 'F' shortcut
		static QString  i18n_EmailTo();            // plain text of 'To:' (email addressee)
		static QString  i18n_EmailSubject();       // plain text of 'Subject:' (email)
		static QString  i18n_j_EmailSubject();     // text of 'Subject:' (email), with 'J' shortcut

	protected:
		virtual QString type_caption(bool newAlarm) const;
		virtual void    type_init(QWidget* parent, QVBoxLayout* frameLayout);
		virtual void    type_initValues(const KAEvent*);
		virtual void    type_showOptions(bool)  {}
		virtual void    setReadOnly(bool readOnly);
		virtual void    saveState(const KAEvent*);
		virtual bool    type_stateChanged() const;
		virtual void    type_setEvent(KAEvent&, const KDateTime&, const QString& text, int lateCancel, bool trial);
		virtual int     getAlarmFlags() const;
		virtual bool    type_validate(bool trial);
		virtual void    type_trySuccessMessage(ShellProcess*, const QString& text);
		virtual bool    checkText(QString& result, bool showErrorMessage = true) const;

	private slots:
		void            openAddressBook();
		void            slotAddAttachment();
		void            slotRemoveAttachment();

	private:
		// Email alarm options
		EmailIdCombo*       mEmailFromList;
		LineEdit*           mEmailToEdit;
		QPushButton*        mEmailAddressButton; // email open address book button
		LineEdit*           mEmailSubjectEdit;
		TextEdit*           mEmailMessageEdit;   // email body edit box
		QComboBox*          mEmailAttachList;
		QPushButton*        mEmailAddAttachButton;
		QPushButton*        mEmailRemoveButton;
		CheckBox*           mEmailBcc;
		QString             mAttachDefaultDir;

		EmailAddressList    mEmailAddresses;     // list of addresses to send email to
		QStringList         mEmailAttachments;   // list of email attachment file names

		// Initial state of all controls
		QString             mSavedEmailFrom;        // mEmailFromList current value
		QString             mSavedEmailTo;          // mEmailToEdit value
		QString             mSavedEmailSubject;     // mEmailSubjectEdit value
		QStringList         mSavedEmailAttach;      // mEmailAttachList values
		bool                mSavedEmailBcc;         // mEmailBcc status
};

#endif // EDITDLGTYPES_H
