/*
 *  newalarmaction.cpp  -  menu action to select a new alarm type
 *  Program:  kalarm
 *  Copyright © 2007,2008 by David Jarvie <software@astrojar.org.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "kalarm.h"
#include "newalarmaction.moc"

#include "shellprocess.h"

#include <kpopupmenu.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kstdaccel.h>
#include <kdebug.h>


#define DISP_ICON "view_remove"
#define CMD_ICON  "exec"
#define MAIL_ICON "mail_generic"
#define DISP_KEY  (Qt::CTRL+Qt::Key_D)
#define CMD_KEY   (Qt::CTRL+Qt::Key_C)
#define MAIL_KEY  (Qt::CTRL+Qt::Key_M)

bool NewAlarmAction::mLoaded = false;
static QIconSet displayIcon;
static QIconSet commandIcon;
static QIconSet mailIcon;


NewAlarmAction::NewAlarmAction(bool templates, const QString& label, QObject* parent, const char* name)
	: KActionMenu(label, "filenew", parent, name)
{
	setShortcut(KStdAccel::openNew());
	if (!mLoaded)
	{
		displayIcon = SmallIconSet(DISP_ICON);
		commandIcon = SmallIconSet(CMD_ICON);
		mailIcon    = SmallIconSet(MAIL_ICON);
		mLoaded = true;
	}
	KPopupMenu* menu = popupMenu();
	menu->insertItem(displayIcon, (templates ? i18n("&Display Alarm Template") : i18n("Display Alarm")), (int)EditAlarmDlg::DISPLAY);
	menu->setAccel(DISP_KEY, (int)EditAlarmDlg::DISPLAY);
	menu->insertItem(commandIcon, (templates ? i18n("&Command Alarm Template") : i18n("Command Alarm")), (int)EditAlarmDlg::COMMAND);
	menu->setAccel(CMD_KEY, (int)EditAlarmDlg::COMMAND);
	menu->insertItem(mailIcon, (templates ? i18n("&Email Alarm Template") : i18n("Email Alarm")), (int)EditAlarmDlg::EMAIL);
	menu->setAccel(MAIL_KEY, (int)EditAlarmDlg::EMAIL);
	setDelayed(false);
	connect(popupMenu(), SIGNAL(aboutToShow()), SLOT(slotInitMenu()));
	connect(popupMenu(), SIGNAL(activated(int)), SLOT(slotSelected(int)));
}

KAction* NewAlarmAction::newDisplayAlarmAction(KActionCollection* actcol, const QObject* receiver, const char* slot)
{
	return new KAction(i18n("New Display Alarm"), DISP_ICON, DISP_KEY, receiver, slot, actcol, "newDisplay");
}

KAction* NewAlarmAction::newCommandAlarmAction(KActionCollection* actcol, const QObject* receiver, const char* slot)
{
	return new KAction(i18n("New Command Alarm"), CMD_ICON, CMD_KEY, receiver, slot, actcol, "newCommand");
}

KAction* NewAlarmAction::newEmailAlarmAction(KActionCollection* actcol, const QObject* receiver, const char* slot)
{
	return new KAction(i18n("New Email Alarm"), MAIL_ICON, MAIL_KEY, receiver, slot, actcol, "newEmail");
}

/******************************************************************************
*  Called when the action is clicked.
*/
void NewAlarmAction::slotInitMenu()
{
	// Don't allow shell commands in kiosk mode
	popupMenu()->setItemEnabled(EditAlarmDlg::COMMAND, ShellProcess::authorised());
}

/******************************************************************************
*  Called when an alarm type is selected from the New popup menu.
*/
void NewAlarmAction::slotSelected(int id)
{
	emit selected(static_cast<EditAlarmDlg::Type>(id));
}
