/*
 *  newalarmaction.h  -  menu action to select a new alarm type
 *  Program:  kalarm
 *  Copyright © 2007,2008 by David Jarvie <software@astrojar.org.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef NEWALARMACTION_H
#define NEWALARMACTION_H

#include <kactionclasses.h>
#include "editdlg.h"

class NewAlarmAction : public KActionMenu
{
		Q_OBJECT
	public:
		// In constructor, 'parent' should be the KActionCollection where applicable.
		NewAlarmAction(bool templates, const QString& label, QObject* parent, const char* name = 0);
		virtual ~NewAlarmAction() {}
		static KAction* newDisplayAlarmAction(KActionCollection*, const QObject* receiver, const char* slot);
		static KAction* newCommandAlarmAction(KActionCollection*, const QObject* receiver, const char* slot);
		static KAction* newEmailAlarmAction(KActionCollection*, const QObject* receiver, const char* slot);

	signals:
		void   selected(EditAlarmDlg::Type);

	private slots:
		void   slotSelected(int);
		void   slotInitMenu();

	private:
		static bool mLoaded;
};

#endif // NEWALARMACTION_H
