/*
 *  prefdlg_p.h  -  private classes for program preferences dialog
 *  Program:  kalarm
 *  Copyright © 2001-2008 by David Jarvie <software@astrojar.org.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef PREFDLG_P_H
#define PREFDLG_P_H

#include "preferences.h"
#include "recurrenceedit.h"
#include "soundpicker.h"
#include "stackedwidgets.h"
#include "prefdlg.h"

#include <qmap.h>

class QButtonGroup;
class QLabel;
class QCheckBox;
class QRadioButton;
class QPushButton;
class QComboBox;
class QSpinBox;
class QLineEdit;
class KComboBox;
class FontColourChooser;
class ColourButton;
class ButtonGroup;
class TimeEdit;
class SpinBox;
class SpecialActionsButton;
class TimeZoneCombo;


// Base class for each tab in the Preferences dialog
class PrefsTabBase : public StackedScrollWidget
{
	public:
		PrefsTabBase(StackedScrollGroup*, QVBox*);

		void         setPreferences();
		virtual void restore() = 0;
		virtual void apply(bool syncToDisc) = 0;
		virtual void setDefaults() = 0;
		static int   indentWidth()    { return mIndentWidth; }

	protected:
		QVBox*       mPage;

	private:
		static int   mIndentWidth;       // indent width for checkboxes etc.
};


// Miscellaneous tab of the Preferences dialog
class MiscPrefTab : public PrefsTabBase
{
		Q_OBJECT
	public:
		MiscPrefTab(StackedScrollGroup*, QVBox*);

		virtual void restore();
		virtual void apply(bool syncToDisc);
		virtual void setDefaults();

	private slots:
		void         slotOtherTerminalToggled(bool);
		void         slotAutostartClicked();

	private:
		QCheckBox*     mAutoStart;
		QCheckBox*     mQuitWarn;
		QCheckBox*     mConfirmAlarmDeletion;
		QButtonGroup*  mXtermType;
		QLineEdit*     mXtermCommand;
		int            mXtermFirst;              // id of first terminal window radio button
		int            mXtermCount;              // number of terminal window types
};


// Date/time tab of the Preferences dialog
class TimePrefTab : public PrefsTabBase
{
		Q_OBJECT
	public:
		TimePrefTab(StackedScrollGroup*, QVBox*);

		virtual void restore();
		virtual void apply(bool syncToDisc);
		virtual void setDefaults();

	private:
		void         setWorkDays(const QBitArray& days);
		void         setHolidays(const QString& regionCode);

		TimeZoneCombo* mTimeZone;
		KComboBox*     mHolidays;
		TimeEdit*      mStartOfDay;
		QCheckBox*     mWorkDays[7];
		TimeEdit*      mWorkStart;
		TimeEdit*      mWorkEnd;
		QMap<QString, QString> mHolidayNames;
};


// Storage tab of the Preferences dialog
class StorePrefTab : public PrefsTabBase
{
		Q_OBJECT
	public:
		StorePrefTab(StackedScrollGroup*, QVBox*);

		virtual void restore();
		virtual void apply(bool syncToDisc);
		virtual void setDefaults();

	private slots:
		void         slotArchivedToggled(bool);
		void         slotClearArchived();

	private:
		void         setArchivedControls(int purgeDays);

		QRadioButton*  mDefaultResource;
		QRadioButton*  mAskResource;
		QCheckBox*     mKeepArchived;
		QCheckBox*     mPurgeArchived;
		SpinBox*       mPurgeAfter;
		QLabel*        mPurgeAfterLabel;
		QPushButton*   mClearArchived;
		bool           mOldKeepArchived;    // previous setting of keep-archived
		bool           mCheckKeepChanges;
};


// Email tab of the Preferences dialog
class EmailPrefTab : public PrefsTabBase
{
		Q_OBJECT
	public:
		EmailPrefTab(StackedScrollGroup*, QVBox*);

		QString      validate();
		virtual void restore();
		virtual void apply(bool syncToDisc);
		virtual void setDefaults();

	private slots:
		void         slotEmailClientChanged(int);
		void         slotFromAddrChanged(int);
		void         slotBccAddrChanged(int);
		void         slotAddressChanged()    { mAddressChanged = true; }

	private:
		void         setEmailAddress(Preferences::MailFrom, const QString& address);
		void         setEmailBccAddress(bool useControlCentre, const QString& address);
		QString      validateAddr(ButtonGroup*, QLineEdit* addr, const QString& msg);

		ButtonGroup*   mEmailClient;
		ButtonGroup*   mFromAddressGroup;
		QLineEdit*     mEmailAddress;
		ButtonGroup*   mBccAddressGroup;
		QLineEdit*     mEmailBccAddress;
		QCheckBox*     mEmailQueuedNotify;
		QCheckBox*     mEmailCopyToKMail;
		bool           mAddressChanged;
		bool           mBccAddressChanged;
};


// Edit defaults tab of the Preferences dialog
class EditPrefTab : public PrefsTabBase
{
		Q_OBJECT
	public:
		EditPrefTab(StackedScrollGroup*, QVBox*);

		QString      validate();
		virtual void restore();
		virtual void apply(bool syncToDisc);
		virtual void setDefaults();

	private slots:
		void         slotBrowseSoundFile();

	private:
		QCheckBox*      mAutoClose;
		QCheckBox*      mConfirmAck;
		QComboBox*      mReminderUnits;
		SpecialActionsButton* mSpecialActionsButton;
		QCheckBox*      mCmdScript;
		QCheckBox*      mCmdXterm;
		QCheckBox*      mEmailBcc;
		QComboBox*      mSound;
		QLabel*         mSoundFileLabel;
		QLineEdit*      mSoundFile;
		QPushButton*    mSoundFileBrowse;
		QCheckBox*      mSoundRepeat;
		QCheckBox*      mCopyToKOrganizer;
		QCheckBox*      mLateCancel;
		QComboBox*      mRecurPeriod;
		QButtonGroup*   mFeb29;
		FontColourChooser* mFontChooser;

		static int soundIndex(SoundPicker::Type);
		static int recurIndex(RecurrenceEdit::RepeatType);
};


// View tab of the Preferences dialog
class ViewPrefTab : public PrefsTabBase
{
		Q_OBJECT
	public:
		ViewPrefTab(StackedScrollGroup*, QVBox*);

		virtual void restore();
		virtual void apply(bool syncToDisc);
		virtual void setDefaults();

	private slots:
		void         slotTooltipAlarmsToggled(bool);
		void         slotTooltipMaxToggled(bool);
		void         slotTooltipTimeToggled(bool);
		void         slotTooltipTimeToToggled(bool);
		void         slotWindowPosChanged(int);

	private:
		void         setTooltip(int maxAlarms, bool time, bool timeTo, const QString& prefix);

		ColourButton*  mDisabledColour;
		ColourButton*  mArchivedColour;
		QCheckBox*     mShowInSystemTray;
		QCheckBox*     mTooltipShowAlarms;
		QCheckBox*     mTooltipMaxAlarms;
		SpinBox*       mTooltipMaxAlarmCount;
		QCheckBox*     mTooltipShowTime;
		QCheckBox*     mTooltipShowTimeTo;
		QLineEdit*     mTooltipTimeToPrefix;
		QLabel*        mTooltipTimeToPrefixLabel;
		ButtonGroup*   mWindowPosition;
		QSpinBox*      mWindowButtonDelay;
		QLabel*        mWindowButtonDelayLabel;
		QCheckBox*     mModalMessages;
};

#endif // PREFDLG_P_H
