/*
 *  resourceselector.cpp  -  alarm calendar resource selection widget
 *  Program:  kalarm
 *  Copyright © 2006-2008 by David Jarvie <software@astrojar.org.uk>
 *  Based on KOrganizer's ResourceView class and KAddressBook's ResourceSelection class,
 *  Copyright (C) 2003,2004 Cornelius Schumacher <schumacher@kde.org>
 *  Copyright (C) 2003-2004 Reinhold Kainhofer <reinhold@kainhofer.com>
 *  Copyright (c) 2004 Tobias Koenig <tokoe@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef RESOURCESELECTOR_H
#define RESOURCESELECTOR_H

#include <qframe.h>
#include <qsize.h>
#include "alarmresource.h"
#include "alarmresources.h"

class QComboBox;
class QPushButton;
class QListViewItem;
class QResizeEvent;
class KAction;
class KActionCollection;
class KToggleAction;
class KListView;
class KPopupMenu;
class ResourceItem;
class ResourceListTooltip;
using KCal::ResourceCalendar;


/**
  This class provides a view of alarm calendar resources.
*/
class ResourceSelector : public QFrame
{
	Q_OBJECT
	friend class ResourceItem;
    public:
	explicit ResourceSelector(AlarmResources*, QWidget* parent = 0, const char* name = 0);
	~ResourceSelector();
	AlarmResources* calendar() const    { return mCalendar; }
	void  initActions(KActionCollection*);
	void  setContextMenu(KPopupMenu*);

    public slots:
	void  archiveDaysChanged(int days);

    signals:
	void  resized(const QSize& oldSize, const QSize& newSize);

    protected:
	virtual void resizeEvent(QResizeEvent*);

    private slots:
	void  refreshList();
	void  addResource();
	void  editResource();
	void  removeResource();
	void  addItem(AlarmResource*);
	void  updateItem(AlarmResource*);
	void  selectionChanged(QListViewItem*);
	void  clicked(QListViewItem*);
	void  contextMenuRequested(QListViewItem*, const QPoint&, int);
	void  slotStandardChanged(AlarmResource::Type);
	void  slotStatusChanged(AlarmResource*, AlarmResources::Change);
	void  slotLoaded(AlarmResource*, bool active);
	void  reloadResource();
	void  saveResource();
	void  setStandard();
	void  setColour();
	void  clearColour();
	void  importCalendar();
	void  showInfo();

    private:
	ResourceItem* findItem(AlarmResource*);
	ResourceItem* currentItem();

	AlarmResources* mCalendar;
	QComboBox*      mAlarmType;
	KListView*      mListView;
	QPushButton*    mAddButton;
	QPushButton*    mDeleteButton;
	QPushButton*    mEditButton;
	AlarmResource::Type mCurrentAlarmType;
	KPopupMenu*     mContextMenu;
	KAction*        mActionReload;
	KAction*        mActionSave;
	KAction*        mActionShowDetails;
	KAction*        mActionSetColour;
	KAction*        mActionClearColour;
	KAction*        mActionEdit;
	KAction*        mActionRemove;
	KAction*        mActionImport;
	KToggleAction*  mActionSetDefault;
	ResourceListTooltip* mTooltip;     // tooltip for showing resource details
};

#endif
