/*
 *  identity.cpp  -  email identity information
 *  Program:  kalarm
 *  Copyright (c) 2004,2007 by David Jarvie <software@astrojar.org.uk>
 *  This is a modified version of the KDEPIM file of the same name.
 *  Copyright (c) 2002-2004 Marc Mutz <mutz@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kconfig.h>
#include "identity.h"

using namespace KPIM;


static Identity* identityNull = 0;
const Identity& Identity::null()
{
    if ( !identityNull )
        identityNull = new Identity;
    return *identityNull;
}

bool Identity::operator==(const Identity& other) const
{
	return mUoid      == other.mUoid
	&&     mIdentity  == other.mIdentity
	&&     mFullName  == other.mFullName
	&&     mEmailAddr == other.mEmailAddr;
}

void Identity::readConfig(const KConfigBase* config)
{
	mUoid      = config->readUnsignedNumEntry(QString::fromLatin1("uoid"), 0);
	mIdentity  = config->readEntry(QString::fromLatin1("Identity"));
	mFullName  = config->readEntry(QString::fromLatin1("Name"));
	mEmailAddr = config->readEntry(QString::fromLatin1("Email Address"));
/*	mReplyToAddr = config->readEntry("Reply-To Address");
	mBcc = config->readEntry("Bcc");
	mFcc = config->readEntry("Fcc", "sent-mail");
	if(mFcc.isEmpty())
		mFcc = "sent-mail";*/
}

QString Identity::fullEmailAddr(void) const
{
	static const QString specials("()<>@,.;:[]");
	if (mFullName.isEmpty())
		return mEmailAddr;

	// Enclose name in double quotes if necessary
	QString result;
	bool needsQuotes = false;
	for (unsigned int i = 0;  i < mFullName.length();  i++)
	{
		if (!needsQuotes  &&  specials.contains(mFullName[i]))
			needsQuotes = true;
		else if (mFullName[i] == '\\' || mFullName[i] == '"')
		{
			needsQuotes = true;
			result += '\\';
		}
		result += mFullName[i];
	}

	if (needsQuotes)
	{
		result.insert(0,'"');
		result += '"';
	}
	result += " <" + mEmailAddr + '>';
	return result;
}
