/*
 *  identity.h  -  email identity information
 *  Program:  kalarm
 *  Copyright (c) 2004,2007 by David Jarvie <software@astrojar.org.uk>
 *  This is a modified version of the KDEPIM file of the same name,
 *  Author: Stefan Taferner <taferner@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef KPIM_IDENTITY_H
#define KPIM_IDENTITY_H

#include <qstring.h>

class KConfigBase;

namespace KPIM {

class Identity
{
	public:
		// only the identity manager should be able to construct and
		// destruct us, but then we get into problems with using
		// QValueList<Identity> and especially qHeapSort().
		friend class IdentityManager;
		Identity() : mUoid(0), mIsDefault(false) { }

		/** used for comparison*/
		bool operator==(const Identity& other) const;
		bool operator!=(const Identity& other) const   { return !operator==(other); }

		/** used for sorting*/
		bool operator<(const Identity& other) const    { if (isDefault()) return true;
		                                                 if (other.isDefault()) return false;
		                                                 return identityName() < other.identityName();
		                                               }
		bool operator>(const Identity& other) const    { return other.operator<(*this); }
		bool operator<=(const Identity& other) const   { return !operator>(other); }
		bool operator>=(const Identity& other) const   { return !operator<(other); }

		QString identityName() const    { return mIdentity; }
		QString fullName() const        { return mFullName; }
		QString emailAddr() const       { return mEmailAddr; }
		QString fullEmailAddr() const;    // get address in format "username <name@host>"
		uint    uoid() const            { return mUoid; }
		bool    isDefault() const       { return mIsDefault; }
		static const Identity& null();
		bool    isNull() const          { return mEmailAddr.isEmpty(); }

	protected:    // members for use only by IdentityManager
		void    readConfig(const KConfigBase*);
		void    setIsDefault(bool flag)    { mIsDefault = flag; }

	private:
		uint    mUoid;          // Unique Object Identifier
		QString mIdentity;      // identity/nickname
		QString mFullName;      // full display name of user
		QString mEmailAddr;     // email address (without the user name - only name@host)
//  QString mReplyToAddr;   // email address for the ReplyTo: field
//  QString mBcc;           // email addresses for the BCC: field
//  QString mFcc;           // folder where sent messages from this identity will be stored
		bool    mIsDefault;
};

} // namespace KPIM

#endif // KPIM_IDENTITY_H
