/*
 *  identitycombo.cpp  -  combo box showing the up-to-date email identity list
 *  Program:  kalarm
 *  Copyright (c) 2004,2007 by David Jarvie <software@astrojar.org.uk>
 *  This is a modified version of the KDEPIM file of the same name,
 *  Copyright (c) 2002 Marc Mutz <mutz@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <assert.h>

#include <klocale.h>

#include "identity.h"
#include "identitymanager.h"
#include "identitycombo.moc"


namespace KPIM {


IdentityCombo::IdentityCombo(IdentityManager* manager, QWidget* parent, const char* name)
	: QComboBox(false, parent, name),
	  mIdentityManager(manager)
{
	reloadCombo();
	reloadUoidList();
	connect(this, SIGNAL(activated(int)), SLOT(slotEmitChanged(int)));
	connect(manager, SIGNAL(changed(uint)), SLOT(slotIdentityManagerChanged()));
}

QString IdentityCombo::currentIdentityName() const
{
	QStringList identities = mIdentityManager->identities();
	int i = currentItem();
	return (i >= 0 && i < static_cast<int>(identities.count())) ? identities[i] : QString::null;
}

uint IdentityCombo::currentIdentity() const {
	int i = currentItem();
	return (i >= 0 && i < static_cast<int>(mUoidList.count())) ? mUoidList[i] : 0;
}

void IdentityCombo::setCurrentIdentity( uint uoid ) {
	int idx = mUoidList.findIndex( uoid );
	if ( idx < 0 ) return;
	if ( idx == currentItem() ) return;

	blockSignals( true ); // just in case Qt gets fixed to emit activated() here
	setCurrentItem( idx );
	blockSignals( false );

	slotEmitChanged( idx );
}

void IdentityCombo::reloadCombo()
{
	QStringList identities = mIdentityManager->identities();
	// the IM should prevent this from happening:
	assert( !identities.isEmpty() );
	identities.first() = i18n("%1 (Default)").arg( identities.first() );
	clear();
	insertStringList( identities );
}

void IdentityCombo::reloadUoidList() {
	mUoidList.clear();
	IdentityManager::ConstIterator it;
	for ( it = mIdentityManager->begin() ; it != mIdentityManager->end() ; ++it )
		mUoidList << (*it).uoid();
}

void IdentityCombo::slotIdentityManagerChanged()
{
	uint oldIdentity = mUoidList[ currentItem() ];

	reloadUoidList();
	int idx = mUoidList.findIndex( oldIdentity );

	blockSignals( true );
	reloadCombo();
	setCurrentItem( idx < 0 ? 0 : idx );
	blockSignals( false );

	if ( idx < 0 )
		slotEmitChanged(currentItem());    // the old selection got deleted
}

void IdentityCombo::slotEmitChanged(int idx)
{
	emit identityChanged(mIdentities[idx]);
}

} // namespace KPIM
