/*
 *  identitycombo.h  -  combo box showing the up-to-date email identity list
 *  Program:  kalarm
 *  Copyright (c) 2004,2007 by David Jarvie <software@astrojar.org.uk>
 *  This is a modified version of the KDEPIM file of the same name,
 *  Copyright (c) 2002 Marc Mutz <mutz@kde.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef KPIM_IDENTITYCOMBO_H
#define KPIM_IDENTITYCOMBO_H

#include <qcombobox.h>
#include <qstringlist.h>

class QString;

namespace KPIM {

class IdentityManager;


class IdentityCombo : public QComboBox
{
		Q_OBJECT
	public:
		IdentityCombo(IdentityManager*, QWidget* parent = 0, const char* name = 0);
		QString currentIdentityName() const;
		uint    currentIdentity() const;
		void    setCurrentIdentity(uint uoid);

	signals:
		void    identityChanged(const QString& identityName);

	private slots:
		void    slotEmitChanged(int);
		void    slotIdentityManagerChanged();

	private:
		void    reloadCombo();
		void    reloadUoidList();

		IdentityManager* mIdentityManager;
		QValueList<uint> mUoidList;
		QStringList      mIdentities;
};

} // namespace

#endif // KPIM_IDENTITYCOMBO_H
