/***************************************************************************
 *   Copyright (C) 2006 by Meni Livne <livne@kde.org>                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "karpionconfigdlgimpl.h"

#include <kconfig.h>
#include <klocale.h>
#include <kinputdialog.h>

#include <qcombobox.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qlistbox.h>

#include <phish.h>


KarpionConfigDialog::KarpionConfigDialog(KConfig *cfg, QWidget *parent,
                                         const char *name) :
                                                KarpionConfigDlg(parent, name)
{
  phish_mode_t mode;
  m_config = cfg;
  
  cfg->setGroup("General");
  
  check_country->setChecked(cfg->readEntry("CheckCountry", "0").toInt() != 0);
  update_interval->setValue(cfg->readEntry("UpdateInterval", "30").toInt());
  
  phish_runningMode(&mode);
  switch(mode)
  {
    case PHISH_ONLINE_MODE:
      running_mode->setCurrentText(i18n("Online"));
      break;
    case PHISH_OFFLINE_MODE:
      running_mode->setCurrentText(i18n("Offline"));
      break;
  }
  
  // populate safe list
  phish_safe_list_entry_t *entry;
  
  phish_getSafeListFirst(&entry);
  while (entry != NULL)
  {
    phish_safe_list_entry_t *next;
    const char *url;
    
    phish_getSafeListData(entry, &url);
    safelistbox->insertItem(url);
    phish_getSafeListNext(entry, &next);
    entry = next;
  }
  
  connect((QObject *)sl_add, SIGNAL(clicked()), SLOT(safeListAdd()));
  connect((QObject *)sl_modify, SIGNAL(clicked()), SLOT(safeListModify()));
  connect((QObject *)sl_remove, SIGNAL(clicked()), SLOT(safeListRemove()));
}

KarpionConfigDialog::~KarpionConfigDialog()
{
}

void KarpionConfigDialog::accept()
{
  m_config->writeEntry("CheckCountry", check_country->isChecked() ? 1 : 0);
  m_config->writeEntry("UpdateInterval", update_interval->value());
  
  if (running_mode->currentText() == i18n("Online"))
    phish_setRunningMode(PHISH_ONLINE_MODE);
  else if (running_mode->currentText() == i18n("Offline"))
    phish_setRunningMode(PHISH_OFFLINE_MODE);
  
  // set new safe list
  phish_safe_list_t *newlist;
  
  phish_newSafeList(&newlist);
  
  for (unsigned int i = 0 ; i < safelistbox->count() ; i++)
  {
    phish_addToSafeList(newlist, safelistbox->text(i).ascii());
  }
  
  phish_setSafeList(newlist);
  phish_saveSafeList();
  phish_saveSettings();
  
  m_config->sync();
  
  QDialog::accept();
}

void KarpionConfigDialog::safeListAdd()
{
  QString url = KInputDialog::getText(i18n("Add URL To Safe List"),
                                      i18n("Enter a URL to add to the safe "
                                          "list."), QString(), 0, this);
  if (!url.isNull())
    safelistbox->insertItem(url);
}

void KarpionConfigDialog::safeListModify()
{
  if (safelistbox->currentItem() == -1)
    return;
  
  QString url = KInputDialog::getText(i18n("Modify Safe List URL"),
                                      i18n("Enter a new URL."),
                                      safelistbox->currentText(), 0, this);
  
  if (!url.isNull())
    safelistbox->changeItem(url, safelistbox->currentItem());
}

void KarpionConfigDialog::safeListRemove()
{
  if (safelistbox->currentItem() != -1)
    safelistbox->removeItem(safelistbox->currentItem());
}


#include "karpionconfigdlgimpl.moc"
